package com.ejianc.business.tender.api;

import com.ejianc.business.tender.common.vo.TenderPicketageVO;
import com.ejianc.business.tender.hystrix.TenderOtherHystrix;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

/**
 *
 *
 * @author yqls
 *
 */
@FeignClient(name= "ejc-tender-web", url="${common.env.feign-client-url}", path="ejc-tender-web", fallback = TenderOtherHystrix.class)
public interface ITenderOtherApi {

	/**
	 *
	 * @return
	 */
	@GetMapping(value = "/api/otherPicketageRefsupplier/updateById")
    CommonResponse<String> updateById(@RequestParam Long id, @RequestParam Integer occupyFlag);
	/**
	 *
	 * @return
	 */
	@GetMapping(value = "/api/otherPicketageRefsupplier/updateStatus")
	CommonResponse<String> updateStatus(@RequestBody TenderPicketageVO tenderPicketageVO);
	/**
	 *
	 * @return
	 */
	@GetMapping(value = "/api/otherPicketageRefsupplier/delUpdateStatus")
	CommonResponse<String> delUpdateStatus(@RequestBody TenderPicketageVO tenderPicketageVO);

//	//供方报名
//	@PostMapping(value = "/api/otherPicketageRefsupplier/signUp")
//	CommonResponse<Boolean> signUp(@RequestBody BmNoticeVO bmNoticeVO);
//
//	//供方报价
//	@PostMapping(value = "/api/otherPicketageRefsupplier/supplierPushSell")
//	CommonResponse<Boolean> supplierPushSell(@RequestBody BjNoticeVO bjNoticeVO);
//
//	//查询二次报价是否开开始评标
//	@PostMapping(value = "/api/otherPicketageRefsupplier/checkBidFlag")
//	CommonResponse<String> checkBidFlag(@RequestBody CheckVo checkVo);
}
