package com.ejianc.business.tender.other.vo;

import com.ejianc.framework.skeleton.template.BaseVO;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.io.File;
import java.io.InputStream;
import java.math.BigDecimal;
import java.util.List;


/**
 * 招标文件供应商标
 * 
 * @author generator
 * 
 */
@ApiModel("招标文件发布之后同步接口")
public class OtherDocumentSupplierTbVO extends BaseVO {
    private static final long serialVersionUID = 1L;

    @ApiModelProperty("来源系统类型")
    private String sourceType;
    @ApiModelProperty("招标立项ID")
    private String sourceId;
    @ApiModelProperty("类型,默认传1")
    private Integer noticeType;
    @ApiModelProperty("项目联系人")
    private String projectLinkName;
    @ApiModelProperty("项目联系电话")
    private String projectLinkPhone;
    @ApiModelProperty("报价开始时间")
    private String offerStartTime;
    @ApiModelProperty("报价结束时间")
    private String offerEndTime;
    @ApiModelProperty("招标文件模板")
    private File file;
    @ApiModelProperty("文件内容")
    private String content;
    @ApiModelProperty("是否允许多品牌报价,0-是,1-否")
    private Integer brandFlag;
    @ApiModelProperty("备注")
    private String memo;
    @ApiModelProperty("洽商参考价")
    private BigDecimal talkMoney;
    @ApiModelProperty("洽商名称")
    private String tenderName;
    @ApiModelProperty("洽商轮数")
    private Integer talkNum;
    @ApiModelProperty("附件流")
    private InputStream inputStream;
    @ApiModelProperty("施工方id")
    private String systemId;
    private Integer rentType; // 租赁方式(0-日租,1-月租,2-工程量租)
    private List<OtherNoticeSupplierDetailTbVO> applyList;

    public String getSystemId() {
        return systemId;
    }

    public void setSystemId(String systemId) {
        this.systemId = systemId;
    }

    public InputStream getInputStream() {
        return inputStream;
    }

    public void setInputStream(InputStream inputStream) {
        this.inputStream = inputStream;
    }

    public Integer getTalkNum() {
        return talkNum;
    }

    public void setTalkNum(Integer talkNum) {
        this.talkNum = talkNum;
    }

    public String getTenderName() {
        return tenderName;
    }

    public void setTenderName(String tenderName) {
        this.tenderName = tenderName;
    }

    public BigDecimal getTalkMoney() {
        return talkMoney;
    }

    public void setTalkMoney(BigDecimal talkMoney) {
        this.talkMoney = talkMoney;
    }

    public String getSourceType() {
        return sourceType;
    }

    public void setSourceType(String sourceType) {
        this.sourceType = sourceType;
    }

    public String getSourceId() {
        return sourceId;
    }

    public void setSourceId(String sourceId) {
        this.sourceId = sourceId;
    }

    public Integer getNoticeType() {
        return noticeType;
    }

    public void setNoticeType(Integer noticeType) {
        this.noticeType = noticeType;
    }

    public String getProjectLinkName() {
        return projectLinkName;
    }

    public void setProjectLinkName(String projectLinkName) {
        this.projectLinkName = projectLinkName;
    }

    public String getProjectLinkPhone() {
        return projectLinkPhone;
    }

    public void setProjectLinkPhone(String projectLinkPhone) {
        this.projectLinkPhone = projectLinkPhone;
    }

    public String getOfferStartTime() {
        return offerStartTime;
    }

    public void setOfferStartTime(String offerStartTime) {
        this.offerStartTime = offerStartTime;
    }

    public String getOfferEndTime() {
        return offerEndTime;
    }

    public void setOfferEndTime(String offerEndTime) {
        this.offerEndTime = offerEndTime;
    }

    public File getFile() {
        return file;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public String getContent() {
        return content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public Integer getBrandFlag() {
        return brandFlag;
    }

    public void setBrandFlag(Integer brandFlag) {
        this.brandFlag = brandFlag;
    }

    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }

    public Integer getRentType() {
        return rentType;
    }

    public void setRentType(Integer rentType) {
        this.rentType = rentType;
    }

    public List<OtherNoticeSupplierDetailTbVO> getApplyList() {
        return applyList;
    }

    public void setApplyList(List<OtherNoticeSupplierDetailTbVO> applyList) {
        this.applyList = applyList;
    }
}
