package com.ejianc.business.tender.report.vo;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.baomidou.mybatisplus.annotation.TableField;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;


/**
 * 定标主表
 *
 * @author generator
 *
 */
@ApiModel("定标主表")
public class ReportVO extends BaseVO {
    private static final long serialVersionUID = 1L;

    @ApiModelProperty("招标立项主键")
    private Long inviteId;
    @ApiModelProperty("单据编号")
    private String billCode;
    @ApiModelProperty("招标名称")
    private String tenderName;
    @ApiModelProperty("采购方式(0-项目采购,1-单位采购)")
    private Integer purchaseType;
    @TableField(value="tender_type")
    private Integer tenderType; //招标方式(0-平台公开招标,1-邀请招标,2-询价,3-竞争性谈判,4-单一来源,5-紧急招标,6-洽商谈判)
    @TableField(value="tender_type_name")
    private String tenderTypeName; //招标方式(0-平台公开招标,1-邀请招标,2-询价,3-竞争性谈判,4-单一来源,5-紧急招标,6-洽商谈判)
    @TableField(value="line_type_name")
    private String lineTypeName; // 材料-0,分包-1，设备采购-2,设备租赁-3,周转材租赁-4,其他-5
    @ApiModelProperty("立项类型(0-招标立项，1-定标立项)")
    private Integer establishType;
    @TableField(value="unit_name")
    private String unitName; //招标单位名称
    @ApiModelProperty("招标阶段")
    private Integer tenderStage;
    @ApiModelProperty("招标控制金额")
    private BigDecimal tenderMoney;
    @ApiModelProperty("定标立项金额")
    private BigDecimal taxMoney;
    @ApiModelProperty("招标联系人")
    private Long employeeId;
    @ApiModelProperty("招标联系人名称")
    private String employeeName;
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private java.util.Date picketageTime; // 定标时间
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private java.util.Date createDate; // 招标时间
    private Long projectId; // 项目ID
    private String projectName; // 项目名称
    private Long orgId; // 组织
    private String orgName; // 组织名称
    private String tenderStageName; // 招标阶段名称
    private String purchaseTypeName; //
    private String establishTypeName; //
    private String tenderUnit; //
    private Long tenderInviteType;//招标类型
    private String tenderInviteTypeName;//招标类型名称

    public String getTenderUnit() {
        return tenderUnit;
    }

    public void setTenderUnit(String tenderUnit) {
        this.tenderUnit = tenderUnit;
    }

    public String getTenderStageName() {
        return tenderStageName;
    }

    public void setTenderStageName(String tenderStageName) {
        this.tenderStageName = tenderStageName;
    }

    public String getPurchaseTypeName() {
        return purchaseTypeName;
    }

    public void setPurchaseTypeName(String purchaseTypeName) {
        this.purchaseTypeName = purchaseTypeName;
    }

    public String getEstablishTypeName() {
        return establishTypeName;
    }

    public void setEstablishTypeName(String establishTypeName) {
        this.establishTypeName = establishTypeName;
    }

    public Integer getTenderType() {
        return tenderType;
    }

    public void setTenderType(Integer tenderType) {
        this.tenderType = tenderType;
    }

    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }

    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    public Long getInviteId() {
        return inviteId;
    }

    public void setInviteId(Long inviteId) {
        this.inviteId = inviteId;
    }

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }

    public String getTenderName() {
        return tenderName;
    }

    public void setTenderName(String tenderName) {
        this.tenderName = tenderName;
    }

    public Integer getPurchaseType() {
        return purchaseType;
    }

    public void setPurchaseType(Integer purchaseType) {
        this.purchaseType = purchaseType;
    }

    public String getTenderTypeName() {
        return tenderTypeName;
    }

    public void setTenderTypeName(String tenderTypeName) {
        this.tenderTypeName = tenderTypeName;
    }

    public String getLineTypeName() {
        return lineTypeName;
    }

    public void setLineTypeName(String lineTypeName) {
        this.lineTypeName = lineTypeName;
    }

    public Integer getEstablishType() {
        return establishType;
    }

    public void setEstablishType(Integer establishType) {
        this.establishType = establishType;
    }

    public String getUnitName() {
        return unitName;
    }

    public void setUnitName(String unitName) {
        this.unitName = unitName;
    }

    public Integer getTenderStage() {
        return tenderStage;
    }

    public void setTenderStage(Integer tenderStage) {
        this.tenderStage = tenderStage;
    }

    public BigDecimal getTenderMoney() {
        return tenderMoney;
    }

    public void setTenderMoney(BigDecimal tenderMoney) {
        this.tenderMoney = tenderMoney;
    }

    public BigDecimal getTaxMoney() {
        return taxMoney;
    }

    public void setTaxMoney(BigDecimal taxMoney) {
        this.taxMoney = taxMoney;
    }

    public Long getEmployeeId() {
        return employeeId;
    }

    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }

    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }

    public Date getPicketageTime() {
        return picketageTime;
    }

    public void setPicketageTime(Date picketageTime) {
        this.picketageTime = picketageTime;
    }

    public Date getCreateDate() {
        return createDate;
    }

    public void setCreateDate(Date createDate) {
        this.createDate = createDate;
    }

    public Long getTenderInviteType() {
        return tenderInviteType;
    }

    public void setTenderInviteType(Long tenderInviteType) {
        this.tenderInviteType = tenderInviteType;
    }

    public String getTenderInviteTypeName() {
        return tenderInviteTypeName;
    }

    public void setTenderInviteTypeName(String tenderInviteTypeName) {
        this.tenderInviteTypeName = tenderInviteTypeName;
    }
}
