package com.ejianc.business.tender.util;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

public enum TenderTypeEnum {
    TARGET_STATE(0, "平台公开招标"),
    BID_STATE(1, "邀请招标"),
    ANNOUNCEMENT_STATE(2, "询价"),
    DOCUMENT_STATE(3, "竞争性谈判"),
    EXPERT_STATE(4, "单一来源"),
    FINISH_STATE(5, "紧急招标"),
    COMPETITIVE_NEGOTIATION_STATE(6, "洽商谈判");

    private final Integer tenderTypeCode;
    private final String description;
    private static Map<Integer, TenderTypeEnum> enumMap = new HashMap();

    private TenderTypeEnum(Integer tenderTypeCode, String description) {
        this.tenderTypeCode = tenderTypeCode;
        this.description = description;
    }

    public Integer getTenderTypeCode() {
        return this.tenderTypeCode;
    }

    public String getDescription() {
        return this.description;
    }

    public static TenderTypeEnum getEnumByStateCode(Integer tenderTypeCode) {
        return (TenderTypeEnum)enumMap.get(tenderTypeCode);
    }

    static {
        enumMap = (Map)EnumSet.allOf(TenderTypeEnum.class).stream().collect(Collectors.toMap(TenderTypeEnum::getTenderTypeCode, Function.identity(), (k1, k2) -> {
            return k2;
        }));
    }
}
