package com.ejianc.business.tender.rent.vo;

import com.baomidou.mybatisplus.annotation.TableField;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.math.BigDecimal;
import java.util.Date;


/**
 * 材料招标公告采购清单表
 * 
 * @author generator
 * 
 */
@ApiModel("材料招标公告采购清单表")
public class RentNoticeDetailVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    @ApiModelProperty("公告主键ID")
    private Long noticeId;
    @ApiModelProperty("材料ID")
    private Long materialId;
    @ApiModelProperty("材料名称")
    private String materialName;
    @ApiModelProperty("材料编码")
    private String materialCode;
    @ApiModelProperty("材料分类ID")
    private Long materialTypeId;
    @ApiModelProperty("材料分类名称")
    private String materialTypeName;
    @ApiModelProperty("单位")
    private String unit;
    @ApiModelProperty("规格型号")
    private String spec;
    @ApiModelProperty("备注")
    private String memo;
    @ApiModelProperty("项目ID")
    private Long detailProjectId;
    @ApiModelProperty("项目名称")
    private String detailProjectName;
    @ApiModelProperty("组织ID")
    private Long detailOrgId; // 组织ID
    @ApiModelProperty("组织名称")
    private String detailOrgName; // 组织名称
    @ApiModelProperty("计划ID")
    private Long planId;
    @ApiModelProperty("计划名称")
    private String planName;
    @ApiModelProperty("计划编码")
    private String planCode;
    @ApiModelProperty("计划金额")
    private BigDecimal planMoney;
    @ApiModelProperty("品牌")
    private String brand;
    @ApiModelProperty("计量方式(0-理计,1-过磅,2-点数)")
    private Integer calculateType;
    @ApiModelProperty("数量")
    private BigDecimal num;
    @ApiModelProperty("税率")
    private BigDecimal rate;
    @ApiModelProperty("暂估金额")
    private BigDecimal money;
    @ApiModelProperty("暂估金额(含税)")
    private BigDecimal moneyTax;
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private java.util.Date planEnterDate; // 计划进场时间
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private java.util.Date planLeaveDate; // 计划出场时间
    private BigDecimal planDay; // 计划周期
    private java.math.BigDecimal sumNum; //
    private java.math.BigDecimal sumRentNum; //
    private java.math.BigDecimal sumMoneyTax; //
    private java.math.BigDecimal sumMoney; //
    //    1、日租：计划周期名称改为租赁天数，现有逻辑不变（调整后供方也需要修改）
//            2、月租：计划周期名称改为租赁月数，计划进场时间、计划出场时间为必填项，按照租金计算法，向上取整，支持修改（调整后供方也需要修改）
//            3、工程量租：
//            1）数量改为租赁工程量，计划周期=计划（进场时间-出场时间）+1，算天数，但是不参与逻辑计算（调整后，需要租赁数量、租赁工程量推送到供方）
//            2）增加一列“租赁数量”手动输入，必填项，大于0的正数，小数位数计算八位，前端显示4位，不自动补零，数量不参与金额的计算（涉及到合并的清单，数量相加）
    @TableField(value="rent_num")
    private BigDecimal rentNum; // 租赁数量
    @TableField(value="flag_oil")
    private Integer flagOil; // 是否含油 (1:是，0：否)
    @TableField(value="flag_operation")
    private Integer flagOperation; // 是否含操作手(1:是，0：否)
    @TableField(value="price")
    private BigDecimal price; //招标控制单价（无税）
    @TableField(value="tax_price")
    private BigDecimal taxPrice; // 招标控制单价
    @TableField(value="tax")
    private BigDecimal tax; // 税额
    @TableField(value="billing_unit_id")
    private Long billingUnitId;
    @TableField(value="billing_unit_name")
    private String billingUnitName;

    public Integer getFlagOil() {
        return flagOil;
    }

    public void setFlagOil(Integer flagOil) {
        this.flagOil = flagOil;
    }

    public Integer getFlagOperation() {
        return flagOperation;
    }

    public void setFlagOperation(Integer flagOperation) {
        this.flagOperation = flagOperation;
    }

    public BigDecimal getPrice() {
        return price;
    }

    public void setPrice(BigDecimal price) {
        this.price = price;
    }

    public BigDecimal getTaxPrice() {
        return taxPrice;
    }

    public void setTaxPrice(BigDecimal taxPrice) {
        this.taxPrice = taxPrice;
    }

    public BigDecimal getTax() {
        return tax;
    }

    public void setTax(BigDecimal tax) {
        this.tax = tax;
    }

    public Long getBillingUnitId() {
        return billingUnitId;
    }

    public void setBillingUnitId(Long billingUnitId) {
        this.billingUnitId = billingUnitId;
    }

    public String getBillingUnitName() {
        return billingUnitName;
    }

    public void setBillingUnitName(String billingUnitName) {
        this.billingUnitName = billingUnitName;
    }

    public BigDecimal getRentNum() {
        return rentNum;
    }

    public void setRentNum(BigDecimal rentNum) {
        this.rentNum = rentNum;
    }

    public BigDecimal getSumRentNum() {
        return sumRentNum;
    }

    public void setSumRentNum(BigDecimal sumRentNum) {
        this.sumRentNum = sumRentNum;
    }

    public BigDecimal getSumNum() {
        return sumNum;
    }

    public void setSumNum(BigDecimal sumNum) {
        this.sumNum = sumNum;
    }

    public BigDecimal getSumMoneyTax() {
        return sumMoneyTax;
    }

    public void setSumMoneyTax(BigDecimal sumMoneyTax) {
        this.sumMoneyTax = sumMoneyTax;
    }

    public BigDecimal getSumMoney() {
        return sumMoney;
    }

    public void setSumMoney(BigDecimal sumMoney) {
        this.sumMoney = sumMoney;
    }

    public Date getPlanEnterDate() {
        return planEnterDate;
    }

    public void setPlanEnterDate(Date planEnterDate) {
        this.planEnterDate = planEnterDate;
    }

    public Date getPlanLeaveDate() {
        return planLeaveDate;
    }

    public void setPlanLeaveDate(Date planLeaveDate) {
        this.planLeaveDate = planLeaveDate;
    }

    public BigDecimal getPlanDay() {
        return planDay;
    }

    public void setPlanDay(BigDecimal planDay) {
        this.planDay = planDay;
    }

    /**
     * 公告主键ID
     */
    public Long getNoticeId() {
        return noticeId;
    }

    /**
     * 公告主键ID
     */
    public void setNoticeId(Long noticeId) {
        this.noticeId = noticeId;
    }
    /**
     * 材料ID
     */
    public Long getMaterialId() {
        return materialId;
    }

    /**
     * 材料ID
     */
    public void setMaterialId(Long materialId) {
        this.materialId = materialId;
    }
    /**
     * 材料名称
     */
    public String getMaterialName() {
        return materialName;
    }

    /**
     * 材料名称
     */
    public void setMaterialName(String materialName) {
        this.materialName = materialName;
    }
    /**
     * 材料编码
     */
    public String getMaterialCode() {
        return materialCode;
    }

    /**
     * 材料编码
     */
    public void setMaterialCode(String materialCode) {
        this.materialCode = materialCode;
    }
    /**
     * 材料分类ID
     */
    public Long getMaterialTypeId() {
        return materialTypeId;
    }

    /**
     * 材料分类ID
     */
    public void setMaterialTypeId(Long materialTypeId) {
        this.materialTypeId = materialTypeId;
    }
    /**
     * 材料分类名称
     */
    public String getMaterialTypeName() {
        return materialTypeName;
    }

    /**
     * 材料分类名称
     */
    public void setMaterialTypeName(String materialTypeName) {
        this.materialTypeName = materialTypeName;
    }
    /**
     * 单位
     */
    public String getUnit() {
        return unit;
    }

    /**
     * 单位
     */
    public void setUnit(String unit) {
        this.unit = unit;
    }
    /**
     * 规格型号
     */
    public String getSpec() {
        return spec;
    }

    /**
     * 规格型号
     */
    public void setSpec(String spec) {
        this.spec = spec;
    }
    /**
     * 备注
     */
    public String getMemo() {
        return memo;
    }

    /**
     * 备注
     */
    public void setMemo(String memo) {
        this.memo = memo;
    }
    /**
     * 项目ID
     */
    public Long getDetailProjectId() {
        return detailProjectId;
    }

    /**
     * 项目ID
     */
    public void setDetailProjectId(Long detailProjectId) {
        this.detailProjectId = detailProjectId;
    }
    /**
     * 项目名称
     */
    public String getDetailProjectName() {
        return detailProjectName;
    }

    /**
     * 项目名称
     */
    public void setDetailProjectName(String detailProjectName) {
        this.detailProjectName = detailProjectName;
    }
    /**
     * 计划ID
     */
    public Long getPlanId() {
        return planId;
    }

    /**
     * 计划ID
     */
    public void setPlanId(Long planId) {
        this.planId = planId;
    }
    /**
     * 计划名称
     */
    public String getPlanName() {
        return planName;
    }

    /**
     * 计划名称
     */
    public void setPlanName(String planName) {
        this.planName = planName;
    }
    /**
     * 计划编码
     */
    public String getPlanCode() {
        return planCode;
    }

    /**
     * 计划编码
     */
    public void setPlanCode(String planCode) {
        this.planCode = planCode;
    }
    /**
     * 计划金额
     */
    public BigDecimal getPlanMoney() {
        return planMoney;
    }

    /**
     * 计划金额
     */
    public void setPlanMoney(BigDecimal planMoney) {
        this.planMoney = planMoney;
    }
    /**
     * 品牌
     */
    public String getBrand() {
        return brand;
    }

    /**
     * 品牌
     */
    public void setBrand(String brand) {
        this.brand = brand;
    }
    /**
     * 计量方式(0-理计,1-过磅,2-点数)
     */
    public Integer getCalculateType() {
        return calculateType;
    }

    /**
     * 计量方式(0-理计,1-过磅,2-点数)
     */
    public void setCalculateType(Integer calculateType) {
        this.calculateType = calculateType;
    }
    /**
     * 数量
     */
    public BigDecimal getNum() {
        return num;
    }

    /**
     * 数量
     */
    public void setNum(BigDecimal num) {
        this.num = num;
    }
    /**
     * 税率
     */
    public BigDecimal getRate() {
        return rate;
    }

    /**
     * 税率
     */
    public void setRate(BigDecimal rate) {
        this.rate = rate;
    }
    /**
     * 暂估金额
     */
    public BigDecimal getMoney() {
        return money;
    }

    /**
     * 暂估金额
     */
    public void setMoney(BigDecimal money) {
        this.money = money;
    }
    /**
     * 暂估金额(含税)
     */
    public BigDecimal getMoneyTax() {
        return moneyTax;
    }

    /**
     * 暂估金额(含税)
     */
    public void setMoneyTax(BigDecimal moneyTax) {
        this.moneyTax = moneyTax;
    }

    public Long getDetailOrgId() {
        return detailOrgId;
    }

    public void setDetailOrgId(Long detailOrgId) {
        this.detailOrgId = detailOrgId;
    }

    public String getDetailOrgName() {
        return detailOrgName;
    }

    public void setDetailOrgName(String detailOrgName) {
        this.detailOrgName = detailOrgName;
    }
}
