package com.ejianc.business.tender.sub.vo;

import com.baomidou.mybatisplus.annotation.TableField;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;


/**
 * 定标供应商参照表(下游单据使用)
 * 
 * @author generator
 * 
 */
@ApiModel("定标供应商参照表(下游单据使用)")
public class SubPicketageRefsupplierVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    @ApiModelProperty("定标主表主键")
    private Long picketageId;
    @ApiModelProperty("备注")
    private String memo;
    @ApiModelProperty("占用状态0-未占用,1-已占用,2-已完成")
    private Integer occupyFlag;
    @ApiModelProperty("供应商租户主键")
    private Long supplierTenantId;
    @ApiModelProperty("供应商ID")
    private Long supplierId;
    @ApiModelProperty("供应商name")
    private String supplierName;
    @ApiModelProperty("定标总额")
    private BigDecimal money;
    @ApiModelProperty("定标总额(含税)")
    private BigDecimal moneyTax;
    @ApiModelProperty("是否中标,0-是,1-否")
    private Integer tenderFlag;
    @ApiModelProperty("项目ID")
    private Long projectId;
    @ApiModelProperty("项目名称")
    private String projectName;
    @ApiModelProperty("定标名称")
    private String picketageName;
    @ApiModelProperty("定标时间")
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date picketageDate;
    @ApiModelProperty("组织")
    private Long orgId;
    @ApiModelProperty("组织名称")
    private String orgName;
    @ApiModelProperty("父级组织")
    private Long parentOrgId;
    @ApiModelProperty("父级组织名称")
    private String parentOrgName;
    @ApiModelProperty("项目编号")
    private String projectCode;
    @TableField(value="unit_id")
    private Long unitId; // 招标单位ID
    @TableField(value="unit_name")
    private String unitName; // 招标单位名称
    @TableField(value="project_qualification_id")
    private Long projectQualificationId; // 工程资质id
    @TableField(value="project_qualification")
    private String projectQualification; // 工程资质
    private String projectLinkName; // 项目联系人
    private String projectLinkPhone; // 项目联系人电话
    private Integer picketageFlag; // 定标类型0-流程定标,1-直接定标
    @TableField(value="sign_status")
    private Integer signStatus; //签订状态:0-未签订,1-部分签订,2-全部已签,3-已关闭
    @TableField(value="contract_money_tax")
    private BigDecimal contractMoneyTax; // 合同签订金额(含税)
    @TableField(value="contract_money")
    private BigDecimal contractMoney; // 合同签订金额
    @TableField(value="purchase_type")
    private Integer purchaseType; //采购方式(0-项目采购,1-单位采购)
    private String purchaseTypeName; //采购方式(0-项目采购,1-单位采购)
    private Long inviteId;

    //非业务字段
    private Long subType; // 分包类型（0-专业分包，1-劳务分包）


    private Long contractTypeId; // 合同类别Id
    private String contractTypeName; // 合同类别名称

    public Long getContractTypeId() {
        return contractTypeId;
    }

    public void setContractTypeId(Long contractTypeId) {
        this.contractTypeId = contractTypeId;
    }

    public String getContractTypeName() {
        return contractTypeName;
    }

    public void setContractTypeName(String contractTypeName) {
        this.contractTypeName = contractTypeName;
    }

    public Long getSubType() {
        return subType;
    }

    public void setSubType(Long subType) {
        this.subType = subType;
    }

    public Long getInviteId() {
        return inviteId;
    }

    public void setInviteId(Long inviteId) {
        this.inviteId = inviteId;
    }

    public String getPurchaseTypeName() {
        return purchaseTypeName;
    }

    public void setPurchaseTypeName(String purchaseTypeName) {
        this.purchaseTypeName = purchaseTypeName;
    }
    public Integer getSignStatus() {
        return signStatus;
    }

    public void setSignStatus(Integer signStatus) {
        this.signStatus = signStatus;
    }

    public BigDecimal getContractMoneyTax() {
        return contractMoneyTax;
    }

    public void setContractMoneyTax(BigDecimal contractMoneyTax) {
        this.contractMoneyTax = contractMoneyTax;
    }

    public BigDecimal getContractMoney() {
        return contractMoney;
    }

    public void setContractMoney(BigDecimal contractMoney) {
        this.contractMoney = contractMoney;
    }

    public Integer getPurchaseType() {
        return purchaseType;
    }

    public void setPurchaseType(Integer purchaseType) {
        this.purchaseType = purchaseType;
    }

    public Integer getPicketageFlag() {
        return picketageFlag;
    }

    public void setPicketageFlag(Integer picketageFlag) {
        this.picketageFlag = picketageFlag;
    }

    public String getProjectLinkName() {
        return projectLinkName;
    }

    public void setProjectLinkName(String projectLinkName) {
        this.projectLinkName = projectLinkName;
    }

    public String getProjectLinkPhone() {
        return projectLinkPhone;
    }

    public void setProjectLinkPhone(String projectLinkPhone) {
        this.projectLinkPhone = projectLinkPhone;
    }

    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }

    public Long getParentOrgId() {
        return parentOrgId;
    }

    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }

    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }

    List<Long> pks =  new ArrayList<Long>();

    public Long getUnitId() {
        return unitId;
    }

    public void setUnitId(Long unitId) {
        this.unitId = unitId;
    }

    public String getUnitName() {
        return unitName;
    }

    public void setUnitName(String unitName) {
        this.unitName = unitName;
    }

    public Long getProjectQualificationId() {
        return projectQualificationId;
    }

    public void setProjectQualificationId(Long projectQualificationId) {
        this.projectQualificationId = projectQualificationId;
    }

    public String getProjectQualification() {
        return projectQualification;
    }

    public void setProjectQualification(String projectQualification) {
        this.projectQualification = projectQualification;
    }

    public List<Long> getPks() {
        return pks;
    }

    public void setPks(List<Long> pks) {
        this.pks = pks;
    }

    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    public Date getPicketageDate() {
        return picketageDate;
    }

    public void setPicketageDate(Date picketageDate) {
        this.picketageDate = picketageDate;
    }

    /**
     * 定标主表主键
     */
    public Long getPicketageId() {
        return picketageId;
    }

    /**
     * 定标主表主键
     */
    public void setPicketageId(Long picketageId) {
        this.picketageId = picketageId;
    }
    /**
     * 备注
     */
    public String getMemo() {
        return memo;
    }

    /**
     * 备注
     */
    public void setMemo(String memo) {
        this.memo = memo;
    }
    /**
     * 占用状态0-未占用,1-已占用,2-已完成
     */
    public Integer getOccupyFlag() {
        return occupyFlag;
    }

    /**
     * 占用状态0-未占用,1-已占用,2-已完成
     */
    public void setOccupyFlag(Integer occupyFlag) {
        this.occupyFlag = occupyFlag;
    }
    /**
     * 供应商租户主键
     */
    public Long getSupplierTenantId() {
        return supplierTenantId;
    }

    /**
     * 供应商租户主键
     */
    public void setSupplierTenantId(Long supplierTenantId) {
        this.supplierTenantId = supplierTenantId;
    }
    /**
     * 供应商ID
     */
    public Long getSupplierId() {
        return supplierId;
    }

    /**
     * 供应商ID
     */
    public void setSupplierId(Long supplierId) {
        this.supplierId = supplierId;
    }
    /**
     * 供应商name
     */
    public String getSupplierName() {
        return supplierName;
    }

    /**
     * 供应商name
     */
    public void setSupplierName(String supplierName) {
        this.supplierName = supplierName;
    }
    /**
     * 定标总额
     */
    public BigDecimal getMoney() {
        return money;
    }

    /**
     * 定标总额
     */
    public void setMoney(BigDecimal money) {
        this.money = money;
    }
    /**
     * 定标总额(含税)
     */
    public BigDecimal getMoneyTax() {
        return moneyTax;
    }

    /**
     * 定标总额(含税)
     */
    public void setMoneyTax(BigDecimal moneyTax) {
        this.moneyTax = moneyTax;
    }
    /**
     * 是否中标,0-是,1-否
     */
    public Integer getTenderFlag() {
        return tenderFlag;
    }

    /**
     * 是否中标,0-是,1-否
     */
    public void setTenderFlag(Integer tenderFlag) {
        this.tenderFlag = tenderFlag;
    }
    /**
     * 项目ID
     */
    public Long getProjectId() {
        return projectId;
    }

    /**
     * 项目ID
     */
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    /**
     * 项目名称
     */
    public String getProjectName() {
        return projectName;
    }

    /**
     * 项目名称
     */
    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    /**
     * 定标名称
     */
    public String getPicketageName() {
        return picketageName;
    }

    /**
     * 定标名称
     */
    public void setPicketageName(String picketageName) {
        this.picketageName = picketageName;
    }
    
}
