package com.ejianc.business.tender.sub.vo;

import com.ejianc.framework.skeleton.template.BaseVO;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.math.BigDecimal;


/**
 * 报价明细实体
 * 
 * @author generator
 * 
 */
@ApiModel("报价明细实体")
public class SubSupplierSellSchemeDetailVO extends BaseVO {
    private static final long serialVersionUID = 1L;

    @ApiModelProperty("招标信息主键")
    private String sourceId;
    @ApiModelProperty("方案主键")
    private Long schemeId;
    @ApiModelProperty("招标采购清单ID")
    private String sourceDetailId;
    @ApiModelProperty("清单编号")
    private String detailCode;
    @ApiModelProperty("清单名称")
    private String detailName;
    @ApiModelProperty("单位")
    private String unit;
    @ApiModelProperty("规格型号")
    private String spec;
    @ApiModelProperty("品牌")
    private String brand;
    @ApiModelProperty("计量方式(0-理计,1-过磅,2-点数)")
    private Integer calculateType;
    @ApiModelProperty("数量")
    private BigDecimal num;
    @ApiModelProperty("税率")
    private BigDecimal rate;
    @ApiModelProperty("备注")
    private String memo;
    @ApiModelProperty("供货品牌")
    private String supplierBrand;
    @ApiModelProperty("单价")
    private BigDecimal price;
    @ApiModelProperty("单价(含税)")
    private BigDecimal taxPrice;
    @ApiModelProperty("总额")
    private BigDecimal mny;
    @ApiModelProperty("总额(含税)")
    private BigDecimal taxMny;
    @ApiModelProperty("税额")
    private BigDecimal tax;
    @ApiModelProperty("备注")
    private String supplierMemo;
    private String content; // 工作内容
    private String rule; // 计量规则
    private String materialEquipmentSupply; //材料设备供应
    private BigDecimal detailRate; // 材料税率

    private BigDecimal artificialTaxMny; //人工费金额
    private BigDecimal artificialMny; //人工费金额（无税）
    private BigDecimal artificialTax; //人工费税额
    private BigDecimal artificialTaxPrice; // 人工费单价
    private BigDecimal artificialPrice; // 人工费单价(无税）
    private BigDecimal artificialControlPrice; // 人工费控制单价(无税）

    public BigDecimal getArtificialControlPrice() {
        return artificialControlPrice;
    }

    public void setArtificialControlPrice(BigDecimal artificialControlPrice) {
        this.artificialControlPrice = artificialControlPrice;
    }

    public BigDecimal getArtificialTaxMny() {
        return artificialTaxMny;
    }

    public void setArtificialTaxMny(BigDecimal artificialTaxMny) {
        this.artificialTaxMny = artificialTaxMny;
    }

    public BigDecimal getArtificialMny() {
        return artificialMny;
    }

    public void setArtificialMny(BigDecimal artificialMny) {
        this.artificialMny = artificialMny;
    }

    public BigDecimal getArtificialTax() {
        return artificialTax;
    }

    public void setArtificialTax(BigDecimal artificialTax) {
        this.artificialTax = artificialTax;
    }

    public BigDecimal getArtificialTaxPrice() {
        return artificialTaxPrice;
    }

    public void setArtificialTaxPrice(BigDecimal artificialTaxPrice) {
        this.artificialTaxPrice = artificialTaxPrice;
    }

    public BigDecimal getArtificialPrice() {
        return artificialPrice;
    }

    public void setArtificialPrice(BigDecimal artificialPrice) {
        this.artificialPrice = artificialPrice;
    }

    public BigDecimal getDetailRate() {
        return detailRate;
    }

    public void setDetailRate(BigDecimal detailRate) {
        this.detailRate = detailRate;
    }
    public String getContent() {
        return content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public String getRule() {
        return rule;
    }

    public void setRule(String rule) {
        this.rule = rule;
    }

    public String getSourceId() {
        return sourceId;
    }

    public void setSourceId(String sourceId) {
        this.sourceId = sourceId;
    }

    public Long getSchemeId() {
        return schemeId;
    }

    public void setSchemeId(Long schemeId) {
        this.schemeId = schemeId;
    }

    public String getSourceDetailId() {
        return sourceDetailId;
    }

    public void setSourceDetailId(String sourceDetailId) {
        this.sourceDetailId = sourceDetailId;
    }

    public String getDetailCode() {
        return detailCode;
    }

    public void setDetailCode(String detailCode) {
        this.detailCode = detailCode;
    }

    public String getDetailName() {
        return detailName;
    }

    public void setDetailName(String detailName) {
        this.detailName = detailName;
    }

    public String getUnit() {
        return unit;
    }

    public void setUnit(String unit) {
        this.unit = unit;
    }

    public String getSpec() {
        return spec;
    }

    public void setSpec(String spec) {
        this.spec = spec;
    }

    public String getBrand() {
        return brand;
    }

    public void setBrand(String brand) {
        this.brand = brand;
    }

    public Integer getCalculateType() {
        return calculateType;
    }

    public void setCalculateType(Integer calculateType) {
        this.calculateType = calculateType;
    }

    public BigDecimal getNum() {
        return num;
    }

    public void setNum(BigDecimal num) {
        this.num = num;
    }

    public BigDecimal getRate() {
        return rate;
    }

    public void setRate(BigDecimal rate) {
        this.rate = rate;
    }

    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }

    public String getSupplierBrand() {
        return supplierBrand;
    }

    public void setSupplierBrand(String supplierBrand) {
        this.supplierBrand = supplierBrand;
    }

    public BigDecimal getPrice() {
        return price;
    }

    public void setPrice(BigDecimal price) {
        this.price = price;
    }

    public BigDecimal getTaxPrice() {
        return taxPrice;
    }

    public void setTaxPrice(BigDecimal taxPrice) {
        this.taxPrice = taxPrice;
    }

    public BigDecimal getMny() {
        return mny;
    }

    public void setMny(BigDecimal mny) {
        this.mny = mny;
    }

    public BigDecimal getTaxMny() {
        return taxMny;
    }

    public void setTaxMny(BigDecimal taxMny) {
        this.taxMny = taxMny;
    }

    public BigDecimal getTax() {
        return tax;
    }

    public void setTax(BigDecimal tax) {
        this.tax = tax;
    }

    public String getSupplierMemo() {
        return supplierMemo;
    }

    public void setSupplierMemo(String supplierMemo) {
        this.supplierMemo = supplierMemo;
    }

    public String getMaterialEquipmentSupply() {
        return materialEquipmentSupply;
    }

    public void setMaterialEquipmentSupply(String materialEquipmentSupply) {
        this.materialEquipmentSupply = materialEquipmentSupply;
    }
}
