package com.ejianc.business.tender.other.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.baomidou.mybatisplus.annotation.TableField;
import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;


/**
 * 其它-中标通知书
 * 
 * @author generator
 * 
 */
@ApiModel("其它-中标通知书")
public class OtherAdviceVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    @ApiModelProperty("招标立项主键")
    private Long inviteId;
    @ApiModelProperty("定标主键")
    private Long picketageId;
    @ApiModelProperty("主标题")
    private String titleName;
    @ApiModelProperty("招标单位ID")
    private Long unitId;
    @ApiModelProperty("招标单位名称")
    private String unitName;
    @ApiModelProperty("通知书日期")
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date noticeDate;
    @ApiModelProperty("单据编号")
    private String billCode;
    @ApiModelProperty("项目ID")
    private Long projectId;
    @ApiModelProperty("项目名称")
    private String projectName;
    @ApiModelProperty("采购单位")
    private Long orgId;
    @ApiModelProperty("采购单位名称")
    private String orgName;
    @ApiModelProperty("采购方式(0-项目采购,1-单位采购)")
    private Integer purchaseType;
    @ApiModelProperty("内容")
    private String content;
    @ApiModelProperty("单据状态（审批必须字段）")
    private Integer billState;
    @ApiModelProperty("招标方式(0-平台公开招标,1-邀请招标,2-询价,3-竞争性谈判,4-单一来源,5-紧急招标,6-洽商谈判)")
    private String tenderTypeName;
    @ApiModelProperty("材料-0,分包-1，设备采购-2,设备租赁-3,周转材租赁-4,其他-5")
    private String lineTypeName;
    @ApiModelProperty("中标单位ID")
    private Long supplierId;
    @ApiModelProperty("中标单位名称")
    private String supplierName;
    @ApiModelProperty("是否生成(0:是，1：否")
    private Integer scFlag;
    @ApiModelProperty("签章状态 未签章 -0,待签章-1,已签章-2")
    private Integer signFlag;
    @ApiModelProperty("是否发送0:是，1：否")
    private Integer sendFlag;
    @ApiModelProperty("定标总额")
    private BigDecimal money;
    @ApiModelProperty("定标总额(含税)")
    private BigDecimal moneyTax;
    @ApiModelProperty("父级组织")
    private Long parentOrgId;
    @ApiModelProperty("父级组织名称")
    private String parentOrgName;
    @TableField(value="trustees_id")
    private Long trusteesId; // 经办人ID
    @TableField(value="trustees_name")
    private String trusteesName; // 经办人名称
    @TableField(value="trustees_phone")
    private String trusteesPhone; //经办人电话
    @ApiModelProperty("附件名称")
    private String fileName;
    @ApiModelProperty("附件主键")
    private Long attachId;
    private String filePath;

    public String getFilePath() {
        return filePath;
    }

    public void setFilePath(String filePath) {
        this.filePath = filePath;
    }
    public String getFileName() {
        return fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public Long getAttachId() {
        return attachId;
    }

    public void setAttachId(Long attachId) {
        this.attachId = attachId;
    }

    public Long getTrusteesId() {
        return trusteesId;
    }

    public void setTrusteesId(Long trusteesId) {
        this.trusteesId = trusteesId;
    }

    public String getTrusteesName() {
        return trusteesName;
    }

    public void setTrusteesName(String trusteesName) {
        this.trusteesName = trusteesName;
    }

    public String getTrusteesPhone() {
        return trusteesPhone;
    }

    public void setTrusteesPhone(String trusteesPhone) {
        this.trusteesPhone = trusteesPhone;
    }

    /**
     * 招标立项主键
     */
    public Long getInviteId() {
        return inviteId;
    }

    /**
     * 招标立项主键
     */
    public void setInviteId(Long inviteId) {
        this.inviteId = inviteId;
    }
    /**
     * 定标主键
     */
    public Long getPicketageId() {
        return picketageId;
    }

    /**
     * 定标主键
     */
    public void setPicketageId(Long picketageId) {
        this.picketageId = picketageId;
    }
    /**
     * 主标题
     */
    public String getTitleName() {
        return titleName;
    }

    /**
     * 主标题
     */
    public void setTitleName(String titleName) {
        this.titleName = titleName;
    }
    /**
     * 招标单位名称
     */
    public String getUnitName() {
        return unitName;
    }

    /**
     * 招标单位名称
     */
    public void setUnitName(String unitName) {
        this.unitName = unitName;
    }
    /**
     * 通知书日期
     */
    public Date getNoticeDate() {
        return noticeDate;
    }

    /**
     * 通知书日期
     */
    public void setNoticeDate(Date noticeDate) {
        this.noticeDate = noticeDate;
    }
    /**
     * 单据编号
     */
    public String getBillCode() {
        return billCode;
    }

    /**
     * 单据编号
     */
    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    /**
     * 项目名称
     */
    public String getProjectName() {
        return projectName;
    }

    /**
     * 项目名称
     */
    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    /**
     * 采购单位名称
     */
    public String getOrgName() {
        return orgName;
    }

    /**
     * 采购单位名称
     */
    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    /**
     * 采购方式(0-项目采购,1-单位采购)
     */
    public Integer getPurchaseType() {
        return purchaseType;
    }

    /**
     * 采购方式(0-项目采购,1-单位采购)
     */
    public void setPurchaseType(Integer purchaseType) {
        this.purchaseType = purchaseType;
    }
    /**
     * 内容
     */
    public String getContent() {
        return content;
    }

    /**
     * 内容
     */
    public void setContent(String content) {
        this.content = content;
    }
    /**
     * 单据状态（审批必须字段）
     */
    public Integer getBillState() {
        return billState;
    }

    /**
     * 单据状态（审批必须字段）
     */
    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    /**
     * 招标方式(0-平台公开招标,1-邀请招标,2-询价,3-竞争性谈判,4-单一来源,5-紧急招标,6-洽商谈判)
     */
    public String getTenderTypeName() {
        return tenderTypeName;
    }

    /**
     * 招标方式(0-平台公开招标,1-邀请招标,2-询价,3-竞争性谈判,4-单一来源,5-紧急招标,6-洽商谈判)
     */
    public void setTenderTypeName(String tenderTypeName) {
        this.tenderTypeName = tenderTypeName;
    }
    /**
     * 材料-0,分包-1，设备采购-2,设备租赁-3,周转材租赁-4,其他-5
     */
    public String getLineTypeName() {
        return lineTypeName;
    }

    /**
     * 材料-0,分包-1，设备采购-2,设备租赁-3,周转材租赁-4,其他-5
     */
    public void setLineTypeName(String lineTypeName) {
        this.lineTypeName = lineTypeName;
    }
    /**
     * 中标单位ID
     */
    public Long getSupplierId() {
        return supplierId;
    }

    /**
     * 中标单位ID
     */
    public void setSupplierId(Long supplierId) {
        this.supplierId = supplierId;
    }
    /**
     * 中标单位名称
     */
    public String getSupplierName() {
        return supplierName;
    }

    /**
     * 中标单位名称
     */
    public void setSupplierName(String supplierName) {
        this.supplierName = supplierName;
    }
    /**
     * 是否生成(0:是，1：否
     */
    public Integer getScFlag() {
        return scFlag;
    }

    /**
     * 是否生成(0:是，1：否
     */
    public void setScFlag(Integer scFlag) {
        this.scFlag = scFlag;
    }
    /**
     * 签章状态 未签章 -0,待签章-1,已签章-2
     */
    public Integer getSignFlag() {
        return signFlag;
    }

    /**
     * 签章状态 未签章 -0,待签章-1,已签章-2
     */
    public void setSignFlag(Integer signFlag) {
        this.signFlag = signFlag;
    }
    /**
     * 是否发送0:是，1：否
     */
    public Integer getSendFlag() {
        return sendFlag;
    }

    /**
     * 是否发送0:是，1：否
     */
    public void setSendFlag(Integer sendFlag) {
        this.sendFlag = sendFlag;
    }
    /**
     * 定标总额
     */
    public BigDecimal getMoney() {
        return money;
    }

    /**
     * 定标总额
     */
    public void setMoney(BigDecimal money) {
        this.money = money;
    }
    /**
     * 定标总额(含税)
     */
    public BigDecimal getMoneyTax() {
        return moneyTax;
    }

    /**
     * 定标总额(含税)
     */
    public void setMoneyTax(BigDecimal moneyTax) {
        this.moneyTax = moneyTax;
    }
    /**
     * 父级组织
     */
    public Long getParentOrgId() {
        return parentOrgId;
    }

    /**
     * 父级组织
     */
    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    /**
     * 父级组织名称
     */
    public String getParentOrgName() {
        return parentOrgName;
    }

    /**
     * 父级组织名称
     */
    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    /**
     * 项目ID
     */
    @ReferSerialTransfer(referCode = "project-set")
    public java.lang.Long getProjectId() {
        return projectId;
    }

    /**
     * 项目ID
     */
    @ReferDeserialTransfer
    public void setProjectId(java.lang.Long projectId) {
        this.projectId = projectId;
    }

    @ReferSerialTransfer(referCode="idm-org")
    public Long getOrgId() {
        return orgId;
    }
    @ReferDeserialTransfer
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    /**
     * 招标单位ID
     */
    @ReferSerialTransfer(referCode="idm-org")
    public java.lang.Long getUnitId() {
        return unitId;
    }

    /**
     * 招标单位ID
     */
    @ReferDeserialTransfer
    public void setUnitId(java.lang.Long unitId) {
        this.unitId = unitId;
    }
    
}
