package com.ejianc.business.tender.rmat.vo;

import com.baomidou.mybatisplus.annotation.TableField;
import com.ejianc.framework.skeleton.template.BaseVO;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.math.BigDecimal;


/**
 * 中标明细实体
 * 
 * @author generator
 * 
 */
@ApiModel("中标明细实体")
public class RmatWinbidDetailVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    @ApiModelProperty("招标信息主键")
    private String sourceId;
    @ApiModelProperty("方案主键")
    private Long schemeId;
    @ApiModelProperty("材料ID")
    private String sourceMaterialId;
    @ApiModelProperty("材料名称")
    private String materialName;
    @ApiModelProperty("材料编码")
    private String materialCode;
    @ApiModelProperty("材料分类ID")
    private String sourceMaterialTypeId;
    @ApiModelProperty("材料分类名称")
    private String materialTypeName;
    @ApiModelProperty("单位")
    private String unit;
    @ApiModelProperty("规格型号")
    private String spec;
    @ApiModelProperty("品牌")
    private String brand;
    @ApiModelProperty("计量方式(0-理计,1-过磅,2-点数)")
    private Integer calculateType;
    @ApiModelProperty("数量")
    private BigDecimal num;
    @ApiModelProperty("税率")
    private BigDecimal rate;
    @ApiModelProperty("备注")
    private String memo;
    @ApiModelProperty("供货品牌")
    private String supplierBrand;
    @ApiModelProperty("单价")
    private BigDecimal price;
    @ApiModelProperty("单价(含税)")
    private BigDecimal priceTax;
    @ApiModelProperty("总额")
    private BigDecimal money;
    @ApiModelProperty("总额(含税)")
    private BigDecimal moneyTax;
    @ApiModelProperty("税额")
    private BigDecimal tax;
    @ApiModelProperty("备注")
    private String supplierMemo;
    @ApiModelProperty("中标主键")
    private Long winbidId;
    @ApiModelProperty("中标数量")
    private BigDecimal tenderNum;
    @ApiModelProperty("供应商租户id")
    private Long tenantId;
    @TableField(value = "lack_month_day_unit_price")
    private BigDecimal lackMonthDayUnitPrice; // 不足月日单价(无税)
    @TableField(value = "lack_month_day_unit_tax_price")
    private BigDecimal lackMonthDayUnitTaxPrice; // 不足月日单价
    @TableField(value = "rent_days")
    private Integer rentDays; // 租赁天数-- 月租使用
    @TableField(value="rent_num")
    private BigDecimal rentNum; // 租赁数量
    @TableField(value="stop_unit_price")
    private BigDecimal stopUnitPrice; // 停租单价(无税)
    @TableField(value="stop_unit_tax_price")
    private BigDecimal stopUnitTaxPrice; // 停租单价
    @TableField(value="lose_unit_price")
    private BigDecimal loseUnitPrice; // 遗失单价(无税)
    @TableField(value="lose_unit_tax_price")
    private BigDecimal loseUnitTaxPrice; // 遗失单价

    public BigDecimal getLackMonthDayUnitPrice() {
        return lackMonthDayUnitPrice;
    }

    public void setLackMonthDayUnitPrice(BigDecimal lackMonthDayUnitPrice) {
        this.lackMonthDayUnitPrice = lackMonthDayUnitPrice;
    }

    public BigDecimal getLackMonthDayUnitTaxPrice() {
        return lackMonthDayUnitTaxPrice;
    }

    public void setLackMonthDayUnitTaxPrice(BigDecimal lackMonthDayUnitTaxPrice) {
        this.lackMonthDayUnitTaxPrice = lackMonthDayUnitTaxPrice;
    }

    public Integer getRentDays() {
        return rentDays;
    }

    public void setRentDays(Integer rentDays) {
        this.rentDays = rentDays;
    }

    public BigDecimal getRentNum() {
        return rentNum;
    }

    public void setRentNum(BigDecimal rentNum) {
        this.rentNum = rentNum;
    }

    public BigDecimal getStopUnitPrice() {
        return stopUnitPrice;
    }

    public void setStopUnitPrice(BigDecimal stopUnitPrice) {
        this.stopUnitPrice = stopUnitPrice;
    }

    public BigDecimal getStopUnitTaxPrice() {
        return stopUnitTaxPrice;
    }

    public void setStopUnitTaxPrice(BigDecimal stopUnitTaxPrice) {
        this.stopUnitTaxPrice = stopUnitTaxPrice;
    }

    public BigDecimal getLoseUnitPrice() {
        return loseUnitPrice;
    }

    public void setLoseUnitPrice(BigDecimal loseUnitPrice) {
        this.loseUnitPrice = loseUnitPrice;
    }

    public BigDecimal getLoseUnitTaxPrice() {
        return loseUnitTaxPrice;
    }

    public void setLoseUnitTaxPrice(BigDecimal loseUnitTaxPrice) {
        this.loseUnitTaxPrice = loseUnitTaxPrice;
    }

    public BigDecimal getTenderNum() {
        return tenderNum;
    }

    public void setTenderNum(BigDecimal tenderNum) {
        this.tenderNum = tenderNum;
    }

    /**
     * 招标信息主键
     */
    public String getSourceId() {
        return sourceId;
    }

    /**
     * 招标信息主键
     */
    public void setSourceId(String sourceId) {
        this.sourceId = sourceId;
    }
    /**
     * 方案主键
     */
    public Long getSchemeId() {
        return schemeId;
    }

    /**
     * 方案主键
     */
    public void setSchemeId(Long schemeId) {
        this.schemeId = schemeId;
    }
    /**
     * 材料ID
     */
    public String getSourceMaterialId() {
        return sourceMaterialId;
    }

    /**
     * 材料ID
     */
    public void setSourceMaterialId(String sourceMaterialId) {
        this.sourceMaterialId = sourceMaterialId;
    }
    /**
     * 材料名称
     */
    public String getMaterialName() {
        return materialName;
    }

    /**
     * 材料名称
     */
    public void setMaterialName(String materialName) {
        this.materialName = materialName;
    }
    /**
     * 材料编码
     */
    public String getMaterialCode() {
        return materialCode;
    }

    /**
     * 材料编码
     */
    public void setMaterialCode(String materialCode) {
        this.materialCode = materialCode;
    }
    /**
     * 材料分类ID
     */
    public String getSourceMaterialTypeId() {
        return sourceMaterialTypeId;
    }

    /**
     * 材料分类ID
     */
    public void setSourceMaterialTypeId(String sourceMaterialTypeId) {
        this.sourceMaterialTypeId = sourceMaterialTypeId;
    }
    /**
     * 材料分类名称
     */
    public String getMaterialTypeName() {
        return materialTypeName;
    }

    /**
     * 材料分类名称
     */
    public void setMaterialTypeName(String materialTypeName) {
        this.materialTypeName = materialTypeName;
    }
    /**
     * 单位
     */
    public String getUnit() {
        return unit;
    }

    /**
     * 单位
     */
    public void setUnit(String unit) {
        this.unit = unit;
    }
    /**
     * 规格型号
     */
    public String getSpec() {
        return spec;
    }

    /**
     * 规格型号
     */
    public void setSpec(String spec) {
        this.spec = spec;
    }
    /**
     * 品牌
     */
    public String getBrand() {
        return brand;
    }

    /**
     * 品牌
     */
    public void setBrand(String brand) {
        this.brand = brand;
    }
    /**
     * 计量方式(0-理计,1-过磅,2-点数)
     */
    public Integer getCalculateType() {
        return calculateType;
    }

    /**
     * 计量方式(0-理计,1-过磅,2-点数)
     */
    public void setCalculateType(Integer calculateType) {
        this.calculateType = calculateType;
    }
    /**
     * 数量
     */
    public BigDecimal getNum() {
        return num;
    }

    /**
     * 数量
     */
    public void setNum(BigDecimal num) {
        this.num = num;
    }
    /**
     * 税率
     */
    public BigDecimal getRate() {
        return rate;
    }

    /**
     * 税率
     */
    public void setRate(BigDecimal rate) {
        this.rate = rate;
    }
    /**
     * 备注
     */
    public String getMemo() {
        return memo;
    }

    /**
     * 备注
     */
    public void setMemo(String memo) {
        this.memo = memo;
    }
    /**
     * 供货品牌
     */
    public String getSupplierBrand() {
        return supplierBrand;
    }

    /**
     * 供货品牌
     */
    public void setSupplierBrand(String supplierBrand) {
        this.supplierBrand = supplierBrand;
    }
    /**
     * 单价
     */
    public BigDecimal getPrice() {
        return price;
    }

    /**
     * 单价
     */
    public void setPrice(BigDecimal price) {
        this.price = price;
    }
    /**
     * 单价(含税)
     */
    public BigDecimal getPriceTax() {
        return priceTax;
    }

    /**
     * 单价(含税)
     */
    public void setPriceTax(BigDecimal priceTax) {
        this.priceTax = priceTax;
    }
    /**
     * 总额
     */
    public BigDecimal getMoney() {
        return money;
    }

    /**
     * 总额
     */
    public void setMoney(BigDecimal money) {
        this.money = money;
    }
    /**
     * 总额(含税)
     */
    public BigDecimal getMoneyTax() {
        return moneyTax;
    }

    /**
     * 总额(含税)
     */
    public void setMoneyTax(BigDecimal moneyTax) {
        this.moneyTax = moneyTax;
    }
    /**
     * 税额
     */
    public BigDecimal getTax() {
        return tax;
    }

    /**
     * 税额
     */
    public void setTax(BigDecimal tax) {
        this.tax = tax;
    }
    /**
     * 备注
     */
    public String getSupplierMemo() {
        return supplierMemo;
    }

    /**
     * 备注
     */
    public void setSupplierMemo(String supplierMemo) {
        this.supplierMemo = supplierMemo;
    }
    /**
     * 中标主键
     */
    public Long getWinbidId() {
        return winbidId;
    }

    /**
     * 中标主键
     */
    public void setWinbidId(Long winbidId) {
        this.winbidId = winbidId;
    }
    
}
