package com.ejianc.business.tender.rmat.vo;

import com.ejianc.business.tools.refer.annotation.ReferJsonField;
import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;


/**
 * 材料招标立项采购清单表
 * 
 * @author generator
 * 
 */
public class RmatInviteDetailVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private Long inviteId; // 招标主键ID
    private Long materialId; // 材料ID
    private String materialName; // 材料名称
    private String materialCode; // 材料编码
    @ReferJsonField(referCode = "MaterialCategory001",referFields = "code",resultFields = "materialTypeCode")
    private Long materialTypeId; // 材料分类ID
    private String materialTypeName; // 材料分类名称
    private String unit; // 单位
    private String spec; // 规格型号
    private String memo; // 备注
    private Long detailProjectId; // 项目ID
    private String detailProjectName; // 项目名称
    private Long detailOrgId; // 组织ID
    private String detailOrgName; // 组织名称
    private Long planId; // 计划ID
    private String planName; // 计划名称
    private String planCode; // 计划编码
    private BigDecimal planMoney; // 计划金额
    private String brand; // 品牌
    private Integer calculateType; // 计量方式(0-理计,1-过磅,2-点数)
    private String calculateTypeName;
    private BigDecimal num; // 数量
    private BigDecimal rate; // 税率
    private BigDecimal money; // 暂估金额
    private BigDecimal moneyTax; // 暂估金额(含税)
    private BigDecimal planNum; // 计划数量
    private String contractType;//合同类型(0-消耗材,1-周转材,2-混凝土,3-零星材料)
    private String purchaseId; // 采购方式ID
    private String purchaseName; // 采购方式ID
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date planEnterDate; // 计划进场时间
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date planLeaveDate; // 计划出场时间
    private BigDecimal planDay; // 计划周期
    private Long unitId; // 单位ID

    private BigDecimal sumNum; //
    private BigDecimal sumMoneyTax; //
    private BigDecimal sumMoney; //
    List<RmatInviteDetailBidderVO> rmatDetailBidder = new ArrayList<RmatInviteDetailBidderVO>();

    // add by sunyj  20231101 周转材租赁招标改造

    private BigDecimal price; // 单价
    private BigDecimal priceTax; // 单价(含税)
    private BigDecimal tax; // 税额

    private BigDecimal lackMonthDayUnitPrice; // 不足月日单价(无税)
    private BigDecimal lackMonthDayUnitTaxPrice; // 不足月日单价
    private Integer rentDays; // 租赁天数-- 不足月天数
    private BigDecimal rentNum; // 租赁数量
    private String materialTypeCode; // 材料分类编码

    private String historyPriceArea;//历史价格区间（无税）
    private String historyTaxPriceArea;//历史价格区间（含税）
    private String guidePriceArea; // 公司指导价区间（无税）
    private String guideTaxPriceArea; // 公司指导价区间（含税）

    public String getCalculateTypeName() {
        return calculateTypeName;
    }

    public void setCalculateTypeName(String calculateTypeName) {
        this.calculateTypeName = calculateTypeName;
    }

    public String getHistoryPriceArea() {
        return historyPriceArea;
    }

    public void setHistoryPriceArea(String historyPriceArea) {
        this.historyPriceArea = historyPriceArea;
    }

    public String getHistoryTaxPriceArea() {
        return historyTaxPriceArea;
    }

    public void setHistoryTaxPriceArea(String historyTaxPriceArea) {
        this.historyTaxPriceArea = historyTaxPriceArea;
    }

    public String getGuidePriceArea() {
        return guidePriceArea;
    }

    public void setGuidePriceArea(String guidePriceArea) {
        this.guidePriceArea = guidePriceArea;
    }

    public String getGuideTaxPriceArea() {
        return guideTaxPriceArea;
    }

    public void setGuideTaxPriceArea(String guideTaxPriceArea) {
        this.guideTaxPriceArea = guideTaxPriceArea;
    }

    public String getMaterialTypeCode() {
        return materialTypeCode;
    }

    public void setMaterialTypeCode(String materialTypeCode) {
        this.materialTypeCode = materialTypeCode;
    }
    public BigDecimal getPrice() {
        return price;
    }

    public void setPrice(BigDecimal price) {
        this.price = price;
    }

    public BigDecimal getPriceTax() {
        return priceTax;
    }

    public void setPriceTax(BigDecimal priceTax) {
        this.priceTax = priceTax;
    }

    public BigDecimal getTax() {
        return tax;
    }

    public void setTax(BigDecimal tax) {
        this.tax = tax;
    }

    public BigDecimal getLackMonthDayUnitPrice() {
        return lackMonthDayUnitPrice;
    }

    public void setLackMonthDayUnitPrice(BigDecimal lackMonthDayUnitPrice) {
        this.lackMonthDayUnitPrice = lackMonthDayUnitPrice;
    }

    public BigDecimal getLackMonthDayUnitTaxPrice() {
        return lackMonthDayUnitTaxPrice;
    }

    public void setLackMonthDayUnitTaxPrice(BigDecimal lackMonthDayUnitTaxPrice) {
        this.lackMonthDayUnitTaxPrice = lackMonthDayUnitTaxPrice;
    }

    public Integer getRentDays() {
        return rentDays;
    }

    public void setRentDays(Integer rentDays) {
        this.rentDays = rentDays;
    }

    public BigDecimal getRentNum() {
        return rentNum;
    }

    public void setRentNum(BigDecimal rentNum) {
        this.rentNum = rentNum;
    }

    public Long getUnitId() {
        return unitId;
    }

    public void setUnitId(Long unitId) {
        this.unitId = unitId;
    }

    public Date getPlanEnterDate() {
        return planEnterDate;
    }

    public void setPlanEnterDate(Date planEnterDate) {
        this.planEnterDate = planEnterDate;
    }

    public Date getPlanLeaveDate() {
        return planLeaveDate;
    }

    public void setPlanLeaveDate(Date planLeaveDate) {
        this.planLeaveDate = planLeaveDate;
    }

    public BigDecimal getPlanDay() {
        return planDay;
    }

    public void setPlanDay(BigDecimal planDay) {
        this.planDay = planDay;
    }

    public BigDecimal getSumNum() {
        return sumNum;
    }

    public void setSumNum(BigDecimal sumNum) {
        this.sumNum = sumNum;
    }

    public BigDecimal getSumMoneyTax() {
        return sumMoneyTax;
    }

    public void setSumMoneyTax(BigDecimal sumMoneyTax) {
        this.sumMoneyTax = sumMoneyTax;
    }

    public BigDecimal getSumMoney() {
        return sumMoney;
    }

    public void setSumMoney(BigDecimal sumMoney) {
        this.sumMoney = sumMoney;
    }

    public List<RmatInviteDetailBidderVO> getRmatDetailBidder() {
        return rmatDetailBidder;
    }

    public String getContractType() {
        return contractType;
    }

    public void setContractType(String contractType) {
        this.contractType = contractType;
    }

    public String getPurchaseId() {
        return purchaseId;
    }

    public void setPurchaseId(String purchaseId) {
        this.purchaseId = purchaseId;
    }

    public String getPurchaseName() {
        return purchaseName;
    }

    public void setPurchaseName(String purchaseName) {
        this.purchaseName = purchaseName;
    }

    public void setRmatDetailBidder(List<RmatInviteDetailBidderVO> rmatDetailBidder) {
        this.rmatDetailBidder = rmatDetailBidder;
    }

    public BigDecimal getPlanNum() {
        return planNum;
    }

    public void setPlanNum(BigDecimal planNum) {
        this.planNum = planNum;
    }

    /**
     * 招标主键ID
     */
    public Long getInviteId() {
        return inviteId;
    }

    public String getPlanCode() {
        return planCode;
    }

    public void setPlanCode(String planCode) {
        this.planCode = planCode;
    }

    /**
     * 招标主键ID
     */
    public void setInviteId(Long inviteId) {
        this.inviteId = inviteId;
    }
    /**
     * 材料ID
     */
    public Long getMaterialId() {
        return materialId;
    }

    /**
     * 材料ID
     */
    public void setMaterialId(Long materialId) {
        this.materialId = materialId;
    }
    /**
     * 材料名称
     */
    public String getMaterialName() {
        return materialName;
    }

    /**
     * 材料名称
     */
    public void setMaterialName(String materialName) {
        this.materialName = materialName;
    }
    /**
     * 材料编码
     */
    public String getMaterialCode() {
        return materialCode;
    }

    /**
     * 材料编码
     */
    public void setMaterialCode(String materialCode) {
        this.materialCode = materialCode;
    }
    /**
     * 材料分类ID
     */
    public Long getMaterialTypeId() {
        return materialTypeId;
    }

    /**
     * 材料分类ID
     */
    public void setMaterialTypeId(Long materialTypeId) {
        this.materialTypeId = materialTypeId;
    }
    /**
     * 材料分类名称
     */
    public String getMaterialTypeName() {
        return materialTypeName;
    }

    /**
     * 材料分类名称
     */
    public void setMaterialTypeName(String materialTypeName) {
        this.materialTypeName = materialTypeName;
    }
    /**
     * 单位
     */
    public String getUnit() {
        return unit;
    }

    /**
     * 单位
     */
    public void setUnit(String unit) {
        this.unit = unit;
    }
    /**
     * 规格型号
     */
    public String getSpec() {
        return spec;
    }

    /**
     * 规格型号
     */
    public void setSpec(String spec) {
        this.spec = spec;
    }
    /**
     * 备注
     */
    public String getMemo() {
        return memo;
    }

    /**
     * 备注
     */
    public void setMemo(String memo) {
        this.memo = memo;
    }
    public Long getDetailProjectId() {
        return detailProjectId;
    }
    public void setDetailProjectId(Long detailProjectId) {
        this.detailProjectId = detailProjectId;
    }

    public String getDetailProjectName() {
        return detailProjectName;
    }

    public void setDetailProjectName(String detailProjectName) {
        this.detailProjectName = detailProjectName;
    }

    /**
     * 计划ID
     */
    public Long getPlanId() {
        return planId;
    }

    /**
     * 计划ID
     */
    public void setPlanId(Long planId) {
        this.planId = planId;
    }
    /**
     * 计划名称
     */
    public String getPlanName() {
        return planName;
    }

    /**
     * 计划名称
     */
    public void setPlanName(String planName) {
        this.planName = planName;
    }
    /**
     * 计划金额
     */
    public BigDecimal getPlanMoney() {
        return planMoney;
    }

    /**
     * 计划金额
     */
    public void setPlanMoney(BigDecimal planMoney) {
        this.planMoney = planMoney;
    }
    /**
     * 品牌
     */
    public String getBrand() {
        return brand;
    }

    /**
     * 品牌
     */
    public void setBrand(String brand) {
        this.brand = brand;
    }
    /**
     * 计量方式(0-理计,1-过磅,2-点数)
     */
    public Integer getCalculateType() {
        return calculateType;
    }

    /**
     * 计量方式(0-理计,1-过磅,2-点数)
     */
    public void setCalculateType(Integer calculateType) {
        this.calculateType = calculateType;
    }
    /**
     * 数量
     */
    public BigDecimal getNum() {
        return num;
    }

    /**
     * 数量
     */
    public void setNum(BigDecimal num) {
        this.num = num;
    }
    /**
     * 税率
     */
    public BigDecimal getRate() {
        return rate;
    }

    /**
     * 税率
     */
    public void setRate(BigDecimal rate) {
        this.rate = rate;
    }
    /**
     * 暂估金额
     */
    public BigDecimal getMoney() {
        return money;
    }

    /**
     * 暂估金额
     */
    public void setMoney(BigDecimal money) {
        this.money = money;
    }
    /**
     * 暂估金额(含税)
     */
    public BigDecimal getMoneyTax() {
        return moneyTax;
    }

    /**
     * 暂估金额(含税)
     */
    public void setMoneyTax(BigDecimal moneyTax) {
        this.moneyTax = moneyTax;
    }

    public Long getDetailOrgId() {
        return detailOrgId;
    }

    public void setDetailOrgId(Long detailOrgId) {
        this.detailOrgId = detailOrgId;
    }

    public String getDetailOrgName() {
        return detailOrgName;
    }

    public void setDetailOrgName(String detailOrgName) {
        this.detailOrgName = detailOrgName;
    }
}
