package com.ejianc.business.tender.sub.vo;

import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;


/**
 * 招标文件供应商标
 * 
 * @author generator
 * 
 */
@ApiModel("招标文件供应商标")
public class SubDocumentSupplierSellVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    @ApiModelProperty("供应商租户主键")
    private String supplierTenantId;
    @ApiModelProperty("供应商ID")
    private Long supplierId;
    @ApiModelProperty("供应商name")
    private String supplierName;
    @ApiModelProperty("报价时间")
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date offerTime;
    @ApiModelProperty("招标立项主键")
    private Long inviteId;
    @ApiModelProperty("联系人")
    private String linkName;
    @ApiModelProperty("联系电话")
    private String linkMobile;
    @ApiModelProperty("发票说明")
    private String taxMemo;
    @ApiModelProperty("采购方式(0-项目采购,1-单位采购)")
    private Integer purchaseType;
    @ApiModelProperty("招标文件方案表")
    private List<SubDocumentSchemeVO> subDocumentSchemeList = new ArrayList<>();
    @ApiModelProperty("多轮报详情")
    private List<SubTalkVO> subTalkVOList = new ArrayList<>();
    @ApiModelProperty("附件名称")
    private String fileName;
    @ApiModelProperty("附件主键")
    private Long attachId;

    private BigDecimal mnySubTender; //投标总价（无税）
    private java.lang.String mnySubTenderName; // 投标总价（无税）大写
    private BigDecimal taxMnySubTender; // 投标总价
    private java.lang.String taxMnySubTenderName; // 投标总价大写

    private java.lang.String priceType; // 新增单价确定方式
    private java.lang.String qualityPromise; // 质量承诺
    private java.lang.String safePromise; // 安全文明施工承诺
    private java.lang.String durationPromise; // 工期承诺
    private java.lang.String marginType; // 投标保证金形式
    private java.lang.String otherPromise; //其他承诺

    public BigDecimal getMnySubTender() {
        return mnySubTender;
    }

    public void setMnySubTender(BigDecimal mnySubTender) {
        this.mnySubTender = mnySubTender;
    }

    public String getMnySubTenderName() {
        return mnySubTenderName;
    }

    public void setMnySubTenderName(String mnySubTenderName) {
        this.mnySubTenderName = mnySubTenderName;
    }

    public BigDecimal getTaxMnySubTender() {
        return taxMnySubTender;
    }

    public void setTaxMnySubTender(BigDecimal taxMnySubTender) {
        this.taxMnySubTender = taxMnySubTender;
    }

    public String getTaxMnySubTenderName() {
        return taxMnySubTenderName;
    }

    public void setTaxMnySubTenderName(String taxMnySubTenderName) {
        this.taxMnySubTenderName = taxMnySubTenderName;
    }

    public String getPriceType() {
        return priceType;
    }

    public void setPriceType(String priceType) {
        this.priceType = priceType;
    }

    public String getQualityPromise() {
        return qualityPromise;
    }

    public void setQualityPromise(String qualityPromise) {
        this.qualityPromise = qualityPromise;
    }

    public String getSafePromise() {
        return safePromise;
    }

    public void setSafePromise(String safePromise) {
        this.safePromise = safePromise;
    }

    public String getDurationPromise() {
        return durationPromise;
    }

    public void setDurationPromise(String durationPromise) {
        this.durationPromise = durationPromise;
    }

    public String getMarginType() {
        return marginType;
    }

    public void setMarginType(String marginType) {
        this.marginType = marginType;
    }

    public String getOtherPromise() {
        return otherPromise;
    }

    public void setOtherPromise(String otherPromise) {
        this.otherPromise = otherPromise;
    }

    public String getFileName() {
        return fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public Long getAttachId() {
        return attachId;
    }

    public void setAttachId(Long attachId) {
        this.attachId = attachId;
    }

    public String getSupplierTenantId() {
        return supplierTenantId;
    }

    public void setSupplierTenantId(String supplierTenantId) {
        this.supplierTenantId = supplierTenantId;
    }

    public Integer getPurchaseType() {
        return purchaseType;
    }

    public void setPurchaseType(Integer purchaseType) {
        this.purchaseType = purchaseType;
    }

    public List<SubTalkVO> getSubTalkVOList() {
        return subTalkVOList;
    }

    public void setSubTalkVOList(List<SubTalkVO> subTalkVOList) {
        this.subTalkVOList = subTalkVOList;
    }

    public String getLinkName() {
        return linkName;
    }

    public void setLinkName(String linkName) {
        this.linkName = linkName;
    }

    public String getLinkMobile() {
        return linkMobile;
    }

    public void setLinkMobile(String linkMobile) {
        this.linkMobile = linkMobile;
    }

    public String getTaxMemo() {
        return taxMemo;
    }

    public void setTaxMemo(String taxMemo) {
        this.taxMemo = taxMemo;
    }

    public Long getInviteId() {
        return inviteId;
    }

    public void setInviteId(Long inviteId) {
        this.inviteId = inviteId;
    }

    public Long getSupplierId() {
        return supplierId;
    }

    public void setSupplierId(Long supplierId) {
        this.supplierId = supplierId;
    }

    public String getSupplierName() {
        return supplierName;
    }

    public void setSupplierName(String supplierName) {
        this.supplierName = supplierName;
    }

    public Date getOfferTime() {
        return offerTime;
    }

    public void setOfferTime(Date offerTime) {
        this.offerTime = offerTime;
    }

    public List<SubDocumentSchemeVO> getSubDocumentSchemeList() {
        return subDocumentSchemeList;
    }

    public void setSubDocumentSchemeList(List<SubDocumentSchemeVO> subDocumentSchemeList) {
        this.subDocumentSchemeList = subDocumentSchemeList;
    }
}
