package com.ejianc.business.tender.equipment.vo;

import com.ejianc.framework.skeleton.template.BaseVO;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.math.BigDecimal;


/**
 * 报价明细实体
 * 
 * @author generator
 * 
 */
@ApiModel("报价明细实体")
public class EquipmentSupplierSellSchemeDetailVO extends BaseVO {
    private static final long serialVersionUID = 1L;

    @ApiModelProperty("招标信息主键")
    private String sourceId;
    @ApiModelProperty("方案主键")
    private Long schemeId;
    @ApiModelProperty("材料ID")
    private String sourceMaterialId;
    @ApiModelProperty("材料名称")
    private String materialName;
    @ApiModelProperty("材料编码")
    private String materialCode;
    @ApiModelProperty("材料分类ID")
    private String sourceMaterialTypeId;
    @ApiModelProperty("材料分类名称")
    private String materialTypeName;
    @ApiModelProperty("单位")
    private String unit;
    @ApiModelProperty("规格型号")
    private String spec;
    @ApiModelProperty("品牌")
    private String brand;
    @ApiModelProperty("计量方式(0-理计,1-过磅,2-点数)")
    private Integer calculateType;
    @ApiModelProperty("数量")
    private java.math.BigDecimal num;
    @ApiModelProperty("税率")
    private java.math.BigDecimal rate;
    @ApiModelProperty("备注")
    private String memo;
    @ApiModelProperty("供货品牌")
    private String supplierBrand;
    @ApiModelProperty("单价")
    private java.math.BigDecimal price;
    @ApiModelProperty("单价(含税)")
    private java.math.BigDecimal priceTax;
    @ApiModelProperty("总额")
    private java.math.BigDecimal money;
    @ApiModelProperty("总额(含税)")
    private java.math.BigDecimal moneyTax;
    @ApiModelProperty("税额")
    private java.math.BigDecimal tax;
    @ApiModelProperty("备注")
    private String supplierMemo;
    private BigDecimal detailRate; // 材料税率

    public BigDecimal getDetailRate() {
        return detailRate;
    }

    public void setDetailRate(BigDecimal detailRate) {
        this.detailRate = detailRate;
    }

    /**
     * 招标信息主键
     */
    public String getSourceId() {
        return sourceId;
    }

    /**
     * 招标信息主键
     */
    public void setSourceId(String sourceId) {
        this.sourceId = sourceId;
    }
    /**
     * 方案主键
     */
    public Long getSchemeId() {
        return schemeId;
    }

    /**
     * 方案主键
     */
    public void setSchemeId(Long schemeId) {
        this.schemeId = schemeId;
    }
    /**
     * 材料ID
     */
    public String getSourceMaterialId() {
        return sourceMaterialId;
    }

    /**
     * 材料ID
     */
    public void setSourceMaterialId(String sourceMaterialId) {
        this.sourceMaterialId = sourceMaterialId;
    }
    /**
     * 材料名称
     */
    public String getMaterialName() {
        return materialName;
    }

    /**
     * 材料名称
     */
    public void setMaterialName(String materialName) {
        this.materialName = materialName;
    }
    /**
     * 材料编码
     */
    public String getMaterialCode() {
        return materialCode;
    }

    /**
     * 材料编码
     */
    public void setMaterialCode(String materialCode) {
        this.materialCode = materialCode;
    }
    /**
     * 材料分类ID
     */
    public String getSourceMaterialTypeId() {
        return sourceMaterialTypeId;
    }

    /**
     * 材料分类ID
     */
    public void setSourceMaterialTypeId(String sourceMaterialTypeId) {
        this.sourceMaterialTypeId = sourceMaterialTypeId;
    }
    /**
     * 材料分类名称
     */
    public String getMaterialTypeName() {
        return materialTypeName;
    }

    /**
     * 材料分类名称
     */
    public void setMaterialTypeName(String materialTypeName) {
        this.materialTypeName = materialTypeName;
    }
    /**
     * 单位
     */
    public String getUnit() {
        return unit;
    }

    /**
     * 单位
     */
    public void setUnit(String unit) {
        this.unit = unit;
    }
    /**
     * 规格型号
     */
    public String getSpec() {
        return spec;
    }

    /**
     * 规格型号
     */
    public void setSpec(String spec) {
        this.spec = spec;
    }
    /**
     * 品牌
     */
    public String getBrand() {
        return brand;
    }

    /**
     * 品牌
     */
    public void setBrand(String brand) {
        this.brand = brand;
    }
    /**
     * 计量方式(0-理计,1-过磅,2-点数)
     */
    public Integer getCalculateType() {
        return calculateType;
    }

    /**
     * 计量方式(0-理计,1-过磅,2-点数)
     */
    public void setCalculateType(Integer calculateType) {
        this.calculateType = calculateType;
    }
    /**
     * 数量
     */
    public java.math.BigDecimal getNum() {
        return num;
    }

    /**
     * 数量
     */
    public void setNum(java.math.BigDecimal num) {
        this.num = num;
    }
    /**
     * 税率
     */
    public java.math.BigDecimal getRate() {
        return rate;
    }

    /**
     * 税率
     */
    public void setRate(java.math.BigDecimal rate) {
        this.rate = rate;
    }
    /**
     * 备注
     */
    public String getMemo() {
        return memo;
    }

    /**
     * 备注
     */
    public void setMemo(String memo) {
        this.memo = memo;
    }
    /**
     * 供货品牌
     */
    public String getSupplierBrand() {
        return supplierBrand;
    }

    /**
     * 供货品牌
     */
    public void setSupplierBrand(String supplierBrand) {
        this.supplierBrand = supplierBrand;
    }
    /**
     * 单价
     */
    public java.math.BigDecimal getPrice() {
        return price;
    }

    /**
     * 单价
     */
    public void setPrice(java.math.BigDecimal price) {
        this.price = price;
    }
    /**
     * 单价(含税)
     */
    public java.math.BigDecimal getPriceTax() {
        return priceTax;
    }

    /**
     * 单价(含税)
     */
    public void setPriceTax(java.math.BigDecimal priceTax) {
        this.priceTax = priceTax;
    }
    /**
     * 总额
     */
    public java.math.BigDecimal getMoney() {
        return money;
    }

    /**
     * 总额
     */
    public void setMoney(java.math.BigDecimal money) {
        this.money = money;
    }
    /**
     * 总额(含税)
     */
    public java.math.BigDecimal getMoneyTax() {
        return moneyTax;
    }

    /**
     * 总额(含税)
     */
    public void setMoneyTax(java.math.BigDecimal moneyTax) {
        this.moneyTax = moneyTax;
    }
    /**
     * 税额
     */
    public java.math.BigDecimal getTax() {
        return tax;
    }

    /**
     * 税额
     */
    public void setTax(java.math.BigDecimal tax) {
        this.tax = tax;
    }
    /**
     * 备注
     */
    public String getSupplierMemo() {
        return supplierMemo;
    }

    /**
     * 备注
     */
    public void setSupplierMemo(String supplierMemo) {
        this.supplierMemo = supplierMemo;
    }
    
}
