package com.ejianc.business.tender.sub.vo;

import com.baomidou.mybatisplus.annotation.TableField;
import com.ejianc.framework.skeleton.template.BaseVO;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;


/**
 * 招标文件物料详情表
 * 
 * @author generator
 * 
 */
@ApiModel("招标文件物料详情表")
public class SubDocumentDetailVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    @ApiModelProperty("招标文件主键")
    private Long documentId;
    @ApiModelProperty("材料ID")
    private Long materialId;
    @ApiModelProperty("材料名称")
    private String materialName;
    @ApiModelProperty("材料编码")
    private String materialCode;
    @ApiModelProperty("材料分类ID")
    private Long materialTypeId;
    @ApiModelProperty("材料分类名称")
    private String materialTypeName;
    @ApiModelProperty("单位")
    private String unit;
    @ApiModelProperty("规格型号")
    private String spec;
    @ApiModelProperty("备注")
    private String memo;
    @ApiModelProperty("项目ID")
    private Long detailProjectId;
    @ApiModelProperty("项目名称")
    private String detailProjectName;
    @ApiModelProperty("组织ID")
    private Long detailOrgId; // 组织ID
    @ApiModelProperty("组织名称")
    private String detailOrgName; // 组织名称
    @ApiModelProperty("计划ID")
    private Long planId;
    @ApiModelProperty("计划名称")
    private String planName;
    @ApiModelProperty("计划编码")
    private String planCode;
    @ApiModelProperty("计划金额")
    private java.math.BigDecimal planMoney;
    @ApiModelProperty("品牌")
    private String brand;
    @ApiModelProperty("计量方式(0-理计,1-过磅,2-点数)")
    private Integer calculateType;
    @ApiModelProperty("数量")
    private java.math.BigDecimal num;
    @ApiModelProperty("税率")
    private java.math.BigDecimal rate;
    @ApiModelProperty("暂估金额")
    private java.math.BigDecimal money;
    @ApiModelProperty("暂估金额(含税)")
    private java.math.BigDecimal moneyTax;
    @ApiModelProperty("父ID")
    private Long parentId;
    @ApiModelProperty("工作内容")
    private String content;
    @ApiModelProperty("计量规则")
    private String rule;
    @ApiModelProperty("材料设备供应")
    private String materialEquipmentSupply; //材料设备供应

    @ApiModelProperty("报价表")
    private List<SubDocumentSupplierVO> subDocumentSupplierVOList  = new ArrayList<>();
    private List<SubDocumentSellVO> subDocumentSellVOList  = new ArrayList<>();
    private BigDecimal artificialTaxMny; //人工费金额
    private BigDecimal artificialMny; //人工费金额（无税）
    private BigDecimal artificialTax; //人工费税额
    private BigDecimal artificialTaxPrice; // 人工费单价
    private BigDecimal artificialPrice; // 人工费单价(无税）

    public BigDecimal getArtificialTaxMny() {
        return artificialTaxMny;
    }

    public void setArtificialTaxMny(BigDecimal artificialTaxMny) {
        this.artificialTaxMny = artificialTaxMny;
    }

    public BigDecimal getArtificialMny() {
        return artificialMny;
    }

    public void setArtificialMny(BigDecimal artificialMny) {
        this.artificialMny = artificialMny;
    }

    public BigDecimal getArtificialTax() {
        return artificialTax;
    }

    public void setArtificialTax(BigDecimal artificialTax) {
        this.artificialTax = artificialTax;
    }

    public BigDecimal getArtificialTaxPrice() {
        return artificialTaxPrice;
    }

    public void setArtificialTaxPrice(BigDecimal artificialTaxPrice) {
        this.artificialTaxPrice = artificialTaxPrice;
    }

    public BigDecimal getArtificialPrice() {
        return artificialPrice;
    }

    public void setArtificialPrice(BigDecimal artificialPrice) {
        this.artificialPrice = artificialPrice;
    }
    public Long getParentId() {
        return parentId;
    }

    public void setParentId(Long parentId) {
        this.parentId = parentId;
    }

    public String getContent() {
        return content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public String getRule() {
        return rule;
    }

    public void setRule(String rule) {
        this.rule = rule;
    }

    public List<SubDocumentSellVO> getSubDocumentSellVOList() {
        return subDocumentSellVOList;
    }

    public void setSubDocumentSellVOList(List<SubDocumentSellVO> subDocumentSellVOList) {
        this.subDocumentSellVOList = subDocumentSellVOList;
    }

    public List<SubDocumentSupplierVO> getSubDocumentSupplierVOList() {
        return subDocumentSupplierVOList;
    }

    public void setSubDocumentSupplierVOList(List<SubDocumentSupplierVO> subDocumentSupplierVOList) {
        this.subDocumentSupplierVOList = subDocumentSupplierVOList;
    }


    /**
     * 招标文件主键
     */
    public Long getDocumentId() {
        return documentId;
    }

    /**
     * 招标文件主键
     */
    public void setDocumentId(Long documentId) {
        this.documentId = documentId;
    }
    /**
     * 材料ID
     */
    public Long getMaterialId() {
        return materialId;
    }

    /**
     * 材料ID
     */
    public void setMaterialId(Long materialId) {
        this.materialId = materialId;
    }
    /**
     * 材料名称
     */
    public String getMaterialName() {
        return materialName;
    }

    /**
     * 材料名称
     */
    public void setMaterialName(String materialName) {
        this.materialName = materialName;
    }
    /**
     * 材料编码
     */
    public String getMaterialCode() {
        return materialCode;
    }

    /**
     * 材料编码
     */
    public void setMaterialCode(String materialCode) {
        this.materialCode = materialCode;
    }
    /**
     * 材料分类ID
     */
    public Long getMaterialTypeId() {
        return materialTypeId;
    }

    /**
     * 材料分类ID
     */
    public void setMaterialTypeId(Long materialTypeId) {
        this.materialTypeId = materialTypeId;
    }
    /**
     * 材料分类名称
     */
    public String getMaterialTypeName() {
        return materialTypeName;
    }

    /**
     * 材料分类名称
     */
    public void setMaterialTypeName(String materialTypeName) {
        this.materialTypeName = materialTypeName;
    }
    /**
     * 单位
     */
    public String getUnit() {
        return unit;
    }

    /**
     * 单位
     */
    public void setUnit(String unit) {
        this.unit = unit;
    }
    /**
     * 规格型号
     */
    public String getSpec() {
        return spec;
    }

    /**
     * 规格型号
     */
    public void setSpec(String spec) {
        this.spec = spec;
    }
    /**
     * 备注
     */
    public String getMemo() {
        return memo;
    }

    /**
     * 备注
     */
    public void setMemo(String memo) {
        this.memo = memo;
    }

    public Long getDetailProjectId() {
        return detailProjectId;
    }

    public void setDetailProjectId(Long detailProjectId) {
        this.detailProjectId = detailProjectId;
    }

    public String getDetailProjectName() {
        return detailProjectName;
    }

    public void setDetailProjectName(String detailProjectName) {
        this.detailProjectName = detailProjectName;
    }

    public Long getDetailOrgId() {
        return detailOrgId;
    }

    public void setDetailOrgId(Long detailOrgId) {
        this.detailOrgId = detailOrgId;
    }

    public String getDetailOrgName() {
        return detailOrgName;
    }

    public void setDetailOrgName(String detailOrgName) {
        this.detailOrgName = detailOrgName;
    }

    /**
     * 计划ID
     */
    public Long getPlanId() {
        return planId;
    }

    /**
     * 计划ID
     */
    public void setPlanId(Long planId) {
        this.planId = planId;
    }
    /**
     * 计划名称
     */
    public String getPlanName() {
        return planName;
    }

    /**
     * 计划名称
     */
    public void setPlanName(String planName) {
        this.planName = planName;
    }
    /**
     * 计划编码
     */
    public String getPlanCode() {
        return planCode;
    }

    /**
     * 计划编码
     */
    public void setPlanCode(String planCode) {
        this.planCode = planCode;
    }
    /**
     * 计划金额
     */
    public java.math.BigDecimal getPlanMoney() {
        return planMoney;
    }

    /**
     * 计划金额
     */
    public void setPlanMoney(java.math.BigDecimal planMoney) {
        this.planMoney = planMoney;
    }
    /**
     * 品牌
     */
    public String getBrand() {
        return brand;
    }

    /**
     * 品牌
     */
    public void setBrand(String brand) {
        this.brand = brand;
    }
    /**
     * 计量方式(0-理计,1-过磅,2-点数)
     */
    public Integer getCalculateType() {
        return calculateType;
    }

    /**
     * 计量方式(0-理计,1-过磅,2-点数)
     */
    public void setCalculateType(Integer calculateType) {
        this.calculateType = calculateType;
    }
    /**
     * 数量
     */
    public java.math.BigDecimal getNum() {
        return num;
    }

    /**
     * 数量
     */
    public void setNum(java.math.BigDecimal num) {
        this.num = num;
    }
    /**
     * 税率
     */
    public java.math.BigDecimal getRate() {
        return rate;
    }

    /**
     * 税率
     */
    public void setRate(java.math.BigDecimal rate) {
        this.rate = rate;
    }
    /**
     * 暂估金额
     */
    public java.math.BigDecimal getMoney() {
        return money;
    }

    /**
     * 暂估金额
     */
    public void setMoney(java.math.BigDecimal money) {
        this.money = money;
    }
    /**
     * 暂估金额(含税)
     */
    public java.math.BigDecimal getMoneyTax() {
        return moneyTax;
    }

    /**
     * 暂估金额(含税)
     */
    public void setMoneyTax(java.math.BigDecimal moneyTax) {
        this.moneyTax = moneyTax;
    }

    public String getMaterialEquipmentSupply() {
        return materialEquipmentSupply;
    }

    public void setMaterialEquipmentSupply(String materialEquipmentSupply) {
        this.materialEquipmentSupply = materialEquipmentSupply;
    }
}
