package com.ejianc.business.tender.rent.vo;

import com.baomidou.mybatisplus.annotation.TableField;
import com.ejianc.business.pro.supplier.vo.InviteVO;
import com.ejianc.business.tender.other.vo.OtherInviteVO;
import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * 材料立项主表
 *
 * @author generator
 *
 */
public class RentInviteVO extends BaseVO {
    private static final long serialVersionUID = 1L;

    private String billCode; // 单据编号
    private Long projectId; // 项目ID
    private String projectName; // 项目名称
    private Long employeeId; // 编制人
    private String employeeName; // 编制人名称
    private Long unitId; // 招标单位ID
    private String unitName; // 招标单位名称
    private String memo; // 备注
    private Integer billState; // 单据状态（审批必须字段）
    private String billStateName; // 单据状态（审批必须字段）
    private String tenderName; // 招标名称
    private Integer tenderType; // 招标方式(0-平台公开招标,1-邀请招标,2-询价,3-竞争性谈判,4-单一来源,5-紧急招标)
    private Integer tenderStage; // 招标阶段
    private String tenderStageName; // 招标阶段名称
    private String tenderUnitNum; // 中标单位及数量
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private java.util.Date createDate; // 编制日期
    private Integer valueType; // 计价方式(0-固定单价,1-浮动单价,2-固定总额)
    private String purchaseId; // 采购方式ID
    private String purchaseName; // 采购方式名称
    private String projectCode; // 项目编号
    private java.math.BigDecimal tenderMoney; // 招标金额
    private Long orgId; // 组织
    private String orgName; // 组织名称
    private Long parentOrgId; // 父级组织
    private String parentOrgName; // 父级组织名称
    private Integer establishType; // 立项类型(0-招标立项，1-定标立项)
    private String tenderTypeName; // 招标方式(0-平台公开招标,1-邀请招标,2-询价,3-竞争性谈判,4-单一来源,5-紧急招标)
    private String establishTypeName; // 立项类型(0-招标立项，1-定标立项)
    private Integer purchaseType; // 采购方式(0-项目采购,1-单位采购)
    private String purchaseTypeName; // 采购方式(0-项目采购,1-单位采购)
    private Integer abolishType;//流/废标（0-正常，1-流标，2-废标）
    private String contractType;//合同类型(0-消耗材,1-周转材,2-混凝土,3-零星材料)
    private String contractTypeName;//合同类型(0-消耗材,1-周转材,2-混凝土,3-零星材料)
    private Integer rentType; // 租赁方式(0-日租,1-月租,2-工程量租)
    private java.lang.Integer tenderPlatform; // 招标平台(1-招采平台，2-云上营家)
    @TableField(value="sign_status")
    private Integer signStatus; //签订状态:0-未签订,1-部分签订,2-全部已签,3-已关闭
    @TableField(value="money")
    private java.math.BigDecimal money; // 定标金额(无税)
    @TableField(value="tax_money")
    private java.math.BigDecimal taxMoney; // 定标金额(含税)
    private String signStatusName; //签订状态:0-未签订,1-部分签订,2-全部已签,3-已关闭
    private Integer occupyState; //占用状态:0-未占用,1-已占用
    private Long supplierId; // 供应商ID
    private String supplierName; // 供应商名称
    private Integer tenderState; // 招标状态:1-报名中,2-报价中,3-专家评标中,4-专家评标结束
    private String tenderStateName; // 招标状态:1-报名中,2-报价中,3-专家评标中,4-专家评标结束
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private java.util.Date stopTime; // 报名或报价截止时间

    private Long equipmentType; // 设备类型（0-机械设备租赁，1-机械承揽）



    @TableField(value="draft_type")
    private Integer draftType; //招标文件生成方式  线上起草-1、手动上传-2
    @TableField(value="contract_file_path")
    private String contractFilePath; // 合同附件路径
    @TableField(value="contract_file_id")
    private Long contractFileId; // 合同附件Id
    @TableField(value="contract_template_id")
    private Long contractTemplateId; // 合同模板Id
    @TableField(value="contract_template_name")
    private String contractTemplateName; // 合同模板名称
    @TableField(value="contract_category_id")
    private Long contractCategoryId; // 招标文件模版(分类)Id--实际存储的是供货内容id
    @TableField(value="contract_category_name")
    private String contractCategoryName; // 招标文件模版(分类)名称--实际存储的是供货内容name
    @TableField(value="contract_file_highlight_path")
    private String contractFileHighlightPath; // 合同高亮附件路径
    @TableField(value="contract_file_highlight_id")
    private Long contractFileHighlightId; // 合同高亮附件Id
    /**
     * 线上起草合同，审批中修改的合同是否已重新进行合同编辑
     */
    @TableField(value = "contract_file_sync_flag")
    private Boolean contractFileSyncFlag = true;

    private String supplierTenderName; // 报价供应商名称-导出用
    @TableField(value="source_tender_id")
    private Long sourceTenderId; //流标/废标来源单据id
    @TableField(value="source_tender_code")
    private String sourceTenderCode; //流标/废标来源单据code
    @TableField(value="retender_flag")
    private Integer retenderFlag;//是否重新发起招标立项 0-否, 1-是

    private Long contractCategoryTypeId; // 合同类别Id
    private String contractCategoryTypeName; // 合同类别名称
    private Long templateId; // 专家评标模板Id
    private String templateName; // 专家评标模板名称

    private Boolean reviewFlag; // 是否开启初步评审 模板类型=分包、设备租赁时，默认开启，非这两种类型意外其他类型默认关
    private Integer tecScore; // 技术得分 默认为0
    private Integer bidEvaluateType; // 评标类型 枚举值为 1【综合评标法】/ 2【经评审的最低价法】
    private Long contractTemplateFileId; // 合同模板附件Id
    private Long inviteMergeFileId; // 合并附件Id（线上起草后，附件与模板合并后的附件id）

    private List<RentInviteClauseVO> clauseList = new ArrayList<>(); // 合同条款
    private List<RentInviteTemplateDetailVO> templateDetailList = new ArrayList<>(); // 分包模板子表

    public List<RentInviteClauseVO> getClauseList() {
        return clauseList;
    }

    public void setClauseList(List<RentInviteClauseVO> clauseList) {
        this.clauseList = clauseList;
    }

    public List<RentInviteTemplateDetailVO> getTemplateDetailList() {
        return templateDetailList;
    }

    public void setTemplateDetailList(List<RentInviteTemplateDetailVO> templateDetailList) {
        this.templateDetailList = templateDetailList;
    }

    public Long getContractCategoryTypeId() {
        return contractCategoryTypeId;
    }
    @ReferDeserialTransfer
    public void setContractCategoryTypeId(Long contractCategoryTypeId) {
        this.contractCategoryTypeId = contractCategoryTypeId;
    }

    public String getContractCategoryTypeName() {
        return contractCategoryTypeName;
    }

    public void setContractCategoryTypeName(String contractCategoryTypeName) {
        this.contractCategoryTypeName = contractCategoryTypeName;
    }


    @ReferSerialTransfer(referCode="evaluation_template")
    public Long getTemplateId() {
        return templateId;
    }

    @ReferDeserialTransfer
    public void setTemplateId(Long templateId) {
        this.templateId = templateId;
    }

    public String getTemplateName() {
        return templateName;
    }

    public void setTemplateName(String templateName) {
        this.templateName = templateName;
    }

    public Boolean getReviewFlag() {
        return reviewFlag;
    }

    public void setReviewFlag(Boolean reviewFlag) {
        this.reviewFlag = reviewFlag;
    }

    public Integer getTecScore() {
        return tecScore;
    }

    public void setTecScore(Integer tecScore) {
        this.tecScore = tecScore;
    }

    public Integer getBidEvaluateType() {
        return bidEvaluateType;
    }

    public void setBidEvaluateType(Integer bidEvaluateType) {
        this.bidEvaluateType = bidEvaluateType;
    }

    public Long getContractTemplateFileId() {
        return contractTemplateFileId;
    }

    public void setContractTemplateFileId(Long contractTemplateFileId) {
        this.contractTemplateFileId = contractTemplateFileId;
    }

    public Long getInviteMergeFileId() {
        return inviteMergeFileId;
    }

    public void setInviteMergeFileId(Long inviteMergeFileId) {
        this.inviteMergeFileId = inviteMergeFileId;
    }

    public Integer getRetenderFlag() {
        return retenderFlag;
    }

    public void setRetenderFlag(Integer retenderFlag) {
        this.retenderFlag = retenderFlag;
    }
    List<RentInviteVO> lastInviteList = new ArrayList<>();

    public List<RentInviteVO> getLastInviteList() {
        return lastInviteList;
    }

    public void setLastInviteList(List<RentInviteVO> lastInviteList) {
        this.lastInviteList = lastInviteList;
    }

    public Long getSourceTenderId() {
        return sourceTenderId;
    }

    public void setSourceTenderId(Long sourceTenderId) {
        this.sourceTenderId = sourceTenderId;
    }

    public String getSourceTenderCode() {
        return sourceTenderCode;
    }

    public void setSourceTenderCode(String sourceTenderCode) {
        this.sourceTenderCode = sourceTenderCode;
    }
    public String getSupplierTenderName() {
        return supplierTenderName;
    }

    public void setSupplierTenderName(String supplierTenderName) {
        this.supplierTenderName = supplierTenderName;
    }

    public Integer getDraftType() {
        return draftType;
    }

    public void setDraftType(Integer draftType) {
        this.draftType = draftType;
    }

    public String getContractFilePath() {
        return contractFilePath;
    }

    public void setContractFilePath(String contractFilePath) {
        this.contractFilePath = contractFilePath;
    }

    public Long getContractFileId() {
        return contractFileId;
    }

    public void setContractFileId(Long contractFileId) {
        this.contractFileId = contractFileId;
    }

    public Long getContractTemplateId() {
        return contractTemplateId;
    }

    public void setContractTemplateId(Long contractTemplateId) {
        this.contractTemplateId = contractTemplateId;
    }

    public String getContractTemplateName() {
        return contractTemplateName;
    }

    public void setContractTemplateName(String contractTemplateName) {
        this.contractTemplateName = contractTemplateName;
    }

    public Long getContractCategoryId() {
        return contractCategoryId;
    }

    public void setContractCategoryId(Long contractCategoryId) {
        this.contractCategoryId = contractCategoryId;
    }

    public String getContractCategoryName() {
        return contractCategoryName;
    }

    public void setContractCategoryName(String contractCategoryName) {
        this.contractCategoryName = contractCategoryName;
    }

    public String getContractFileHighlightPath() {
        return contractFileHighlightPath;
    }

    public void setContractFileHighlightPath(String contractFileHighlightPath) {
        this.contractFileHighlightPath = contractFileHighlightPath;
    }

    public Long getContractFileHighlightId() {
        return contractFileHighlightId;
    }

    public void setContractFileHighlightId(Long contractFileHighlightId) {
        this.contractFileHighlightId = contractFileHighlightId;
    }

    public Boolean getContractFileSyncFlag() {
        return contractFileSyncFlag;
    }

    public void setContractFileSyncFlag(Boolean contractFileSyncFlag) {
        this.contractFileSyncFlag = contractFileSyncFlag;
    }


    public Long getEquipmentType() {
        return equipmentType;
    }

    public void setEquipmentType(Long equipmentType) {
        this.equipmentType = equipmentType;
    }
    public Long getSupplierId() {
        return supplierId;
    }

    public void setSupplierId(Long supplierId) {
        this.supplierId = supplierId;
    }

    public String getSupplierName() {
        return supplierName;
    }

    public void setSupplierName(String supplierName) {
        this.supplierName = supplierName;
    }

    public Integer getOccupyState() {
        return occupyState;
    }

    public void setOccupyState(Integer occupyState) {
        this.occupyState = occupyState;
    }

    public String getSignStatusName() {
        return signStatusName;
    }

    public void setSignStatusName(String signStatusName) {
        this.signStatusName = signStatusName;
    }

    public BigDecimal getMoney() {
        return money;
    }

    public void setMoney(BigDecimal money) {
        this.money = money;
    }

    public BigDecimal getTaxMoney() {
        return taxMoney;
    }

    public void setTaxMoney(BigDecimal taxMoney) {
        this.taxMoney = taxMoney;
    }
    @SubEntity
    private List<RentInviteDetailVO> rentDetail = new ArrayList<>(); // 材料招标立项采购清单表
    private List<RentInviteSupplierVO> supplierDetail = new ArrayList<>(); // 材料招标立项供应商表
    @SubEntity
    private List<RentInviteDetailRecordVO> rentDetailRecord = new ArrayList<>(); // 材料招标立项采购清单表不合并
//    private List<RentInviteExpertVO> expertDetail = new ArrayList<>(); // 材料招标立项专家表
    private List<RentInviteDetailBidderVO> rentDetailBidder = new ArrayList<>(); // 材料定标立项定标情况表

    public Integer getSignStatus() {
        return signStatus;
    }

    public void setSignStatus(Integer signStatus) {
        this.signStatus = signStatus;
    }

    public Integer getTenderPlatform() {
        return tenderPlatform;
    }

    public void setTenderPlatform(Integer tenderPlatform) {
        this.tenderPlatform = tenderPlatform;
    }

    public Integer getRentType() {
        return rentType;
    }

    public void setRentType(Integer rentType) {
        this.rentType = rentType;
    }

    public List<RentInviteDetailRecordVO> getRentDetailRecord() {
        return rentDetailRecord;
    }

    public void setRentDetailRecord(List<RentInviteDetailRecordVO> rentDetailRecord) {
        this.rentDetailRecord = rentDetailRecord;
    }

    public String getContractTypeName() {
        return contractTypeName;
    }

    public void setContractTypeName(String contractTypeName) {
        this.contractTypeName = contractTypeName;
    }

    public String getContractType() {
        return contractType;
    }

    public void setContractType(String contractType) {
        this.contractType = contractType;
    }

    public Integer getPurchaseType() {
        return purchaseType;
    }

    public void setPurchaseType(Integer purchaseType) {
        this.purchaseType = purchaseType;
    }

    public String getPurchaseTypeName() {
        return purchaseTypeName;
    }

    public void setPurchaseTypeName(String purchaseTypeName) {
        this.purchaseTypeName = purchaseTypeName;
    }

    public String getTenderStageName() {
        return tenderStageName;
    }

    public void setTenderStageName(String tenderStageName) {
        this.tenderStageName = tenderStageName;
    }

    public String getBillStateName() {
        return billStateName;
    }

    public void setBillStateName(String billStateName) {
        this.billStateName = billStateName;
    }

    public String getTenderTypeName() {
        return tenderTypeName;
    }

    public void setTenderTypeName(String tenderTypeName) {
        this.tenderTypeName = tenderTypeName;
    }

    public String getEstablishTypeName() {
        return establishTypeName;
    }

    public void setEstablishTypeName(String establishTypeName) {
        this.establishTypeName = establishTypeName;
    }

    /**
     * 流/废标状态
     */
    public Integer getAbolishType() {
        return abolishType;
    }

    public void setAbolishType(Integer abolishType) {
        this.abolishType = abolishType;
    }

    /**
     * 单据编号
     */
    public String getBillCode() {
        return billCode;
    }

    /**
     * 单据编号
     */
    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    /**
     * 项目ID
     */
    @ReferSerialTransfer(referCode = "project-set")
    public Long getProjectId() {
        return projectId;
    }

    /**
     * 项目ID
     */
    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    /**
     * 项目名称
     */
    public String getProjectName() {
        return projectName;
    }

    /**
     * 项目名称
     */
    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    /**
     * 编制人
     */
    public Long getEmployeeId() {
        return employeeId;
    }

    /**
     * 编制人
     */
    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    /**
     * 编制人名称
     */
    public String getEmployeeName() {
        return employeeName;
    }

    /**
     * 编制人名称
     */
    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    /**
     * 招标单位ID
     */
    @ReferSerialTransfer(referCode="idm-org")
    public Long getUnitId() {
        return unitId;
    }

    /**
     * 招标单位ID
     */
    @ReferDeserialTransfer
    public void setUnitId(Long unitId) {
        this.unitId = unitId;
    }
    /**
     * 招标单位名称
     */
    public String getUnitName() {
        return unitName;
    }

    /**
     * 招标单位名称
     */
    public void setUnitName(String unitName) {
        this.unitName = unitName;
    }
    /**
     * 备注
     */
    public String getMemo() {
        return memo;
    }

    /**
     * 备注
     */
    public void setMemo(String memo) {
        this.memo = memo;
    }
    /**
     * 单据状态（审批必须字段）
     */
    public Integer getBillState() {
        return billState;
    }

    /**
     * 单据状态（审批必须字段）
     */
    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    /**
     * 招标名称
     */
    public String getTenderName() {
        return tenderName;
    }

    /**
     * 招标名称
     */
    public void setTenderName(String tenderName) {
        this.tenderName = tenderName;
    }
    /**
     * 招标方式(0-平台公开招标,1-邀请招标,2-询价,3-竞争性谈判,4-单一来源,5-紧急招标)
     */
    public Integer getTenderType() {
        return tenderType;
    }

    /**
     * 招标方式(0-平台公开招标,1-邀请招标,2-询价,3-竞争性谈判,4-单一来源,5-紧急招标)
     */
    public void setTenderType(Integer tenderType) {
        this.tenderType = tenderType;
    }
    /**
     * 招标阶段
     */
    public Integer getTenderStage() {
        return tenderStage;
    }

    /**
     * 招标阶段
     */
    public void setTenderStage(Integer tenderStage) {
        this.tenderStage = tenderStage;
    }
    /**
     * 中标单位及数量
     */
    public String getTenderUnitNum() {
        return tenderUnitNum;
    }

    /**
     * 中标单位及数量
     */
    public void setTenderUnitNum(String tenderUnitNum) {
        this.tenderUnitNum = tenderUnitNum;
    }
    /**
     * 编制日期
     */
    public java.util.Date getCreateDate() {
        return createDate;
    }

    /**
     * 编制日期
     */
    public void setCreateDate(java.util.Date createDate) {
        this.createDate = createDate;
    }
    /**
     * 计价方式(0-固定单价,1-浮动单价,2-固定总额)
     */
    public Integer getValueType() {
        return valueType;
    }

    /**
     * 计价方式(0-固定单价,1-浮动单价,2-固定总额)
     */
    public void setValueType(Integer valueType) {
        this.valueType = valueType;
    }
    /**
     * 采购方式ID
     */
    public String getPurchaseId() {
        return purchaseId;
    }

    /**
     * 采购方式ID
     */
    public void setPurchaseId(String purchaseId) {
        this.purchaseId = purchaseId;
    }
    /**
     * 采购方式名称
     */
    public String getPurchaseName() {
        return purchaseName;
    }

    /**
     * 采购方式名称
     */
    public void setPurchaseName(String purchaseName) {
        this.purchaseName = purchaseName;
    }
    /**
     * 项目编号
     */
    public String getProjectCode() {
        return projectCode;
    }

    /**
     * 项目编号
     */
    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }
    /**
     * 招标金额
     */
    public java.math.BigDecimal getTenderMoney() {
        return tenderMoney;
    }

    /**
     * 招标金额
     */
    public void setTenderMoney(java.math.BigDecimal tenderMoney) {
        this.tenderMoney = tenderMoney;
    }
    /**
     * 组织
     */
    @ReferSerialTransfer(referCode="idm-org")
    public Long getOrgId() {
        return orgId;
    }

    /**
     * 组织
     */
    @ReferDeserialTransfer
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    /**
     * 组织名称
     */
    public String getOrgName() {
        return orgName;
    }

    /**
     * 组织名称
     */
    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    /**
     * 父级组织
     */
    public Long getParentOrgId() {
        return parentOrgId;
    }

    /**
     * 父级组织
     */
    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    /**
     * 父级组织名称
     */
    public String getParentOrgName() {
        return parentOrgName;
    }

    /**
     * 父级组织名称
     */
    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    /**
     * 立项类型(0-招标立项，1-定标立项)
     */
    public Integer getEstablishType() {
        return establishType;
    }

    /**
     * 立项类型(0-招标立项，1-定标立项)
     */
    public void setEstablishType(Integer establishType) {
        this.establishType = establishType;
    }

    public List<RentInviteDetailVO> getRentDetail() {
        return rentDetail;
    }

    public void setRentDetail(List<RentInviteDetailVO> rentDetail) {
        this.rentDetail = rentDetail;
    }

    public List<RentInviteSupplierVO> getSupplierDetail() {
        return supplierDetail;
    }

    public void setSupplierDetail(List<RentInviteSupplierVO> supplierDetail) {
        this.supplierDetail = supplierDetail;
    }


    public List<RentInviteDetailBidderVO> getRentDetailBidder() {
        return rentDetailBidder;
    }

    public void setRentDetailBidder(List<RentInviteDetailBidderVO> rentDetailBidder) {
        this.rentDetailBidder = rentDetailBidder;
    }

    public Integer getTenderState() {
        return tenderState;
    }

    public void setTenderState(Integer tenderState) {
        this.tenderState = tenderState;
    }

    public String getTenderStateName() {
        return tenderStateName;
    }

    public void setTenderStateName(String tenderStateName) {
        this.tenderStateName = tenderStateName;
    }

    public Date getStopTime() {
        return stopTime;
    }

    public void setStopTime(Date stopTime) {
        this.stopTime = stopTime;
    }
}
