package com.ejianc.business.tender.expert.vo;

import java.math.BigDecimal;
import java.util.List;
import java.util.ArrayList;

import com.baomidou.mybatisplus.annotation.TableField;
import com.ejianc.business.tender.equipment.vo.EquipmentInviteDetailRecordVO;
import com.ejianc.business.tender.other.vo.OtherInviteDetailRecordVO;
import com.ejianc.business.tender.rent.vo.RentInviteDetailRecordVO;
import com.ejianc.business.tender.rmat.vo.RmatInviteDetailRecordVO;
import com.ejianc.business.tender.stuff.vo.StuffDocumentDetailVO;
import com.ejianc.business.tender.stuff.vo.StuffDocumentSupplierVO;
import com.ejianc.business.tender.stuff.vo.StuffInviteDetailRecordVO;
import com.ejianc.business.tender.sub.vo.SubInviteDetailRecordVO;
import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;

import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * 材料专家评标主表
 * 
 * @author generator
 * 
 */
public class ExpertEvaluatingVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private Long projectId; // 项目ID
    private String projectName; // 项目名称
    private String projectCode; // 项目编号
    private Long templateId; // 模板Id
    private String templateName; // 模板名称
    private String evaluationName; // 评标名称
    private Long employeeId; // 招标联系人
    private String employeeName; // 招标联系人名称
    private String employeeMobile; // 招标联系人电话
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private java.util.Date startTime; // 评标开始日期
    private String memo; // 备注
    private Long inviteId; // 招标ID
    private Long documentId; // 招标文件主键
    private Long orgId; // 组织
    private String orgName; // 组织名称
    private Long parentOrgId; // 父级组织
    private String parentOrgName; // 父级组织名称
    private Integer billState; // 单据状态
    private String billCode; // 单据编号
    private String type; // 招标类型
    private Integer purchaseType; // 采购方式
    private Integer gatherStatus; // 汇总状态(0-待汇总,1-已汇总) 2-评审待汇总 3-评审已汇总
    private String gatherReason; // 汇总原因
    private String bidNum ; //评标人数
    private String bidBusinessNum ; //商务专家评标人数
    private Integer inviteType; // 招标类型
    private Integer distinctionFlag; // 是否区分商务/技术（0-是，1-否）
    private Long subType; // 分包类型 ,0-专业分包,1-劳务分包(分包线专用)
    private Long unitId; // 招标单位ID
    private String unitName; // 招标单位名称
    private Integer evaluationState; //
    private java.math.BigDecimal tenderMoney; // 招标金额

    private String remarks; // 评标备注

    private Long equipmentType; // 设备类型（0-机械设备租赁，1-机械承揽）
    private Integer rentType; // 租赁方式(0-日租,1-月租,2-工程量租)
    private Integer flagNew; // 是否最新(1-是,0-否)
    private Integer changeVersion; // 二次报价版本号
    private Integer evaStatus; //状态,0-专家未评分完成,1-有二次评标未完成,2-正常
    private Integer rentalType; // 出租运输方式(1-承租方,2-租赁方)
    private Integer backType; // 归还运输方式(1-承租方,2-租赁方)
    private Integer rentalStacking; // 出租堆码(1-承租方,2-租赁方)
    private Integer backStacking; // 归还堆码堆码(1-承租方,2-租赁方)
    private Integer talkNum;
    private Integer tenderType; // 招标方式(0-平台公开招标,1-邀请招标,2-询价,3-竞争性谈判,4-单一来源,5-紧急招标，6-洽商谈判)
    private Integer businessStatus; // 商务计算得分状态 0-未计算,1-已计算



    private List<StuffInviteDetailRecordVO> stuffDetailRecord = new ArrayList<>(); // 材料招标立项采购清单表不合并
    private List<SubInviteDetailRecordVO> subDetailRecord = new ArrayList<>(); // 分包招标立项采购清单表不合并
    private List<EquipmentInviteDetailRecordVO> equipmentDetailRecord = new ArrayList<>(); // 设备招标立项采购清单表不合并
    private List<RentInviteDetailRecordVO> rentDetailRecord = new ArrayList<>(); // 设备租赁招标立项采购清单表不合并
    private List<RmatInviteDetailRecordVO> rmatDetailRecord = new ArrayList<>(); // 材料招标立项采购清单表不合并
    private List<OtherInviteDetailRecordVO> otherDetailRecord = new ArrayList<>(); // 其他招标立项采购清单表不合并

    private List<ExpertReviewDetailVO> expertReviewDetailList = new ArrayList<>(); // 评审内容子表

    public String getBidBusinessNum() {
        return bidBusinessNum;
    }

    public void setBidBusinessNum(String bidBusinessNum) {
        this.bidBusinessNum = bidBusinessNum;
    }

    private Boolean reviewFlag; // 是否开启初步评审 模板类型=分包、设备租赁时，默认开启，非这两种类型意外其他类型默认关
    private Integer tecScore; // 技术最低分 默认为0
    private Integer bidEvaluateType; // 评标类型 枚举值为 1【综合评标法】/ 2【经评审的最低价法】
    private Integer reviewGatherStatus; // 评审汇总状态 0-待汇总,1-已汇总
    public Integer getBusinessStatus() {
        return businessStatus;
    }

    public void setBusinessStatus(Integer businessStatus) {
        this.businessStatus = businessStatus;
    }

    public Boolean getReviewFlag() {
        return reviewFlag;
    }

    public void setReviewFlag(Boolean reviewFlag) {
        this.reviewFlag = reviewFlag;
    }

    public Integer getTecScore() {
        return tecScore;
    }

    public void setTecScore(Integer tecScore) {
        this.tecScore = tecScore;
    }

    public Integer getBidEvaluateType() {
        return bidEvaluateType;
    }

    public void setBidEvaluateType(Integer bidEvaluateType) {
        this.bidEvaluateType = bidEvaluateType;
    }

    public Integer getReviewGatherStatus() {
        return reviewGatherStatus;
    }

    public void setReviewGatherStatus(Integer reviewGatherStatus) {
        this.reviewGatherStatus = reviewGatherStatus;
    }

    public List<ExpertReviewDetailVO> getExpertReviewDetailList() {
        return expertReviewDetailList;
    }

    public void setExpertReviewDetailList(List<ExpertReviewDetailVO> expertReviewDetailList) {
        this.expertReviewDetailList = expertReviewDetailList;
    }

    public List<StuffInviteDetailRecordVO> getStuffDetailRecord() {
        return stuffDetailRecord;
    }

    public void setStuffDetailRecord(List<StuffInviteDetailRecordVO> stuffDetailRecord) {
        this.stuffDetailRecord = stuffDetailRecord;
    }

    public List<SubInviteDetailRecordVO> getSubDetailRecord() {
        return subDetailRecord;
    }

    public void setSubDetailRecord(List<SubInviteDetailRecordVO> subDetailRecord) {
        this.subDetailRecord = subDetailRecord;
    }

    public List<EquipmentInviteDetailRecordVO> getEquipmentDetailRecord() {
        return equipmentDetailRecord;
    }

    public void setEquipmentDetailRecord(List<EquipmentInviteDetailRecordVO> equipmentDetailRecord) {
        this.equipmentDetailRecord = equipmentDetailRecord;
    }

    public List<RentInviteDetailRecordVO> getRentDetailRecord() {
        return rentDetailRecord;
    }

    public void setRentDetailRecord(List<RentInviteDetailRecordVO> rentDetailRecord) {
        this.rentDetailRecord = rentDetailRecord;
    }

    public List<RmatInviteDetailRecordVO> getRmatDetailRecord() {
        return rmatDetailRecord;
    }

    public void setRmatDetailRecord(List<RmatInviteDetailRecordVO> rmatDetailRecord) {
        this.rmatDetailRecord = rmatDetailRecord;
    }

    public List<OtherInviteDetailRecordVO> getOtherDetailRecord() {
        return otherDetailRecord;
    }

    public void setOtherDetailRecord(List<OtherInviteDetailRecordVO> otherDetailRecord) {
        this.otherDetailRecord = otherDetailRecord;
    }

    public Integer getTenderType() {
        return tenderType;
    }

    public void setTenderType(Integer tenderType) {
        this.tenderType = tenderType;
    }

    public Integer getRentalType() {
        return rentalType;
    }

    public void setRentalType(Integer rentalType) {
        this.rentalType = rentalType;
    }

    public Integer getBackType() {
        return backType;
    }

    public void setBackType(Integer backType) {
        this.backType = backType;
    }

    public Integer getRentalStacking() {
        return rentalStacking;
    }

    public void setRentalStacking(Integer rentalStacking) {
        this.rentalStacking = rentalStacking;
    }

    public Integer getBackStacking() {
        return backStacking;
    }

    public void setBackStacking(Integer backStacking) {
        this.backStacking = backStacking;
    }

    public Integer getTalkNum() {
        return talkNum;
    }

    public void setTalkNum(Integer talkNum) {
        this.talkNum = talkNum;
    }

    public Integer getEvaStatus() {
        return evaStatus;
    }

    public void setEvaStatus(Integer evaStatus) {
        this.evaStatus = evaStatus;
    }

    public Integer getFlagNew() {
        return flagNew;
    }

    public void setFlagNew(Integer flagNew) {
        this.flagNew = flagNew;
    }

    public Integer getChangeVersion() {
        return changeVersion;
    }

    public void setChangeVersion(Integer changeVersion) {
        this.changeVersion = changeVersion;
    }

    public Integer getRentType() {
        return rentType;
    }

    public void setRentType(Integer rentType) {
        this.rentType = rentType;
    }

    public Long getEquipmentType() {
        return equipmentType;
    }

    public void setEquipmentType(Long equipmentType) {
        this.equipmentType = equipmentType;
    }

    private List stuffDocumentSupplierSchemeList = new ArrayList<>();//按供应商查看报价
    private List stuffDocumentDetailSellList = new ArrayList<>();//按材料查看报价
    private List scoreResult = new ArrayList<>();
    private List<ExpertRepetitionVO> repetitionVOList = new ArrayList<>();//二次报价历史

    public List<ExpertRepetitionVO> getRepetitionVOList() {
        return repetitionVOList;
    }

    public void setRepetitionVOList(List<ExpertRepetitionVO> repetitionVOList) {
        this.repetitionVOList = repetitionVOList;
    }

    public String getRemarks() {
        return remarks;
    }

    public void setRemarks(String remarks) {
        this.remarks = remarks;
    }

    public BigDecimal getTenderMoney() {
        return tenderMoney;
    }

    public void setTenderMoney(BigDecimal tenderMoney) {
        this.tenderMoney = tenderMoney;
    }

    public Integer getEvaluationState() {
        return evaluationState;
    }

    public void setEvaluationState(Integer evaluationState) {
        this.evaluationState = evaluationState;
    }

    public Long getSubType() {
        return subType;
    }

    public Long getUnitId() {
        return unitId;
    }

    public void setUnitId(Long unitId) {
        this.unitId = unitId;
    }

    public String getUnitName() {
        return unitName;
    }

    public void setUnitName(String unitName) {
        this.unitName = unitName;
    }

    public void setSubType(Long subType) {
        this.subType = subType;
    }

    public Integer getDistinctionFlag() {
        return distinctionFlag;
    }

    public void setDistinctionFlag(Integer distinctionFlag) {
        this.distinctionFlag = distinctionFlag;
    }

    public Integer getInviteType() {
        return inviteType;
    }

    public void setInviteType(Integer inviteType) {
        this.inviteType = inviteType;
    }

    public String getBidNum() {
        return bidNum;
    }

    public void setBidNum(String bidNum) {
        this.bidNum = bidNum;
    }

    public List getStuffDocumentSupplierSchemeList() {
        return stuffDocumentSupplierSchemeList;
    }

    public void setStuffDocumentSupplierSchemeList(List stuffDocumentSupplierSchemeList) {
        this.stuffDocumentSupplierSchemeList = stuffDocumentSupplierSchemeList;
    }

    public List getStuffDocumentDetailSellList() {
        return stuffDocumentDetailSellList;
    }

    public void setStuffDocumentDetailSellList(List stuffDocumentDetailSellList) {
        this.stuffDocumentDetailSellList = stuffDocumentDetailSellList;
    }

    public List getScoreResult() {
        return scoreResult;
    }

    public void setScoreResult(List scoreResult) {
        this.scoreResult = scoreResult;
    }

    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }

    private List<ExpertEvaluatingDetailVO> stuffEvaluationDetailEntities = new ArrayList<>(); // 材料专家评标专家子表

    public String getGatherReason() {
        return gatherReason;
    }

    public void setGatherReason(String gatherReason) {
        this.gatherReason = gatherReason;
    }

    /**
     * 采购方式
     */
    public Integer getPurchaseType() {
        return purchaseType;
    }

    public void setPurchaseType(Integer purchaseType) {
        this.purchaseType = purchaseType;
    }

    /**
     * 项目ID
     */
    public Long getProjectId() {
        return projectId;
    }

    /**
     * 项目ID
     */
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    /**
     * 项目名称
     */
    public String getProjectName() {
        return projectName;
    }

    /**
     * 项目名称
     */
    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    /**
     * 项目编号
     */
    public String getProjectCode() {
        return projectCode;
    }

    /**
     * 项目编号
     */
    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }
    /**
     * 模板Id
     */
    @ReferSerialTransfer(referCode="evaluation_template")
    public Long getTemplateId() {
        return templateId;
    }

    /**
     * 模板Id
     */
    @ReferDeserialTransfer
    public void setTemplateId(Long templateId) {
        this.templateId = templateId;
    }
    /**
     * 模板名称
     */
    public String getTemplateName() {
        return templateName;
    }

    /**
     * 模板名称
     */
    public void setTemplateName(String templateName) {
        this.templateName = templateName;
    }
    /**
     * 评标名称
     */
    public String getEvaluationName() {
        return evaluationName;
    }

    /**
     * 评标名称
     */
    public void setEvaluationName(String evaluationName) {
        this.evaluationName = evaluationName;
    }
    /**
     * 招标联系人
     */
    public Long getEmployeeId() {
        return employeeId;
    }

    /**
     * 招标联系人
     */
    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    /**
     * 招标联系人名称
     */
    public String getEmployeeName() {
        return employeeName;
    }

    /**
     * 招标联系人名称
     */
    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    /**
     * 招标联系人电话
     */
    public String getEmployeeMobile() {
        return employeeMobile;
    }

    /**
     * 招标联系人电话
     */
    public void setEmployeeMobile(String employeeMobile) {
        this.employeeMobile = employeeMobile;
    }
    /**
     * 评标开始日期
     */
    public java.util.Date getStartTime() {
        return startTime;
    }

    /**
     * 评标开始日期
     */
    public void setStartTime(java.util.Date startTime) {
        this.startTime = startTime;
    }
    /**
     * 备注
     */
    public String getMemo() {
        return memo;
    }

    /**
     * 备注
     */
    public void setMemo(String memo) {
        this.memo = memo;
    }
    /**
     * 招标ID
     */
    public Long getInviteId() {
        return inviteId;
    }

    /**
     * 招标ID
     */
    public void setInviteId(Long inviteId) {
        this.inviteId = inviteId;
    }

    public Integer getGatherStatus() {
        return gatherStatus;
    }

    public void setGatherStatus(Integer gatherStatus) {
        this.gatherStatus = gatherStatus;
    }

    /**
     * 招标文件主键
     */
    public Long getDocumentId() {
        return documentId;
    }

    /**
     * 招标文件主键
     */
    public void setDocumentId(Long documentId) {
        this.documentId = documentId;
    }
    /**
     * 组织
     */
    @ReferSerialTransfer(referCode = "idm-org")
    public Long getOrgId() {
        return orgId;
    }

    /**
     * 组织
     */
    @ReferDeserialTransfer
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    /**
     * 组织名称
     */
    public String getOrgName() {
        return orgName;
    }

    /**
     * 组织名称
     */
    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    /**
     * 父级组织
     */
    public Long getParentOrgId() {
        return parentOrgId;
    }

    /**
     * 父级组织
     */
    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    /**
     * 父级组织名称
     */
    public String getParentOrgName() {
        return parentOrgName;
    }

    /**
     * 父级组织名称
     */
    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    /**
     * 单据状态
     */
    public Integer getBillState() {
        return billState;
    }

    /**
     * 单据状态
     */
    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    /**
     * 单据编号
     */
    public String getBillCode() {
        return billCode;
    }

    /**
     * 单据编号
     */
    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    
     /**
      * 材料专家评标专家子表
      */
     public List<ExpertEvaluatingDetailVO> getStuffEvaluationDetailEntities() {
        return stuffEvaluationDetailEntities;
     }

     /**
      * 材料专家评标专家子表
      */
     public void setStuffEvaluationDetailEntities(List<ExpertEvaluatingDetailVO> stuffEvaluationDetailVos) {
        this.stuffEvaluationDetailEntities = stuffEvaluationDetailVos;
     }
}
