package com.ejianc.business.tender.sub.vo;

import com.baomidou.mybatisplus.annotation.TableField;
import com.ejianc.business.tender.util.ITreeNodeB;
import com.ejianc.framework.skeleton.template.BaseVO;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;


/**
 * 招标文件报价表
 * 
 * @author generator
 * 
 */


@ApiModel("招标文件报价表")
public class SubDocumentSellVO extends BaseVO implements ITreeNodeB {
    private static final long serialVersionUID = 1L;
    
    @ApiModelProperty("采购物料详情主键")
    private Long detailId;
    @ApiModelProperty("方案子表主键")
    private Long schemeId;
    @ApiModelProperty("招标文件主表主键")
    private Long documentId;
    @ApiModelProperty("项目ID")
    private Long projectId;
    @ApiModelProperty("项目名称")
    private String projectName;
    @ApiModelProperty("供应商ID")
    private Long supplierId;
    @ApiModelProperty("供应商租户id")
    private Long supplierTenantId;
    @ApiModelProperty("供应商名称")
    private String supplierName;
    @ApiModelProperty("材料ID")
    private Long materialId;
    @ApiModelProperty("材料名称")
    private String materialName;
    @ApiModelProperty("材料编码")
    private String materialCode;
    @ApiModelProperty("材料分类ID")
    private Long materialTypeId;
    @ApiModelProperty("材料分类名称")
    private String materialTypeName;
    @ApiModelProperty("单位")
    private String unit;
    @ApiModelProperty("规格型号")
    private String spec;
    @ApiModelProperty("供货品牌")
    private String brand;
    @ApiModelProperty("数量")
    private BigDecimal num;
    @ApiModelProperty("税率")
    private BigDecimal rate;
    @ApiModelProperty("备注")
    private String memo;
    @ApiModelProperty("单价")
    private BigDecimal price;
    @ApiModelProperty("单价(含税)")
    private BigDecimal priceTax;
    @ApiModelProperty("总额")
    private BigDecimal money;
    @ApiModelProperty("总额(含税)")
    private BigDecimal moneyTax;
    @ApiModelProperty("税额")
    private BigDecimal sellTax;
    @ApiModelProperty("中标数量")
    private BigDecimal tenderNum;
    @ApiModelProperty("中标金额")
    private BigDecimal tenderMoney;
    @ApiModelProperty("方案名称")
    private String schemeName;
    @ApiModelProperty("是否中标,0-是1-否")
    private Integer tenderFlag;
    @ApiModelProperty("定标立项备注")
    private String materialMemo;
    @ApiModelProperty("定标立项品牌")
    private String materialBrand;
    @ApiModelProperty("计量方式(0-理计,1-过磅,2-点数)")
    private Integer calculateType;
    @ApiModelProperty("分时")
    private BigDecimal score;
    @ApiModelProperty("中标金额(含税)")
    private BigDecimal tenderMoneyTax;
    @ApiModelProperty("洽商轮数")
    private Integer talkNum;
    @ApiModelProperty("是否推荐,1-是,2-否")
    private Integer referFlag;
    @ApiModelProperty("是否通过,1-是,2-否")
    private Integer passFlag;
    private String content; //工作内容
    private String rule; //计量规则
    private String materialEquipmentSupply; //材料设备供应
    private List<ITreeNodeB> children;
    private Long parentId;
    private String treeIndex; // 序号
    @TableField(value="sign_num")
    private java.math.BigDecimal signNum; // 合同签订数量
    private java.math.BigDecimal surplusNum; // 剩余可签订数量
    private Long sellId; // 自己的id  特殊记录
    private BigDecimal detailRate; // 材料税率
    @ApiModelProperty("招标控制单价")
    private BigDecimal invitePrice;
    @ApiModelProperty("招标控制单价(含税)")
    private BigDecimal invitePriceTax;
    private BigDecimal artificialTaxMny; //人工费金额
    private BigDecimal artificialMny; //人工费金额（无税）
    private BigDecimal artificialTax; //人工费税额
    private BigDecimal artificialTaxPrice; // 人工费单价
    private BigDecimal artificialPrice; // 人工费单价(无税）
    private BigDecimal artificialControlPrice; // 人工费控制单价(无税）
    private String transactionGroup;//事务特性组

    public String getTransactionGroup() {
        return transactionGroup;
    }

    public void setTransactionGroup(String transactionGroup) {
        this.transactionGroup = transactionGroup;
    }
    public BigDecimal getArtificialControlPrice() {
        return artificialControlPrice;
    }

    public void setArtificialControlPrice(BigDecimal artificialControlPrice) {
        this.artificialControlPrice = artificialControlPrice;
    }

    public BigDecimal getArtificialTaxMny() {
        return artificialTaxMny;
    }

    public void setArtificialTaxMny(BigDecimal artificialTaxMny) {
        this.artificialTaxMny = artificialTaxMny;
    }

    public BigDecimal getArtificialMny() {
        return artificialMny;
    }

    public void setArtificialMny(BigDecimal artificialMny) {
        this.artificialMny = artificialMny;
    }

    public BigDecimal getArtificialTax() {
        return artificialTax;
    }

    public void setArtificialTax(BigDecimal artificialTax) {
        this.artificialTax = artificialTax;
    }

    public BigDecimal getArtificialTaxPrice() {
        return artificialTaxPrice;
    }

    public void setArtificialTaxPrice(BigDecimal artificialTaxPrice) {
        this.artificialTaxPrice = artificialTaxPrice;
    }

    public BigDecimal getArtificialPrice() {
        return artificialPrice;
    }

    public void setArtificialPrice(BigDecimal artificialPrice) {
        this.artificialPrice = artificialPrice;
    }
    public BigDecimal getInvitePrice() {
        return invitePrice;
    }

    public void setInvitePrice(BigDecimal invitePrice) {
        this.invitePrice = invitePrice;
    }

    public BigDecimal getInvitePriceTax() {
        return invitePriceTax;
    }

    public void setInvitePriceTax(BigDecimal invitePriceTax) {
        this.invitePriceTax = invitePriceTax;
    }

    public BigDecimal getDetailRate() {
        return detailRate;
    }

    public void setDetailRate(BigDecimal detailRate) {
        this.detailRate = detailRate;
    }
    public Long getSellId() {
        return sellId;
    }

    public void setSellId(Long sellId) {
        this.sellId = sellId;
    }

    public BigDecimal getSurplusNum() {
        return surplusNum;
    }

    public void setSurplusNum(BigDecimal surplusNum) {
        this.surplusNum = surplusNum;
    }

    public BigDecimal getSignNum() {
        return signNum;
    }

    public void setSignNum(BigDecimal signNum) {
        this.signNum = signNum;
    }

    public String getTreeIndex() {
        return treeIndex;
    }

    public void setTreeIndex(String treeIndex) {
        this.treeIndex = treeIndex;
    }

    public Long getParentId() {
        return parentId;
    }

    public void setParentId(Long parentId) {
        this.parentId = parentId;
    }

    @Override
    public Long getNodeID() {
        return getId();
    }

    @Override
    public Long getParentID() {
        return parentId;
    }

    @Override
    public List<ITreeNodeB> getChildren() {
        if (children == null) {
            children = new ArrayList<>();
        }
        return children;
    }
    public void setChildren(List<ITreeNodeB> children) {
        this.children = children;
    }
    public String getContent() {
        return content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public String getRule() {
        return rule;
    }

    public void setRule(String rule) {
        this.rule = rule;
    }

    public Integer getPassFlag() {
        return passFlag;
    }

    public void setPassFlag(Integer passFlag) {
        this.passFlag = passFlag;
    }
    public Integer getReferFlag() {
        return referFlag;
    }

    public void setReferFlag(Integer referFlag) {
        this.referFlag = referFlag;
    }
    public Integer getTalkNum() {
        return talkNum;
    }

    public void setTalkNum(Integer talkNum) {
        this.talkNum = talkNum;
    }

    public BigDecimal getTenderMoneyTax() {
        return tenderMoneyTax;
    }

    public void setTenderMoneyTax(BigDecimal tenderMoneyTax) {
        this.tenderMoneyTax = tenderMoneyTax;
    }

    public BigDecimal getScore() {
        return score;
    }

    public void setScore(BigDecimal score) {
        this.score = score;
    }

    public Integer getCalculateType() {
        return calculateType;
    }

    public void setCalculateType(Integer calculateType) {
        this.calculateType = calculateType;
    }

    public String getMaterialMemo() {
        return materialMemo;
    }

    public void setMaterialMemo(String materialMemo) {
        this.materialMemo = materialMemo;
    }

    public String getMaterialBrand() {
        return materialBrand;
    }

    public void setMaterialBrand(String materialBrand) {
        this.materialBrand = materialBrand;
    }

    /**
     * 采购物料详情主键
     */
    public Long getDetailId() {
        return detailId;
    }

    /**
     * 采购物料详情主键
     */
    public void setDetailId(Long detailId) {
        this.detailId = detailId;
    }
    /**
     * 方案子表主键
     */
    public Long getSchemeId() {
        return schemeId;
    }

    /**
     * 方案子表主键
     */
    public void setSchemeId(Long schemeId) {
        this.schemeId = schemeId;
    }
    /**
     * 招标文件主表主键
     */
    public Long getDocumentId() {
        return documentId;
    }

    /**
     * 招标文件主表主键
     */
    public void setDocumentId(Long documentId) {
        this.documentId = documentId;
    }
    /**
     * 项目ID
     */
    public Long getProjectId() {
        return projectId;
    }

    /**
     * 项目ID
     */
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    /**
     * 项目名称
     */
    public String getProjectName() {
        return projectName;
    }

    /**
     * 项目名称
     */
    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    /**
     * 供应商ID
     */
    public Long getSupplierId() {
        return supplierId;
    }

    /**
     * 供应商ID
     */
    public void setSupplierId(Long supplierId) {
        this.supplierId = supplierId;
    }
    /**
     * 供应商租户id
     */
    public Long getSupplierTenantId() {
        return supplierTenantId;
    }

    /**
     * 供应商租户id
     */
    public void setSupplierTenantId(Long supplierTenantId) {
        this.supplierTenantId = supplierTenantId;
    }
    /**
     * 供应商名称
     */
    public String getSupplierName() {
        return supplierName;
    }

    /**
     * 供应商名称
     */
    public void setSupplierName(String supplierName) {
        this.supplierName = supplierName;
    }
    /**
     * 材料ID
     */
    public Long getMaterialId() {
        return materialId;
    }

    /**
     * 材料ID
     */
    public void setMaterialId(Long materialId) {
        this.materialId = materialId;
    }
    /**
     * 材料名称
     */
    public String getMaterialName() {
        return materialName;
    }

    /**
     * 材料名称
     */
    public void setMaterialName(String materialName) {
        this.materialName = materialName;
    }
    /**
     * 材料编码
     */
    public String getMaterialCode() {
        return materialCode;
    }

    /**
     * 材料编码
     */
    public void setMaterialCode(String materialCode) {
        this.materialCode = materialCode;
    }
    /**
     * 材料分类ID
     */
    public Long getMaterialTypeId() {
        return materialTypeId;
    }

    /**
     * 材料分类ID
     */
    public void setMaterialTypeId(Long materialTypeId) {
        this.materialTypeId = materialTypeId;
    }
    /**
     * 材料分类名称
     */
    public String getMaterialTypeName() {
        return materialTypeName;
    }

    /**
     * 材料分类名称
     */
    public void setMaterialTypeName(String materialTypeName) {
        this.materialTypeName = materialTypeName;
    }
    /**
     * 单位
     */
    public String getUnit() {
        return unit;
    }

    /**
     * 单位
     */
    public void setUnit(String unit) {
        this.unit = unit;
    }
    /**
     * 规格型号
     */
    public String getSpec() {
        return spec;
    }

    /**
     * 规格型号
     */
    public void setSpec(String spec) {
        this.spec = spec;
    }
    /**
     * 供货品牌
     */
    public String getBrand() {
        return brand;
    }

    /**
     * 供货品牌
     */
    public void setBrand(String brand) {
        this.brand = brand;
    }
    /**
     * 数量
     */
    public BigDecimal getNum() {
        return num;
    }

    /**
     * 数量
     */
    public void setNum(BigDecimal num) {
        this.num = num;
    }
    /**
     * 税率
     */
    public BigDecimal getRate() {
        return rate;
    }

    /**
     * 税率
     */
    public void setRate(BigDecimal rate) {
        this.rate = rate;
    }
    /**
     * 备注
     */
    public String getMemo() {
        return memo;
    }

    /**
     * 备注
     */
    public void setMemo(String memo) {
        this.memo = memo;
    }
    /**
     * 单价
     */
    public BigDecimal getPrice() {
        return price;
    }

    /**
     * 单价
     */
    public void setPrice(BigDecimal price) {
        this.price = price;
    }
    /**
     * 单价(含税)
     */
    public BigDecimal getPriceTax() {
        return priceTax;
    }

    /**
     * 单价(含税)
     */
    public void setPriceTax(BigDecimal priceTax) {
        this.priceTax = priceTax;
    }
    /**
     * 总额
     */
    public BigDecimal getMoney() {
        return money;
    }

    /**
     * 总额
     */
    public void setMoney(BigDecimal money) {
        this.money = money;
    }
    /**
     * 总额(含税)
     */
    public BigDecimal getMoneyTax() {
        return moneyTax;
    }

    /**
     * 总额(含税)
     */
    public void setMoneyTax(BigDecimal moneyTax) {
        this.moneyTax = moneyTax;
    }
    /**
     * 税额
     */
    public BigDecimal getSellTax() {
        return sellTax;
    }

    /**
     * 税额
     */
    public void setSellTax(BigDecimal sellTax) {
        this.sellTax = sellTax;
    }
    /**
     * 中标数量
     */
    public BigDecimal getTenderNum() {
        return tenderNum;
    }

    /**
     * 中标数量
     */
    public void setTenderNum(BigDecimal tenderNum) {
        this.tenderNum = tenderNum;
    }
    /**
     * 中标金额
     */
    public BigDecimal getTenderMoney() {
        return tenderMoney;
    }

    /**
     * 中标金额
     */
    public void setTenderMoney(BigDecimal tenderMoney) {
        this.tenderMoney = tenderMoney;
    }
    /**
     * 方案名称
     */
    public String getSchemeName() {
        return schemeName;
    }

    /**
     * 方案名称
     */
    public void setSchemeName(String schemeName) {
        this.schemeName = schemeName;
    }
    /**
     * 是否中标,1-是2-否
     */
    public Integer getTenderFlag() {
        return tenderFlag;
    }

    /**
     * 是否中标,1-是2-否
     */
    public void setTenderFlag(Integer tenderFlag) {
        this.tenderFlag = tenderFlag;
    }

    public String getMaterialEquipmentSupply() {
        return materialEquipmentSupply;
    }

    public void setMaterialEquipmentSupply(String materialEquipmentSupply) {
        this.materialEquipmentSupply = materialEquipmentSupply;
    }
}
