package com.ejianc.business.tender.expert.vo;

import java.util.Date;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.baomidou.mybatisplus.annotation.TableField;
import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;

import com.ejianc.business.tender.expert.vo.ExperienceDetailVO;
import com.ejianc.business.tender.expert.vo.EducationDetailVO;
import com.ejianc.business.tender.expert.vo.EvaluationDetailVO;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * 专家库主表
 * 
 * @author generator
 * 
 */
public class ExpertVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private java.lang.Integer billState; // 单据状态
    private java.lang.Integer state; // 状态（0：启用，1：停用）
    private java.lang.String billCode; // 单据编码
    private java.lang.Long unitId; // 单位id
    private java.lang.String unitName; // 单位名称
    private java.lang.Long expertId; // 专家id
    private java.lang.String expertName; // 专家名称
    private java.lang.String mobile; // 手机号
    private java.lang.String email; // 邮箱
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private java.util.Date employeeTime; // 编制日期
    private java.math.BigDecimal yearLimit; // 从业年限
    private java.lang.Long employeeId; // 编制人
    private java.lang.String employeeName; // 编制人名称
    private java.lang.Integer sex;//性别（0-男，1-女）
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private java.util.Date birthday; // 出生日期
    private java.lang.String telephone; // 固定电话
    private java.lang.String idcard; // 身份证号码
    private java.lang.Long postId; // 岗位id
    private java.lang.String postName; // 岗位名称
    private java.lang.String empno; // 工号
    private java.lang.Integer interiorExterior; // 内外部(0-内部，1-外部)
    private java.lang.String fieldId; // 专业领域id
    private java.lang.String fieldName; // 专业领域name
    private java.lang.Integer type; // 类型(0-商务，1-技术，2-商务技术)
    private java.lang.String typeName; // 类型name
    private java.lang.Long gradeId; // 级别id
    private java.lang.String gradeName; // 级别name
    private java.lang.Long oldExpertId; // 老专家id
    private java.lang.Long deptId; // 部门id
    private java.lang.String deptName; // 部门名称
    private java.lang.Integer employeeType; // 人员状态 1-在职，2-离职，3-退休，4-退休返聘,5-派驻人员......13-其他
//    private java.lang.String employeeTypeName; // 人员状态名称

    private List<ExperienceDetailVO> experienceDetailEntities = new ArrayList<>(); // 专家库工作履历表
    private List<EducationDetailVO> educationDetailEntities = new ArrayList<>(); // 专家库教育经历表
    private List<EvaluationDetailVO> evaluationDetailEntities = new ArrayList<>(); // 专家库评标记录表

//    public String getEmployeeTypeName() {
//        return employeeTypeName;
//    }
//
//    public void setEmployeeTypeName(String employeeTypeName) {
//        this.employeeTypeName = employeeTypeName;
//    }
    public Integer getEmployeeType() {
        return employeeType;
    }

    public void setEmployeeType(Integer employeeType) {
        this.employeeType = employeeType;
    }

    public Long getDeptId() {
        return deptId;
    }

    public void setDeptId(Long deptId) {
        this.deptId = deptId;
    }

    public String getDeptName() {
        return deptName;
    }

    public void setDeptName(String deptName) {
        this.deptName = deptName;
    }

    public Long getOldExpertId() {
        return oldExpertId;
    }

    public void setOldExpertId(Long oldExpertId) {
        this.oldExpertId = oldExpertId;
    }

    // 专业领域id
    @ReferSerialTransfer(referCode = "support-defdoc")
    public String getFieldId() {
        return fieldId;
    }
    @ReferDeserialTransfer
    public void setFieldId(String fieldId) {
        this.fieldId = fieldId;
    }
    // 专业领域name
    public String getFieldName() {
        return fieldName;
    }

    public void setFieldName(String fieldName) {
        this.fieldName = fieldName;
    }
    // 类型

    public Integer getType() {
        return type;
    }

    public void setType(Integer type) {
        this.type = type;
    }

    public String getTypeName() {
        return typeName;
    }

    public void setTypeName(String typeName) {
        this.typeName = typeName;
    }

    // 级别id
    @ReferSerialTransfer(referCode = "support-defdoc")
    public Long getGradeId() {
        return gradeId;
    }
    @ReferDeserialTransfer
    public void setGradeId(Long gradeId) {
        this.gradeId = gradeId;
    }
    // 级别name
    public String getGradeName() {
        return gradeName;
    }

    public void setGradeName(String gradeName) {
        this.gradeName = gradeName;
    }

    //性别（0-男，1-女）
    public Integer getSex() {
        return sex;
    }

    public void setSex(Integer sex) {
        this.sex = sex;
    }


    public Date getBirthday() {
        return birthday;
    }

    public void setBirthday(Date birthday) {
        this.birthday = birthday;
    }

    public String getTelephone() {
        return telephone;
    }

    public void setTelephone(String telephone) {
        this.telephone = telephone;
    }

    public String getIdcard() {
        return idcard;
    }

    public void setIdcard(String idcard) {
        this.idcard = idcard;
    }
    @ReferSerialTransfer(referCode = "idm_post")
    public Long getPostId() {
        return postId;
    }
    @ReferDeserialTransfer
    public void setPostId(Long postId) {
        this.postId = postId;
    }

    public String getPostName() {
        return postName;
    }

    public void setPostName(String postName) {
        this.postName = postName;
    }

    public String getEmpno() {
        return empno;
    }

    public void setEmpno(String empno) {
        this.empno = empno;
    }

    public Integer getInteriorExterior() {
        return interiorExterior;
    }

    public void setInteriorExterior(Integer interiorExterior) {
        this.interiorExterior = interiorExterior;
    }

    /**
     * 单据状态
     */
    public java.lang.Integer getBillState() {
        return billState;
    }

    /**
     * 单据状态
     */
    public void setBillState(java.lang.Integer billState) {
        this.billState = billState;
    }
    /**
     * 状态（0：启用，1：停用）
     */
    public java.lang.Integer getState() {
        return state;
    }

    /**
     * 状态（0：启用，1：停用）
     */
    public void setState(java.lang.Integer state) {
        this.state = state;
    }
    /**
     * 单据编码
     */
    public java.lang.String getBillCode() {
        return billCode;
    }

    /**
     * 单据编码
     */
    public void setBillCode(java.lang.String billCode) {
        this.billCode = billCode;
    }
    /**
     * 单位id
     */
    public java.lang.Long getUnitId() {
        return unitId;
    }

    /**
     * 单位id
     */
    public void setUnitId(java.lang.Long unitId) {
        this.unitId = unitId;
    }
    /**
     * 单位名称
     */
    public java.lang.String getUnitName() {
        return unitName;
    }

    /**
     * 单位名称
     */
    public void setUnitName(java.lang.String unitName) {
        this.unitName = unitName;
    }
    /**
     * 专家id
     */
    @ReferSerialTransfer(referCode="idm-employee")
    public java.lang.Long getExpertId() {
        return expertId;
    }

    /**
     * 专家id
     */
    @ReferDeserialTransfer
    public void setExpertId(java.lang.Long expertId) {
        this.expertId = expertId;
    }
    /**
     * 专家名称
     */
    public java.lang.String getExpertName() {
        return expertName;
    }

    /**
     * 专家名称
     */
    public void setExpertName(java.lang.String expertName) {
        this.expertName = expertName;
    }
    /**
     * 手机号
     */
    public java.lang.String getMobile() {
        return mobile;
    }

    /**
     * 手机号
     */
    public void setMobile(java.lang.String mobile) {
        this.mobile = mobile;
    }
    /**
     * 邮箱
     */
    public java.lang.String getEmail() {
        return email;
    }

    /**
     * 邮箱
     */
    public void setEmail(java.lang.String email) {
        this.email = email;
    }
    /**
     * 编制日期
     */
    public java.util.Date getEmployeeTime() {
        return employeeTime;
    }

    /**
     * 编制日期
     */
    public void setEmployeeTime(java.util.Date employeeTime) {
        this.employeeTime = employeeTime;
    }
    /**
     * 从业年限
     */
    public java.math.BigDecimal getYearLimit() {
        return yearLimit;
    }

    /**
     * 从业年限
     */
    public void setYearLimit(java.math.BigDecimal yearLimit) {
        this.yearLimit = yearLimit;
    }
    /**
     * 编制人
     */
    public java.lang.Long getEmployeeId() {
        return employeeId;
    }

    /**
     * 编制人
     */
    public void setEmployeeId(java.lang.Long employeeId) {
        this.employeeId = employeeId;
    }
    /**
     * 编制人名称
     */
    public java.lang.String getEmployeeName() {
        return employeeName;
    }

    /**
     * 编制人名称
     */
    public void setEmployeeName(java.lang.String employeeName) {
        this.employeeName = employeeName;
    }

     /**
      * 专家库工作履历表
      */
     public List<ExperienceDetailVO> getExperienceDetailEntities() {
        return experienceDetailEntities;
     }

     /**
      * 专家库工作履历表
      */
     public void setExperienceDetailEntities(List<ExperienceDetailVO> experienceDetailVos) {
        this.experienceDetailEntities = experienceDetailVos;
     }
     /**
      * 专家库教育经历表
      */
     public List<EducationDetailVO> getEducationDetailEntities() {
        return educationDetailEntities;
     }

     /**
      * 专家库教育经历表
      */
     public void setEducationDetailEntities(List<EducationDetailVO> educationDetailVos) {
        this.educationDetailEntities= educationDetailVos;
     }
     /**
      * 专家库评标记录表
      */
     public List<EvaluationDetailVO> getEvaluationDetailEntities() {
        return evaluationDetailEntities;
     }

     /**
      * 专家库评标记录表
      */
     public void setEvaluationDetailEntities(List<EvaluationDetailVO> evaluationDetailVos) {
        this.evaluationDetailEntities = evaluationDetailVos;
     }
}
