package com.ejianc.business.tender.stuff.vo;

import java.math.BigDecimal;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.baomidou.mybatisplus.annotation.TableField;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;


/**
 * 招标文件供应商标
 * 
 * @author generator
 * 
 */
@ApiModel("招标文件供应商标")
public class StuffDocumentSupplierVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    @ApiModelProperty("招标文件主键")
    private java.lang.Long documentId;
    @ApiModelProperty("保证金金额")
    private java.math.BigDecimal depositMoney;
    @ApiModelProperty("保证金日期")
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private java.util.Date depositDate;
    @ApiModelProperty("保证金是否缴纳,0-是,1-否")
    private java.lang.Integer depositFlag;
    @ApiModelProperty("报名费金额")
    private java.math.BigDecimal registerMoney;
    @ApiModelProperty("报名费是否缴纳,0-是,1-否")
    private java.lang.Integer registerFlag;
    @ApiModelProperty("报名日期")
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private java.util.Date registerDate;
    @ApiModelProperty("标书费是否缴纳,0-是,1-否")
    private java.lang.Integer tenderFlag;
    @ApiModelProperty("标书费金额")
    private java.math.BigDecimal tenderMoney;
    @ApiModelProperty("标书日期")
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private java.util.Date tenderDate;
    @ApiModelProperty("报价时间")
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private java.util.Date offerTime;
    @ApiModelProperty("备注")
    private java.lang.String memo;
    @ApiModelProperty("供应商租户主键")
    private java.lang.Long supplierTenantId;
    @ApiModelProperty("供应商ID")
    private java.lang.Long supplierId;
    @ApiModelProperty("供应商name")
    private java.lang.String supplierName; // 供应商name
    @ApiModelProperty("方案金额汇总")
    private java.lang.String schemeMoney;
    @ApiModelProperty("联系人")
    private String linkName;
    @ApiModelProperty("联系电话")
    private String linkMobile;
    @ApiModelProperty("发票说明")
    private String taxMemo;
    @ApiModelProperty("供应商租户来源主键")
    private String sourceSupplierTenantId;
    @ApiModelProperty("洽商轮数")
    private Integer talkNum;
    @ApiModelProperty("附件名称")
    private String fileName;
    @ApiModelProperty("附件主键")
    private Long attachId;
    private java.math.BigDecimal money; // 定标总额
    @TableField(value="money_tax")
    private java.math.BigDecimal moneyTax; // 定标总额(含税)
    @TableField(value="tender_flag")
    private Integer bidFlag; // 是否中标,0-是,1-否

    private String bidName;// 是否中标,


    public String getBidName() {
        return bidName;
    }

    public void setBidName(String bidName) {
        this.bidName = bidName;
    }

    public BigDecimal getMoney() {
        return money;
    }

    public void setMoney(BigDecimal money) {
        this.money = money;
    }

    public BigDecimal getMoneyTax() {
        return moneyTax;
    }

    public void setMoneyTax(BigDecimal moneyTax) {
        this.moneyTax = moneyTax;
    }

    public Integer getBidFlag() {
        return bidFlag;
    }

    public void setBidFlag(Integer bidFlag) {
        this.bidFlag = bidFlag;
    }

    public String getFileName() {
        return fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public Long getAttachId() {
        return attachId;
    }

    public void setAttachId(Long attachId) {
        this.attachId = attachId;
    }

    public Integer getTalkNum() {
        return talkNum;
    }

    public void setTalkNum(Integer talkNum) {
        this.talkNum = talkNum;
    }

    public String getSupplierName() {
        return supplierName;
    }

    public void setSupplierName(String supplierName) {
        this.supplierName = supplierName;
    }

    public String getSourceSupplierTenantId() {
        return sourceSupplierTenantId;
    }

    public void setSourceSupplierTenantId(String sourceSupplierTenantId) {
        this.sourceSupplierTenantId = sourceSupplierTenantId;
    }

    public String getLinkName() {
        return linkName;
    }

    public void setLinkName(String linkName) {
        this.linkName = linkName;
    }

    public String getLinkMobile() {
        return linkMobile;
    }

    public void setLinkMobile(String linkMobile) {
        this.linkMobile = linkMobile;
    }

    public String getTaxMemo() {
        return taxMemo;
    }

    public void setTaxMemo(String taxMemo) {
        this.taxMemo = taxMemo;
    }

    private List<StuffDocumentSellVO> stuffDocumentSellVOList  = new ArrayList<>();

    public List<StuffDocumentSellVO> getStuffDocumentSellVOList() {
        return stuffDocumentSellVOList;
    }

    public void setStuffDocumentSellVOList(List<StuffDocumentSellVO> stuffDocumentSellVOList) {
        this.stuffDocumentSellVOList = stuffDocumentSellVOList;
    }

    public String getSchemeMoney() {
        return schemeMoney;
    }

    public void setSchemeMoney(String schemeMoney) {
        this.schemeMoney = schemeMoney;
    }

    /**
     * 招标文件主键
     */
    public java.lang.Long getDocumentId() {
        return documentId;
    }

    /**
     * 招标文件主键
     */
    public void setDocumentId(java.lang.Long documentId) {
        this.documentId = documentId;
    }
    /**
     * 保证金金额
     */
    public java.math.BigDecimal getDepositMoney() {
        return depositMoney;
    }

    /**
     * 保证金金额
     */
    public void setDepositMoney(java.math.BigDecimal depositMoney) {
        this.depositMoney = depositMoney;
    }
    /**
     * 保证金日期
     */
    public java.util.Date getDepositDate() {
        return depositDate;
    }

    /**
     * 保证金日期
     */
    public void setDepositDate(java.util.Date depositDate) {
        this.depositDate = depositDate;
    }
    /**
     * 保证金是否缴纳,0-是,1-否
     */
    public java.lang.Integer getDepositFlag() {
        return depositFlag;
    }

    /**
     * 保证金是否缴纳,0-是,1-否
     */
    public void setDepositFlag(java.lang.Integer depositFlag) {
        this.depositFlag = depositFlag;
    }
    /**
     * 报名费金额
     */
    public java.math.BigDecimal getRegisterMoney() {
        return registerMoney;
    }

    /**
     * 报名费金额
     */
    public void setRegisterMoney(java.math.BigDecimal registerMoney) {
        this.registerMoney = registerMoney;
    }
    /**
     * 报名费是否缴纳,0-是,1-否
     */
    public java.lang.Integer getRegisterFlag() {
        return registerFlag;
    }

    /**
     * 报名费是否缴纳,0-是,1-否
     */
    public void setRegisterFlag(java.lang.Integer registerFlag) {
        this.registerFlag = registerFlag;
    }
    /**
     * 报名日期
     */
    public java.util.Date getRegisterDate() {
        return registerDate;
    }

    /**
     * 报名日期
     */
    public void setRegisterDate(java.util.Date registerDate) {
        this.registerDate = registerDate;
    }
    /**
     * 标书费是否缴纳,0-是,1-否
     */
    public java.lang.Integer getTenderFlag() {
        return tenderFlag;
    }

    /**
     * 标书费是否缴纳,0-是,1-否
     */
    public void setTenderFlag(java.lang.Integer tenderFlag) {
        this.tenderFlag = tenderFlag;
    }
    /**
     * 标书费金额
     */
    public java.math.BigDecimal getTenderMoney() {
        return tenderMoney;
    }

    /**
     * 标书费金额
     */
    public void setTenderMoney(java.math.BigDecimal tenderMoney) {
        this.tenderMoney = tenderMoney;
    }
    /**
     * 标书日期
     */
    public java.util.Date getTenderDate() {
        return tenderDate;
    }

    /**
     * 标书日期
     */
    public void setTenderDate(java.util.Date tenderDate) {
        this.tenderDate = tenderDate;
    }
    /**
     * 标书日期
     */
    public java.util.Date getOfferTime() {
        return offerTime;
    }

    /**
     * 标书日期
     */
    public void setOfferTime(java.util.Date offerTime) {
        this.offerTime = offerTime;
    }
    /**
     * 备注
     */
    public java.lang.String getMemo() {
        return memo;
    }

    /**
     * 备注
     */
    public void setMemo(java.lang.String memo) {
        this.memo = memo;
    }
    /**
     * 供应商租户主键
     */
    public java.lang.Long getSupplierTenantId() {
        return supplierTenantId;
    }

    /**
     * 供应商租户主键
     */
    public void setSupplierTenantId(java.lang.Long supplierTenantId) {
        this.supplierTenantId = supplierTenantId;
    }
    /**
     * 供应商ID
     */
    public java.lang.Long getSupplierId() {
        return supplierId;
    }

    /**
     * 供应商ID
     */
    public void setSupplierId(java.lang.Long supplierId) {
        this.supplierId = supplierId;
    }



    
}
