package com.ejianc.business.tender.expert.vo;

import java.math.BigDecimal;
import java.util.List;
import java.util.ArrayList;

import com.ejianc.business.tender.util.ITreeNodeB;
import com.ejianc.framework.skeleton.template.BaseVO;

/**
 * 评标模板指标表
 * 
 * @author generator
 * 
 */
public class TemplateDetailVO extends BaseVO implements ITreeNodeB {
    private static final long serialVersionUID = 1L;
    
    private String scoringRubrics; // 评分指标
    private String scoringStandards; // 评分标准
    private Integer scoreValues; // 评分值
    private String memo; // 备注
    private Long templateId; // 模板主键
    private BigDecimal weight; // 权重
    private Long parentId; // 父id(树结构需要)
    private String rowIndex; // 序号
    private Integer scoringType; // 评分类型（0-商务，1-技术）
    private String tid;
    private String tpid;
    private List<ITreeNodeB> children;

    public Integer getScoringType() {
        return scoringType;
    }

    public void setScoringType(Integer scoringType) {
        this.scoringType = scoringType;
    }

    public String getRowIndex() {
        return rowIndex;
    }

    public void setRowIndex(String rowIndex) {
        this.rowIndex = rowIndex;
    }

    public void setChildren(List<ITreeNodeB> children) {
        this.children = children;
    }

    public String getTid() {
        return tid;
    }

    public void setTid(String tid) {
        this.tid = tid;
    }

    public String getTpid() {
        return tpid;
    }

    public void setTpid(String tpid) {
        this.tpid = tpid;
    }


    public BigDecimal getWeight() {
        return weight;
    }

    public void setWeight(BigDecimal weight) {
        this.weight = weight;
    }

    public Long getParentId() {
        return parentId;
    }

    public void setParentId(Long parentId) {
        this.parentId = parentId;
    }

    /**
     * 评分指标
     */
    public String getScoringRubrics() {
        return scoringRubrics;
    }

    /**
     * 评分指标
     */
    public void setScoringRubrics(String scoringRubrics) {
        this.scoringRubrics = scoringRubrics;
    }
    /**
     * 评分标准
     */
    public String getScoringStandards() {
        return scoringStandards;
    }

    /**
     * 评分标准
     */
    public void setScoringStandards(String scoringStandards) {
        this.scoringStandards = scoringStandards;
    }
    /**
     * 评分值
     */
    public Integer getScoreValues() {
        return scoreValues;
    }

    /**
     * 评分值
     */
    public void setScoreValues(Integer scoreValues) {
        this.scoreValues = scoreValues;
    }
    /**
     * 备注
     */
    public String getMemo() {
        return memo;
    }

    /**
     * 备注
     */
    public void setMemo(String memo) {
        this.memo = memo;
    }
    /**
     * 模板主键
     */
    public Long getTemplateId() {
        return templateId;
    }

    /**
     * 模板主键
     */
    public void setTemplateId(Long templateId) {
        this.templateId = templateId;
    }


    @Override
    public Long getNodeID() {
        return getId();
    }

    @Override
    public Long getParentID() {
        return getParentId();
    }

    @Override
    public List<ITreeNodeB> getChildren() {
        if (children == null) {
            children = new ArrayList<>();
        }
        return children;
    }
}
