package com.ejianc.business.tender.expert.vo;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 专家条件
 */
public enum ExpertNumEnum {

    物资类("物资类", 2),
    工程经济类("工程经济类", 1),
    施工技术及施工质量管理类("施工技术及施工质量管理类", 1),
    统购中心("统购中心",1 ),
//    八建科技("八建科技",1 ),
    实施项目基层单位("实施项目基层单位",1 ),
    ;

    private final String name;
    private final Integer code;
    private static Map<String, ExpertNumEnum> enumMap = new HashMap();

    private ExpertNumEnum(String name, Integer code) {
        this.name = name;
        this.code = code;
    }

    public String getName() {
        return this.name;
    }

    public Integer getCode() {
        return this.code;
    }

    public static ExpertNumEnum getEnumByName(String billTypeName) {
        return (ExpertNumEnum)enumMap.get(billTypeName);
    }

    static {
        enumMap = (Map)EnumSet.allOf(ExpertNumEnum.class).stream().collect(Collectors.toMap(ExpertNumEnum::getName, Function.identity(), (k1, k2) -> {
            return k2;
        }));
    }

}
