package com.ejianc.business.tender.rmat.vo;

import com.baomidou.mybatisplus.annotation.TableField;
import com.ejianc.framework.skeleton.template.BaseVO;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.math.BigDecimal;
import java.util.Date;


/**
 * 材料招标公告采购清单表
 * 
 * @author generator
 * 
 */
@ApiModel("材料招标公告采购清单表")
public class RmatNoticeDetailTbVO extends BaseVO {
    private static final long serialVersionUID = 1L;

    @ApiModelProperty("招标主键ID")
    private String sourceId;
    @ApiModelProperty("公告主键ID")
    private Long noticeId;
    @ApiModelProperty("材料ID")
    private String sourceMaterialId;
    @ApiModelProperty("材料名称")
    private String materialName;
    @ApiModelProperty("材料编码")
    private String materialCode;
    @ApiModelProperty("材料分类ID")
    private String sourceMaterialTypeId;
    @ApiModelProperty("材料分类名称")
    private String materialTypeName;
    @ApiModelProperty("单位")
    private String unit;
    @ApiModelProperty("规格型号")
    private String spec;
    @ApiModelProperty("备注")
    private String memo;
    @ApiModelProperty("项目ID")
    private Long detailProjectId;
    @ApiModelProperty("项目名称")
    private String detailProjectName;
    @ApiModelProperty("计划ID")
    private Long planId;
    @ApiModelProperty("计划名称")
    private String planName;
    @ApiModelProperty("计划编码")
    private String planCode;
    @ApiModelProperty("计划金额")
    private BigDecimal planMoney;
    @ApiModelProperty("品牌")
    private String brand;
    @ApiModelProperty("计量方式(0-理计,1-过磅,2-点数)")
    private Integer calculateType;
    @ApiModelProperty("数量")
    private BigDecimal num;
    @ApiModelProperty("税率")
    private BigDecimal rate;
    @ApiModelProperty("暂估金额")
    private BigDecimal money;
    @ApiModelProperty("暂估金额(含税)")
    private BigDecimal moneyTax;
    private Date planEnterDate; // 计划进场时间
    private Date planLeaveDate; // 计划出场时间
    private BigDecimal planDay; // 计划周期
    private BigDecimal lackMonthDayUnitPrice; // 不足月日单价(无税)
    private BigDecimal lackMonthDayUnitTaxPrice; // 不足月日单价
    private BigDecimal rentNum; // 租赁数量
    private BigDecimal priceTender; //招标控制单价（无税）
    private BigDecimal taxPriceTender; // 招标控制单价
    private BigDecimal lackMonthDayUnitPriceTender; // 不足月日单价(无税)
    private BigDecimal lackMonthDayUnitTaxPriceTender; // 不足月日单价
    private Integer rentDays; // 租赁天数-- 月租使用

    public Integer getRentDays() {
        return rentDays;
    }

    public void setRentDays(Integer rentDays) {
        this.rentDays = rentDays;
    }

    public BigDecimal getLackMonthDayUnitPriceTender() {
        return lackMonthDayUnitPriceTender;
    }

    public void setLackMonthDayUnitPriceTender(BigDecimal lackMonthDayUnitPriceTender) {
        this.lackMonthDayUnitPriceTender = lackMonthDayUnitPriceTender;
    }

    public BigDecimal getLackMonthDayUnitTaxPriceTender() {
        return lackMonthDayUnitTaxPriceTender;
    }

    public void setLackMonthDayUnitTaxPriceTender(BigDecimal lackMonthDayUnitTaxPriceTender) {
        this.lackMonthDayUnitTaxPriceTender = lackMonthDayUnitTaxPriceTender;
    }

    public BigDecimal getPriceTender() {
        return priceTender;
    }

    public void setPriceTender(BigDecimal priceTender) {
        this.priceTender = priceTender;
    }

    public BigDecimal getTaxPriceTender() {
        return taxPriceTender;
    }

    public void setTaxPriceTender(BigDecimal taxPriceTender) {
        this.taxPriceTender = taxPriceTender;
    }

    public BigDecimal getLackMonthDayUnitPrice() {
        return lackMonthDayUnitPrice;
    }

    public void setLackMonthDayUnitPrice(BigDecimal lackMonthDayUnitPrice) {
        this.lackMonthDayUnitPrice = lackMonthDayUnitPrice;
    }

    public BigDecimal getLackMonthDayUnitTaxPrice() {
        return lackMonthDayUnitTaxPrice;
    }

    public void setLackMonthDayUnitTaxPrice(BigDecimal lackMonthDayUnitTaxPrice) {
        this.lackMonthDayUnitTaxPrice = lackMonthDayUnitTaxPrice;
    }

    public BigDecimal getRentNum() {
        return rentNum;
    }

    public void setRentNum(BigDecimal rentNum) {
        this.rentNum = rentNum;
    }

    public Date getPlanEnterDate() {
        return planEnterDate;
    }

    public void setPlanEnterDate(Date planEnterDate) {
        this.planEnterDate = planEnterDate;
    }

    public Date getPlanLeaveDate() {
        return planLeaveDate;
    }

    public void setPlanLeaveDate(Date planLeaveDate) {
        this.planLeaveDate = planLeaveDate;
    }

    public BigDecimal getPlanDay() {
        return planDay;
    }

    public void setPlanDay(BigDecimal planDay) {
        this.planDay = planDay;
    }

    public String getSourceId() {
        return sourceId;
    }

    public void setSourceId(String sourceId) {
        this.sourceId = sourceId;
    }

    public Long getNoticeId() {
        return noticeId;
    }

    public void setNoticeId(Long noticeId) {
        this.noticeId = noticeId;
    }



    public String getMaterialName() {
        return materialName;
    }

    public void setMaterialName(String materialName) {
        this.materialName = materialName;
    }

    public String getMaterialCode() {
        return materialCode;
    }

    public void setMaterialCode(String materialCode) {
        this.materialCode = materialCode;
    }

    public String getSourceMaterialId() {
        return sourceMaterialId;
    }

    public void setSourceMaterialId(String sourceMaterialId) {
        this.sourceMaterialId = sourceMaterialId;
    }

    public String getSourceMaterialTypeId() {
        return sourceMaterialTypeId;
    }

    public void setSourceMaterialTypeId(String sourceMaterialTypeId) {
        this.sourceMaterialTypeId = sourceMaterialTypeId;
    }

    public String getMaterialTypeName() {
        return materialTypeName;
    }

    public void setMaterialTypeName(String materialTypeName) {
        this.materialTypeName = materialTypeName;
    }

    public String getUnit() {
        return unit;
    }

    public void setUnit(String unit) {
        this.unit = unit;
    }

    public String getSpec() {
        return spec;
    }

    public void setSpec(String spec) {
        this.spec = spec;
    }

    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }

    public Long getDetailProjectId() {
        return detailProjectId;
    }

    public void setDetailProjectId(Long detailProjectId) {
        this.detailProjectId = detailProjectId;
    }

    public String getDetailProjectName() {
        return detailProjectName;
    }

    public void setDetailProjectName(String detailProjectName) {
        this.detailProjectName = detailProjectName;
    }

    public Long getPlanId() {
        return planId;
    }

    public void setPlanId(Long planId) {
        this.planId = planId;
    }

    public String getPlanName() {
        return planName;
    }

    public void setPlanName(String planName) {
        this.planName = planName;
    }

    public String getPlanCode() {
        return planCode;
    }

    public void setPlanCode(String planCode) {
        this.planCode = planCode;
    }

    public BigDecimal getPlanMoney() {
        return planMoney;
    }

    public void setPlanMoney(BigDecimal planMoney) {
        this.planMoney = planMoney;
    }

    public String getBrand() {
        return brand;
    }

    public void setBrand(String brand) {
        this.brand = brand;
    }

    public Integer getCalculateType() {
        return calculateType;
    }

    public void setCalculateType(Integer calculateType) {
        this.calculateType = calculateType;
    }

    public BigDecimal getNum() {
        return num;
    }

    public void setNum(BigDecimal num) {
        this.num = num;
    }

    public BigDecimal getRate() {
        return rate;
    }

    public void setRate(BigDecimal rate) {
        this.rate = rate;
    }

    public BigDecimal getMoney() {
        return money;
    }

    public void setMoney(BigDecimal money) {
        this.money = money;
    }

    public BigDecimal getMoneyTax() {
        return moneyTax;
    }

    public void setMoneyTax(BigDecimal moneyTax) {
        this.moneyTax = moneyTax;
    }
}
