package com.ejianc.business.tender.expert.vo;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 专家条件
 */
public enum RandomRuleTypeEnum {

    组织( 3,"组织"),
    部门(2,"部门"),
    领域(1,"领域"),
    ;
    private final Integer code;
    private final String name;
    private static Map<Integer, RandomRuleTypeEnum> enumMap = new HashMap();

    private RandomRuleTypeEnum(Integer code,String name) {
        this.name = name;
        this.code = code;
    }

    public String getName() {
        return this.name;
    }

    public Integer getCode() {
        return this.code;
    }

    public static RandomRuleTypeEnum getEnumByName(Integer code) {
        return (RandomRuleTypeEnum)enumMap.get(code);
    }

    static {
        enumMap = (Map)EnumSet.allOf(RandomRuleTypeEnum.class).stream().collect(Collectors.toMap(RandomRuleTypeEnum::getCode, Function.identity(), (k1, k2) -> {
            return k2;
        }));
    }

}
