package com.ejianc.business.tender.stuff.vo;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

public enum TenderStageEnum {

    TARGET_STATE(0, "定标立项"),
    BID_STATE(1, "招标立项"),
    ANNOUNCEMENT_STATE(2, "招标公告"),
    DOCUMENT_STATE(3, "招标文件"),
    EXPERT_STATE(4, "专家评标"),
    FINISH_STATE(5, "定标"),
    COMPETITIVE_NEGOTIATION_STATE(6, "竞争性谈判文件"),
    NEGOTIATION_STATE(7, "洽商谈判"),
    SINGLE_STATE(8, "单一来源文件"),
    URGENT_STATE(9, "紧急文件"),
    INQUIRY_STATE(10, "询价公告"),
    FLOW_STATE(11, "流标"),
    WASTE_STATE(12, "废标"),
    BID_ANNOUNCEMENT_STATE(13, "中标公告"),
    BID_NOTICE_STATE(14, "中标通知书"),
    END_STATE(15, "已完成");

    private final Integer tenderTypeCode;
    private final String description;
    private static Map<Integer, TenderStageEnum> enumMap = new HashMap();

    private TenderStageEnum(Integer tenderTypeCode, String description) {
        this.tenderTypeCode = tenderTypeCode;
        this.description = description;
    }

    public Integer getTenderTypeCode() {
        return this.tenderTypeCode;
    }

    public String getDescription() {
        return this.description;
    }

    public static TenderStageEnum getEnumByStateCode(Integer tenderTypeCode) {
        return (TenderStageEnum)enumMap.get(tenderTypeCode);
    }

    static {
        enumMap = (Map)EnumSet.allOf(TenderStageEnum.class).stream().collect(Collectors.toMap(TenderStageEnum::getTenderTypeCode, Function.identity(), (k1, k2) -> {
            return k2;
        }));
    }
}
