package com.ejianc.business.tender.rent.vo;

import com.ejianc.business.tender.common.vo.SupplyFileVo;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * 报价数据实体
 * 
 * @author sunyj
 * 
 */
@ApiModel("供方报价vo")
public class RentSupplierSellVO {
    private static final long serialVersionUID = 1L;

    @ApiModelProperty("来源租户ID")
    private String sourceTenantId;
    @ApiModelProperty("来源ID-招标主键")
    private String sourceId;
    @ApiModelProperty("当前租户主键")
    private Long tenantId;
    @ApiModelProperty("供应商主键")
    private String sourceSupplierId;
    @ApiModelProperty("联系人")
    private Long employeeId;
    @ApiModelProperty("联系人名称")
    private String employeeName;
    @ApiModelProperty("联系人电话")
    private String employeeMobile;
    @ApiModelProperty("发票说明")
    private String invoiceNote;
    @ApiModelProperty("报价操作人")
    private String schemeId;
    @ApiModelProperty("报价操作人名称")
    private String schemeName;
    @ApiModelProperty("报价时间")
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date schemeTime;
    @ApiModelProperty("报价结束时间")
    private Date offerEndTime;
    @ApiModelProperty("类型(0-公告，1-文件,2-询价,3-竞争性,4-洽商谈判)")
    private Integer noticeType;
    @ApiModelProperty("供应商报价方案")
    private List<RentSupplierSellSchemeVO> rentSchemeList = new ArrayList<>();
    @ApiModelProperty("附件全路径")
    private List<SupplyFileVo> supplyFileList;
    private java.lang.Integer tenderType; // 招标方式(0-公开招标,1-邀请招标,2-询价,3-竞争性谈判,4-单一来源,5-紧急招标)
    @ApiModelProperty("轮数")
    private Integer talkNum;

    public Integer getTalkNum() {
        return talkNum;
    }

    public void setTalkNum(Integer talkNum) {
        this.talkNum = talkNum;
    }

    public Integer getTenderType() {
        return tenderType;
    }

    public void setTenderType(Integer tenderType) {
        this.tenderType = tenderType;
    }

    public List<SupplyFileVo> getSupplyFileList() {
        return supplyFileList;
    }

    public void setSupplyFileList(List<SupplyFileVo> supplyFileList) {
        this.supplyFileList = supplyFileList;
    }

    public Integer getNoticeType() {
        return noticeType;
    }

    public void setNoticeType(Integer noticeType) {
        this.noticeType = noticeType;
    }

    public Date getOfferEndTime() {
        return offerEndTime;
    }

    public void setOfferEndTime(Date offerEndTime) {
        this.offerEndTime = offerEndTime;
    }

    public Date getSchemeTime() {
        return schemeTime;
    }

    public void setSchemeTime(Date schemeTime) {
        this.schemeTime = schemeTime;
    }

    public String getSourceTenantId() {
        return sourceTenantId;
    }

    public void setSourceTenantId(String sourceTenantId) {
        this.sourceTenantId = sourceTenantId;
    }

    public String getSourceId() {
        return sourceId;
    }

    public void setSourceId(String sourceId) {
        this.sourceId = sourceId;
    }

    public Long getTenantId() {
        return tenantId;
    }

    public void setTenantId(Long tenantId) {
        this.tenantId = tenantId;
    }

    public String getSourceSupplierId() {
        return sourceSupplierId;
    }

    public void setSourceSupplierId(String sourceSupplierId) {
        this.sourceSupplierId = sourceSupplierId;
    }

    public Long getEmployeeId() {
        return employeeId;
    }

    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }

    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }

    public String getEmployeeMobile() {
        return employeeMobile;
    }

    public void setEmployeeMobile(String employeeMobile) {
        this.employeeMobile = employeeMobile;
    }

    public String getInvoiceNote() {
        return invoiceNote;
    }

    public void setInvoiceNote(String invoiceNote) {
        this.invoiceNote = invoiceNote;
    }

    public String getSchemeId() {
        return schemeId;
    }

    public void setSchemeId(String schemeId) {
        this.schemeId = schemeId;
    }

    public String getSchemeName() {
        return schemeName;
    }

    public void setSchemeName(String schemeName) {
        this.schemeName = schemeName;
    }

    public List<RentSupplierSellSchemeVO> getRentSchemeList() {
        return rentSchemeList;
    }

    public void setRentSchemeList(List<RentSupplierSellSchemeVO> rentSchemeList) {
        this.rentSchemeList = rentSchemeList;
    }
}
