package com.ejianc.business.tender.equipment.vo;

import com.ejianc.business.tender.common.vo.SupplyFileVo;
import com.ejianc.framework.skeleton.template.BaseVO;
import io.swagger.annotations.ApiModelProperty;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;


/**
 * 材料招标立项供应商表
 *
 * @author generator
 *
 */
public class EquipmentNoticeSupplierVO extends BaseVO {
    private static final long serialVersionUID = 1L;

    private Long noticeId; // 公告主键ID
    private Long supplierId; // 供应商ID
    private Integer state; // 状态（0：正常，1：已剔除）
    private String sourceSupplierTenantId; // 供应商租户主键
    private String sourceSupplierId; // 供应商主键
    private Long employeeId; // 报名联系人(接收)
    private String employeeName; // 报名联系人名称(接收)
    private String employeeMobile; // 报名联系人电话(接收)
    private java.util.Date signTime; // 报名时间
    private String supplierName; // 供应商名称
    private String sourceId; // 供应商来源主键
    private Long supplierEmployeeId; // 报名联系人
    private String supplierEmployeeName; // 报名联系人名称
    private String supplierEmployeeMobile; // 报名联系人电话
    @ApiModelProperty("附件名称")
    private String fileName;
    @ApiModelProperty("附件主键")
    private Long attachId;
    private String outReason; // 剔除供应商原因
    private java.lang.Integer documentType; // 是否报价（招标文件专用 lzj+）
    private List<Map<String, Object>> file = new ArrayList<>();
    @ApiModelProperty("附件全路径")
    private List<SupplyFileVo> supplyFileList;

    public List<SupplyFileVo> getSupplyFileList() {
        return supplyFileList;
    }

    public void setSupplyFileList(List<SupplyFileVo> supplyFileList) {
        this.supplyFileList = supplyFileList;
    }

    public List<Map<String, Object>> getFile() {
        return file;
    }

    public void setFile(List<Map<String, Object>> file) {
        this.file = file;
    }

    public Integer getDocumentType() {
        return documentType;
    }

    public void setDocumentType(Integer documentType) {
        this.documentType = documentType;
    }

    public String getOutReason() {
        return outReason;
    }

    public void setOutReason(String outReason) {
        this.outReason = outReason;
    }

    public String getFileName() {
        return fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public Long getAttachId() {
        return attachId;
    }

    public void setAttachId(Long attachId) {
        this.attachId = attachId;
    }

    public String getSourceSupplierId() {
        return sourceSupplierId;
    }

    public void setSourceSupplierId(String sourceSupplierId) {
        this.sourceSupplierId = sourceSupplierId;
    }

    public String getSourceId() {
        return sourceId;
    }

    public void setSourceId(String sourceId) {
        this.sourceId = sourceId;
    }

    public Long getSupplierEmployeeId() {
        return supplierEmployeeId;
    }

    public void setSupplierEmployeeId(Long supplierEmployeeId) {
        this.supplierEmployeeId = supplierEmployeeId;
    }

    public String getSupplierEmployeeName() {
        return supplierEmployeeName;
    }

    public void setSupplierEmployeeName(String supplierEmployeeName) {
        this.supplierEmployeeName = supplierEmployeeName;
    }

    public String getSupplierEmployeeMobile() {
        return supplierEmployeeMobile;
    }

    public void setSupplierEmployeeMobile(String supplierEmployeeMobile) {
        this.supplierEmployeeMobile = supplierEmployeeMobile;
    }

    /**
     * 公告主键ID
     */
    public Long getNoticeId() {
        return noticeId;
    }

    /**
     * 公告主键ID
     */
    public void setNoticeId(Long noticeId) {
        this.noticeId = noticeId;
    }
    /**
     * 供应商ID
     */
    public Long getSupplierId() {
        return supplierId;
    }

    /**
     * 供应商ID
     */
    public void setSupplierId(Long supplierId) {
        this.supplierId = supplierId;
    }
    /**
     * 状态（0：正常，1：已剔除）
     */
    public Integer getState() {
        return state;
    }

    /**
     * 状态（0：正常，1：已剔除）
     */
    public void setState(Integer state) {
        this.state = state;
    }

    public String getSourceSupplierTenantId() {
        return sourceSupplierTenantId;
    }

    public void setSourceSupplierTenantId(String sourceSupplierTenantId) {
        this.sourceSupplierTenantId = sourceSupplierTenantId;
    }

    /**
     * 报名联系人
     */
    public Long getEmployeeId() {
        return employeeId;
    }

    /**
     * 报名联系人
     */
    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    /**
     * 报名联系人名称
     */
    public String getEmployeeName() {
        return employeeName;
    }

    /**
     * 报名联系人名称
     */
    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    /**
     * 报名联系人电话
     */
    public String getEmployeeMobile() {
        return employeeMobile;
    }

    /**
     * 报名联系人电话
     */
    public void setEmployeeMobile(String employeeMobile) {
        this.employeeMobile = employeeMobile;
    }
    /**
     * 报名时间
     */
    public java.util.Date getSignTime() {
        return signTime;
    }

    /**
     * 报名时间
     */
    public void setSignTime(java.util.Date signTime) {
        this.signTime = signTime;
    }
    /**
     * 供应商名称
     */
    public String getSupplierName() {
        return supplierName;
    }

    /**
     * 供应商名称
     */
    public void setSupplierName(String supplierName) {
        this.supplierName = supplierName;
    }

}
