package com.ejianc.business.tender.util;

import java.util.HashMap;
import java.util.Map;

public enum TenderTypeUrlEnum {
    材料招标("材料招标","/stuff/invite"),
    分包招标("分包招标","/sub/invite"),
    设备采购("设备采购","/equipment/invite"),
    设备租赁("设备租赁","/rent/invite"),
    周转材租赁("周转材租赁","/rmat/invite"),
    其他("其他","/other/invite");

    private String type;
    private String url;

    private static Map<String, TenderTypeUrlEnum> enumMap = new HashMap();

    static {
        for (TenderTypeUrlEnum urlEnum : TenderTypeUrlEnum.values()) {
            enumMap.put(urlEnum.getType(), urlEnum);
        }
    }

    public static String getUrl(String type) {
        TenderTypeUrlEnum tenderTypeUrlEnum = enumMap.get(type);
        return tenderTypeUrlEnum != null ? tenderTypeUrlEnum.getUrl() : null;
    }

    TenderTypeUrlEnum(String type,String url) {
        this.type = type;
        this.url = url;
    }

    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getUrl() {
        return url;
    }

    public void setUrl(String url) {
        this.url = url;
    }
}
