package com.ejianc.business.tender.api;

import com.ejianc.business.tender.common.vo.TenderPicketageVO;
import com.ejianc.business.tender.hystrix.TenderRentHystrix;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

/**
 *
 *
 * @author yqls
 *
 */
@FeignClient(name= "ejc-tender-web", url="${common.env.feign-client-url}", path="ejc-tender-web", fallback = TenderRentHystrix.class)
public interface ITenderRentApi {

	/**
	 *
	 * @return
	 */
	@GetMapping(value = "/api/rentPicketageRefsupplier/updateById")
    CommonResponse<String> updateById(@RequestParam Long id, @RequestParam Integer occupyFlag);
	/**
	 *
	 * @return
	 */
	@GetMapping(value = "/api/rentPicketageRefsupplier/updateStatus")
	CommonResponse<String> updateStatus(@RequestBody TenderPicketageVO tenderPicketageVO);
	/**
	 *
	 * @return
	 */
	@GetMapping(value = "/api/rentPicketageRefsupplier/delUpdateStatus")
	CommonResponse<String> delUpdateStatus(@RequestBody TenderPicketageVO tenderPicketageVO);
}
