package com.ejianc.business.tender.abolish.vo;

import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.baomidou.mybatisplus.annotation.TableField;
import com.ejianc.business.tender.equipment.vo.EquipmentInviteDetailRecordVO;
import com.ejianc.business.tender.equipment.vo.EquipmentInviteDetailVO;
import com.ejianc.business.tender.other.vo.OtherInviteDetailVO;
import com.ejianc.business.tender.rent.vo.RentInviteDetailVO;
import com.ejianc.business.tender.rmat.vo.RmatInviteDetailVO;
import com.ejianc.business.tender.stuff.vo.StuffInviteDetailVO;
import com.ejianc.business.tender.sub.vo.SubInviteDetailRecordVO;
import com.ejianc.business.tender.sub.vo.SubInviteDetailVO;
import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;


/**
 * 废标记录表
 * 
 * @author generator
 * 
 */
@ApiModel("废标记录表")
public class WasteVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    @ApiModelProperty("招标立项主键")
    private Long tenderId;
    @ApiModelProperty("招标立项名称")
    private String tenderName;
    @ApiModelProperty("阶段主键")
    private Long stageId;
    @ApiModelProperty("招标阶段")
    private Integer tenderStage;
    @ApiModelProperty("项目ID")
    private Long projectId;
    @ApiModelProperty("项目名称")
    private String projectName;
    @ApiModelProperty("项目编号")
    private String projectCode;
    @ApiModelProperty("招标方式(0-平台公开招标,1-邀请招标,2-询价,3-竞争性谈判,4-单一来源,5-紧急招标)")
    private Integer tenderType;
    @ApiModelProperty("申请人id")
    private Long employeeId;
    @ApiModelProperty("申请人名称")
    private String employeeName;
    @ApiModelProperty("申请人电话")
    private String employeeMobile;
    @ApiModelProperty("申请单位ID")
    private Long unitId;
    @ApiModelProperty("申请单位名称")
    private String unitName;
    @ApiModelProperty("申请时间")
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private java.util.Date applyTime;
    @ApiModelProperty("原因")
    private String memo;
    @ApiModelProperty("公示内容")
    private String content;
    @ApiModelProperty("是否发布,0-是,1-否")
    private Integer publishFlag;
    @ApiModelProperty("组织")
    private Long orgId;
    @ApiModelProperty("组织名称")
    private String orgName;
    @ApiModelProperty("父级组织")
    private Long parentOrgId;
    @ApiModelProperty("父级组织名称")
    private String parentOrgName;
    @ApiModelProperty("单据编号")
    private String billCode;
    @ApiModelProperty("单据状态（审批必须字段）")
    private Integer billState;
    @ApiModelProperty("招标类型(0-材料,1-劳务....)")
    private Integer type;
    @ApiModelProperty("招标方式(0-平台公开招标,1-邀请招标,2-询价,3-竞争性谈判,4-单一来源,5-紧急招标)")
    private java.lang.String tenderTypeName; // 招标方式(0-平台公开招标,1-邀请招标,2-询价,3-竞争性谈判,4-单一来源,5-紧急招标)
    @ApiModelProperty("采购方式(0-项目采购,1-单位采购)")
    private java.lang.Integer purchaseType;
    @ApiModelProperty("采购方式(0-项目采购,1-单位采购)")
    private java.lang.String purchaseTypeName;
    @ApiModelProperty("采购方式ID")
    private java.lang.String purchaseId;
    @ApiModelProperty("采购方式名称")
    private java.lang.String purchaseName;
    private Integer retenderFlag;//是否重新发起招标立项 0-否, 1-是

    private Integer pushI8Flag; // 0否 1是
    private String inviteSourceType; // 来源类型: "自制" / "i8"
    public String getInviteSourceType() {
        return inviteSourceType;
    }

    public void setInviteSourceType(String inviteSourceType) {
        this.inviteSourceType = inviteSourceType;
    }
    public Integer getPushI8Flag() {
        return pushI8Flag;
    }

    public void setPushI8Flag(Integer pushI8Flag) {
        this.pushI8Flag = pushI8Flag;
    }

    public Integer getRetenderFlag() {
        return retenderFlag;
    }

    public void setRetenderFlag(Integer retenderFlag) {
        this.retenderFlag = retenderFlag;
    }

    // 采购清单
    @ApiModelProperty("采购清单明细")
    private List<StuffInviteDetailVO> stuffInviteDetailList = new ArrayList<>();
    @ApiModelProperty("分包清单明细")
    private List<SubInviteDetailRecordVO> subInviteDetailList = new ArrayList<>();
    @ApiModelProperty("设备采购清单明细")
    private List<EquipmentInviteDetailVO> equipmentInviteDetailList = new ArrayList<>();
    @ApiModelProperty("设备租赁清单明细")
    private List<RentInviteDetailVO> rentInviteDetailList = new ArrayList<>();
    @ApiModelProperty("周转材租赁清单明细")
    private List<RmatInviteDetailVO> rmatInviteDetailList = new ArrayList<>();
    @ApiModelProperty("其他清单明细")
    private List<OtherInviteDetailVO> otherInviteDetailList = new ArrayList<>();


    /**
     * 招标立项主键
     */
    public Long getTenderId() {
        return tenderId;
    }

    /**
     * 招标立项主键
     */
    public void setTenderId(Long tenderId) {
        this.tenderId = tenderId;
    }
    /**
     * 招标立项名称
     */
    public String getTenderName() {
        return tenderName;
    }

    /**
     * 招标立项名称
     */
    public void setTenderName(String tenderName) {
        this.tenderName = tenderName;
    }
    /**
     * 阶段主键
     */
    public Long getStageId() {
        return stageId;
    }

    /**
     * 阶段主键
     */
    public void setStageId(Long stageId) {
        this.stageId = stageId;
    }
    /**
     * 招标阶段
     */
    public Integer getTenderStage() {
        return tenderStage;
    }

    /**
     * 招标阶段
     */
    public void setTenderStage(Integer tenderStage) {
        this.tenderStage = tenderStage;
    }
    /**
     * 项目ID
     */
    public Long getProjectId() {
        return projectId;
    }

    /**
     * 项目ID
     */
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    /**
     * 项目名称
     */
    public String getProjectName() {
        return projectName;
    }

    /**
     * 项目名称
     */
    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    /**
     * 项目编号
     */
    public String getProjectCode() {
        return projectCode;
    }

    /**
     * 项目编号
     */
    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }
    /**
     * 招标方式(0-平台公开招标,1-邀请招标,2-询价,3-竞争性谈判,4-单一来源,5-紧急招标)
     */
    public Integer getTenderType() {
        return tenderType;
    }

    /**
     * 招标方式(0-平台公开招标,1-邀请招标,2-询价,3-竞争性谈判,4-单一来源,5-紧急招标)
     */
    public void setTenderType(Integer tenderType) {
        this.tenderType = tenderType;
    }
    /**
     * 申请人id
     */
    public Long getEmployeeId() {
        return employeeId;
    }

    /**
     * 申请人id
     */
    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    /**
     * 申请人名称
     */
    public String getEmployeeName() {
        return employeeName;
    }

    /**
     * 申请人名称
     */
    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    /**
     * 申请人电话
     */
    public String getEmployeeMobile() {
        return employeeMobile;
    }

    /**
     * 申请人电话
     */
    public void setEmployeeMobile(String employeeMobile) {
        this.employeeMobile = employeeMobile;
    }
    /**
     * 申请单位ID
     */
    @ReferSerialTransfer(referCode = "idm-org")
    public Long getUnitId() {
        return unitId;
    }

    /**
     * 申请单位ID
     */
    @ReferDeserialTransfer
    public void setUnitId(Long unitId) {
        this.unitId = unitId;
    }
    /**
     * 申请单位名称
     */
    public String getUnitName() {
        return unitName;
    }

    /**
     * 申请单位名称
     */
    public void setUnitName(String unitName) {
        this.unitName = unitName;
    }
    /**
     * 申请时间
     */
    public java.util.Date getApplyTime() {
        return applyTime;
    }

    /**
     * 申请时间
     */
    public void setApplyTime(java.util.Date applyTime) {
        this.applyTime = applyTime;
    }
    /**
     * 原因
     */
    public String getMemo() {
        return memo;
    }

    /**
     * 原因
     */
    public void setMemo(String memo) {
        this.memo = memo;
    }
    /**
     * 公示内容
     */
    public String getContent() {
        return content;
    }

    /**
     * 公示内容
     */
    public void setContent(String content) {
        this.content = content;
    }
    /**
     * 是否发布,0-是,1-否
     */
    public Integer getPublishFlag() {
        return publishFlag;
    }

    /**
     * 是否发布,0-是,1-否
     */
    public void setPublishFlag(Integer publishFlag) {
        this.publishFlag = publishFlag;
    }
    /**
     * 组织
     */
    @ReferSerialTransfer(referCode = "idm-org")
    public Long getOrgId() {
        return orgId;
    }

    /**
     * 组织
     */
    @ReferDeserialTransfer
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    /**
     * 组织名称
     */
    public String getOrgName() {
        return orgName;
    }

    /**
     * 组织名称
     */
    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    /**
     * 父级组织
     */
    public Long getParentOrgId() {
        return parentOrgId;
    }

    /**
     * 父级组织
     */
    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    /**
     * 父级组织名称
     */
    public String getParentOrgName() {
        return parentOrgName;
    }

    /**
     * 父级组织名称
     */
    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    /**
     * 单据编号
     */
    public String getBillCode() {
        return billCode;
    }

    /**
     * 单据编号
     */
    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    /**
     * 单据状态（审批必须字段）
     */
    public Integer getBillState() {
        return billState;
    }

    /**
     * 单据状态（审批必须字段）
     */
    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    /**
     * 招标类型(0-材料,1-劳务....)
     */
    public Integer getType() {
        return type;
    }

    /**
     * 招标类型(0-材料,1-劳务....)
     */
    public void setType(Integer type) {
        this.type = type;
    }

    public String getTenderTypeName() {
        return tenderTypeName;
    }

    public void setTenderTypeName(String tenderTypeName) {
        this.tenderTypeName = tenderTypeName;
    }

    public Integer getPurchaseType() {
        return purchaseType;
    }

    public void setPurchaseType(Integer purchaseType) {
        this.purchaseType = purchaseType;
    }

    public String getPurchaseTypeName() {
        return purchaseTypeName;
    }

    public void setPurchaseTypeName(String purchaseTypeName) {
        this.purchaseTypeName = purchaseTypeName;
    }

    public String getPurchaseId() {
        return purchaseId;
    }

    public void setPurchaseId(String purchaseId) {
        this.purchaseId = purchaseId;
    }

    public String getPurchaseName() {
        return purchaseName;
    }

    public void setPurchaseName(String purchaseName) {
        this.purchaseName = purchaseName;
    }

    public List<StuffInviteDetailVO> getStuffInviteDetailList() {
        return stuffInviteDetailList;
    }

    public void setStuffInviteDetailList(List<StuffInviteDetailVO> stuffInviteDetailList) {
        this.stuffInviteDetailList = stuffInviteDetailList;
    }

    public List<SubInviteDetailRecordVO> getSubInviteDetailList() {
        return subInviteDetailList;
    }

    public void setSubInviteDetailList(List<SubInviteDetailRecordVO> subInviteDetailList) {
        this.subInviteDetailList = subInviteDetailList;
    }

    public List<EquipmentInviteDetailVO> getEquipmentInviteDetailList() {
        return equipmentInviteDetailList;
    }

    public void setEquipmentInviteDetailList(List<EquipmentInviteDetailVO> equipmentInviteDetailList) {
        this.equipmentInviteDetailList = equipmentInviteDetailList;
    }

    public List<RentInviteDetailVO> getRentInviteDetailList() {
        return rentInviteDetailList;
    }

    public void setRentInviteDetailList(List<RentInviteDetailVO> rentInviteDetailList) {
        this.rentInviteDetailList = rentInviteDetailList;
    }

    public List<RmatInviteDetailVO> getRmatInviteDetailList() {
        return rmatInviteDetailList;
    }

    public void setRmatInviteDetailList(List<RmatInviteDetailVO> rmatInviteDetailList) {
        this.rmatInviteDetailList = rmatInviteDetailList;
    }

    public List<OtherInviteDetailVO> getOtherInviteDetailList() {
        return otherInviteDetailList;
    }

    public void setOtherInviteDetailList(List<OtherInviteDetailVO> otherInviteDetailList) {
        this.otherInviteDetailList = otherInviteDetailList;
    }
}
