package com.ejianc.business.tender.rent.vo;

import com.baomidou.mybatisplus.annotation.TableField;
import com.ejianc.business.tools.refer.annotation.ReferJsonField;
import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;


/**
 * 材料招标立项采购清单记录表
 * 
 * @author generator
 * 
 */
public class RentInviteDetailRecordVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private Long inviteId; // 招标主键ID
    private Long materialId; // 材料ID
    private String materialName; // 材料名称
    private String materialCode; // 材料编码
    @ReferJsonField(referCode = "equipmentType001",referFields = "code",resultFields = "materialTypeCode")
    private Long materialTypeId; // 材料分类ID
    private String materialTypeName; // 材料分类名称
    private String unit; // 单位
    private String spec; // 规格型号
    private String memo; // 备注
    private Long detailProjectId; // 项目ID
    private String detailProjectName; // 项目名称
    private Long detailOrgId; // 采购单位ID
    private String detailOrgName; // 采购单位名称
    private Long planId; // 计划ID
    private String planName; // 计划名称
    private String planCode; // 计划编码
    private BigDecimal planMoney; // 计划金额
    private String brand; // 品牌
    private Integer calculateType; // 计量方式(0-理计,1-过磅,2-点数)
    private BigDecimal num; // 数量
    private BigDecimal rate; // 税率
    private BigDecimal money; // 暂估金额
    private BigDecimal moneyTax; // 暂估金额(含税)
    private BigDecimal planNum; // 计划数量
    private String contractType;//合同类型(0-消耗材,1-周转材,2-混凝土,3-零星材料)
    private String purchaseId; // 采购方式ID
    private String purchaseName; // 采购方式ID
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private java.util.Date planEnterDate; // 计划进场时间
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private java.util.Date planLeaveDate; // 计划出场时间
    private BigDecimal planDay; // 计划周期
    //    1、日租：计划周期名称改为租赁天数，现有逻辑不变（调整后供方也需要修改）
//            2、月租：计划周期名称改为租赁月数，计划进场时间、计划出场时间为必填项，按照租金计算法，向上取整，支持修改（调整后供方也需要修改）
//            3、工程量租：
//            1）数量改为租赁工程量，计划周期=计划（进场时间-出场时间）+1，算天数，但是不参与逻辑计算（调整后，需要租赁数量、租赁工程量推送到供方）
//            2）增加一列“租赁数量”手动输入，必填项，大于0的正数，小数位数计算八位，前端显示4位，不自动补零，数量不参与金额的计算（涉及到合并的清单，数量相加）
    @TableField(value="rent_num")
    private BigDecimal rentNum; // 租赁工程量
    @TableField(value="flag_oil")
    private Integer flagOil; // 是否含油 (1:是，0：否)

    private String flagOilName;
    @TableField(value="flag_operation")
    private Integer flagOperation; // 是否含操作手(1:是，0：否)

    private String flagOperationName;

    private BigDecimal overDays;

    private BigDecimal overMonths;
    @TableField(value="price")
    private BigDecimal price; //招标控制单价（无税）
    @TableField(value="tax_price")
    private BigDecimal taxPrice; // 招标控制单价
    @TableField(value="tax")
    private BigDecimal tax; // 税额
    @TableField(value="billing_unit_id")
    private Long billingUnitId;
    @TableField(value="billing_unit_name")
    private String billingUnitName;
    private String detailMeasurementRules;//计量规则

    private String jobContent;//工作内容

    private String treeIndex; // 序号

    public String getTreeIndex() {
        return treeIndex;
    }

    public void setTreeIndex(String treeIndex) {
        this.treeIndex = treeIndex;
    }
    public String getDetailMeasurementRules() {
        return detailMeasurementRules;
    }

    public void setDetailMeasurementRules(String detailMeasurementRules) {
        this.detailMeasurementRules = detailMeasurementRules;
    }

    public String getJobContent() {
        return jobContent;
    }

    public void setJobContent(String jobContent) {
        this.jobContent = jobContent;
    }
    /**
     * 计费单位
     */
    @ReferSerialTransfer(referCode="share-unit")
    public Long getBillingUnitId() {
        return billingUnitId;
    }

    /**
     * 计费单位
     */
    @ReferDeserialTransfer
    public void setBillingUnitId(Long billingUnitId) {
        this.billingUnitId = billingUnitId;
    }


    public String getFlagOilName() {
        return flagOilName;
    }

    public void setFlagOilName(String flagOilName) {
        this.flagOilName = flagOilName;
    }

    public String getFlagOperationName() {
        return flagOperationName;
    }

    public void setFlagOperationName(String flagOperationName) {
        this.flagOperationName = flagOperationName;
    }


    public BigDecimal getOverDays() {
        return overDays;
    }

    public void setOverDays(BigDecimal overDays) {
        this.overDays = overDays;
    }

    public BigDecimal getOverMonths() {
        return overMonths;
    }

    public void setOverMonths(BigDecimal overMonths) {
        this.overMonths = overMonths;
    }

    private String rateStr; // 税率
    private String moneyTaxStr; // 金额

    private String historyPriceArea;//历史价格区间（无税）
    private String historyTaxPriceArea;//历史价格区间（含税）
    private String guidePriceArea; // 公司指导价区间（无税）
    private String guideTaxPriceArea; // 公司指导价区间（含税）


    private Integer detailRentType; // 子表租赁方式(0-日租,1-月租,2-工程量租)
    private Integer detailTableType; // i8子表表格类型 0-清单，1-费用

    public Integer getDetailTableType() {
        return detailTableType;
    }

    public void setDetailTableType(Integer detailTableType) {
        this.detailTableType = detailTableType;
    }

    public Integer getDetailRentType() {
        return detailRentType;
    }

    public void setDetailRentType(Integer detailRentType) {
        this.detailRentType = detailRentType;
    }

    public String getHistoryPriceArea() {
        return historyPriceArea;
    }

    public void setHistoryPriceArea(String historyPriceArea) {
        this.historyPriceArea = historyPriceArea;
    }

    public String getHistoryTaxPriceArea() {
        return historyTaxPriceArea;
    }

    public void setHistoryTaxPriceArea(String historyTaxPriceArea) {
        this.historyTaxPriceArea = historyTaxPriceArea;
    }

    public String getGuidePriceArea() {
        return guidePriceArea;
    }

    public void setGuidePriceArea(String guidePriceArea) {
        this.guidePriceArea = guidePriceArea;
    }

    public String getGuideTaxPriceArea() {
        return guideTaxPriceArea;
    }

    public void setGuideTaxPriceArea(String guideTaxPriceArea) {
        this.guideTaxPriceArea = guideTaxPriceArea;
    }
    public String getRateStr() {
        return rateStr;
    }

    public void setRateStr(String rateStr) {
        this.rateStr = rateStr;
    }

    public String getMoneyTaxStr() {
        return moneyTaxStr;
    }

    public void setMoneyTaxStr(String moneyTaxStr) {
        this.moneyTaxStr = moneyTaxStr;
    }

    public String getBillingUnitName() {
        return billingUnitName;
    }

    public void setBillingUnitName(String billingUnitName) {
        this.billingUnitName = billingUnitName;
    }

    public BigDecimal getTax() {
        return tax;
    }

    public void setTax(BigDecimal tax) {
        this.tax = tax;
    }

    public BigDecimal getPrice() {
        return price;
    }

    public void setPrice(BigDecimal price) {
        this.price = price;
    }

    public BigDecimal getTaxPrice() {
        return taxPrice;
    }

    public void setTaxPrice(BigDecimal taxPrice) {
        this.taxPrice = taxPrice;
    }

    List<RentInviteDetailBidderVO> rentDetailBidder = new ArrayList<RentInviteDetailBidderVO>();

    public BigDecimal getRentNum() {
        return rentNum;
    }

    public void setRentNum(BigDecimal rentNum) {
        this.rentNum = rentNum;
    }

    public Integer getFlagOil() {
        return flagOil;
    }

    public void setFlagOil(Integer flagOil) {
        this.flagOil = flagOil;
    }

    public Integer getFlagOperation() {
        return flagOperation;
    }

    public void setFlagOperation(Integer flagOperation) {
        this.flagOperation = flagOperation;
    }


    public Date getPlanEnterDate() {
        return planEnterDate;
    }

    public void setPlanEnterDate(Date planEnterDate) {
        this.planEnterDate = planEnterDate;
    }

    public Date getPlanLeaveDate() {
        return planLeaveDate;
    }

    public void setPlanLeaveDate(Date planLeaveDate) {
        this.planLeaveDate = planLeaveDate;
    }

    public BigDecimal getPlanDay() {
        return planDay;
    }

    public void setPlanDay(BigDecimal planDay) {
        this.planDay = planDay;
    }

    public String getPurchaseId() {
        return purchaseId;
    }

    public void setPurchaseId(String purchaseId) {
        this.purchaseId = purchaseId;
    }

    public String getPurchaseName() {
        return purchaseName;
    }

    public void setPurchaseName(String purchaseName) {
        this.purchaseName = purchaseName;
    }

    public List<RentInviteDetailBidderVO> getRentDetailBidder() {
        return rentDetailBidder;
    }

    public void setRentDetailBidder(List<RentInviteDetailBidderVO> rentDetailBidder) {
        this.rentDetailBidder = rentDetailBidder;
    }

    public String getContractType() {
        return contractType;
    }

    public void setContractType(String contractType) {
        this.contractType = contractType;
    }

    public Long getInviteId() {
        return inviteId;
    }

    public void setInviteId(Long inviteId) {
        this.inviteId = inviteId;
    }
    public Long getMaterialId() {
        return materialId;
    }

    public void setMaterialId(Long materialId) {
        this.materialId = materialId;
    }
    public String getMaterialName() {
        return materialName;
    }

    public void setMaterialName(String materialName) {
        this.materialName = materialName;
    }
    public String getMaterialCode() {
        return materialCode;
    }

    public void setMaterialCode(String materialCode) {
        this.materialCode = materialCode;
    }
    public Long getMaterialTypeId() {
        return materialTypeId;
    }

    public void setMaterialTypeId(Long materialTypeId) {
        this.materialTypeId = materialTypeId;
    }
    public String getMaterialTypeName() {
        return materialTypeName;
    }

    public void setMaterialTypeName(String materialTypeName) {
        this.materialTypeName = materialTypeName;
    }
    public String getUnit() {
        return unit;
    }

    public void setUnit(String unit) {
        this.unit = unit;
    }
    public String getSpec() {
        return spec;
    }

    public void setSpec(String spec) {
        this.spec = spec;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    public Long getDetailProjectId() {
        return detailProjectId;
    }
    public void setDetailProjectId(Long detailProjectId) {
        this.detailProjectId = detailProjectId;
    }
    public String getDetailProjectName() {
        return detailProjectName;
    }

    public void setDetailProjectName(String detailProjectName) {
        this.detailProjectName = detailProjectName;
    }
    public Long getDetailOrgId() {
        return detailOrgId;
    }

    public void setDetailOrgId(Long detailOrgId) {
        this.detailOrgId = detailOrgId;
    }
    public String getDetailOrgName() {
        return detailOrgName;
    }

    public void setDetailOrgName(String detailOrgName) {
        this.detailOrgName = detailOrgName;
    }
    public Long getPlanId() {
        return planId;
    }

    public void setPlanId(Long planId) {
        this.planId = planId;
    }
    public String getPlanName() {
        return planName;
    }

    public void setPlanName(String planName) {
        this.planName = planName;
    }
    public String getPlanCode() {
        return planCode;
    }

    public void setPlanCode(String planCode) {
        this.planCode = planCode;
    }
    public BigDecimal getPlanMoney() {
        return planMoney;
    }

    public void setPlanMoney(BigDecimal planMoney) {
        this.planMoney = planMoney;
    }
    public String getBrand() {
        return brand;
    }

    public void setBrand(String brand) {
        this.brand = brand;
    }
    public Integer getCalculateType() {
        return calculateType;
    }

    public void setCalculateType(Integer calculateType) {
        this.calculateType = calculateType;
    }
    public BigDecimal getNum() {
        return num;
    }

    public void setNum(BigDecimal num) {
        this.num = num;
    }
    public BigDecimal getRate() {
        return rate;
    }

    public void setRate(BigDecimal rate) {
        this.rate = rate;
    }
    public BigDecimal getMoney() {
        return money;
    }

    public void setMoney(BigDecimal money) {
        this.money = money;
    }
    public BigDecimal getMoneyTax() {
        return moneyTax;
    }

    public void setMoneyTax(BigDecimal moneyTax) {
        this.moneyTax = moneyTax;
    }
    public BigDecimal getPlanNum() {
        return planNum;
    }

    public void setPlanNum(BigDecimal planNum) {
        this.planNum = planNum;
    }
    
}
