package com.ejianc.business.tender.rent.vo;

import com.ejianc.framework.skeleton.template.BaseVO;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.ArrayList;
import java.util.List;


/**
 * 招标公告供应商标
 *
 * @author generator
 *
 */
@ApiModel("招标公告发布之后同步接口")
public class RentNoticeSupplierTbVO extends BaseVO {
    private static final long serialVersionUID = 1L;

    @ApiModelProperty("来源系统类型")
    private String sourceType;
    @ApiModelProperty("招标立项ID")
    private String sourceId;
    @ApiModelProperty("类型,默认传0")
    private Integer noticeType;
    @ApiModelProperty("来源项目主键")
    private String sourceProjectId;
    @ApiModelProperty("项目名称")
    private String projectName;
    @ApiModelProperty("项目编码")
    private String projectCode;
    @ApiModelProperty("来源组织主键")
    private String sourceOrgId;
    @ApiModelProperty("组织名称")
    private String orgName;
    @ApiModelProperty("招标单位主键")
    private String sourceUnitId;
    @ApiModelProperty("招标单位名称")
    private String unitName;
    @ApiModelProperty("备注")
    private String memo;
    @ApiModelProperty("类型")
    private String type;
    @ApiModelProperty("公告名称")
    private String tenderName;
    @ApiModelProperty("招标方式")
    private Integer tenderType;
    @ApiModelProperty("采购类别")
    private String purchaseName;
    @ApiModelProperty("招标联系人主键")
    private String sourceEmployeeId;
    @ApiModelProperty("招标联系人名称")
    private String employeeName;
    @ApiModelProperty("招标联系人电话")
    private String employeeMobile;
    @ApiModelProperty("招标方式")
    private String purchaseType;
    @ApiModelProperty("报名开始时间")
    private String noticeStartTime;
    @ApiModelProperty("报名结束时间")
    private String noticeEndTime;
    @ApiModelProperty("计价方式")
    private Integer valueType;
    @ApiModelProperty("公告内容")
    private String noticeContent;
    @ApiModelProperty("公告内容")
    private String content;
    @ApiModelProperty("报价开始时间")
    private String offerStartTime;
    @ApiModelProperty("报价结束时间")
    private String offerEndTime;
    @ApiModelProperty("是否允许多品牌报价,0-是,1-否")
    private Integer brandFlag;
    @ApiModelProperty("项目联系人")
    private String projectLinkName;
    @ApiModelProperty("项目联系电话")
    private String projectLinkPhone;
    private String systemId;//第三方系统 id
    private String materialContentId;//供货内容Id
    private String materialContent;//供货内容
    private Integer rentType; // 租赁方式(0-日租,1-月租,2-工程量租)


    private List<RentNoticeDetailTbVO> rentDetailList = new ArrayList<>(); // 如果type是材料，该集合必传
    private List<RentNoticeSupplierDetailTbVO> applyList = new ArrayList<>(); // 如果是邀请招标，需传该集合

    private Long equipmentType; // 设备类型（0-机械设备租赁，1-机械承揽）

    public Long getEquipmentType() {
        return equipmentType;
    }

    public void setEquipmentType(Long equipmentType) {
        this.equipmentType = equipmentType;
    }

    public Integer getRentType() {
        return rentType;
    }

    public void setRentType(Integer rentType) {
        this.rentType = rentType;
    }

    public String getMaterialContentId() {
        return materialContentId;
    }

    public void setMaterialContentId(String materialContentId) {
        this.materialContentId = materialContentId;
    }

    public String getMaterialContent() {
        return materialContent;
    }

    public void setMaterialContent(String materialContent) {
        this.materialContent = materialContent;
    }

    public String getSystemId() {
        return systemId;
    }

    public void setSystemId(String systemId) {
        this.systemId = systemId;
    }

    public String getSourceType() {
        return sourceType;
    }

    public Integer getBrandFlag() {
        return brandFlag;
    }

    public void setBrandFlag(Integer brandFlag) {
        this.brandFlag = brandFlag;
    }

    public String getProjectLinkName() {
        return projectLinkName;
    }

    public void setProjectLinkName(String projectLinkName) {
        this.projectLinkName = projectLinkName;
    }

    public String getProjectLinkPhone() {
        return projectLinkPhone;
    }

    public void setProjectLinkPhone(String projectLinkPhone) {
        this.projectLinkPhone = projectLinkPhone;
    }

    public String getOfferStartTime() {
        return offerStartTime;
    }

    public void setOfferStartTime(String offerStartTime) {
        this.offerStartTime = offerStartTime;
    }

    public String getOfferEndTime() {
        return offerEndTime;
    }

    public void setOfferEndTime(String offerEndTime) {
        this.offerEndTime = offerEndTime;
    }

    public String getContent() {
        return content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public void setSourceType(String sourceType) {
        this.sourceType = sourceType;
    }

    public String getSourceId() {
        return sourceId;
    }

    public void setSourceId(String sourceId) {
        this.sourceId = sourceId;
    }

    public Integer getNoticeType() {
        return noticeType;
    }

    public void setNoticeType(Integer noticeType) {
        this.noticeType = noticeType;
    }

    public String getSourceProjectId() {
        return sourceProjectId;
    }

    public void setSourceProjectId(String sourceProjectId) {
        this.sourceProjectId = sourceProjectId;
    }

    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }

    public String getSourceOrgId() {
        return sourceOrgId;
    }

    public void setSourceOrgId(String sourceOrgId) {
        this.sourceOrgId = sourceOrgId;
    }

    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    public String getSourceUnitId() {
        return sourceUnitId;
    }

    public void setSourceUnitId(String sourceUnitId) {
        this.sourceUnitId = sourceUnitId;
    }

    public String getUnitName() {
        return unitName;
    }

    public void setUnitName(String unitName) {
        this.unitName = unitName;
    }

    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }

    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getTenderName() {
        return tenderName;
    }

    public void setTenderName(String tenderName) {
        this.tenderName = tenderName;
    }

    public Integer getTenderType() {
        return tenderType;
    }

    public void setTenderType(Integer tenderType) {
        this.tenderType = tenderType;
    }

    public String getPurchaseName() {
        return purchaseName;
    }

    public void setPurchaseName(String purchaseName) {
        this.purchaseName = purchaseName;
    }

    public String getSourceEmployeeId() {
        return sourceEmployeeId;
    }

    public void setSourceEmployeeId(String sourceEmployeeId) {
        this.sourceEmployeeId = sourceEmployeeId;
    }

    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }

    public String getEmployeeMobile() {
        return employeeMobile;
    }

    public void setEmployeeMobile(String employeeMobile) {
        this.employeeMobile = employeeMobile;
    }

    public String getPurchaseType() {
        return purchaseType;
    }

    public void setPurchaseType(String purchaseType) {
        this.purchaseType = purchaseType;
    }

    public String getNoticeStartTime() {
        return noticeStartTime;
    }

    public void setNoticeStartTime(String noticeStartTime) {
        this.noticeStartTime = noticeStartTime;
    }

    public String getNoticeEndTime() {
        return noticeEndTime;
    }

    public void setNoticeEndTime(String noticeEndTime) {
        this.noticeEndTime = noticeEndTime;
    }

    public Integer getValueType() {
        return valueType;
    }

    public void setValueType(Integer valueType) {
        this.valueType = valueType;
    }

    public String getNoticeContent() {
        return noticeContent;
    }

    public void setNoticeContent(String noticeContent) {
        this.noticeContent = noticeContent;
    }

    public List<RentNoticeDetailTbVO> getRentDetailList() {
        return rentDetailList;
    }

    public void setRentDetailList(List<RentNoticeDetailTbVO> rentDetailList) {
        this.rentDetailList = rentDetailList;
    }

    public List<RentNoticeSupplierDetailTbVO> getApplyList() {
        return applyList;
    }

    public void setApplyList(List<RentNoticeSupplierDetailTbVO> applyList) {
        this.applyList = applyList;
    }

}
