package com.ejianc.business.tender.expert.vo;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * 专家评标进度报表VO
 * 
 * @author generator
 * 
 */
public class ProgressSheetVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private Integer billState; // 单据状态
    private Integer state; // 状态（0：启用，1：停用）
    private String billCode; // 单据编码
    private Long unitId; // 单位id
    private String unitName; // 单位名称
    private Long expertId; // 专家id
    private String expertName; // 专家名称
    private String mobile; // 手机号
    private String email; // 邮箱
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date employeeTime; // 编制日期
    private java.math.BigDecimal yearLimit; // 从业年限
    private Long employeeId; // 编制人
    private String employeeName; // 编制人名称
    private Integer sex;//性别（0-男，1-女）
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date birthday; // 出生日期
    private String telephone; // 固定电话
    private String idcard; // 身份证号码
    private Long postId; // 岗位id
    private String postName; // 岗位名称
    private String empno; // 工号
    private Integer interiorExterior; // 内外部(0-内部，1-外部)
    private String fieldId; // 专业领域id
    private String fieldName; // 专业领域name
    private Integer type; // 类型(0-商务，1-技术，2-商务技术)
    private String typeName; // 类型name
    private Long gradeId; // 级别id
    private String gradeName; // 级别name
    private Long oldExpertId; // 老专家id
    private Long deptId; // 部门id
    private String deptName; // 部门名称

    private BigDecimal totalNum; // 评标总量
    private BigDecimal noOverdueNum; // 未超期评标量
    private BigDecimal overdueNum; // 超期评标量
    private BigDecimal tenderRate; // 评标率
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date createTimeC; //排序时间




    private List<ExperienceDetailVO> experienceDetailEntities = new ArrayList<>(); // 专家库工作履历表
    private List<EducationDetailVO> educationDetailEntities = new ArrayList<>(); // 专家库教育经历表
    private List<EvaluationDetailVO> evaluationDetailEntities = new ArrayList<>(); // 专家库评标记录表

    public BigDecimal getTotalNum() {
        return totalNum;
    }

    public void setTotalNum(BigDecimal totalNum) {
        this.totalNum = totalNum;
    }

    public BigDecimal getNoOverdueNum() {
        return noOverdueNum;
    }

    public void setNoOverdueNum(BigDecimal noOverdueNum) {
        this.noOverdueNum = noOverdueNum;
    }

    public BigDecimal getOverdueNum() {
        return overdueNum;
    }

    public void setOverdueNum(BigDecimal overdueNum) {
        this.overdueNum = overdueNum;
    }

    public BigDecimal getTenderRate() {
        return tenderRate;
    }

    public void setTenderRate(BigDecimal tenderRate) {
        this.tenderRate = tenderRate;
    }

    public Date getCreateTimeC() {
        return createTimeC;
    }

    public void setCreateTimeC(Date createTimeC) {
        this.createTimeC = createTimeC;
    }

    public Long getDeptId() {
        return deptId;
    }

    public void setDeptId(Long deptId) {
        this.deptId = deptId;
    }

    public String getDeptName() {
        return deptName;
    }

    public void setDeptName(String deptName) {
        this.deptName = deptName;
    }

    public Long getOldExpertId() {
        return oldExpertId;
    }

    public void setOldExpertId(Long oldExpertId) {
        this.oldExpertId = oldExpertId;
    }

    // 专业领域id
    @ReferSerialTransfer(referCode = "support-defdoc")
    public String getFieldId() {
        return fieldId;
    }
    @ReferDeserialTransfer
    public void setFieldId(String fieldId) {
        this.fieldId = fieldId;
    }
    // 专业领域name
    public String getFieldName() {
        return fieldName;
    }

    public void setFieldName(String fieldName) {
        this.fieldName = fieldName;
    }
    // 类型

    public Integer getType() {
        return type;
    }

    public void setType(Integer type) {
        this.type = type;
    }

    public String getTypeName() {
        return typeName;
    }

    public void setTypeName(String typeName) {
        this.typeName = typeName;
    }

    // 级别id
    @ReferSerialTransfer(referCode = "support-defdoc")
    public Long getGradeId() {
        return gradeId;
    }
    @ReferDeserialTransfer
    public void setGradeId(Long gradeId) {
        this.gradeId = gradeId;
    }
    // 级别name
    public String getGradeName() {
        return gradeName;
    }

    public void setGradeName(String gradeName) {
        this.gradeName = gradeName;
    }

    //性别（0-男，1-女）
    public Integer getSex() {
        return sex;
    }

    public void setSex(Integer sex) {
        this.sex = sex;
    }


    public Date getBirthday() {
        return birthday;
    }

    public void setBirthday(Date birthday) {
        this.birthday = birthday;
    }

    public String getTelephone() {
        return telephone;
    }

    public void setTelephone(String telephone) {
        this.telephone = telephone;
    }

    public String getIdcard() {
        return idcard;
    }

    public void setIdcard(String idcard) {
        this.idcard = idcard;
    }
    @ReferSerialTransfer(referCode = "idm_post")
    public Long getPostId() {
        return postId;
    }
    @ReferDeserialTransfer
    public void setPostId(Long postId) {
        this.postId = postId;
    }

    public String getPostName() {
        return postName;
    }

    public void setPostName(String postName) {
        this.postName = postName;
    }

    public String getEmpno() {
        return empno;
    }

    public void setEmpno(String empno) {
        this.empno = empno;
    }

    public Integer getInteriorExterior() {
        return interiorExterior;
    }

    public void setInteriorExterior(Integer interiorExterior) {
        this.interiorExterior = interiorExterior;
    }

    /**
     * 单据状态
     */
    public Integer getBillState() {
        return billState;
    }

    /**
     * 单据状态
     */
    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    /**
     * 状态（0：启用，1：停用）
     */
    public Integer getState() {
        return state;
    }

    /**
     * 状态（0：启用，1：停用）
     */
    public void setState(Integer state) {
        this.state = state;
    }
    /**
     * 单据编码
     */
    public String getBillCode() {
        return billCode;
    }

    /**
     * 单据编码
     */
    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    /**
     * 单位id
     */
    public Long getUnitId() {
        return unitId;
    }

    /**
     * 单位id
     */
    public void setUnitId(Long unitId) {
        this.unitId = unitId;
    }
    /**
     * 单位名称
     */
    public String getUnitName() {
        return unitName;
    }

    /**
     * 单位名称
     */
    public void setUnitName(String unitName) {
        this.unitName = unitName;
    }
    /**
     * 专家id
     */
    @ReferSerialTransfer(referCode="idm-employee")
    public Long getExpertId() {
        return expertId;
    }

    /**
     * 专家id
     */
    @ReferDeserialTransfer
    public void setExpertId(Long expertId) {
        this.expertId = expertId;
    }
    /**
     * 专家名称
     */
    public String getExpertName() {
        return expertName;
    }

    /**
     * 专家名称
     */
    public void setExpertName(String expertName) {
        this.expertName = expertName;
    }
    /**
     * 手机号
     */
    public String getMobile() {
        return mobile;
    }

    /**
     * 手机号
     */
    public void setMobile(String mobile) {
        this.mobile = mobile;
    }
    /**
     * 邮箱
     */
    public String getEmail() {
        return email;
    }

    /**
     * 邮箱
     */
    public void setEmail(String email) {
        this.email = email;
    }
    /**
     * 编制日期
     */
    public Date getEmployeeTime() {
        return employeeTime;
    }

    /**
     * 编制日期
     */
    public void setEmployeeTime(Date employeeTime) {
        this.employeeTime = employeeTime;
    }
    /**
     * 从业年限
     */
    public java.math.BigDecimal getYearLimit() {
        return yearLimit;
    }

    /**
     * 从业年限
     */
    public void setYearLimit(java.math.BigDecimal yearLimit) {
        this.yearLimit = yearLimit;
    }
    /**
     * 编制人
     */
    public Long getEmployeeId() {
        return employeeId;
    }

    /**
     * 编制人
     */
    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    /**
     * 编制人名称
     */
    public String getEmployeeName() {
        return employeeName;
    }

    /**
     * 编制人名称
     */
    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }

     /**
      * 专家库工作履历表
      */
     public List<ExperienceDetailVO> getExperienceDetailEntities() {
        return experienceDetailEntities;
     }

     /**
      * 专家库工作履历表
      */
     public void setExperienceDetailEntities(List<ExperienceDetailVO> experienceDetailVos) {
        this.experienceDetailEntities = experienceDetailVos;
     }
     /**
      * 专家库教育经历表
      */
     public List<EducationDetailVO> getEducationDetailEntities() {
        return educationDetailEntities;
     }

     /**
      * 专家库教育经历表
      */
     public void setEducationDetailEntities(List<EducationDetailVO> educationDetailVos) {
        this.educationDetailEntities= educationDetailVos;
     }
     /**
      * 专家库评标记录表
      */
     public List<EvaluationDetailVO> getEvaluationDetailEntities() {
        return evaluationDetailEntities;
     }

     /**
      * 专家库评标记录表
      */
     public void setEvaluationDetailEntities(List<EvaluationDetailVO> evaluationDetailVos) {
        this.evaluationDetailEntities = evaluationDetailVos;
     }
}
