package com.ejianc.business.tender.other.vo;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.ArrayList;
import java.util.List;

/**
 * 洽商谈判主表
 * 
 * @author generator
 * 
 */
@ApiModel("洽商谈判主表")
public class OtherTalkVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    @ApiModelProperty("招标立项主键")
    private Long inviteId;
    @ApiModelProperty("来源单据主键")
    private Long billId;
    @ApiModelProperty("单据编号")
    private String billCode;
    @ApiModelProperty("洽商名称")
    private String talkName;
    @ApiModelProperty("项目ID")
    private Long projectId;
    @ApiModelProperty("项目名称")
    private String projectName;
    @ApiModelProperty("组织")
    private Long orgId;
    @ApiModelProperty("组织名称")
    private String orgName;
    @ApiModelProperty("父级组织")
    private Long parentOrgId;
    @ApiModelProperty("父级组织名称")
    private String parentOrgName;
    @ApiModelProperty("项目编号")
    private String projectCode;
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    @ApiModelProperty("洽商开始时间")
    private java.util.Date talkStartTime;
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    @ApiModelProperty("洽商结束时间")
    private java.util.Date talkEndTime;
    @ApiModelProperty("是否允许多品牌报价,0-是,1-否")
    private Integer brandFlag;
    @ApiModelProperty("洽商轮数")
    private Integer talkNum;
    @ApiModelProperty("洽商参考价")
    private java.math.BigDecimal talkMoney;
    @ApiModelProperty("是否发布,0-是,1-否")
    private Integer publishFlag;
    @ApiModelProperty("是否下一步,0-是,1-否")
    private Integer nextFlag;
    @ApiModelProperty("备注")
    private String memo;
    @ApiModelProperty("单据状态（审批必须字段）")
    private Integer billState;
    @ApiModelProperty("洽商轮数名称")
    private String talkNumName;
    @ApiModelProperty("采购方式(0-项目采购,1-单位采购)")
    private Integer purchaseType;
    @ApiModelProperty("洽商谈判子表")
    private List<OtherTalkDetailVO> otherTalkDetailList = new ArrayList<>();
    @ApiModelProperty("招标文件物料详情表")
    private List<OtherDocumentDetailVO> otherDocumentDetailList = new ArrayList<>();
    @ApiModelProperty("招标文件物料详情表(报价详情用)")
    private List<OtherDocumentDetailVO> otherDocumentDetailSellList = new ArrayList<>();
    @ApiModelProperty("招标文件方案表")
    private List<OtherDocumentSchemeVO> otherDocumentSchemeList = new ArrayList<>();
    @ApiModelProperty("招标文件报价表")
    private List<OtherDocumentSellVO> otherDocumentSellList = new ArrayList<>();
    @ApiModelProperty("招标文件供应商标")
    private List<OtherDocumentSupplierVO> otherDocumentSupplierList = new ArrayList<>();
    @ApiModelProperty("招标文件供应商标方案报价表(界面设计器避键值免重复设计)")
    private List<OtherDocumentSupplierVO> otherDocumentSupplierSchemeList = new ArrayList<>();
    @ApiModelProperty("历史记录表")
    private List<OtherTalkRecordVO> talkRecordEntityList = new ArrayList<>();

    public Integer getPurchaseType() {
        return purchaseType;
    }

    public void setPurchaseType(Integer purchaseType) {
        this.purchaseType = purchaseType;
    }

    public String getTalkNumName() {
        return talkNumName;
    }

    public void setTalkNumName(String talkNumName) {
        this.talkNumName = talkNumName;
    }

    public List<OtherTalkRecordVO> getTalkRecordEntityList() {
        return talkRecordEntityList;
    }

    public void setTalkRecordEntityList(List<OtherTalkRecordVO> talkRecordEntityList) {
        this.talkRecordEntityList = talkRecordEntityList;
    }

    public List<OtherDocumentDetailVO> getOtherDocumentDetailList() {
        return otherDocumentDetailList;
    }

    public void setOtherDocumentDetailList(List<OtherDocumentDetailVO> otherDocumentDetailList) {
        this.otherDocumentDetailList = otherDocumentDetailList;
    }


    public List<OtherDocumentSchemeVO> getOtherDocumentSchemeList() {
        return otherDocumentSchemeList;
    }

    public void setOtherDocumentSchemeList(List<OtherDocumentSchemeVO> otherDocumentSchemeList) {
        this.otherDocumentSchemeList = otherDocumentSchemeList;
    }

    public List<OtherDocumentSellVO> getOtherDocumentSellList() {
        return otherDocumentSellList;
    }

    public void setOtherDocumentSellList(List<OtherDocumentSellVO> otherDocumentSellList) {
        this.otherDocumentSellList = otherDocumentSellList;
    }

    public List<OtherDocumentSupplierVO> getOtherDocumentSupplierList() {
        return otherDocumentSupplierList;
    }

    public void setOtherDocumentSupplierList(List<OtherDocumentSupplierVO> otherDocumentSupplierList) {
        this.otherDocumentSupplierList = otherDocumentSupplierList;
    }

    public List<OtherDocumentSupplierVO> getOtherDocumentSupplierSchemeList() {
        return otherDocumentSupplierSchemeList;
    }

    public void setOtherDocumentSupplierSchemeList(List<OtherDocumentSupplierVO> otherDocumentSupplierSchemeList) {
        this.otherDocumentSupplierSchemeList = otherDocumentSupplierSchemeList;
    }

    public List<OtherDocumentDetailVO> getOtherDocumentDetailSellList() {
        return otherDocumentDetailSellList;
    }

    public void setOtherDocumentDetailSellList(List<OtherDocumentDetailVO> otherDocumentDetailSellList) {
        this.otherDocumentDetailSellList = otherDocumentDetailSellList;
    }

    /**
     * 招标立项主键
     */
    public Long getInviteId() {
        return inviteId;
    }

    /**
     * 招标立项主键
     */
    public void setInviteId(Long inviteId) {
        this.inviteId = inviteId;
    }
    /**
     * 来源单据主键
     */
    public Long getBillId() {
        return billId;
    }

    /**
     * 来源单据主键
     */
    public void setBillId(Long billId) {
        this.billId = billId;
    }
    /**
     * 单据编号
     */
    public String getBillCode() {
        return billCode;
    }

    /**
     * 单据编号
     */
    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    /**
     * 洽商名称
     */
    public String getTalkName() {
        return talkName;
    }

    /**
     * 洽商名称
     */
    public void setTalkName(String talkName) {
        this.talkName = talkName;
    }
    /**
     * 项目ID
     */
    @ReferSerialTransfer(referCode = "project-set")
    public Long getProjectId() {
        return projectId;
    }

    /**
     * 项目ID
     */
    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    /**
     * 项目名称
     */
    public String getProjectName() {
        return projectName;
    }

    /**
     * 项目名称
     */
    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    /**
     * 组织
     */
    @ReferSerialTransfer(referCode = "idm-org")
    public Long getOrgId() {
        return orgId;
    }

    /**
     * 组织
     */
    @ReferDeserialTransfer
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    /**
     * 组织名称
     */
    public String getOrgName() {
        return orgName;
    }

    /**
     * 组织名称
     */
    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    /**
     * 父级组织
     */
    public Long getParentOrgId() {
        return parentOrgId;
    }

    /**
     * 父级组织
     */
    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    /**
     * 父级组织名称
     */
    public String getParentOrgName() {
        return parentOrgName;
    }

    /**
     * 父级组织名称
     */
    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    /**
     * 项目编号
     */
    public String getProjectCode() {
        return projectCode;
    }

    /**
     * 项目编号
     */
    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }
    /**
     * 洽商开始时间
     */
    public java.util.Date getTalkStartTime() {
        return talkStartTime;
    }

    /**
     * 洽商开始时间
     */
    public void setTalkStartTime(java.util.Date talkStartTime) {
        this.talkStartTime = talkStartTime;
    }
    /**
     * 洽商结束时间
     */
    public java.util.Date getTalkEndTime() {
        return talkEndTime;
    }

    /**
     * 洽商结束时间
     */
    public void setTalkEndTime(java.util.Date talkEndTime) {
        this.talkEndTime = talkEndTime;
    }
    /**
     * 是否允许多品牌报价,0-是,1-否
     */
    public Integer getBrandFlag() {
        return brandFlag;
    }

    /**
     * 是否允许多品牌报价,0-是,1-否
     */
    public void setBrandFlag(Integer brandFlag) {
        this.brandFlag = brandFlag;
    }
    /**
     * 洽商轮数
     */
    public Integer getTalkNum() {
        return talkNum;
    }

    /**
     * 洽商轮数
     */
    public void setTalkNum(Integer talkNum) {
        this.talkNum = talkNum;
    }
    /**
     * 洽商参考价
     */
    public java.math.BigDecimal getTalkMoney() {
        return talkMoney;
    }

    /**
     * 洽商参考价
     */
    public void setTalkMoney(java.math.BigDecimal talkMoney) {
        this.talkMoney = talkMoney;
    }
    /**
     * 是否发布,0-是,1-否
     */
    public Integer getPublishFlag() {
        return publishFlag;
    }

    /**
     * 是否发布,0-是,1-否
     */
    public void setPublishFlag(Integer publishFlag) {
        this.publishFlag = publishFlag;
    }
    /**
     * 是否下一步,0-是,1-否
     */
    public Integer getNextFlag() {
        return nextFlag;
    }

    /**
     * 是否下一步,0-是,1-否
     */
    public void setNextFlag(Integer nextFlag) {
        this.nextFlag = nextFlag;
    }
    /**
     * 备注
     */
    public String getMemo() {
        return memo;
    }

    /**
     * 备注
     */
    public void setMemo(String memo) {
        this.memo = memo;
    }
    /**
     * 单据状态（审批必须字段）
     */
    public Integer getBillState() {
        return billState;
    }

    /**
     * 单据状态（审批必须字段）
     */
    public void setBillState(Integer billState) {
        this.billState = billState;
    }

    public List<OtherTalkDetailVO> getOtherTalkDetailList() {
        return otherTalkDetailList;
    }

    public void setOtherTalkDetailList(List<OtherTalkDetailVO> otherTalkDetailList) {
        this.otherTalkDetailList = otherTalkDetailList;
    }
}
