package com.ejianc.business.tender.pricelib;

import com.ejianc.framework.skeleton.template.BaseVO;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.aspectj.weaver.ast.Var;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;


/**
 * 价格库-历史价明细
 * 
 * @author generator
 * 
 */
@ApiModel("价格库-历史价明细")
public class MaterialPriceHistoryApiVO {
    private static final long serialVersionUID = 1L;
    /*
     * 明细预警用字段*/
    @ApiModelProperty("主键（与物资主键一样）")
    private Long id;
    @ApiModelProperty("物资id")
    private Long materialId;
    @ApiModelProperty("物资编码")
    private String materialCode;
    @ApiModelProperty("物资名称")
    private String materialName;
    @ApiModelProperty("物资分类Id")
    private Long materialTypeId;
    @ApiModelProperty("物资分类名称")
    private String materialTypeName;
    @ApiModelProperty("分类内码")
    private String innerCode;
    @ApiModelProperty("规则/型号")
    private String spec;
    @ApiModelProperty("计量单位主键")
    private Long unitId;
    @ApiModelProperty("计量单位")
    private String unitName;

    private String historyPriceArea;//历史价格区间（无税）
    private String historyTaxPriceArea;//历史价格区间（含税）
    private String guidePriceArea; // 公司指导价区间（无税）
    private String guideTaxPriceArea; // 公司指导价区间（含税）
    @ApiModelProperty("单价（无税）")
    private BigDecimal price;
    @ApiModelProperty("单价（含税）")
    private BigDecimal taxPrice;
    /*
    * 表头预警用字段*/
    @ApiModelProperty("预警单据类型")
    private Integer priceCheckType;
    private Long orgId;

    public String getGuidePriceArea() {
        return guidePriceArea;
    }

    public void setGuidePriceArea(String guidePriceArea) {
        this.guidePriceArea = guidePriceArea;
    }

    public String getGuideTaxPriceArea() {
        return guideTaxPriceArea;
    }

    public void setGuideTaxPriceArea(String guideTaxPriceArea) {
        this.guideTaxPriceArea = guideTaxPriceArea;
    }
    /*
     * 预警明细列表*/
    List<MaterialPriceHistoryApiVO>  materialPriceHistoryApiVOList = new ArrayList<MaterialPriceHistoryApiVO>();

    public List<MaterialPriceHistoryApiVO> getMaterialPriceHistoryApiVOList() {
        return materialPriceHistoryApiVOList;
    }

    public void setMaterialPriceHistoryApiVOList(List<MaterialPriceHistoryApiVO> materialPriceHistoryApiVOList) {
        this.materialPriceHistoryApiVOList = materialPriceHistoryApiVOList;
    }

    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    public Integer getPriceCheckType() {
        return priceCheckType;
    }

    public void setPriceCheckType(Integer priceCheckType) {
        this.priceCheckType = priceCheckType;
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public BigDecimal getPrice() {
        return price;
    }

    public void setPrice(BigDecimal price) {
        this.price = price;
    }

    public BigDecimal getTaxPrice() {
        return taxPrice;
    }

    public void setTaxPrice(BigDecimal taxPrice) {
        this.taxPrice = taxPrice;
    }

    public String getHistoryPriceArea() {
        return historyPriceArea;
    }

    public void setHistoryPriceArea(String historyPriceArea) {
        this.historyPriceArea = historyPriceArea;
    }

    public String getHistoryTaxPriceArea() {
        return historyTaxPriceArea;
    }

    public void setHistoryTaxPriceArea(String historyTaxPriceArea) {
        this.historyTaxPriceArea = historyTaxPriceArea;
    }

    /**
     * 物料Id
     */
    public Long getMaterialId() {
        return materialId;
    }

    /**
     * 物料Id
     */
    public void setMaterialId(Long materialId) {
        this.materialId = materialId;
    }
    /**
     * 物资编码
     */
    public String getMaterialCode() {
        return materialCode;
    }

    /**
     * 物资编码
     */
    public void setMaterialCode(String materialCode) {
        this.materialCode = materialCode;
    }
    /**
     * 物资名称
     */
    public String getMaterialName() {
        return materialName;
    }

    /**
     * 物资名称
     */
    public void setMaterialName(String materialName) {
        this.materialName = materialName;
    }
    /**
     * 物资分类Id
     */
    public Long getMaterialTypeId() {
        return materialTypeId;
    }

    /**
     * 物资分类Id
     */
    public void setMaterialTypeId(Long materialTypeId) {
        this.materialTypeId = materialTypeId;
    }
    /**
     * 物资分类名称
     */
    public String getMaterialTypeName() {
        return materialTypeName;
    }

    /**
     * 物资分类名称
     */
    public void setMaterialTypeName(String materialTypeName) {
        this.materialTypeName = materialTypeName;
    }
    /**
     * 分类内码
     */
    public String getInnerCode() {
        return innerCode;
    }

    /**
     * 分类内码
     */
    public void setInnerCode(String innerCode) {
        this.innerCode = innerCode;
    }
    /**
     * 规则/型号
     */
    public String getSpec() {
        return spec;
    }

    /**
     * 规则/型号
     */
    public void setSpec(String spec) {
        this.spec = spec;
    }
    /**
     * 计量单位主键
     */
    public Long getUnitId() {
        return unitId;
    }

    /**
     * 计量单位主键
     */
    public void setUnitId(Long unitId) {
        this.unitId = unitId;
    }
    /**
     * 计量单位
     */
    public String getUnitName() {
        return unitName;
    }

    /**
     * 计量单位
     */
    public void setUnitName(String unitName) {
        this.unitName = unitName;
    }

}
