package com.ejianc.business.tender.sub.vo;

import com.baomidou.mybatisplus.annotation.TableField;
import com.ejianc.business.pro.supplier.vo.InviteVO;
import com.ejianc.business.tender.other.vo.OtherInviteVO;
import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * 材料立项主表
 *
 * @author generator
 *
 */
public class SubInviteVO extends BaseVO {
    private static final long serialVersionUID = 1L;

    private String billCode; // 单据编号
    private Long projectId; // 项目ID
    private String projectName; // 项目名称
    private Long employeeId; // 编制人
    private String employeeName; // 编制人名称
    private Long unitId; // 招标单位ID
    private String unitName; // 招标单位名称
    private String memo; // 备注
    private Integer establishType; // 立项类型(0-招标立项，1-定标立项)
    private Integer billState; // 单据状态（审批必须字段）
    private String tenderName; // 招标名称
    private Integer tenderType; // 招标方式(0-平台公开招标,1-邀请招标,2-询价,3-竞争性谈判,4-单一来源,5-紧急招标,6-洽商谈判)
    private Integer tenderStage; // 招标阶段(0-定标立项,1-招标立项,2-招标公告,3-招标文件,4-专家评标,5-已完成,6-竞争性谈判文件,7-洽商谈判,8-单一来源文件,9-紧急文件,10-询价公告,11-流标，12-费标)
    private String tenderUnitNum; // 中标单位及数量
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date createDate; // 编制日期
    private Integer valueType; // 计价方式(0-可调单价,1-固定总价,2-成本加酬金)
    private String projectCode; // 项目编号
    private BigDecimal tenderMoney; // 计价方式(0-固定单价,1-浮动单价,2-固定总额)
    private Long orgId; // 组织
    private String orgName; // 组织名称
    private Long parentOrgId; // 父级组织
    private String parentOrgName; // 父级组织名称
    private Integer purchaseType; // 采购方式(0-项目采购,1-单位采购)
    private Integer abolishType; // 流/废标（0-正常，1-流标，2-废标）
    private Long subType; // 分包类型（0-专业分包，1-劳务分包）
    private String projectQualification; // 工程资质
    private BigDecimal payScale; // 付款比例
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date entryTime; // 进场时间
    private String tenderTypeName; //
    private String establishTypeName; //
    private String purchaseTypeName; //
    private String tenderStageName; //
    private String billStateName; //
    private String paymentId; // 付款方式
    private String paymentName; // 付款方式
    private Long projectQualificationId; // 工程资质id
    private String purchaseId; // 采购方式ID
    private String purchaseName; // 采购方式名称
    private BigDecimal score; // 专家评分
    private Long supplierId; // 付款方式
    private String supplierName; // 付款方式
    private String subTypeName; // 分包类型（0-专业分包，1-劳务分包）
    private java.lang.Integer tenderPlatform; // 招标平台(1-招采平台，2-云上营家)
    private Integer tenderState; // 招标状态:1-报名中,2-报价中,3-专家评标中,4-专家评标结束
    private String tenderStateName; // 招标状态:1-报名中,2-报价中,3-专家评标中,4-专家评标结束
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private java.util.Date stopTime; // 报名或报价截止时间


    @TableField(value="money")
    private java.math.BigDecimal money; // 定标金额(无税)
    @TableField(value="tax_money")
    private java.math.BigDecimal taxMoney; // 定标金额(含税)
    @TableField(value="sign_status")
    private Integer signStatus; //签订状态:0-未签订,1-部分签订,2-全部已签,3-已关闭
    private String signStatusName; //签订状态:0-未签订,1-部分签订,2-全部已签,3-已关闭
    private Integer occupyState; //占用状态:0-未占用,1-已占用
    @TableField(value="draft_type")
    private Integer draftType; //招标文件生成方式  线上起草-1、手动上传-2
    @TableField(value="contract_file_path")
    private String contractFilePath; // 合同附件路径
    @TableField(value="contract_file_id")
    private Long contractFileId; // 合同附件Id
    @TableField(value="contract_template_id")
    private Long contractTemplateId; // 合同模板Id
    @TableField(value="contract_template_name")
    private String contractTemplateName; // 合同模板名称
    @TableField(value="contract_category_id")
    private Long contractCategoryId; // 招标文件模版(分类)Id--实际存储的是供货内容id
    @TableField(value="contract_category_name")
    private String contractCategoryName; // 招标文件模版(分类)名称--实际存储的是供货内容name
    @TableField(value="contract_file_highlight_path")
    private String contractFileHighlightPath; // 合同高亮附件路径
    @TableField(value="contract_file_highlight_id")
    private Long contractFileHighlightId; // 合同高亮附件Id
    /**
     * 线上起草合同，审批中修改的合同是否已重新进行合同编辑
     */
    @TableField(value = "contract_file_sync_flag")
    private Boolean contractFileSyncFlag = true;
    private Boolean contractTemplateFileSyncFlag = true;

    private String supplierTenderName; // 报价供应商名称-导出用
    @TableField(value="source_tender_id")
    private Long sourceTenderId; //流标/废标来源单据id
    @TableField(value="source_tender_code")
    private String sourceTenderCode; //流标/废标来源单据code
    @TableField(value="retender_flag")
    private Integer retenderFlag;//是否重新发起招标立项 0-否, 1-是

    private Long contractCategoryTypeId; // 合同类别Id
    private String contractCategoryTypeName; // 合同类别名称
    private Long templateId; // 专家评标模板Id
    private String templateName; // 专家评标模板名称

    private Boolean reviewFlag; // 是否开启初步评审 模板类型=分包、设备租赁时，默认开启，非这两种类型意外其他类型默认关
    private Integer tecScore; // 技术得分 默认为0
    private Integer bidEvaluateType; // 评标类型 枚举值为 1【综合评标法】/ 2【经评审的最低价法】
    private Long contractTemplateFileId; // 合同模板附件Id
    private Long inviteMergeFileId; // 合并附件Id（线上起草后，附件与模板合并后的附件id）


    private Boolean repetitionFlag; // 是否允许二次报价，默认开启，非这两种类型意外其他类型默认关


    private String employeeCode; // 编制人编码
    private String i8UnitCode; // i8招标单位编码
    private String i8SocialCreditCode; // i8招标单位统一社会信用代码
    private String i8BillCode; // i8单据编码
    private String sourceType; // 来源类型
    private String sourceId; // 来源id
    private String i8Url; // i8数据地址
    private String pushI8UpdateMsg; // 推送i8响应信息
    private Integer pushI8Flag; // 0否 1是

    private String subReason; // 分包理由及说明
    private String settleClause; // 结算条款
    private String payClause; // 付款条款

    private Integer subTypeCode; // 0-专业分包，1-劳务分包，2-机械承揽
    private java.lang.Long supplierProjectManagerId; // 分包负责人
    private java.lang.String supplierProjectManagerName; // 分包负责人名称
    private java.lang.String supplierProjectManagerLink; // 分包负责人电话
    private java.lang.String supplierProjectManagerIcard; // 分包负责人身份证号
    private java.lang.Long supplierProjectManagerTenantId; // 分包负责人所属租户主键


    private Integer i8CloudFlag; // 0否 1是
    private Boolean businessBidFlag; // 是否开启三步走流程 默认 是
    private String sourceELTenderCode; // el招标立项单据编码（i8传值使用）
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date planTenderTime; // 计划招标时间

    public Date getPlanTenderTime() {
        return planTenderTime;
    }

    public void setPlanTenderTime(Date planTenderTime) {
        this.planTenderTime = planTenderTime;
    }

    public String getSourceELTenderCode() {
        return sourceELTenderCode;
    }

    public void setSourceELTenderCode(String sourceELTenderCode) {
        this.sourceELTenderCode = sourceELTenderCode;
    }

    public Boolean getBusinessBidFlag() {
        return businessBidFlag;
    }

    public void setBusinessBidFlag(Boolean businessBidFlag) {
        this.businessBidFlag = businessBidFlag;
    }
    public Integer getI8CloudFlag() {
        return i8CloudFlag;
    }

    public void setI8CloudFlag(Integer i8CloudFlag) {
        this.i8CloudFlag = i8CloudFlag;
    }

    public String getSupplierProjectManagerIcard() {
        return supplierProjectManagerIcard;
    }

    public void setSupplierProjectManagerIcard(String supplierProjectManagerIcard) {
        this.supplierProjectManagerIcard = supplierProjectManagerIcard;
    }

    public Long getSupplierProjectManagerTenantId() {
        return supplierProjectManagerTenantId;
    }

    public void setSupplierProjectManagerTenantId(Long supplierProjectManagerTenantId) {
        this.supplierProjectManagerTenantId = supplierProjectManagerTenantId;
    }
    @ReferSerialTransfer(referCode = "share-supplier-sub-leader")
    public Long getSupplierProjectManagerId() {
        return supplierProjectManagerId;
    }
    @ReferDeserialTransfer
    public void setSupplierProjectManagerId(Long supplierProjectManagerId) {
        this.supplierProjectManagerId = supplierProjectManagerId;
    }

    public String getSupplierProjectManagerName() {
        return supplierProjectManagerName;
    }

    public void setSupplierProjectManagerName(String supplierProjectManagerName) {
        this.supplierProjectManagerName = supplierProjectManagerName;
    }

    public String getSupplierProjectManagerLink() {
        return supplierProjectManagerLink;
    }

    public void setSupplierProjectManagerLink(String supplierProjectManagerLink) {
        this.supplierProjectManagerLink = supplierProjectManagerLink;
    }
    public String getSubReason() {
        return subReason;
    }

    public void setSubReason(String subReason) {
        this.subReason = subReason;
    }

    public String getSettleClause() {
        return settleClause;
    }

    public void setSettleClause(String settleClause) {
        this.settleClause = settleClause;
    }

    public String getPayClause() {
        return payClause;
    }

    public void setPayClause(String payClause) {
        this.payClause = payClause;
    }

    public Integer getSubTypeCode() {
        return subTypeCode;
    }

    public void setSubTypeCode(Integer subTypeCode) {
        this.subTypeCode = subTypeCode;
    }

    public String getEmployeeCode() {
        return employeeCode;
    }

    public void setEmployeeCode(String employeeCode) {
        this.employeeCode = employeeCode;
    }

    public String getI8UnitCode() {
        return i8UnitCode;
    }

    public void setI8UnitCode(String i8UnitCode) {
        this.i8UnitCode = i8UnitCode;
    }

    public String getI8SocialCreditCode() {
        return i8SocialCreditCode;
    }

    public void setI8SocialCreditCode(String i8SocialCreditCode) {
        this.i8SocialCreditCode = i8SocialCreditCode;
    }

    public String getI8BillCode() {
        return i8BillCode;
    }

    public void setI8BillCode(String i8BillCode) {
        this.i8BillCode = i8BillCode;
    }

    public String getSourceType() {
        return sourceType;
    }

    public void setSourceType(String sourceType) {
        this.sourceType = sourceType;
    }

    public String getSourceId() {
        return sourceId;
    }

    public void setSourceId(String sourceId) {
        this.sourceId = sourceId;
    }

    public String getI8Url() {
        return i8Url;
    }

    public void setI8Url(String i8Url) {
        this.i8Url = i8Url;
    }

    public String getPushI8UpdateMsg() {
        return pushI8UpdateMsg;
    }

    public void setPushI8UpdateMsg(String pushI8UpdateMsg) {
        this.pushI8UpdateMsg = pushI8UpdateMsg;
    }

    public Integer getPushI8Flag() {
        return pushI8Flag;
    }

    public void setPushI8Flag(Integer pushI8Flag) {
        this.pushI8Flag = pushI8Flag;
    }

    public Boolean getRepetitionFlag() {
        return repetitionFlag;
    }

    public void setRepetitionFlag(Boolean repetitionFlag) {
        this.repetitionFlag = repetitionFlag;
    }

    public Long getContractTemplateFileId() {
        return contractTemplateFileId;
    }

    public void setContractTemplateFileId(Long contractTemplateFileId) {
        this.contractTemplateFileId = contractTemplateFileId;
    }

    public Long getInviteMergeFileId() {
        return inviteMergeFileId;
    }

    public void setInviteMergeFileId(Long inviteMergeFileId) {
        this.inviteMergeFileId = inviteMergeFileId;
    }


    public Long getContractCategoryTypeId() {
        return contractCategoryTypeId;
    }

    @ReferDeserialTransfer
    public void setContractCategoryTypeId(Long contractCategoryTypeId) {
        this.contractCategoryTypeId = contractCategoryTypeId;
    }

    public String getContractCategoryTypeName() {
        return contractCategoryTypeName;
    }

    public void setContractCategoryTypeName(String contractCategoryTypeName) {
        this.contractCategoryTypeName = contractCategoryTypeName;
    }

    @ReferSerialTransfer(referCode="evaluation_template")
    public Long getTemplateId() {
        return templateId;
    }

    @ReferDeserialTransfer
    public void setTemplateId(Long templateId) {
        this.templateId = templateId;
    }

    public String getTemplateName() {
        return templateName;
    }

    public void setTemplateName(String templateName) {
        this.templateName = templateName;
    }

    public Boolean getReviewFlag() {
        return reviewFlag;
    }

    public void setReviewFlag(Boolean reviewFlag) {
        this.reviewFlag = reviewFlag;
    }

    public Integer getTecScore() {
        return tecScore;
    }

    public void setTecScore(Integer tecScore) {
        this.tecScore = tecScore;
    }

    public Integer getBidEvaluateType() {
        return bidEvaluateType;
    }

    public void setBidEvaluateType(Integer bidEvaluateType) {
        this.bidEvaluateType = bidEvaluateType;
    }

    public Integer getRetenderFlag() {
        return retenderFlag;
    }

    public void setRetenderFlag(Integer retenderFlag) {
        this.retenderFlag = retenderFlag;
    }
    List<SubInviteVO> lastInviteList = new ArrayList<>();

    public List<SubInviteVO> getLastInviteList() {
        return lastInviteList;
    }

    public void setLastInviteList(List<SubInviteVO> lastInviteList) {
        this.lastInviteList = lastInviteList;
    }

    public Long getSourceTenderId() {
        return sourceTenderId;
    }

    public void setSourceTenderId(Long sourceTenderId) {
        this.sourceTenderId = sourceTenderId;
    }

    public String getSourceTenderCode() {
        return sourceTenderCode;
    }

    public void setSourceTenderCode(String sourceTenderCode) {
        this.sourceTenderCode = sourceTenderCode;
    }
    public String getSupplierTenderName() {
        return supplierTenderName;
    }

    public void setSupplierTenderName(String supplierTenderName) {
        this.supplierTenderName = supplierTenderName;
    }

    public Integer getDraftType() {
        return draftType;
    }

    public void setDraftType(Integer draftType) {
        this.draftType = draftType;
    }

    public String getContractFilePath() {
        return contractFilePath;
    }

    public void setContractFilePath(String contractFilePath) {
        this.contractFilePath = contractFilePath;
    }

    public Long getContractFileId() {
        return contractFileId;
    }

    public void setContractFileId(Long contractFileId) {
        this.contractFileId = contractFileId;
    }

    public Long getContractTemplateId() {
        return contractTemplateId;
    }

    public void setContractTemplateId(Long contractTemplateId) {
        this.contractTemplateId = contractTemplateId;
    }

    public String getContractTemplateName() {
        return contractTemplateName;
    }

    public void setContractTemplateName(String contractTemplateName) {
        this.contractTemplateName = contractTemplateName;
    }

    public Long getContractCategoryId() {
        return contractCategoryId;
    }

    public void setContractCategoryId(Long contractCategoryId) {
        this.contractCategoryId = contractCategoryId;
    }

    public String getContractCategoryName() {
        return contractCategoryName;
    }

    public void setContractCategoryName(String contractCategoryName) {
        this.contractCategoryName = contractCategoryName;
    }

    public String getContractFileHighlightPath() {
        return contractFileHighlightPath;
    }

    public void setContractFileHighlightPath(String contractFileHighlightPath) {
        this.contractFileHighlightPath = contractFileHighlightPath;
    }

    public Long getContractFileHighlightId() {
        return contractFileHighlightId;
    }

    public void setContractFileHighlightId(Long contractFileHighlightId) {
        this.contractFileHighlightId = contractFileHighlightId;
    }

    public Boolean getContractFileSyncFlag() {
        return contractFileSyncFlag;
    }

    public void setContractFileSyncFlag(Boolean contractFileSyncFlag) {
        this.contractFileSyncFlag = contractFileSyncFlag;
    }

    public Boolean getContractTemplateFileSyncFlag() {
        return contractTemplateFileSyncFlag;
    }

    public void setContractTemplateFileSyncFlag(Boolean contractTemplateFileSyncFlag) {
        this.contractTemplateFileSyncFlag = contractTemplateFileSyncFlag;
    }

    public Integer getOccupyState() {
        return occupyState;
    }

    public void setOccupyState(Integer occupyState) {
        this.occupyState = occupyState;
    }

    public String getSignStatusName() {
        return signStatusName;
    }

    public void setSignStatusName(String signStatusName) {
        this.signStatusName = signStatusName;
    }

    public Integer getSignStatus() {
        return signStatus;
    }

    public void setSignStatus(Integer signStatus) {
        this.signStatus = signStatus;
    }
    public BigDecimal getMoney() {
        return money;
    }

    public void setMoney(BigDecimal money) {
        this.money = money;
    }

    public BigDecimal getTaxMoney() {
        return taxMoney;
    }

    public void setTaxMoney(BigDecimal taxMoney) {
        this.taxMoney = taxMoney;
    }



    private List<SubInviteDetailVO> subDetail = new ArrayList<>(); // 材料招标立项采购清单表
    private List<SubInviteSupplierVO> supplierDetail = new ArrayList<>(); // 材料招标立项供应商表
    private List<SubInviteDetailRecordVO> subDetailRecord = new ArrayList<>(); // 材料招标立项采购清单表不合并
//    private List<SubInviteExpertVO> expertDetail = new ArrayList<>(); // 材料招标立项专家表
    private List<SubInviteDetailBidderVO> subDetailBidder = new ArrayList<>(); // 材料定标立项定标情况表
    private List<SubInviteClauseVO> clauseList = new ArrayList<>(); // 合同条款
    private List<SubInviteTemplateDetailVO> templateDetailList = new ArrayList<>(); // 分包模板子表

    public List<SubInviteClauseVO> getClauseList() {
        return clauseList;
    }

    public void setClauseList(List<SubInviteClauseVO> clauseList) {
        this.clauseList = clauseList;
    }

    public List<SubInviteTemplateDetailVO> getTemplateDetailList() {
        return templateDetailList;
    }

    public void setTemplateDetailList(List<SubInviteTemplateDetailVO> templateDetailList) {
        this.templateDetailList = templateDetailList;
    }

    public Integer getTenderPlatform() {
        return tenderPlatform;
    }

    public void setTenderPlatform(Integer tenderPlatform) {
        this.tenderPlatform = tenderPlatform;
    }

    public Long getProjectQualificationId() {
        return projectQualificationId;
    }
    @ReferDeserialTransfer
    public void setProjectQualificationId(Long projectQualificationId) {
        this.projectQualificationId = projectQualificationId;
    }

    public String getSubTypeName() {
        return subTypeName;
    }

    public void setSubTypeName(String subTypeName) {
        this.subTypeName = subTypeName;
    }

    public BigDecimal getScore() {
        return score;
    }

    public void setScore(BigDecimal score) {
        this.score = score;
    }

    public String getPurchaseId() {
        return purchaseId;
    }

    public void setPurchaseId(String purchaseId) {
        this.purchaseId = purchaseId;
    }

    public String getPurchaseName() {
        return purchaseName;
    }

    public void setPurchaseName(String purchaseName) {
        this.purchaseName = purchaseName;
    }

    public String getBillStateName() {
        return billStateName;
    }

    public void setBillStateName(String billStateName) {
        this.billStateName = billStateName;
    }

    public String getTenderStageName() {
        return tenderStageName;
    }

    public void setTenderStageName(String tenderStageName) {
        this.tenderStageName = tenderStageName;
    }

    public String getPurchaseTypeName() {
        return purchaseTypeName;
    }

    public void setPurchaseTypeName(String purchaseTypeName) {
        this.purchaseTypeName = purchaseTypeName;
    }

    public String getEstablishTypeName() {
        return establishTypeName;
    }

    public void setEstablishTypeName(String establishTypeName) {
        this.establishTypeName = establishTypeName;
    }

    public String getTenderTypeName() {
        return tenderTypeName;
    }

    public void setTenderTypeName(String tenderTypeName) {
        this.tenderTypeName = tenderTypeName;
    }

    /**
     * 流/废标状态
     */
    public Integer getAbolishType() {
        return abolishType;
    }

    public void setAbolishType(Integer abolishType) {
        this.abolishType = abolishType;
    }

    /**
     * 单据编号
     */
    public String getBillCode() {
        return billCode;
    }

    /**
     * 单据编号
     */
    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    /**
     * 项目ID
     */
    @ReferSerialTransfer(referCode = "project-set")
    public Long getProjectId() {
        return projectId;
    }

    /**
     * 项目ID
     */
    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    /**
     * 项目名称
     */
    public String getProjectName() {
        return projectName;
    }

    /**
     * 项目名称
     */
    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    /**
     * 编制人
     */
    public Long getEmployeeId() {
        return employeeId;
    }

    /**
     * 编制人
     */
    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    /**
     * 编制人名称
     */
    public String getEmployeeName() {
        return employeeName;
    }

    /**
     * 编制人名称
     */
    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    /**
     * 招标单位ID
     */
    @ReferSerialTransfer(referCode="idm-org")
    public Long getUnitId() {
        return unitId;
    }

    /**
     * 招标单位ID
     */
    @ReferDeserialTransfer
    public void setUnitId(Long unitId) {
        this.unitId = unitId;
    }
    /**
     * 招标单位名称
     */
    public String getUnitName() {
        return unitName;
    }

    /**
     * 招标单位名称
     */
    public void setUnitName(String unitName) {
        this.unitName = unitName;
    }
    /**
     * 备注
     */
    public String getMemo() {
        return memo;
    }

    /**
     * 备注
     */
    public void setMemo(String memo) {
        this.memo = memo;
    }
    /**
     * 单据状态（审批必须字段）
     */
    public Integer getBillState() {
        return billState;
    }

    /**
     * 单据状态（审批必须字段）
     */
    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    /**
     * 招标名称
     */
    public String getTenderName() {
        return tenderName;
    }

    /**
     * 招标名称
     */
    public void setTenderName(String tenderName) {
        this.tenderName = tenderName;
    }
    /**
     * 招标方式(0-平台公开招标,1-邀请招标,2-询价,3-竞争性谈判,4-单一来源,5-紧急招标)
     */
    public Integer getTenderType() {
        return tenderType;
    }

    /**
     * 招标方式(0-平台公开招标,1-邀请招标,2-询价,3-竞争性谈判,4-单一来源,5-紧急招标)
     */
    public void setTenderType(Integer tenderType) {
        this.tenderType = tenderType;
    }
    /**
     * 招标阶段
     */
    public Integer getTenderStage() {
        return tenderStage;
    }

    /**
     * 招标阶段
     */
    public void setTenderStage(Integer tenderStage) {
        this.tenderStage = tenderStage;
    }
    /**
     * 中标单位及数量
     */
    public String getTenderUnitNum() {
        return tenderUnitNum;
    }

    /**
     * 中标单位及数量
     */
    public void setTenderUnitNum(String tenderUnitNum) {
        this.tenderUnitNum = tenderUnitNum;
    }
    /**
     * 编制日期
     */
    public java.util.Date getCreateDate() {
        return createDate;
    }

    /**
     * 编制日期
     */
    public void setCreateDate(java.util.Date createDate) {
        this.createDate = createDate;
    }
    /**
     * 计价方式(0-固定单价,1-浮动单价,2-固定总额)
     */
    public Integer getValueType() {
        return valueType;
    }

    /**
     * 计价方式(0-固定单价,1-浮动单价,2-固定总额)
     */
    public void setValueType(Integer valueType) {
        this.valueType = valueType;
    }
    /**
     * 项目编号
     */
    public String getProjectCode() {
        return projectCode;
    }

    /**
     * 项目编号
     */
    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }
    /**
     * 招标金额
     */
    public java.math.BigDecimal getTenderMoney() {
        return tenderMoney;
    }

    /**
     * 招标金额
     */
    public void setTenderMoney(java.math.BigDecimal tenderMoney) {
        this.tenderMoney = tenderMoney;
    }
    /**
     * 组织
     */
    @ReferSerialTransfer(referCode="idm-org")
    public Long getOrgId() {
        return orgId;
    }

    /**
     * 组织
     */
    @ReferDeserialTransfer
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    /**
     * 组织名称
     */
    public String getOrgName() {
        return orgName;
    }

    /**
     * 组织名称
     */
    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    /**
     * 父级组织
     */
    public Long getParentOrgId() {
        return parentOrgId;
    }

    /**
     * 父级组织
     */
    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    /**
     * 父级组织名称
     */
    public String getParentOrgName() {
        return parentOrgName;
    }

    /**
     * 父级组织名称
     */
    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    /**
     * 立项类型(0-招标立项，1-定标立项)
     */
    public Integer getEstablishType() {
        return establishType;
    }

    /**
     * 立项类型(0-招标立项，1-定标立项)
     */
    public void setEstablishType(Integer establishType) {
        this.establishType = establishType;
    }

    public List<SubInviteDetailVO> getSubDetail() {
        return subDetail;
    }

    public void setSubDetail(List<SubInviteDetailVO> subDetail) {
        this.subDetail = subDetail;
    }

    public List<SubInviteDetailRecordVO> getSubDetailRecord() {
        return subDetailRecord;
    }

    public void setSubDetailRecord(List<SubInviteDetailRecordVO> subDetailRecord) {
        this.subDetailRecord = subDetailRecord;
    }

    public List<SubInviteDetailBidderVO> getSubDetailBidder() {
        return subDetailBidder;
    }

    public void setSubDetailBidder(List<SubInviteDetailBidderVO> subDetailBidder) {
        this.subDetailBidder = subDetailBidder;
    }

    public List<SubInviteSupplierVO> getSupplierDetail() {
        return supplierDetail;
    }

    public void setSupplierDetail(List<SubInviteSupplierVO> supplierDetail) {
        this.supplierDetail = supplierDetail;
    }

    public Integer getPurchaseType() {
        return purchaseType;
    }

    public void setPurchaseType(Integer purchaseType) {
        this.purchaseType = purchaseType;
    }

    public Long getSubType() {
        return subType;
    }

    public void setSubType(Long subType) {
        this.subType = subType;
    }

    public String getProjectQualification() {
        return projectQualification;
    }

    public void setProjectQualification(String projectQualification) {
        this.projectQualification = projectQualification;
    }

    public String getPaymentId() {
        return paymentId;
    }
    public void setPaymentId(String paymentId) {
        this.paymentId = paymentId;
    }

    public String getPaymentName() {
        return paymentName;
    }

    public void setPaymentName(String paymentName) {
        this.paymentName = paymentName;
    }

    public BigDecimal getPayScale() {
        return payScale;
    }

    public void setPayScale(BigDecimal payScale) {
        this.payScale = payScale;
    }

    public Date getEntryTime() {
        return entryTime;
    }

    public void setEntryTime(Date entryTime) {
        this.entryTime = entryTime;
    }

    public Long getSupplierId() {
        return supplierId;
    }
    @ReferDeserialTransfer
    public void setSupplierId(Long supplierId) {
        this.supplierId = supplierId;
    }

    public String getSupplierName() {
        return supplierName;
    }

    public void setSupplierName(String supplierName) {
        this.supplierName = supplierName;
    }

    public Integer getTenderState() {
        return tenderState;
    }

    public void setTenderState(Integer tenderState) {
        this.tenderState = tenderState;
    }

    public String getTenderStateName() {
        return tenderStateName;
    }

    public void setTenderStateName(String tenderStateName) {
        this.tenderStateName = tenderStateName;
    }

    public Date getStopTime() {
        return stopTime;
    }

    public void setStopTime(Date stopTime) {
        this.stopTime = stopTime;
    }
}
