package com.ejianc.business.tender.equipment.vo;

import com.baomidou.mybatisplus.annotation.TableField;
import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

/**
 * 材料立项主表
 *
 * @author generator
 *
 */
public class EquipmentInviteVO extends BaseVO {
    private static final long serialVersionUID = 1L;

    private String billCode; // 单据编号
    private Long projectId; // 项目ID
    private String projectName; // 项目名称
    private Long employeeId; // 编制人
    private String employeeName; // 编制人名称
    private Long unitId; // 招标单位ID
    private String unitName; // 招标单位名称
    private String memo; // 备注
    private Integer billState; // 单据状态（审批必须字段）
    private String billStateName; // 单据状态（审批必须字段）
    private String tenderName; // 招标名称
    private Integer tenderType; // 招标方式(0-平台公开招标,1-邀请招标,2-询价,3-竞争性谈判,4-单一来源,5-紧急招标)
    private Integer tenderStage; // 招标阶段
    private String tenderStageName; // 招标阶段名称
    private String tenderUnitNum; // 中标单位及数量
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private java.util.Date createDate; // 编制日期
    private Integer valueType; // 计价方式(0-固定单价,1-浮动单价,2-固定总额)
    private String purchaseId; // 采购方式ID
    private String purchaseName; // 采购方式名称
    private String projectCode; // 项目编号
    private java.math.BigDecimal tenderMoney; // 招标金额
    private Long orgId; // 组织
    private String orgName; // 组织名称
    private Long parentOrgId; // 父级组织
    private String parentOrgName; // 父级组织名称
    private Integer establishType; // 立项类型(0-招标立项，1-定标立项)
    private String tenderTypeName; // 招标方式(0-平台公开招标,1-邀请招标,2-询价,3-竞争性谈判,4-单一来源,5-紧急招标)
    private String establishTypeName; // 立项类型(0-招标立项，1-定标立项)
    private Integer purchaseType; // 采购方式(0-项目采购,1-单位采购)
    private String purchaseTypeName; // 采购方式(0-项目采购,1-单位采购)
    private Integer abolishType;//流/废标（0-正常，1-流标，2-废标）
    private String contractType;//合同类型(0-消耗材,1-周转材,2-混凝土,3-零星材料)
    private String contractTypeName;//合同类型(0-消耗材,1-周转材,2-混凝土,3-零星材料)
    private java.lang.Integer tenderPlatform; // 招标平台(1-招采平台，2-云上营家)

    @TableField(value="money")
    private java.math.BigDecimal money; // 定标金额(无税)
    @TableField(value="tax_money")
    private java.math.BigDecimal taxMoney; // 定标金额(含税)
    private Integer occupyState; //占用状态:0-未占用,1-已占用
    private Long supplierId; // 供应商ID
    private String supplierName; // 供应商名称
    private Long categoryId; // 设备类别
    private String categoryName; // 设备类别名称
    private String orgCode; // 项目部编码
    private String parentOrgCode; // 项目部上级组织编码
    private Integer isLowPrice; // 低价中标


    public Integer getIsLowPrice() {
        return isLowPrice;
    }

    public void setIsLowPrice(Integer isLowPrice) {
        this.isLowPrice = isLowPrice;
    }
    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }

    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }


    public Long getSupplierId() {
        return supplierId;
    }

    public void setSupplierId(Long supplierId) {
        this.supplierId = supplierId;
    }

    public String getSupplierName() {
        return supplierName;
    }

    public void setSupplierName(String supplierName) {
        this.supplierName = supplierName;
    }

    public Integer getOccupyState() {
        return occupyState;
    }

    public void setOccupyState(Integer occupyState) {
        this.occupyState = occupyState;
    }

    public BigDecimal getMoney() {
        return money;
    }
    @TableField(value="sign_status")
    private Integer signStatus; //签订状态:0-未签订,1-部分签订,2-全部已签,3-已关闭
    private String signStatusName; //签订状态:0-未签订,1-部分签订,2-全部已签,3-已关闭

    public String getSignStatusName() {
        return signStatusName;
    }

    public void setSignStatusName(String signStatusName) {
        this.signStatusName = signStatusName;
    }

    public Integer getSignStatus() {
        return signStatus;
    }

    public void setSignStatus(Integer signStatus) {
        this.signStatus = signStatus;
    }

    public void setMoney(BigDecimal money) {
        this.money = money;
    }

    public BigDecimal getTaxMoney() {
        return taxMoney;
    }

    public void setTaxMoney(BigDecimal taxMoney) {
        this.taxMoney = taxMoney;
    }
    private List<EquipmentInviteDetailVO> equipmentDetail = new ArrayList<>(); // 材料招标立项采购清单表
    private List<EquipmentInviteSupplierVO> supplierDetail = new ArrayList<>(); // 材料招标立项供应商表
    private List<EquipmentInviteDetailRecordVO> equipmentDetailRecord = new ArrayList<>(); // 材料招标立项采购清单表不合并
//    private List<EquipmentInviteExpertVO> expertDetail = new ArrayList<>(); // 材料招标立项专家表
    private List<EquipmentInviteDetailBidderVO> equipmentDetailBidder = new ArrayList<>(); // 材料定标立项定标情况表



    public List<EquipmentInviteDetailRecordVO> getEquipmentDetailRecord() {
        return equipmentDetailRecord;
    }

    public void setEquipmentDetailRecord(List<EquipmentInviteDetailRecordVO> equipmentDetailRecord) {
        this.equipmentDetailRecord = equipmentDetailRecord;
    }

    public Integer getTenderPlatform() {
        return tenderPlatform;
    }

    public void setTenderPlatform(Integer tenderPlatform) {
        this.tenderPlatform = tenderPlatform;
    }

    public String getContractTypeName() {
        return contractTypeName;
    }

    public void setContractTypeName(String contractTypeName) {
        this.contractTypeName = contractTypeName;
    }

    public String getContractType() {
        return contractType;
    }

    public void setContractType(String contractType) {
        this.contractType = contractType;
    }

    public Integer getPurchaseType() {
        return purchaseType;
    }

    public void setPurchaseType(Integer purchaseType) {
        this.purchaseType = purchaseType;
    }

    public String getPurchaseTypeName() {
        return purchaseTypeName;
    }

    public void setPurchaseTypeName(String purchaseTypeName) {
        this.purchaseTypeName = purchaseTypeName;
    }

    public String getTenderStageName() {
        return tenderStageName;
    }

    public void setTenderStageName(String tenderStageName) {
        this.tenderStageName = tenderStageName;
    }

    public String getBillStateName() {
        return billStateName;
    }

    public void setBillStateName(String billStateName) {
        this.billStateName = billStateName;
    }

    public String getTenderTypeName() {
        return tenderTypeName;
    }

    public void setTenderTypeName(String tenderTypeName) {
        this.tenderTypeName = tenderTypeName;
    }

    public String getEstablishTypeName() {
        return establishTypeName;
    }

    public void setEstablishTypeName(String establishTypeName) {
        this.establishTypeName = establishTypeName;
    }

    /**
     * 流/废标状态
     */
    public Integer getAbolishType() {
        return abolishType;
    }

    public void setAbolishType(Integer abolishType) {
        this.abolishType = abolishType;
    }

    /**
     * 单据编号
     */
    public String getBillCode() {
        return billCode;
    }

    /**
     * 单据编号
     */
    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    /**
     * 项目ID
     */
    @ReferSerialTransfer(referCode = "project-set")
    public Long getProjectId() {
        return projectId;
    }

    /**
     * 项目ID
     */
    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    /**
     * 项目名称
     */
    public String getProjectName() {
        return projectName;
    }

    /**
     * 项目名称
     */
    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    /**
     * 编制人
     */
    public Long getEmployeeId() {
        return employeeId;
    }

    /**
     * 编制人
     */
    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    /**
     * 编制人名称
     */
    public String getEmployeeName() {
        return employeeName;
    }

    /**
     * 编制人名称
     */
    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    /**
     * 招标单位ID
     */
    @ReferSerialTransfer(referCode="idm-org")
    public Long getUnitId() {
        return unitId;
    }

    /**
     * 招标单位ID
     */
    @ReferDeserialTransfer
    public void setUnitId(Long unitId) {
        this.unitId = unitId;
    }
    /**
     * 招标单位名称
     */
    public String getUnitName() {
        return unitName;
    }

    /**
     * 招标单位名称
     */
    public void setUnitName(String unitName) {
        this.unitName = unitName;
    }
    /**
     * 备注
     */
    public String getMemo() {
        return memo;
    }

    /**
     * 备注
     */
    public void setMemo(String memo) {
        this.memo = memo;
    }
    /**
     * 单据状态（审批必须字段）
     */
    public Integer getBillState() {
        return billState;
    }

    /**
     * 单据状态（审批必须字段）
     */
    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    /**
     * 招标名称
     */
    public String getTenderName() {
        return tenderName;
    }

    /**
     * 招标名称
     */
    public void setTenderName(String tenderName) {
        this.tenderName = tenderName;
    }
    /**
     * 招标方式(0-平台公开招标,1-邀请招标,2-询价,3-竞争性谈判,4-单一来源,5-紧急招标)
     */
    public Integer getTenderType() {
        return tenderType;
    }

    /**
     * 招标方式(0-平台公开招标,1-邀请招标,2-询价,3-竞争性谈判,4-单一来源,5-紧急招标)
     */
    public void setTenderType(Integer tenderType) {
        this.tenderType = tenderType;
    }
    /**
     * 招标阶段
     */
    public Integer getTenderStage() {
        return tenderStage;
    }

    /**
     * 招标阶段
     */
    public void setTenderStage(Integer tenderStage) {
        this.tenderStage = tenderStage;
    }
    /**
     * 中标单位及数量
     */
    public String getTenderUnitNum() {
        return tenderUnitNum;
    }

    /**
     * 中标单位及数量
     */
    public void setTenderUnitNum(String tenderUnitNum) {
        this.tenderUnitNum = tenderUnitNum;
    }
    /**
     * 编制日期
     */
    public java.util.Date getCreateDate() {
        return createDate;
    }

    /**
     * 编制日期
     */
    public void setCreateDate(java.util.Date createDate) {
        this.createDate = createDate;
    }
    /**
     * 计价方式(0-固定单价,1-浮动单价,2-固定总额)
     */
    public Integer getValueType() {
        return valueType;
    }

    /**
     * 计价方式(0-固定单价,1-浮动单价,2-固定总额)
     */
    public void setValueType(Integer valueType) {
        this.valueType = valueType;
    }
    /**
     * 采购方式ID
     */
    public String getPurchaseId() {
        return purchaseId;
    }

    /**
     * 采购方式ID
     */
    public void setPurchaseId(String purchaseId) {
        this.purchaseId = purchaseId;
    }
    /**
     * 采购方式名称
     */
    public String getPurchaseName() {
        return purchaseName;
    }

    /**
     * 采购方式名称
     */
    public void setPurchaseName(String purchaseName) {
        this.purchaseName = purchaseName;
    }
    /**
     * 项目编号
     */
    public String getProjectCode() {
        return projectCode;
    }

    /**
     * 项目编号
     */
    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }
    /**
     * 招标金额
     */
    public java.math.BigDecimal getTenderMoney() {
        return tenderMoney;
    }

    /**
     * 招标金额
     */
    public void setTenderMoney(java.math.BigDecimal tenderMoney) {
        this.tenderMoney = tenderMoney;
    }
    /**
     * 组织
     */
    @ReferSerialTransfer(referCode="idm-org")
    public Long getOrgId() {
        return orgId;
    }

    /**
     * 组织
     */
    @ReferDeserialTransfer
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    /**
     * 组织名称
     */
    public String getOrgName() {
        return orgName;
    }

    /**
     * 组织名称
     */
    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    /**
     * 父级组织
     */
    public Long getParentOrgId() {
        return parentOrgId;
    }

    /**
     * 父级组织
     */
    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    /**
     * 父级组织名称
     */
    public String getParentOrgName() {
        return parentOrgName;
    }

    /**
     * 父级组织名称
     */
    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    /**
     * 立项类型(0-招标立项，1-定标立项)
     */
    public Integer getEstablishType() {
        return establishType;
    }

    /**
     * 立项类型(0-招标立项，1-定标立项)
     */
    public void setEstablishType(Integer establishType) {
        this.establishType = establishType;
    }

    public List<EquipmentInviteDetailVO> getEquipmentDetail() {
        return equipmentDetail;
    }

    public void setEquipmentDetail(List<EquipmentInviteDetailVO> equipmentDetail) {
        this.equipmentDetail = equipmentDetail;
    }

    public List<EquipmentInviteSupplierVO> getSupplierDetail() {
        return supplierDetail;
    }

    public void setSupplierDetail(List<EquipmentInviteSupplierVO> supplierDetail) {
        this.supplierDetail = supplierDetail;
    }


    public List<EquipmentInviteDetailBidderVO> getEquipmentDetailBidder() {
        return equipmentDetailBidder;
    }

    public void setEquipmentDetailBidder(List<EquipmentInviteDetailBidderVO> equipmentDetailBidder) {
        this.equipmentDetailBidder = equipmentDetailBidder;
    }
    @ReferSerialTransfer(referCode="support-defdoc")
    public Long getCategoryId() {
        return categoryId;
    }
    @ReferDeserialTransfer
    public void setCategoryId(Long categoryId) {
        this.categoryId = categoryId;
    }

    public String getCategoryName() {
        return categoryName;
    }

    public void setCategoryName(String categoryName) {
        this.categoryName = categoryName;
    }
}
