package com.ejianc.business.tender.other.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;


/**
 * 其他采购计划
 * 
 * @author generator
 * 
 */
public class OtherBatPlanVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private String billCode; // 单据编号
    private Long projectId; // 项目ID
    private String projectName; // 
    private String projectCode; // 项目编号
    private Long employeeId; // 编制人
    private String employeeName; // 编制人名称
    private Long unitId; // 采购单位ID
    private String unitName; // 采购单位名称
    private String memo; // 备注
    private Integer billState; // 单据状态（审批必须字段）
    private String planName; // 计划名称
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date createDate; // 编制日期
    private BigDecimal temporaryMoney; // 暂估金额
    private Long orgId; // 组织
    private String orgName; // 
    private String orgCode; // 项目部编码
    private Long parentOrgId; // 父级组织
    private String parentOrgName; // 
    private String parentOrgCode; // 项目部上级组织编码
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date planStartTime; // 计划进场日期
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date planEndTime; // 计划完成日期
    private String paymentId; // 付款方式ID
    private String paymentName; // 付款方式名称
    private String takeAddress; // 收货地址
    private String settlementClause; // 结算条款
    private String planStandard; // 质量验收标准
    private Integer planState; // 采购计划状态（0-待采购,1-采购中,2-采购完成）
    private Long trusteesId; // 招标经办人ID
    private String trusteesName; // 招标经办人名称
    private String purchaseType; // 采购类型 1-自采，2-集采
    private String purchaseTypeName; // 集采/自采
    private Integer valueType; // 计价方式(0-可调单价,1-固定总价,2-成本加酬金)
    private String subContent; // 分包内容
    private String subContentName; // 分包内容名称
    private List<OtherBatPlanDetailVO> otherDetailRecord = new ArrayList<>(); // 其他采购计划详情


    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    @ReferSerialTransfer(referCode = "project-set")
    public Long getProjectId() {
        return projectId;
    }
    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }
    public Long getEmployeeId() {
        return employeeId;
    }

    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    @ReferSerialTransfer(referCode="idm-org")
    public Long getUnitId() {
        return unitId;
    }
    @ReferDeserialTransfer
    public void setUnitId(Long unitId) {
        this.unitId = unitId;
    }
    public String getUnitName() {
        return unitName;
    }

    public void setUnitName(String unitName) {
        this.unitName = unitName;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public String getPlanName() {
        return planName;
    }

    public void setPlanName(String planName) {
        this.planName = planName;
    }
    public Date getCreateDate() {
        return createDate;
    }

    public void setCreateDate(Date createDate) {
        this.createDate = createDate;
    }
    public BigDecimal getTemporaryMoney() {
        return temporaryMoney;
    }

    public void setTemporaryMoney(BigDecimal temporaryMoney) {
        this.temporaryMoney = temporaryMoney;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }
    public Long getParentOrgId() {
        return parentOrgId;
    }

    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }
    public Date getPlanStartTime() {
        return planStartTime;
    }

    public void setPlanStartTime(Date planStartTime) {
        this.planStartTime = planStartTime;
    }
    public Date getPlanEndTime() {
        return planEndTime;
    }

    public void setPlanEndTime(Date planEndTime) {
        this.planEndTime = planEndTime;
    }
    public String getPaymentId() {
        return paymentId;
    }

    public void setPaymentId(String paymentId) {
        this.paymentId = paymentId;
    }
    public String getPaymentName() {
        return paymentName;
    }

    public void setPaymentName(String paymentName) {
        this.paymentName = paymentName;
    }
    public String getTakeAddress() {
        return takeAddress;
    }

    public void setTakeAddress(String takeAddress) {
        this.takeAddress = takeAddress;
    }
    public String getSettlementClause() {
        return settlementClause;
    }

    public void setSettlementClause(String settlementClause) {
        this.settlementClause = settlementClause;
    }
    public String getPlanStandard() {
        return planStandard;
    }

    public void setPlanStandard(String planStandard) {
        this.planStandard = planStandard;
    }
    public Integer getPlanState() {
        return planState;
    }

    public void setPlanState(Integer planState) {
        this.planState = planState;
    }
    @ReferSerialTransfer(referCode="idm-user")
    public Long getTrusteesId() {
        return trusteesId;
    }
    @ReferDeserialTransfer
    public void setTrusteesId(Long trusteesId) {
        this.trusteesId = trusteesId;
    }
    public String getTrusteesName() {
        return trusteesName;
    }

    public void setTrusteesName(String trusteesName) {
        this.trusteesName = trusteesName;
    }
    public String getPurchaseType() {
        return purchaseType;
    }

    public void setPurchaseType(String purchaseType) {
        this.purchaseType = purchaseType;
    }
    public String getPurchaseTypeName() {
        return purchaseTypeName;
    }

    public void setPurchaseTypeName(String purchaseTypeName) {
        this.purchaseTypeName = purchaseTypeName;
    }
    public Integer getValueType() {
        return valueType;
    }

    public void setValueType(Integer valueType) {
        this.valueType = valueType;
    }
    public String getSubContent() {
        return subContent;
    }

    public void setSubContent(String subContent) {
        this.subContent = subContent;
    }
    public String getSubContentName() {
        return subContentName;
    }

    public void setSubContentName(String subContentName) {
        this.subContentName = subContentName;
    }

    public List<OtherBatPlanDetailVO> getOtherDetailRecord() {
        return otherDetailRecord;
    }

    public void setOtherDetailRecord(List<OtherBatPlanDetailVO> otherDetailRecord) {
        this.otherDetailRecord = otherDetailRecord;
    }
}
