/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.tender.expert.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.tender.enums.TenderStateEnum;
import com.ejianc.business.tender.expert.bean.ExpertEvaluatingDetailEntity;
import com.ejianc.business.tender.expert.bean.ExpertEvaluatingEntity;
import com.ejianc.business.tender.expert.bean.ExpertRepetitionEntity;
import com.ejianc.business.tender.expert.bean.ExpertRepetitionSupplierEntity;
import com.ejianc.business.tender.expert.mapper.ExpertRepetitionMapper;
import com.ejianc.business.tender.expert.service.IExpertEvaluatingDetailService;
import com.ejianc.business.tender.expert.service.IExpertEvaluatingService;
import com.ejianc.business.tender.expert.service.IExpertRecordScoreService;
import com.ejianc.business.tender.expert.service.IExpertRecordService;
import com.ejianc.business.tender.expert.service.IExpertRepetitionService;
import com.ejianc.business.tender.expert.service.IExpertRepetitionSupplierService;
import com.ejianc.business.tender.expert.vo.ExpertEvaluatingVO;
import com.ejianc.business.tender.expert.vo.ExpertRepetitionSupplierVO;
import com.ejianc.business.tender.expert.vo.ExpertRepetitionVO;
import com.ejianc.business.tender.other.bean.OtherInviteEntity;
import com.ejianc.business.tender.other.service.IOtherDocumentService;
import com.ejianc.business.tender.other.service.IOtherInviteService;
import com.ejianc.business.tender.other.service.IOtherTalkService;
import com.ejianc.business.tender.other.vo.OtherDocumentSupplierTbVO;
import com.ejianc.business.tender.other.vo.OtherDocumentVO;
import com.ejianc.business.tender.other.vo.OtherNoticeSupplierDetailTbVO;
import com.ejianc.business.tender.process.bean.ProcessEntity;
import com.ejianc.business.tender.process.service.IProcessService;
import com.ejianc.business.tender.util.SendMsgUtils;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.message.api.IPushMessageApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.dataPush.ISystemDataPushService;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="expertRepetitionService")
public class ExpertRepetitionServiceImpl
extends BaseServiceImpl<ExpertRepetitionMapper, ExpertRepetitionEntity>
implements IExpertRepetitionService {
    @Autowired
    private IExpertEvaluatingService expertEvaluatingService;
    @Autowired
    private IExpertEvaluatingDetailService expertEvaluatingDetailService;
    @Autowired
    private IExpertRepetitionService expertRepetitionService;
    @Autowired
    private IExpertRepetitionSupplierService expertRepetitionSupplierService;
    @Autowired
    private ISystemDataPushService systemDataPushService;
    @Autowired
    private IProcessService processService;
    @Autowired
    private IPushMessageApi pushMessageApi;
    @Autowired
    private SessionManager sessionManager;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IAttachmentApi attachmentApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOtherDocumentService otherDocumentService;
    @Autowired
    private IOtherTalkService otherTalkService;
    @Autowired
    private IExpertRecordService expertRecordService;
    @Autowired
    private IExpertRecordScoreService expertRecordScoreService;
    @Autowired
    private IOtherInviteService otherInviteService;
    @Value(value="${gysUrl.delFileUrl}")
    private String delFileUrl;
    @Value(value="${gysUrl.appHost}")
    private String appHost;
    @Value(value="${gysUrl.saveWjUrl}")
    private String saveWjUrl;
    @Value(value="${gysUrl.updateTimeUrl}")
    private String updateTimeUrl;
    @Value(value="${gysUrl.saveOrUpdateUrl}")
    private String saveOrUpdateUrl;
    @Value(value="${gysUrl.updateSupStatusUrl}")
    private String updateSupStatusUrl;
    @Value(value="${gysUrl.addFileUrl}")
    private String addFileUrl;
    @Value(value="${gysUrl.appId}")
    private String appId;
    @Value(value="${gysUrl.appSecret}")
    private String appSecret;
    @Value(value="${common.env.base-host}")
    private String BASE_HOST;
    @Value(value="${refer.base-host:null}")
    private String BASE_HOST_FRONTEND;
    private static final String BILL_CODE = "EXPERT_REPETITION_RULE";

    @Override
    public ExpertRepetitionVO repetitionSell(ExpertRepetitionVO vo) {
        ExpertEvaluatingEntity expertEvaluatingEntity = (ExpertEvaluatingEntity)((Object)this.expertEvaluatingService.selectById(vo.getEvaluatingId()));
        List expertRepetitionSupplierList = vo.getExpertRepetitionSupplierList();
        ExpertRepetitionEntity expertRepetitionEntity = (ExpertRepetitionEntity)((Object)BeanMapper.map((Object)((Object)expertEvaluatingEntity), ExpertRepetitionEntity.class));
        expertRepetitionEntity.setId(IdWorker.getId());
        expertRepetitionEntity.setTalkNum(vo.getTalkNum() + 1);
        expertRepetitionEntity.setBidFlag(0);
        expertRepetitionEntity.setPublishFlag(0);
        expertRepetitionEntity.setBillState(0);
        expertRepetitionEntity.setRepetiterId(this.sessionManager.getUserContext().getEmployeeId());
        expertRepetitionEntity.setRepetiterName(this.sessionManager.getUserContext().getEmployeeName());
        expertRepetitionEntity.setEvaluatingId(expertEvaluatingEntity.getId());
        List expertRepetitionSupplierEntities = new ArrayList();
        if (CollectionUtils.isNotEmpty((Collection)expertRepetitionSupplierList)) {
            expertRepetitionSupplierEntities = BeanMapper.mapList((Iterable)expertRepetitionSupplierList, ExpertRepetitionSupplierEntity.class);
            for (ExpertRepetitionSupplierEntity expertRepetitionSupplierEntity : expertRepetitionSupplierEntities) {
                expertRepetitionSupplierEntity.setId(IdWorker.getId());
                expertRepetitionSupplierEntity.setSellStatus(1);
                expertRepetitionSupplierEntity.setTalkNum(vo.getTalkNum() + 1);
                expertRepetitionSupplierEntity.setRepetitionId(expertRepetitionEntity.getId());
            }
        }
        this.expertRepetitionSupplierService.saveBatch(expertRepetitionSupplierEntities);
        BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)vo);
        CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
        if (!billCode.isSuccess()) {
            throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
        }
        expertRepetitionEntity.setBillCode((String)billCode.getData());
        this.expertRepetitionService.save((Object)expertRepetitionEntity);
        return this.queryCollectDetail(expertRepetitionEntity.getId());
    }

    @Override
    public ExpertRepetitionVO queryCollectDetail(Long id) {
        ExpertRepetitionEntity entity = (ExpertRepetitionEntity)((Object)this.expertRepetitionService.selectById(id));
        ExpertEvaluatingEntity expertEvaluatingEntity = (ExpertEvaluatingEntity)((Object)this.expertEvaluatingService.selectById(entity.getEvaluatingId()));
        ExpertEvaluatingVO expertEvaluatingVO = (ExpertEvaluatingVO)BeanMapper.map((Object)((Object)expertEvaluatingEntity), ExpertEvaluatingVO.class);
        ExpertRepetitionVO vo = (ExpertRepetitionVO)BeanMapper.map((Object)((Object)entity), ExpertRepetitionVO.class);
        vo.setStuffEvaluationDetailEntities(expertEvaluatingVO.getStuffEvaluationDetailEntities());
        Integer num = vo.getTalkNum() - 1;
        if (entity.getInviteType() == 5) {
            OtherDocumentVO stuffDocumentVO = this.otherDocumentService.queryDetail1(vo.getDocumentId(), num);
            vo.setScoreResult(this.expertEvaluatingService.queryScoreDetail(entity.getInviteId(), entity.getEvaluatingId()));
            vo.setStuffDocumentDetailSellList(stuffDocumentVO.getOtherDocumentDetailSellList());
            vo.setStuffDocumentSupplierSchemeList(stuffDocumentVO.getOtherDocumentSupplierSchemeList());
            OtherInviteEntity otherInviteEntity = (OtherInviteEntity)((Object)this.otherInviteService.selectById(vo.getInviteId()));
            vo.setTenderMoney(otherInviteEntity.getTenderMoney());
        }
        return vo;
    }

    @Override
    @Transactional
    public ExpertRepetitionVO publish(Long id) {
        ExpertRepetitionEntity expertRepetitionEntity = (ExpertRepetitionEntity)((Object)super.selectById((Serializable)id));
        expertRepetitionEntity.setPublishFlag(1);
        super.updateById((Object)expertRepetitionEntity);
        OtherDocumentSupplierTbVO rentDocumentSupplierTbVO = new OtherDocumentSupplierTbVO();
        rentDocumentSupplierTbVO.setSourceId(expertRepetitionEntity.getInviteId().toString());
        rentDocumentSupplierTbVO.setNoticeType(Integer.valueOf(1));
        rentDocumentSupplierTbVO.setTalkNum(expertRepetitionEntity.getTalkNum());
        rentDocumentSupplierTbVO.setMemo(expertRepetitionEntity.getRepetitionReason());
        List<ExpertRepetitionSupplierEntity> expertRepetitionSupplierList = expertRepetitionEntity.getExpertRepetitionSupplierList();
        ArrayList<OtherNoticeSupplierDetailTbVO> supplierDetailTbVOList = new ArrayList<OtherNoticeSupplierDetailTbVO>();
        for (ExpertRepetitionSupplierEntity supplierDetailEntity : expertRepetitionSupplierList) {
            OtherNoticeSupplierDetailTbVO stuffNoticeSupplierDetailTbVO = new OtherNoticeSupplierDetailTbVO();
            stuffNoticeSupplierDetailTbVO.setSourceId(expertRepetitionEntity.getInviteId().toString());
            stuffNoticeSupplierDetailTbVO.setSourceSupplierId(supplierDetailEntity.getSupplierId().toString());
            supplierDetailTbVOList.add(stuffNoticeSupplierDetailTbVO);
        }
        rentDocumentSupplierTbVO.setApplyList(supplierDetailTbVOList);
        String stringFb = JSONObject.toJSONString((Object)rentDocumentSupplierTbVO);
        this.logger.info("\u4e8c\u6b21\u62a5\u4ef7\u4fe1\u606f" + stringFb);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("noticeEntity", stringFb);
        Map files = null;
        CommonResponse stringCommonResponses = this.systemDataPushService.exchangeDataAndFilesWithUniversal(this.saveWjUrl, params, files, this.appId, this.appSecret, this.appHost);
        if (!stringCommonResponses.isSuccess()) {
            throw new BusinessException("\u62db\u6807\u6587\u4ef6\u53d1\u5e03\u63a8\u9001\u4f9b\u65b9\u63a5\u53e3\u62a5\u9519" + stringCommonResponses.getMsg());
        }
        ExpertEvaluatingEntity expertEvaluatingEntity = (ExpertEvaluatingEntity)((Object)this.expertEvaluatingService.selectById(expertRepetitionEntity.getEvaluatingId()));
        Integer inviteType = expertEvaluatingEntity.getInviteType();
        Long inviteId = expertRepetitionEntity.getInviteId();
        String billCode = null;
        switch (inviteType) {
            case 5: {
                OtherInviteEntity inviteEntity = (OtherInviteEntity)((Object)this.otherInviteService.selectById(inviteId));
                inviteEntity.setTenderState(TenderStateEnum.\u62a5\u4ef7\u4e2d.getCode());
                billCode = inviteEntity.getBillCode();
                this.otherInviteService.saveOrUpdate((Object)inviteEntity);
                break;
            }
            default: {
                throw new BusinessException("\u62db\u6807\u7acb\u9879\u7c7b\u578b\u4e0d\u5b58\u5728[" + inviteType + "]");
            }
        }
        ArrayList<String> messageType = new ArrayList<String>();
        messageType.add("sys");
        messageType.add("weChat");
        ArrayList<String> sender = new ArrayList<String>();
        sender.add(expertRepetitionEntity.getEmployeeId() + "");
        this.logger.info("\u53d1\u9001\u4fe1\u606f\u7ed9\u4e13\u5bb6:>----------" + sender);
        String subject = expertRepetitionEntity.getEmployeeName() + "\u60a8\u597d\uff0c\u5355\u636e\u7f16\u7801\u4e3a" + billCode + "\u7684\u62db\u6807\u7531\u4e8e\u3010" + expertRepetitionEntity.getRepetitionReason() + "\u3011\uff0c\u8bc4\u6807\u7ec4\u957f\u53d1\u8d77\u4e86\u4e8c\u6b21\u62a5\u4ef7\uff0c\u8bf7\u77e5\u6653\uff01";
        String content = expertRepetitionEntity.getEmployeeName() + "\u60a8\u597d\uff0c\u5355\u636e\u7f16\u7801\u4e3a" + billCode + "\u7684\u62db\u6807\u7531\u4e8e\u3010" + expertRepetitionEntity.getRepetitionReason() + "\u3011\uff0c\u8bc4\u6807\u7ec4\u957f\u53d1\u8d77\u4e86\u4e8c\u6b21\u62a5\u4ef7\uff0c\u8bf7\u77e5\u6653\uff01";
        this.logger.info("\u53d1\u9001\u4fe1\u606f\u7684\u5185\u5bb9:>----------" + content);
        new SendMsgUtils().sendSysMsg(sender, subject, content, this.pushMessageApi);
        return null;
    }

    @Override
    @Transactional
    public String startScore(Long id) {
        OtherDocumentVO stuffDocumentVO;
        List stuffDocumentSupplierSchemeList;
        ExpertRepetitionEntity expertRepetitionEntity = (ExpertRepetitionEntity)((Object)super.selectById((Serializable)id));
        expertRepetitionEntity.setBidFlag(1);
        super.updateById((Object)expertRepetitionEntity);
        Integer num = expertRepetitionEntity.getTalkNum();
        List expertRepetitionSupplierVOS = new ArrayList();
        if (expertRepetitionEntity.getInviteType() == 5 && CollectionUtils.isNotEmpty((Collection)(stuffDocumentSupplierSchemeList = (stuffDocumentVO = this.otherDocumentService.queryDetail1(expertRepetitionEntity.getDocumentId(), num)).getOtherDocumentSupplierSchemeList()))) {
            expertRepetitionSupplierVOS = BeanMapper.mapList((Iterable)stuffDocumentSupplierSchemeList, ExpertRepetitionSupplierVO.class);
        }
        List<ExpertRepetitionSupplierEntity> expertRepetitionSupplierList = expertRepetitionEntity.getExpertRepetitionSupplierList();
        if (expertRepetitionSupplierVOS.size() < expertRepetitionSupplierList.size()) {
            throw new BusinessException("\u4f9b\u5e94\u5546\u672a\u5168\u90e8\u5b8c\u6210\u62a5\u4ef7,\u4e0d\u80fd\u5f00\u59cb\u8bc4\u6807!");
        }
        ExpertEvaluatingEntity expertEvaluatingEntity = (ExpertEvaluatingEntity)((Object)this.expertEvaluatingService.selectById(expertRepetitionEntity.getEvaluatingId()));
        expertEvaluatingEntity.setFlagNew(0);
        this.expertEvaluatingService.updateById((Object)expertEvaluatingEntity);
        expertEvaluatingEntity.setId(IdWorker.getId());
        expertEvaluatingEntity.setFlagNew(1);
        expertEvaluatingEntity.setCreateTime(null);
        expertEvaluatingEntity.setChangeVersion(expertEvaluatingEntity.getChangeVersion() + 1);
        List<ExpertEvaluatingDetailEntity> stuffEvaluationDetailEntities = expertEvaluatingEntity.getStuffEvaluationDetailEntities();
        for (ExpertEvaluatingDetailEntity expertEvaluatingDetailEntity : stuffEvaluationDetailEntities) {
            expertEvaluatingDetailEntity.setId(IdWorker.getId());
            expertEvaluatingDetailEntity.setEvaluationId(expertEvaluatingEntity.getId());
            expertEvaluatingDetailEntity.setEvaluationState(0);
            expertEvaluatingDetailEntity.setEvaluationTime(null);
            if (expertEvaluatingDetailEntity.getLeader() != 1) continue;
            ArrayList<String> messageType = new ArrayList<String>();
            messageType.add("sys");
            messageType.add("weChat");
            ArrayList<String> sender = new ArrayList<String>();
            sender.add(expertEvaluatingDetailEntity.getExpertId() + "");
            String name = expertEvaluatingEntity.getPurchaseType() == 0 ? expertEvaluatingEntity.getProjectName() : expertEvaluatingEntity.getOrgName();
            this.logger.info("\u53d1\u9001\u4fe1\u606f\u7ed9\u4e13\u5bb6:>----------" + sender);
            String subject = expertEvaluatingDetailEntity.getExpertName() + "\u4e13\u5bb6\u60a8\u597d\uff0c" + name + "\u8fdb\u5165\u4e8c\u6b21\u62a5\u4ef7\u7684\u8bc4\u6807\u9636\u6bb5\uff0c\u8bf7\u572824\u5c0f\u65f6\u5b8c\u6210\u8bc4\u6807\u4efb\u52a1";
            String frontendBaseHost = "";
            frontendBaseHost = StringUtils.isNotBlank((CharSequence)this.BASE_HOST_FRONTEND) && !"null".equals(this.BASE_HOST_FRONTEND) ? this.BASE_HOST_FRONTEND : this.BASE_HOST;
            String formUrl = frontendBaseHost + "ejc-tender-frontend/#/bidRecordList";
            String content = expertEvaluatingDetailEntity.getExpertName() + "\u4e13\u5bb6\u60a8\u597d\uff0c" + name + "\u8fdb\u5165\u4e8c\u6b21\u62a5\u4ef7\u7684\u8bc4\u6807\u9636\u6bb5\uff0c\u8bf7\u572824\u5c0f\u65f6\u5b8c\u6210\u8bc4\u6807\u4efb\u52a1,<a href=" + '\"' + formUrl + '\"' + ">\u8bf7\u5c3d\u5feb\u8bc4\u6807</a>";
            this.logger.info("\u53d1\u9001\u4fe1\u606f\u7684\u5185\u5bb9:>----------" + content);
            new SendMsgUtils().sendSysMsg(sender, subject, content, this.pushMessageApi);
        }
        LambdaQueryWrapper lambdaExpertProcess = Wrappers.lambdaQuery();
        lambdaExpertProcess.eq(ProcessEntity::getTenderId, (Object)expertRepetitionEntity.getInviteId());
        lambdaExpertProcess.eq(ProcessEntity::getFrontendUrl, (Object)"stuff/evaluationCard");
        ProcessEntity processServiceOne = (ProcessEntity)((Object)this.processService.getOne((Wrapper)lambdaExpertProcess));
        processServiceOne.setBillId(expertEvaluatingEntity.getId());
        this.processService.updateById((Object)processServiceOne);
        this.expertEvaluatingService.saveOrUpdate((Object)expertEvaluatingEntity, false);
        this.logger.info("\u65b0\u6570\u636e" + expertEvaluatingEntity.getId() + "flagNew" + expertEvaluatingEntity.getFlagNew());
        return "";
    }

    @Override
    public ExpertRepetitionVO saveOrUpdate(ExpertRepetitionVO saveOrUpdateVO) {
        ExpertRepetitionEntity expertRepetitionEntity;
        ExpertRepetitionEntity entity = (ExpertRepetitionEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, ExpertRepetitionEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        LambdaQueryWrapper lambdaRepetition = Wrappers.lambdaQuery();
        lambdaRepetition.eq(ExpertRepetitionEntity::getEvaluatingId, (Object)saveOrUpdateVO.getEvaluatingId());
        lambdaRepetition.eq(ExpertRepetitionEntity::getBidFlag, (Object)0);
        if (null != entity.getId()) {
            lambdaRepetition.ne(BaseEntity::getId, (Object)entity.getId());
        }
        if (null != (expertRepetitionEntity = (ExpertRepetitionEntity)((Object)this.expertRepetitionService.getOne((Wrapper)lambdaRepetition)))) {
            throw new BusinessException("\u5b58\u5728\u672a\u5f00\u6807\u7684\u4e8c\u6b21\u62a5\u4ef7\u6570\u636e\uff0c\u4e0d\u5141\u8bb8\u4fdd\u5b58");
        }
        this.expertRepetitionService.saveOrUpdate((Object)entity, false);
        return this.queryCollectDetail(entity.getId());
    }
}

