/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.tender.report.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.tender.other.vo.TenderStageEnum;
import com.ejianc.business.tender.report.mapper.ReportMapper;
import com.ejianc.business.tender.report.service.IReportService;
import com.ejianc.business.tender.report.vo.ReportVO;
import com.ejianc.business.tender.report.vo.SupplierReportVO;
import com.ejianc.business.tender.util.TenderTypeUrlEnum;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseVO;
import io.swagger.annotations.ApiOperation;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.ParseException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"report"})
public class ReportController
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IReportService service;
    @Autowired
    private ReportMapper reportMapper;
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<JSONObject> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("orgName");
        fuzzyFields.add("unitName");
        fuzzyFields.add("billCode");
        fuzzyFields.add("tenderName");
        fuzzyFields.add("tenderUnit");
        fuzzyFields.add("employeeName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        Map<String, Object> map = this.service.queryData(param);
        IPage page = (IPage)map.get("page");
        BigDecimal sumTaxMoney = (BigDecimal)map.get("sumTaxMoney");
        for (ReportVO record : page.getRecords()) {
            switch (record.getTenderTypeName()) {
                case "0": {
                    record.setTenderTypeName("\u5e73\u53f0\u516c\u5f00\u62db\u6807");
                    break;
                }
                case "1": {
                    record.setTenderTypeName("\u9080\u8bf7\u62db\u6807");
                    break;
                }
                case "2": {
                    record.setTenderTypeName("\u8be2\u4ef7");
                    break;
                }
                case "3": {
                    record.setTenderTypeName("\u7ade\u4e89\u6027\u8c08\u5224");
                    break;
                }
                case "4": {
                    record.setTenderTypeName("\u5355\u4e00\u6765\u6e90");
                    break;
                }
                case "5": {
                    record.setTenderTypeName("\u7d27\u6025\u62db\u6807");
                }
            }
            record.setEstablishTypeName(record.getEstablishType() == 0 ? "\u62db\u6807\u7acb\u9879" : "\u5b9a\u6807\u7acb\u9879");
            record.setPurchaseTypeName(record.getPurchaseType() == 0 ? "\u9879\u76ee\u91c7\u8d2d" : "\u5355\u4f4d\u91c7\u8d2d");
            record.setTenderStageName(TenderStageEnum.getEnumByStateCode((Integer)record.getTenderStage()).getDescription());
            String tenderUnit = record.getTenderUnit();
            if (null == tenderUnit) continue;
            record.setTenderUnit(ReportController.ClearBracket(tenderUnit));
        }
        JSONObject pageData = new JSONObject();
        pageData.put("records", (Object)BeanMapper.mapList((Iterable)page.getRecords(), ReportVO.class));
        pageData.put("total", (Object)page.getTotal());
        pageData.put("current", (Object)page.getCurrent());
        pageData.put("size", (Object)page.getSize());
        pageData.put("pages", (Object)page.getPages());
        pageData.put("sumTaxMoney", (Object)sumTaxMoney);
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @ApiOperation(value="\u5bfc\u51fa")
    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("orgName");
        fuzzyFields.add("unitName");
        fuzzyFields.add("billCode");
        fuzzyFields.add("tenderName");
        fuzzyFields.add("tenderUnit");
        fuzzyFields.add("employeeName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        Map<String, Object> map = this.service.queryData(param);
        IPage page = (IPage)map.get("page");
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), ReportVO.class));
        for (ReportVO record : pageData.getRecords()) {
            switch (record.getTenderTypeName()) {
                case "0": {
                    record.setTenderTypeName("\u5e73\u53f0\u516c\u5f00\u62db\u6807");
                    break;
                }
                case "1": {
                    record.setTenderTypeName("\u9080\u8bf7\u62db\u6807");
                    break;
                }
                case "2": {
                    record.setTenderTypeName("\u8be2\u4ef7");
                    break;
                }
                case "3": {
                    record.setTenderTypeName("\u7ade\u4e89\u6027\u8c08\u5224");
                    break;
                }
                case "4": {
                    record.setTenderTypeName("\u5355\u4e00\u6765\u6e90");
                    break;
                }
                case "5": {
                    record.setTenderTypeName("\u7d27\u6025\u62db\u6807");
                }
            }
            record.setEstablishTypeName(record.getEstablishType() == 0 ? "\u62db\u6807\u7acb\u9879" : "\u5b9a\u6807\u7acb\u9879");
            record.setPurchaseTypeName(record.getPurchaseType() == 0 ? "\u9879\u76ee\u91c7\u8d2d" : "\u5355\u4f4d\u91c7\u8d2d");
            record.setTenderStageName(TenderStageEnum.getEnumByStateCode((Integer)record.getTenderStage()).getDescription());
            String tenderUnit = record.getTenderUnit();
            if (null == tenderUnit) continue;
            record.setTenderUnit(ReportController.ClearBracket(tenderUnit));
        }
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", pageData.getRecords());
        ExcelExport.getInstance().export("report.xlsx", beans, response);
    }

    @RequestMapping(value={"/querySupplierReportList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<SupplierReportVO>> querySupplierReportList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        List orgIdList = ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList());
        IPage<SupplierReportVO> page = new IPage<SupplierReportVO>();
        if (param.getParams().containsKey("supplierId")) {
            Parameter obj = (Parameter)param.getParams().get("supplierId");
            Long supplierId = (long)Long.valueOf(String.valueOf(obj.getValue()));
            param.getParams().remove("supplierId");
            page = this.service.querySupplierReportData(param, supplierId);
            param.getParams().put("supplierId", new Parameter("eq", (Object)supplierId));
        }
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), SupplierReportVO.class));
        for (SupplierReportVO record : pageData.getRecords()) {
            switch (record.getTenderTypeName()) {
                case "0": {
                    record.setTenderTypeName("\u5e73\u53f0\u516c\u5f00\u62db\u6807");
                    break;
                }
                case "1": {
                    record.setTenderTypeName("\u9080\u8bf7\u62db\u6807");
                    break;
                }
                case "2": {
                    record.setTenderTypeName("\u8be2\u4ef7");
                    break;
                }
                case "3": {
                    record.setTenderTypeName("\u7ade\u4e89\u6027\u8c08\u5224");
                    break;
                }
                case "4": {
                    record.setTenderTypeName("\u5355\u4e00\u6765\u6e90");
                    break;
                }
                case "5": {
                    record.setTenderTypeName("\u7d27\u6025\u62db\u6807");
                }
            }
            if (!orgIdList.contains(record.getOrgId())) {
                record.setTenderMoney("******");
                record.setTaxMoney("******");
                record.setClickable(Boolean.valueOf(false));
            } else {
                record.setClickable(Boolean.valueOf(true));
            }
            if (!"".equals(record.getLineTypeName()) && record.getLineTypeName() != null) {
                if (record.getEstablishType() == 1) {
                    record.setUrl(TenderTypeUrlEnum.getUrl((String)record.getLineTypeName()) + "/dbcard?id=" + record.getInviteId());
                } else {
                    record.setUrl(TenderTypeUrlEnum.getUrl((String)record.getLineTypeName()) + "/card?id=" + record.getInviteId());
                }
            }
            record.setEstablishTypeName(record.getEstablishType() == 0 ? "\u62db\u6807\u7acb\u9879" : "\u5b9a\u6807\u7acb\u9879");
            record.setPurchaseTypeName(record.getPurchaseType() == 0 ? "\u9879\u76ee\u91c7\u8d2d" : "\u5355\u4f4d\u91c7\u8d2d");
            record.setTenderStageName(TenderStageEnum.getEnumByStateCode((Integer)record.getTenderStage()).getDescription());
            String tenderUnit = record.getTenderUnit();
            if ("".equals(tenderUnit) || tenderUnit == null || tenderUnit.indexOf("(") == -1 || tenderUnit.indexOf(")") == -1) continue;
            record.setTenderUnit(ReportController.ClearBracket(tenderUnit));
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @ApiOperation(value="\u6295\u6807\u7edf\u8ba1\u5217\u8868\u5bfc\u51fa")
    @RequestMapping(value={"/supplierReportExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void supplierReportExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        List orgIdList = ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList());
        IPage<SupplierReportVO> page = new IPage<SupplierReportVO>();
        if (param.getParams().containsKey("supplierId")) {
            Parameter obj = (Parameter)param.getParams().get("supplierId");
            Long supplierId = (long)Long.valueOf(String.valueOf(obj));
            param.getParams().remove("supplierId");
            page = this.service.querySupplierReportData(param, supplierId);
            param.getParams().put("supplierId", new Parameter("eq", (Object)supplierId));
        }
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), SupplierReportVO.class));
        for (SupplierReportVO record : pageData.getRecords()) {
            switch (record.getTenderTypeName()) {
                case "0": {
                    record.setTenderTypeName("\u5e73\u53f0\u516c\u5f00\u62db\u6807");
                    break;
                }
                case "1": {
                    record.setTenderTypeName("\u9080\u8bf7\u62db\u6807");
                    break;
                }
                case "2": {
                    record.setTenderTypeName("\u8be2\u4ef7");
                    break;
                }
                case "3": {
                    record.setTenderTypeName("\u7ade\u4e89\u6027\u8c08\u5224");
                    break;
                }
                case "4": {
                    record.setTenderTypeName("\u5355\u4e00\u6765\u6e90");
                    break;
                }
                case "5": {
                    record.setTenderTypeName("\u7d27\u6025\u62db\u6807");
                }
            }
            if (!orgIdList.contains(record.getOrgId())) {
                record.setTenderMoney("******");
                record.setTaxMoney("******");
            }
            record.setEstablishTypeName(record.getEstablishType() == 0 ? "\u62db\u6807\u7acb\u9879" : "\u5b9a\u6807\u7acb\u9879");
            record.setPurchaseTypeName(record.getPurchaseType() == 0 ? "\u9879\u76ee\u91c7\u8d2d" : "\u5355\u4f4d\u91c7\u8d2d");
            record.setTenderStageName(TenderStageEnum.getEnumByStateCode((Integer)record.getTenderStage()).getDescription());
            String tenderUnit = record.getTenderUnit();
            if ("".equals(tenderUnit) || tenderUnit == null || tenderUnit.indexOf("(") == -1 || tenderUnit.indexOf(")") == -1) continue;
            record.setTenderUnit(ReportController.ClearBracket(tenderUnit));
        }
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", pageData.getRecords());
        ExcelExport.getInstance().export("report.xlsx", beans, response);
    }

    private static String ClearBracket(String context) {
        int head = (context = context.replaceAll(",", "")).indexOf(40);
        if (head == -1) {
            return context;
        }
        int next = head + 1;
        int count = 1;
        do {
            if (context.charAt(next) == '(') {
                ++count;
            } else if (context.charAt(next) == ')') {
                --count;
            }
            ++next;
            if (count != 0) continue;
            String temp = context.substring(head, next);
            context = context.replace(temp, ",");
            head = context.indexOf(40);
            next = head + 1;
            count = 1;
        } while (head != -1);
        return context.substring(0, context.lastIndexOf(","));
    }

    @RequestMapping(value={"/queryBidData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<Map> queryBidData(Long orgId) throws ParseException {
        QueryParam param = new QueryParam();
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (orgId != null) {
            param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(orgId).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        } else {
            param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        }
        Map map = this.service.queryBidData(param);
        return CommonResponse.success((String)"\u67e5\u8be2\u62db\u6807\u7edf\u8ba1\u6210\u529f", (Object)map);
    }

    public BigDecimal queryMoney(Integer tenderType, String tenderTypeName, String firstDayOfMonth, String lastDayOfMonth) {
        return this.service.queryMoney(tenderType, tenderTypeName, firstDayOfMonth, lastDayOfMonth);
    }
}

