/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.tender.expert.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.tender.expert.bean.ExpertEntity;
import com.ejianc.business.tender.expert.bean.ExpertEvaluatingDetailEntity;
import com.ejianc.business.tender.expert.bean.RandomRuleEntity;
import com.ejianc.business.tender.expert.mapper.ExpertMapper;
import com.ejianc.business.tender.expert.service.IExpertFieldDetailService;
import com.ejianc.business.tender.expert.service.IExpertService;
import com.ejianc.business.tender.expert.service.IRandomRuleService;
import com.ejianc.business.tender.expert.service.impl.ExpertEvaluatingDetailServiceImpl;
import com.ejianc.business.tender.expert.vo.ExpertVO;
import com.ejianc.business.tender.expert.vo.RandomRuleTypeEnum;
import com.ejianc.business.tender.expert.vo.RandomRuleVO;
import com.ejianc.business.tender.expert.vo.RandomSupplierExpertVO;
import com.ejianc.business.tender.other.bean.OtherInviteEntity;
import com.ejianc.business.tender.other.service.IOtherInviteService;
import com.ejianc.business.tender.util.CommonUtils;
import com.ejianc.foundation.orgcenter.api.IEmployeeApi;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.CollectionUtil;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service(value="expertService")
public class ExpertServiceImpl
extends BaseServiceImpl<ExpertMapper, ExpertEntity>
implements IExpertService {
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IOtherInviteService otherInviteService;
    @Autowired
    private IEmployeeApi employeeApi;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String BILL_CODE = "EXPERT_CODE";
    @Autowired
    private IExpertService service;
    @Autowired
    private IRandomRuleService randomRuleService;
    @Autowired
    private IExpertFieldDetailService expertFieldDetailService;
    @Autowired
    private ExpertEvaluatingDetailServiceImpl expertEvaluatingDetailService;
    @Value(value="${parentOrgId.wztgzx}")
    private Long wztgzx;
    @Value(value="${parentOrgId.bjkj}")
    private Long bjkj;
    @Value(value="${parentOrgId.bjkjName}")
    private String bjkjName;

    @Override
    public Boolean dislodge(Long expertId) {
        LambdaQueryWrapper lambda = Wrappers.lambdaQuery();
        lambda.eq(ExpertEntity::getExpertId, (Object)expertId);
        List expertEntities = ((ExpertMapper)this.baseMapper).selectList((Wrapper)lambda);
        if (CollectionUtil.isNotEmpty((Collection)expertEntities)) {
            return false;
        }
        return true;
    }

    @Override
    public List<ExpertVO> randomSelectPlus(Integer expertNum, List<ExpertVO> expertVOS, Long inviteId, Integer inviteType) {
        LambdaQueryWrapper expertLambda;
        List<RandomRuleVO> randomRuleVOList = this.randomPlus(inviteId, inviteType);
        Collections.shuffle(randomRuleVOList);
        List oExpertIdList = expertVOS.stream().filter(item -> null != item.getExpertId()).map(item -> item.getExpertId().toString()).distinct().collect(Collectors.toList());
        ArrayList nExpertIdList = new ArrayList();
        for (RandomRuleVO randomRuleVO : randomRuleVOList) {
            for (String s : oExpertIdList) {
                if (!randomRuleVO.getRandomExpertIdStore().contains(s)) continue;
                randomRuleVO.getRandomExpertIdStore().remove(s);
                if (randomRuleVO.getNum() <= 0) continue;
                randomRuleVO.setNum(Integer.valueOf(randomRuleVO.getNum() - 1));
            }
            while (nExpertIdList.size() < expertNum && randomRuleVO.getRandomExpertIdStore().size() != 0 && randomRuleVO.getNum() > 0) {
                randomRuleVO.setNum(Integer.valueOf(randomRuleVO.getNum() - 1));
                ArrayList expertIdStore = new ArrayList(randomRuleVO.getRandomExpertIdStore());
                int randomIndex = (int)Math.floor(Math.random() * (double)expertIdStore.size());
                nExpertIdList.add(expertIdStore.get(randomIndex));
                oExpertIdList.add(expertIdStore.get(randomIndex));
                randomRuleVO.getRandomExpertIdStore().remove(expertIdStore.get(randomIndex));
            }
        }
        List expertIds = nExpertIdList.stream().map(v -> Long.valueOf(v)).distinct().collect(Collectors.toList());
        ArrayList<ExpertEntity> list = new ArrayList<ExpertEntity>();
        if (CollectionUtil.isNotEmpty(expertIds)) {
            expertLambda = Wrappers.lambdaQuery();
            expertLambda.in(ExpertEntity::getExpertId, expertIds);
            list.addAll(this.service.list((Wrapper)expertLambda));
        }
        if (nExpertIdList.size() < expertNum) {
            expertLambda = Wrappers.lambdaQuery();
            expertLambda.in(ExpertEntity::getBillState, new Object[]{1, 3});
            expertLambda.eq(ExpertEntity::getState, (Object)0);
            expertLambda.eq(ExpertEntity::getEmployeeType, (Object)1);
            if (CollectionUtil.isNotEmpty(oExpertIdList)) {
                expertLambda.notIn(ExpertEntity::getExpertId, (Collection)oExpertIdList.stream().map(v -> Long.valueOf(v)).distinct().collect(Collectors.toList()));
            }
            List<ExpertEntity> expertEntities = this.randomList(expertNum - nExpertIdList.size(), this.service.list((Wrapper)expertLambda));
            list.addAll(expertEntities);
        }
        return BeanMapper.mapList(list, ExpertVO.class);
    }

    public List<RandomRuleVO> randomPlus(Long inviteId, Integer inviteType) {
        this.logger.info("\u62db\u6807\u7acb\u9879id:{},\u7acb\u9879\u7c7b\u578b\uff1a{}", (Object)inviteId, (Object)inviteType);
        Long orgId = null;
        String contractType = "";
        String purchaseId = "";
        switch (inviteType) {
            case 5: {
                OtherInviteEntity inviteEntity = (OtherInviteEntity)((Object)this.otherInviteService.selectById(inviteId));
                this.logger.info(CommonUtils.getTypeName(inviteType) + "\u62db\u6807\u7acb\u9879\u6570\u636e:" + JSONObject.toJSONString((Object)((Object)inviteEntity)));
                orgId = inviteEntity.getParentOrgId() != null ? inviteEntity.getParentOrgId() : inviteEntity.getOrgId();
                break;
            }
            default: {
                throw new BusinessException("\u62db\u6807\u7acb\u9879\u7c7b\u578b\u4e0d\u5b58\u5728[" + inviteType + "]");
            }
        }
        if (null == orgId) {
            throw new BusinessException("\u672a\u83b7\u53d6\u5230\u62db\u6807\u7acb\u9879[" + inviteId + "]\u7c7b\u578b[" + CommonUtils.getTypeName(inviteType) + "]\u7684\u57fa\u5c42\u5355\u4f4did!");
        }
        this.logger.info("\u57fa\u5c42\u5355\u4f4did:{}", (Object)orgId);
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(RandomRuleEntity::getInviteType, (Object)inviteType);
        List randomRuleList = this.randomRuleService.list((Wrapper)wrapper);
        if (CollectionUtil.isEmpty((Collection)randomRuleList)) {
            throw new BusinessException("\u672a\u67e5\u8be2\u5230" + CommonUtils.getTypeName(inviteType) + "\u7c7b\u578b\u62bd\u53d6\u89c4\u5219\uff01");
        }
        List randomRuleVOList = BeanMapper.mapList((Iterable)randomRuleList, RandomRuleVO.class);
        ArrayList<RandomRuleVO> removeList = new ArrayList<RandomRuleVO>();
        for (RandomRuleVO randomRuleVO : randomRuleVOList) {
            if (RandomRuleVO.FLAG_NO.equals(randomRuleVO.getFlag())) {
                randomRuleVO.setTypeId(orgId);
            }
            if (RandomRuleVO.FLAG_YES.equals(randomRuleVO.getFiltrationFlag())) {
                block3 : switch (inviteType) {
                    case 0: {
                        if (!"\u8f85\u6599\u4e2d\u5fc3".equals(randomRuleVO.getFiltrationName()) || randomRuleVO.getFiltration().equals(contractType)) break;
                        removeList.add(randomRuleVO);
                        break;
                    }
                    case 1: {
                        break;
                    }
                    case 2: {
                        String[] split;
                        if (null == purchaseId) {
                            purchaseId = "";
                        }
                        if (!"\u673a\u68b0\u8bbe\u5907\u79df\u8d41\u5206\u516c\u53f8".equals(randomRuleVO.getFiltrationName())) break;
                        for (String s : split = randomRuleVO.getFiltration().split(",")) {
                            if (purchaseId.contains(s)) continue;
                            removeList.add(randomRuleVO);
                            break block3;
                        }
                        break;
                    }
                    case 3: {
                        String[] split;
                        if (!StringUtils.isNotBlank((CharSequence)purchaseId)) break;
                        for (String s : split = purchaseId.split(",")) {
                            if (purchaseId.contains(s) && "\u673a\u68b0\u8bbe\u5907\u79df\u8d41\u5206\u516c\u53f8".equals(randomRuleVO.getFiltrationName())) continue;
                            removeList.add(randomRuleVO);
                            break block3;
                        }
                        break;
                    }
                    case 4: {
                        break;
                    }
                    case 5: {
                        break;
                    }
                    default: {
                        throw new BusinessException("\u62db\u6807\u7acb\u9879\u7c7b\u578b\u4e0d\u5b58\u5728[" + inviteType + "]");
                    }
                }
            }
            switch (RandomRuleTypeEnum.getEnumByName((Integer)randomRuleVO.getType())) {
                case \u7ec4\u7ec7: {
                    randomRuleVO.setRandomExpertIdStore(this.getExpertIds(randomRuleVO.getTypeId()));
                    break;
                }
                case \u90e8\u95e8: {
                    randomRuleVO.setRandomExpertIdStore(this.getDeptExpertIds(randomRuleVO.getTypeId()));
                    break;
                }
                case \u9886\u57df: {
                    randomRuleVO.setRandomExpertIdStore(this.expertFieldDetailService.queryExpertIdsTwo(randomRuleVO.getTypeName()));
                }
            }
        }
        this.logger.info("\u62bd\u53d6\u89c4\u5219\u5220\u9664\uff1a" + JSONObject.toJSONString(removeList));
        randomRuleVOList.removeAll(removeList);
        this.logger.info("\u62bd\u53d6\u89c4\u5219\uff1a" + JSONObject.toJSONString((Object)randomRuleVOList));
        return randomRuleVOList;
    }

    @Override
    public List<String> checkOutPlus(List<ExpertVO> expertVOS, Long inviteId, Integer inviteType) {
        ArrayList<String> list = new ArrayList<String>();
        List<RandomRuleVO> randomRuleVOList = this.randomPlus(inviteId, inviteType);
        List oExpertIdList = expertVOS.stream().filter(item -> null != item.getExpertId()).map(item -> item.getExpertId().toString()).distinct().collect(Collectors.toList());
        for (RandomRuleVO randomRuleVO : randomRuleVOList) {
            for (String s : oExpertIdList) {
                if (!randomRuleVO.getRandomExpertIdStore().contains(s)) continue;
                randomRuleVO.getRandomExpertIdStore().remove(s);
                if (randomRuleVO.getNum() <= 0) continue;
                randomRuleVO.setNum(Integer.valueOf(randomRuleVO.getNum() - 1));
            }
            if (randomRuleVO.getNum() <= 0) continue;
            switch (RandomRuleTypeEnum.getEnumByName((Integer)randomRuleVO.getType())) {
                case \u7ec4\u7ec7: {
                    list.add("\u4e13\u5bb6\u6240\u5c5e\u7ec4\u7ec7\u4e3a\u201d" + randomRuleVO.getTypeName() + "\u201c\u7f3a\u5c11\u201d" + randomRuleVO.getNum() + "\u4eba");
                    break;
                }
                case \u90e8\u95e8: {
                    list.add("\u4e13\u5bb6\u6240\u5c5e\u90e8\u95e8\u4e3a\u201d" + randomRuleVO.getTypeName() + "\u201c\u7f3a\u5c11\u201d" + randomRuleVO.getNum() + "\u4eba");
                    break;
                }
                case \u9886\u57df: {
                    list.add("\u4e13\u5bb6\u4e13\u4e1a\u9886\u57df\u4e3a\u201d" + randomRuleVO.getTypeName() + "\u201c\u7f3a\u5c11\u201d" + randomRuleVO.getNum() + "\u4eba");
                }
            }
        }
        return list;
    }

    @Override
    public List<ExpertVO> randomSelectTwo(Integer expertNum, List<ExpertVO> expertVOS, Long inviteId) {
        LinkedHashMap<String, Integer> map = new LinkedHashMap<String, Integer>();
        HashMap<String, Map<String, String>> mapId = new HashMap<String, Map<String, String>>();
        ArrayList<String> olist = new ArrayList<String>();
        ArrayList nlist = new ArrayList();
        for (String s : map.keySet()) {
            while (nlist.size() < expertNum && (Integer)map.get(s) != 0 && ((Map)mapId.get(s)).size() != 0) {
                ArrayList strings = new ArrayList(((Map)mapId.get(s)).keySet());
                int randomIndex = (int)Math.floor(Math.random() * (double)strings.size());
                nlist.add(strings.get(randomIndex));
                olist.add((String)strings.get(randomIndex));
                this.updateCondition(map, olist, mapId);
            }
        }
        List expertIds = nlist.stream().map(v -> Long.valueOf(v)).distinct().collect(Collectors.toList());
        ArrayList<ExpertEntity> list = new ArrayList<ExpertEntity>();
        if (CollectionUtil.isNotEmpty(expertIds)) {
            LambdaQueryWrapper expertLambda = Wrappers.lambdaQuery();
            expertLambda.in(ExpertEntity::getExpertId, expertIds);
            list.addAll(this.service.list((Wrapper)expertLambda));
        }
        if (nlist.size() < expertNum) {
            LambdaQueryWrapper expertLambda2 = Wrappers.lambdaQuery();
            expertLambda2.in(ExpertEntity::getBillState, new Object[]{1, 3});
            expertLambda2.eq(ExpertEntity::getState, (Object)0);
            expertLambda2.eq(ExpertEntity::getEmployeeType, (Object)1);
            if (CollectionUtil.isNotEmpty(olist)) {
                expertLambda2.notIn(ExpertEntity::getExpertId, (Collection)olist.stream().map(v -> Long.valueOf(v)).distinct().collect(Collectors.toList()));
            }
            List<ExpertEntity> expertEntities = this.randomList(expertNum - nlist.size(), this.service.list((Wrapper)expertLambda2));
            list.addAll(expertEntities);
        }
        return BeanMapper.mapList(list, ExpertVO.class);
    }

    public Map updateCondition(Map<String, Integer> map, List<String> expertVOS, Map<String, Map<String, String>> mapId) {
        for (String s : map.keySet()) {
            if (map.get(s) == 0 || mapId.get(s).size() == 0) continue;
            for (String expertId : expertVOS) {
                if (!mapId.get(s).containsKey(expertId)) continue;
                if (map.get(s) != 0) {
                    map.put(s, map.get(s) - 1);
                }
                mapId.get(s).remove(expertId);
            }
        }
        return map;
    }

    @Override
    public List<String> checkout(List<ExpertVO> expertVOS, Long inviteId) {
        ArrayList<String> list = new ArrayList<String>();
        return list;
    }

    @Override
    public List<String> getExpertIds(Long parentOrgId) {
        if (null == parentOrgId) {
            return new ArrayList<String>();
        }
        CommonResponse response = this.iOrgApi.findChildrenByParentId(parentOrgId);
        ArrayList<Long> longs = new ArrayList<Long>();
        longs.add(parentOrgId);
        LambdaQueryWrapper expertLambda = Wrappers.lambdaQuery();
        expertLambda.in(ExpertEntity::getBillState, new Object[]{1, 3});
        expertLambda.eq(ExpertEntity::getState, (Object)0);
        expertLambda.eq(ExpertEntity::getEmployeeType, (Object)1);
        expertLambda.in(ExpertEntity::getUnitId, longs);
        List list = this.service.list((Wrapper)expertLambda);
        List<String> expertIds = list.stream().filter(item -> item.getExpertId() != null).map(item -> item.getExpertId().toString()).distinct().collect(Collectors.toList());
        return expertIds;
    }

    @Override
    public List<String> getDeptExpertIds(Long dept) {
        if (null == dept) {
            return new ArrayList<String>();
        }
        LambdaQueryWrapper expertLambda = Wrappers.lambdaQuery();
        expertLambda.in(ExpertEntity::getBillState, new Object[]{1, 3});
        expertLambda.eq(ExpertEntity::getState, (Object)0);
        expertLambda.eq(ExpertEntity::getEmployeeType, (Object)1);
        expertLambda.eq(ExpertEntity::getDeptId, (Object)dept);
        List list = this.service.list((Wrapper)expertLambda);
        List<String> expertIds = list.stream().filter(item -> item.getExpertId() != null).map(item -> item.getExpertId().toString()).distinct().collect(Collectors.toList());
        return expertIds;
    }

    @Override
    public List<ExpertVO> randomSelect(Integer expertNum, String fieldNames) {
        List<Long> expertIds;
        LambdaQueryWrapper expertLambda = Wrappers.lambdaQuery();
        if (fieldNames != null && CollectionUtil.isNotEmpty(expertIds = this.expertFieldDetailService.queryExpertIds(fieldNames))) {
            expertLambda.in(ExpertEntity::getExpertId, expertIds);
        }
        ArrayList<Integer> billStates = new ArrayList<Integer>();
        billStates.add(1);
        billStates.add(3);
        expertLambda.in(ExpertEntity::getBillState, billStates);
        expertLambda.eq(ExpertEntity::getState, (Object)0);
        expertLambda.eq(ExpertEntity::getEmployeeType, (Object)1);
        List list = this.service.list((Wrapper)expertLambda);
        List<ExpertEntity> expertEntities = this.randomList(expertNum, list);
        List expertVOS = BeanMapper.mapList(expertEntities, ExpertVO.class);
        return expertVOS;
    }

    @Override
    public IPage<ExpertVO> manualSelect(Integer pageNumber, Integer pageSize, String fieldNames, String searchObject, String searchText) {
        List<Long> expertIds;
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getFuzzyFields().add("expertName");
        param.getFuzzyFields().add("mobile");
        param.getFuzzyFields().add("unitName");
        param.getFuzzyFields().add("postName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (fieldNames != null && CollectionUtil.isNotEmpty(expertIds = this.expertFieldDetailService.queryExpertIds(fieldNames))) {
            param.getParams().put("expertId", new Parameter("in", expertIds));
        }
        ArrayList<Integer> billStates = new ArrayList<Integer>();
        billStates.add(1);
        billStates.add(3);
        param.getParams().put("state", new Parameter("eq", (Object)0));
        param.getParams().put("employeeType", new Parameter("eq", (Object)1));
        param.getParams().put("billState", new Parameter("in", billStates));
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), ExpertVO.class));
        return pageData;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public ExpertVO saveOrUpdate(ExpertVO saveOrUpdateVO) {
        ExpertEntity entity = (ExpertEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, ExpertEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if (!billCode.isSuccess()) throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            entity.setBillCode((String)billCode.getData());
            Boolean dislodge = this.service.dislodge(entity.getExpertId());
            if (dislodge == false) throw new BusinessException("\u4e13\u5bb6\u5df2\u5b58\u5728\uff01");
            entity.setOldExpertId(entity.getExpertId());
        } else if (!entity.getExpertId().equals(entity.getOldExpertId())) {
            Boolean dislodge = this.service.dislodge(entity.getExpertId());
            if (dislodge == false) throw new BusinessException("\u4e13\u5bb6\u5df2\u5b58\u5728\uff01");
            entity.setOldExpertId(entity.getExpertId());
        }
        switch (entity.getType()) {
            case 0: {
                entity.setTypeName("\u5546\u52a1\u4e13\u5bb6");
                break;
            }
            case 1: {
                entity.setTypeName("\u6280\u672f\u4e13\u5bb6");
                break;
            }
            case 2: {
                entity.setTypeName("\u5546\u52a1\u6280\u672f\u4e13\u5bb6");
            }
        }
        this.service.saveOrUpdate((Object)entity, false);
        this.expertFieldDetailService.saveOrUpdate(entity.getExpertId(), entity.getFieldName());
        return (ExpertVO)BeanMapper.map((Object)((Object)entity), ExpertVO.class);
    }

    @Override
    public Boolean bidEvaluation(Long id) {
        ExpertEntity expertEntity = (ExpertEntity)((Object)this.service.selectById(id));
        LambdaQueryWrapper lambda = Wrappers.lambdaQuery();
        lambda.eq(ExpertEvaluatingDetailEntity::getExpertId, (Object)expertEntity.getExpertId());
        lambda.in(ExpertEvaluatingDetailEntity::getEvaluationState, new Object[]{0, 3});
        List list = this.expertEvaluatingDetailService.list((Wrapper)lambda);
        if (CollectionUtil.isNotEmpty((Collection)list)) {
            return true;
        }
        return false;
    }

    public List<ExpertEntity> randomList(Integer value, List<ExpertEntity> list) {
        if (value < list.size()) {
            ArrayList<ExpertEntity> randList = new ArrayList<ExpertEntity>();
            HashMap<Integer, ExpertEntity> map = new HashMap<Integer, ExpertEntity>();
            while (map.size() < value) {
                int randomIndex = (int)Math.floor(Math.random() * (double)list.size());
                if (map.containsKey(randomIndex)) continue;
                map.put(randomIndex, list.get(randomIndex));
            }
            randList.addAll(map.values());
            return randList;
        }
        return list;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public List<ExpertVO> randomExpertForSupplier(RandomSupplierExpertVO randomExpertVO) {
        this.logger.info("\u968f\u673a\u83b7\u53d6\u4f9b\u5e94\u5546\u51c6\u5165\u8003\u5bdf\u4e13\u5bb6\uff0c\u53c2\u6570\uff1a{}", (Object)JSONObject.toJSONString((Object)randomExpertVO));
        res = new ArrayList<ExpertVO>();
        fieldNames = null;
        map = null;
        deptName = null;
        unitNameMap = null;
        var7_7 = randomExpertVO.getSupplierType();
        var8_8 = -1;
        switch (var7_7.hashCode()) {
            case 102727728: {
                if (!var7_7.equals("labor")) break;
                var8_8 = 0;
                break;
            }
            case 103658937: {
                if (!var7_7.equals("major")) break;
                var8_8 = 1;
                break;
            }
            case 106069776: {
                if (!var7_7.equals("other")) break;
                var8_8 = 2;
                break;
            }
            case 951516140: {
                if (!var7_7.equals("consult")) break;
                var8_8 = 3;
                break;
            }
            case 299066663: {
                if (!var7_7.equals("material")) break;
                var8_8 = 4;
                break;
            }
            case 1076356494: {
                if (!var7_7.equals("equipment")) break;
                var8_8 = 5;
                break;
            }
            case 1169539581: {
                if (!var7_7.equals("revolvMaterial")) break;
                var8_8 = 6;
            }
        }
        switch (var8_8) {
            case 0: 
            case 1: {
                fieldNames = new String[]{"\u751f\u4ea7\u7ba1\u7406\u7c7b", "\u65bd\u5de5\u6280\u672f\u53ca\u65bd\u5de5\u8d28\u91cf\u7ba1\u7406\u7c7b", "\u5b89\u5168\u53ca\u8bbe\u5907\u7ba1\u7406\u7c7b", "\u5de5\u7a0b\u7ecf\u6d4e\u7c7b"};
                map = new HashMap<K, V>();
                deptName = new ArrayList<E>();
                unitNameMap = new HashMap<K, V>();
                if (ListUtil.isNotEmpty((List)randomExpertVO.getExpertVOS())) {
                    for (ExpertVO expertVO : randomExpertVO.getExpertVOS()) {
                        for (String s : fieldNames) {
                            if (!expertVO.getFieldName().contains(s)) continue;
                            ex = map.computeIfAbsent(s, (Function<String, List>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$randomExpertForSupplier$12(java.lang.String ), (Ljava/lang/String;)Ljava/util/List;)());
                            ex.add(expertVO.getExpertId() + "");
                        }
                        if ("\u6210\u672c\u5408\u7ea6\u90e8".equals(expertVO.getDeptName())) {
                            deptName.add(expertVO.getExpertId() + "");
                        }
                        if (!StringUtils.isNotEmpty((CharSequence)expertVO.getUnitName())) continue;
                        unitNameMap.computeIfAbsent(expertVO.getUnitName(), (Function<String, List>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$randomExpertForSupplier$13(java.lang.String ), (Ljava/lang/String;)Ljava/util/List;)()).add(expertVO.getExpertId() + "");
                    }
                }
                for (String s : fieldNames) {
                    if (map.get(s) != null && ((List)map.get(s)).size() != 0 || res.size() > randomExpertVO.getExpertNum() - 1 || !ListUtil.isNotEmpty(select = this.randomSelect(1, s))) continue;
                    res.addAll(select);
                    randomExpertVO.setExpertNum(Integer.valueOf(randomExpertVO.getExpertNum() - 1));
                    if ("\u6210\u672c\u5408\u7ea6\u90e8".equals(select.get(0).getDeptName())) {
                        deptName.add(select.get(0).getExpertId() + "");
                    }
                    if (!StringUtils.isNotEmpty((CharSequence)select.get(0).getUnitName())) continue;
                    unitNameMap.computeIfAbsent(select.get(0).getUnitName(), (Function<String, List>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$randomExpertForSupplier$14(java.lang.String ), (Ljava/lang/String;)Ljava/util/List;)()).add(select.get(0).getExpertId() + "");
                }
                if (randomExpertVO.getExpertNum() > 0 && ListUtil.isEmpty(deptName)) {
                    expertLambda2 = Wrappers.lambdaQuery();
                    expertLambda2.in((Object)(SFunction & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, getBillState(), (Lcom/ejianc/business/tender/expert/bean/ExpertEntity;)Ljava/lang/Object;)(), new Object[]{1, 3});
                    expertLambda2.eq((Object)(SFunction & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, getState(), (Lcom/ejianc/business/tender/expert/bean/ExpertEntity;)Ljava/lang/Object;)(), (Object)0);
                    expertLambda2.eq((Object)(SFunction & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, getDeptName(), (Lcom/ejianc/business/tender/expert/bean/ExpertEntity;)Ljava/lang/Object;)(), (Object)"\u6210\u672c\u5408\u7ea6\u90e8");
                    expertEntities = this.randomList(1, this.service.list((Wrapper)expertLambda2));
                    if (ListUtil.isNotEmpty(expertEntities)) {
                        randomExpertVO.setExpertNum(Integer.valueOf(randomExpertVO.getExpertNum() - 1));
                        res.addAll(BeanMapper.mapList(expertEntities, ExpertVO.class));
                        unitNameMap.computeIfAbsent(expertEntities.get(0).getUnitName(), (Function<String, List>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$randomExpertForSupplier$15(java.lang.String ), (Ljava/lang/String;)Ljava/util/List;)()).add(expertEntities.get(0).getExpertId() + "");
                    }
                }
                if (randomExpertVO.getExpertNum() <= 0) ** GOTO lbl118
                response = this.iOrgApi.getOneById(randomExpertVO.getApplyOrgId());
                orgVO = null;
                need = true;
                if (!response.isSuccess()) ** GOTO lbl103
                orgVO = (OrgVO)response.getData();
                if (orgVO.getOrgType() != 1 && orgVO.getOrgType() != 2) ** GOTO lbl95
                if (!ListUtil.isNotEmpty((List)((List)unitNameMap.get(orgVO.getShortName())))) ** GOTO lbl103
                need = false;
                ** GOTO lbl103
lbl95:
                // 1 sources

                innerCode = orgVO.getInnerCode();
                parentIds = innerCode.split("\\|");
                for (i = parentIds.length - 2; i >= 0; --i) {
                    response = this.iOrgApi.getOneById(Long.valueOf(parentIds[i]));
                    if (!response.isSuccess() || (orgVO = (OrgVO)response.getData()).getOrgType() != 1 && orgVO.getOrgType() != 2) continue;
                    if (!ListUtil.isNotEmpty((List)((List)unitNameMap.get(orgVO.getShortName())))) break;
                    need = false;
                    break;
                }
lbl103:
                // 6 sources

                if (need && orgVO != null) {
                    expertLambda2 = Wrappers.lambdaQuery();
                    expertLambda2.in((Object)(SFunction & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, getBillState(), (Lcom/ejianc/business/tender/expert/bean/ExpertEntity;)Ljava/lang/Object;)(), new Object[]{1, 3});
                    expertLambda2.eq((Object)(SFunction & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, getState(), (Lcom/ejianc/business/tender/expert/bean/ExpertEntity;)Ljava/lang/Object;)(), (Object)0);
                    expertLambda2.eq((Object)(SFunction & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, getUnitName(), (Lcom/ejianc/business/tender/expert/bean/ExpertEntity;)Ljava/lang/Object;)(), (Object)orgVO.getShortName());
                    expertEntities = this.randomList(1, this.service.list((Wrapper)expertLambda2));
                    if (ListUtil.isNotEmpty(expertEntities)) {
                        randomExpertVO.setExpertNum(Integer.valueOf(randomExpertVO.getExpertNum() - 1));
                        res.addAll(BeanMapper.mapList(expertEntities, ExpertVO.class));
                        unitNameMap.computeIfAbsent(expertEntities.get(0).getUnitName(), (Function<String, List>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$randomExpertForSupplier$16(java.lang.String ), (Ljava/lang/String;)Ljava/util/List;)()).add(expertEntities.get(0).getExpertId() + "");
                    }
                }
lbl118:
                // 6 sources

                if (randomExpertVO.getExpertNum() <= 0) break;
                expertLambda2 = Wrappers.lambdaQuery();
                expertLambda2.in((Object)(SFunction & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, getBillState(), (Lcom/ejianc/business/tender/expert/bean/ExpertEntity;)Ljava/lang/Object;)(), new Object[]{1, 3});
                expertLambda2.eq((Object)(SFunction & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, getState(), (Lcom/ejianc/business/tender/expert/bean/ExpertEntity;)Ljava/lang/Object;)(), (Object)0);
                ids = randomExpertVO.getExpertVOS() == null ? new ArrayList<E>() : randomExpertVO.getExpertVOS().stream().map((Function<ExpertVO, Long>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, getExpertId(), (Lcom/ejianc/business/tender/expert/vo/ExpertVO;)Ljava/lang/Long;)()).distinct().collect(Collectors.toList());
                ids.addAll(res.stream().map((Function<ExpertVO, Long>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, getExpertId(), (Lcom/ejianc/business/tender/expert/vo/ExpertVO;)Ljava/lang/Long;)()).distinct().collect(Collectors.toList()));
                if (ListUtil.isNotEmpty(ids)) {
                    expertLambda2.notIn((Object)(SFunction & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, getExpertId(), (Lcom/ejianc/business/tender/expert/bean/ExpertEntity;)Ljava/lang/Object;)(), (Collection)ids.stream().distinct().collect(Collectors.toList()));
                }
                expertEntities = this.randomList(randomExpertVO.getExpertNum(), this.service.list((Wrapper)expertLambda2));
                res.addAll(BeanMapper.mapList(expertEntities, ExpertVO.class));
                break;
            }
            case 2: 
            case 3: {
                unitNameMap = new HashMap<String, List>();
                if (ListUtil.isNotEmpty((List)randomExpertVO.getExpertVOS())) {
                    for (ExpertVO expertVO : randomExpertVO.getExpertVOS()) {
                        if (!StringUtils.isNotEmpty((CharSequence)expertVO.getUnitName())) continue;
                        unitNameMap.computeIfAbsent(expertVO.getUnitName(), (Function<String, List>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$randomExpertForSupplier$17(java.lang.String ), (Ljava/lang/String;)Ljava/util/List;)()).add(expertVO.getExpertId() + "");
                    }
                }
                if (randomExpertVO.getExpertNum() <= 0) ** GOTO lbl175
                response = this.iOrgApi.getOneById(randomExpertVO.getApplyOrgId());
                orgVO = null;
                need = true;
                if (!response.isSuccess()) ** GOTO lbl160
                orgVO = (OrgVO)response.getData();
                if (orgVO.getOrgType() != 1 && orgVO.getOrgType() != 2) ** GOTO lbl152
                if (!ListUtil.isNotEmpty((List)((List)unitNameMap.get(orgVO.getShortName())))) ** GOTO lbl160
                need = false;
                ** GOTO lbl160
lbl152:
                // 1 sources

                innerCode = orgVO.getInnerCode();
                parentIds = innerCode.split("\\|");
                for (i = parentIds.length - 2; i >= 0; --i) {
                    response = this.iOrgApi.getOneById(Long.valueOf(parentIds[i]));
                    if (!response.isSuccess() || (orgVO = (OrgVO)response.getData()).getOrgType() != 1 && orgVO.getOrgType() != 2) continue;
                    if (!ListUtil.isNotEmpty((List)((List)unitNameMap.get(orgVO.getShortName())))) break;
                    need = false;
                    break;
                }
lbl160:
                // 6 sources

                if (need && orgVO != null) {
                    expertLambda2 = Wrappers.lambdaQuery();
                    expertLambda2.in((Object)(SFunction & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, getBillState(), (Lcom/ejianc/business/tender/expert/bean/ExpertEntity;)Ljava/lang/Object;)(), new Object[]{1, 3});
                    expertLambda2.eq((Object)(SFunction & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, getState(), (Lcom/ejianc/business/tender/expert/bean/ExpertEntity;)Ljava/lang/Object;)(), (Object)0);
                    expertLambda2.eq((Object)(SFunction & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, getUnitName(), (Lcom/ejianc/business/tender/expert/bean/ExpertEntity;)Ljava/lang/Object;)(), (Object)orgVO.getShortName());
                    expertEntities = this.randomList(1, this.service.list((Wrapper)expertLambda2));
                    if (ListUtil.isNotEmpty(expertEntities)) {
                        randomExpertVO.setExpertNum(Integer.valueOf(randomExpertVO.getExpertNum() - 1));
                        res.addAll(BeanMapper.mapList(expertEntities, ExpertVO.class));
                        unitNameMap.computeIfAbsent(expertEntities.get(0).getUnitName(), (Function<String, List>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$randomExpertForSupplier$18(java.lang.String ), (Ljava/lang/String;)Ljava/util/List;)()).add(expertEntities.get(0).getExpertId() + "");
                    }
                }
lbl175:
                // 6 sources

                if (randomExpertVO.getExpertNum() <= 0) break;
                expertLambda2 = Wrappers.lambdaQuery();
                expertLambda2.in((Object)(SFunction & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, getBillState(), (Lcom/ejianc/business/tender/expert/bean/ExpertEntity;)Ljava/lang/Object;)(), new Object[]{1, 3});
                expertLambda2.eq((Object)(SFunction & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, getState(), (Lcom/ejianc/business/tender/expert/bean/ExpertEntity;)Ljava/lang/Object;)(), (Object)0);
                ids = randomExpertVO.getExpertVOS() == null ? new ArrayList<E>() : randomExpertVO.getExpertVOS().stream().map((Function<ExpertVO, Long>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, getExpertId(), (Lcom/ejianc/business/tender/expert/vo/ExpertVO;)Ljava/lang/Long;)()).distinct().collect(Collectors.toList());
                ids.addAll(res.stream().map((Function<ExpertVO, Long>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, getExpertId(), (Lcom/ejianc/business/tender/expert/vo/ExpertVO;)Ljava/lang/Long;)()).distinct().collect(Collectors.toList()));
                if (ListUtil.isNotEmpty(ids)) {
                    expertLambda2.notIn((Object)(SFunction & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, getExpertId(), (Lcom/ejianc/business/tender/expert/bean/ExpertEntity;)Ljava/lang/Object;)(), (Collection)ids.stream().distinct().collect(Collectors.toList()));
                }
                expertEntities = this.randomList(randomExpertVO.getExpertNum(), this.service.list((Wrapper)expertLambda2));
                res.addAll(BeanMapper.mapList(expertEntities, ExpertVO.class));
                break;
            }
            case 4: {
                fieldNames = new String[]{"\u7269\u8d44\u7c7b", "\u65bd\u5de5\u6280\u672f\u53ca\u65bd\u5de5\u8d28\u91cf\u7ba1\u7406\u7c7b", "\u5de5\u7a0b\u7ecf\u6d4e\u7c7b"};
                map = new HashMap<String, List>();
                deptName = new ArrayList<String>();
                unitNameMap = new HashMap<K, V>();
                if (ListUtil.isNotEmpty((List)randomExpertVO.getExpertVOS())) {
                    for (ExpertVO expertVO : randomExpertVO.getExpertVOS()) {
                        for (String s : fieldNames) {
                            if (!expertVO.getFieldName().contains(s)) continue;
                            ex = map.computeIfAbsent(s, (Function<String, List>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$randomExpertForSupplier$19(java.lang.String ), (Ljava/lang/String;)Ljava/util/List;)());
                            ex.add(expertVO.getExpertId() + "");
                        }
                        if ("\u7edf\u8d2d\u4e2d\u5fc3".equals(expertVO.getDeptName())) {
                            deptName.add(expertVO.getExpertId() + "");
                        }
                        if (!StringUtils.isNotEmpty((CharSequence)expertVO.getUnitName())) continue;
                        unitNameMap.computeIfAbsent(expertVO.getUnitName(), (Function<String, List>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$randomExpertForSupplier$20(java.lang.String ), (Ljava/lang/String;)Ljava/util/List;)()).add(expertVO.getExpertId() + "");
                    }
                }
                for (String s : fieldNames) {
                    if (map.get(s) != null && ((List)map.get(s)).size() != 0 || res.size() > randomExpertVO.getExpertNum() - ("\u7269\u8d44\u7c7b".equals(s) != false ? 2 : 1)) continue;
                    v0 = select = "\u7269\u8d44\u7c7b".equals(s) != false ? this.randomSelect(2, s) : this.randomSelect(1, s);
                    if (!ListUtil.isNotEmpty(select)) continue;
                    res.addAll(select);
                    for (ExpertVO expertVO : select) {
                        randomExpertVO.setExpertNum(Integer.valueOf(randomExpertVO.getExpertNum() - 1));
                        if ("\u7edf\u8d2d\u4e2d\u5fc3".equals(expertVO.getDeptName())) {
                            deptName.add(expertVO.getExpertId() + "");
                        }
                        if (!StringUtils.isNotEmpty((CharSequence)expertVO.getUnitName())) continue;
                        unitNameMap.computeIfAbsent(expertVO.getUnitName(), (Function<String, List>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$randomExpertForSupplier$21(java.lang.String ), (Ljava/lang/String;)Ljava/util/List;)()).add(expertVO.getExpertId() + "");
                    }
                }
                if (randomExpertVO.getExpertNum() > 0 && ListUtil.isEmpty(deptName)) {
                    expertLambda2 = Wrappers.lambdaQuery();
                    expertLambda2.in((Object)(SFunction & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, getBillState(), (Lcom/ejianc/business/tender/expert/bean/ExpertEntity;)Ljava/lang/Object;)(), new Object[]{1, 3});
                    expertLambda2.eq((Object)(SFunction & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, getState(), (Lcom/ejianc/business/tender/expert/bean/ExpertEntity;)Ljava/lang/Object;)(), (Object)0);
                    expertLambda2.eq((Object)(SFunction & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, getDeptName(), (Lcom/ejianc/business/tender/expert/bean/ExpertEntity;)Ljava/lang/Object;)(), (Object)"\u7edf\u8d2d\u4e2d\u5fc3");
                    expertEntities = this.randomList(1, this.service.list((Wrapper)expertLambda2));
                    if (ListUtil.isNotEmpty(expertEntities)) {
                        randomExpertVO.setExpertNum(Integer.valueOf(randomExpertVO.getExpertNum() - 1));
                        res.addAll(BeanMapper.mapList(expertEntities, ExpertVO.class));
                        unitNameMap.computeIfAbsent(expertEntities.get(0).getUnitName(), (Function<String, List>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$randomExpertForSupplier$22(java.lang.String ), (Ljava/lang/String;)Ljava/util/List;)()).add(expertEntities.get(0).getExpertId() + "");
                    }
                }
                if (randomExpertVO.getExpertNum() <= 0) ** GOTO lbl275
                response = this.iOrgApi.getOneById(randomExpertVO.getApplyOrgId());
                orgVO = null;
                need = true;
                if (!response.isSuccess()) ** GOTO lbl260
                orgVO = (OrgVO)response.getData();
                if (orgVO.getOrgType() != 1 && orgVO.getOrgType() != 2) ** GOTO lbl252
                if (!ListUtil.isNotEmpty((List)((List)unitNameMap.get(orgVO.getShortName())))) ** GOTO lbl260
                need = false;
                ** GOTO lbl260
lbl252:
                // 1 sources

                innerCode = orgVO.getInnerCode();
                parentIds = innerCode.split("\\|");
                for (i = parentIds.length - 2; i >= 0; --i) {
                    response = this.iOrgApi.getOneById(Long.valueOf(parentIds[i]));
                    if (!response.isSuccess() || (orgVO = (OrgVO)response.getData()).getOrgType() != 1 && orgVO.getOrgType() != 2) continue;
                    if (!ListUtil.isNotEmpty((List)((List)unitNameMap.get(orgVO.getShortName())))) break;
                    need = false;
                    break;
                }
lbl260:
                // 6 sources

                if (need && orgVO != null) {
                    expertLambda2 = Wrappers.lambdaQuery();
                    expertLambda2.in((Object)(SFunction & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, getBillState(), (Lcom/ejianc/business/tender/expert/bean/ExpertEntity;)Ljava/lang/Object;)(), new Object[]{1, 3});
                    expertLambda2.eq((Object)(SFunction & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, getState(), (Lcom/ejianc/business/tender/expert/bean/ExpertEntity;)Ljava/lang/Object;)(), (Object)0);
                    expertLambda2.eq((Object)(SFunction & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, getUnitName(), (Lcom/ejianc/business/tender/expert/bean/ExpertEntity;)Ljava/lang/Object;)(), (Object)orgVO.getShortName());
                    expertEntities = this.randomList(1, this.service.list((Wrapper)expertLambda2));
                    if (ListUtil.isNotEmpty(expertEntities)) {
                        randomExpertVO.setExpertNum(Integer.valueOf(randomExpertVO.getExpertNum() - 1));
                        res.addAll(BeanMapper.mapList(expertEntities, ExpertVO.class));
                        unitNameMap.computeIfAbsent(expertEntities.get(0).getUnitName(), (Function<String, List>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$randomExpertForSupplier$23(java.lang.String ), (Ljava/lang/String;)Ljava/util/List;)()).add(expertEntities.get(0).getExpertId() + "");
                    }
                }
lbl275:
                // 6 sources

                if (randomExpertVO.getExpertNum() <= 0) break;
                expertLambda2 = Wrappers.lambdaQuery();
                expertLambda2.in((Object)(SFunction & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, getBillState(), (Lcom/ejianc/business/tender/expert/bean/ExpertEntity;)Ljava/lang/Object;)(), new Object[]{1, 3});
                expertLambda2.eq((Object)(SFunction & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, getState(), (Lcom/ejianc/business/tender/expert/bean/ExpertEntity;)Ljava/lang/Object;)(), (Object)0);
                ids = randomExpertVO.getExpertVOS() == null ? new ArrayList<E>() : randomExpertVO.getExpertVOS().stream().map((Function<ExpertVO, Long>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, getExpertId(), (Lcom/ejianc/business/tender/expert/vo/ExpertVO;)Ljava/lang/Long;)()).distinct().collect(Collectors.toList());
                ids.addAll(res.stream().map((Function<ExpertVO, Long>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, getExpertId(), (Lcom/ejianc/business/tender/expert/vo/ExpertVO;)Ljava/lang/Long;)()).distinct().collect(Collectors.toList()));
                if (ListUtil.isNotEmpty(ids)) {
                    expertLambda2.notIn((Object)(SFunction & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, getExpertId(), (Lcom/ejianc/business/tender/expert/bean/ExpertEntity;)Ljava/lang/Object;)(), (Collection)ids.stream().distinct().collect(Collectors.toList()));
                }
                expertEntities = this.randomList(randomExpertVO.getExpertNum(), this.service.list((Wrapper)expertLambda2));
                res.addAll(BeanMapper.mapList(expertEntities, ExpertVO.class));
                break;
            }
            case 5: {
                fieldNames = new String[]{"\u5b89\u5168\u53ca\u8bbe\u5907\u7ba1\u7406\u7c7b", "\u65bd\u5de5\u6280\u672f\u53ca\u65bd\u5de5\u8d28\u91cf\u7ba1\u7406\u7c7b", "\u5de5\u7a0b\u7ecf\u6d4e\u7c7b"};
                map = new HashMap<K, V>();
                deptName = new ArrayList<E>();
                unitNameMap = new HashMap<K, V>();
                if (ListUtil.isNotEmpty((List)randomExpertVO.getExpertVOS())) {
                    for (ExpertVO expertVO : randomExpertVO.getExpertVOS()) {
                        for (String s : fieldNames) {
                            if (!expertVO.getFieldName().contains(s)) continue;
                            ex = map.computeIfAbsent(s, (Function<String, List>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$randomExpertForSupplier$24(java.lang.String ), (Ljava/lang/String;)Ljava/util/List;)());
                            ex.add(expertVO.getExpertId() + "");
                        }
                        if ("\u5b89\u5168\u76d1\u7763\u7ba1\u7406\u90e8".equals(expertVO.getDeptName())) {
                            deptName.add(expertVO.getExpertId() + "");
                        }
                        if (!StringUtils.isNotEmpty((CharSequence)expertVO.getUnitName())) continue;
                        unitNameMap.computeIfAbsent(expertVO.getUnitName(), (Function<String, List>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$randomExpertForSupplier$25(java.lang.String ), (Ljava/lang/String;)Ljava/util/List;)()).add(expertVO.getExpertId() + "");
                    }
                }
                for (String s : fieldNames) {
                    if (map.get(s) != null && ((List)map.get(s)).size() != 0 || res.size() > randomExpertVO.getExpertNum() - ("\u5b89\u5168\u53ca\u8bbe\u5907\u7ba1\u7406\u7c7b".equals(s) != false ? 2 : 1)) continue;
                    v1 = select = "\u5b89\u5168\u53ca\u8bbe\u5907\u7ba1\u7406\u7c7b".equals(s) != false ? this.randomSelect(2, s) : this.randomSelect(1, s);
                    if (!ListUtil.isNotEmpty(select)) continue;
                    res.addAll(select);
                    for (ExpertVO expertVO : select) {
                        randomExpertVO.setExpertNum(Integer.valueOf(randomExpertVO.getExpertNum() - 1));
                        if ("\u5b89\u5168\u76d1\u7763\u7ba1\u7406\u90e8".equals(expertVO.getDeptName())) {
                            deptName.add(expertVO.getExpertId() + "");
                        }
                        if (!StringUtils.isNotEmpty((CharSequence)expertVO.getUnitName())) continue;
                        unitNameMap.computeIfAbsent(expertVO.getUnitName(), (Function<String, List>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$randomExpertForSupplier$26(java.lang.String ), (Ljava/lang/String;)Ljava/util/List;)()).add(expertVO.getExpertId() + "");
                    }
                }
                if (randomExpertVO.getExpertNum() > 0 && ListUtil.isEmpty(deptName)) {
                    expertLambda2 = Wrappers.lambdaQuery();
                    expertLambda2.in((Object)(SFunction & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, getBillState(), (Lcom/ejianc/business/tender/expert/bean/ExpertEntity;)Ljava/lang/Object;)(), new Object[]{1, 3});
                    expertLambda2.eq((Object)(SFunction & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, getState(), (Lcom/ejianc/business/tender/expert/bean/ExpertEntity;)Ljava/lang/Object;)(), (Object)0);
                    expertLambda2.eq((Object)(SFunction & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, getDeptName(), (Lcom/ejianc/business/tender/expert/bean/ExpertEntity;)Ljava/lang/Object;)(), (Object)"\u5b89\u5168\u76d1\u7763\u7ba1\u7406\u90e8");
                    expertEntities = this.randomList(1, this.service.list((Wrapper)expertLambda2));
                    if (ListUtil.isNotEmpty(expertEntities)) {
                        randomExpertVO.setExpertNum(Integer.valueOf(randomExpertVO.getExpertNum() - 1));
                        res.addAll(BeanMapper.mapList(expertEntities, ExpertVO.class));
                        unitNameMap.computeIfAbsent(expertEntities.get(0).getUnitName(), (Function<String, List>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$randomExpertForSupplier$27(java.lang.String ), (Ljava/lang/String;)Ljava/util/List;)()).add(expertEntities.get(0).getExpertId() + "");
                    }
                }
                if (randomExpertVO.getExpertNum() <= 0) ** GOTO lbl375
                response = this.iOrgApi.getOneById(randomExpertVO.getApplyOrgId());
                orgVO = null;
                need = true;
                if (!response.isSuccess()) ** GOTO lbl360
                orgVO = (OrgVO)response.getData();
                if (orgVO.getOrgType() != 1 && orgVO.getOrgType() != 2) ** GOTO lbl352
                if (!ListUtil.isNotEmpty((List)((List)unitNameMap.get(orgVO.getShortName())))) ** GOTO lbl360
                need = false;
                ** GOTO lbl360
lbl352:
                // 1 sources

                innerCode = orgVO.getInnerCode();
                parentIds = innerCode.split("\\|");
                for (i = parentIds.length - 2; i >= 0; --i) {
                    response = this.iOrgApi.getOneById(Long.valueOf(parentIds[i]));
                    if (!response.isSuccess() || (orgVO = (OrgVO)response.getData()).getOrgType() != 1 && orgVO.getOrgType() != 2) continue;
                    if (!ListUtil.isNotEmpty((List)((List)unitNameMap.get(orgVO.getShortName())))) break;
                    need = false;
                    break;
                }
lbl360:
                // 6 sources

                if (need && orgVO != null) {
                    expertLambda2 = Wrappers.lambdaQuery();
                    expertLambda2.in((Object)(SFunction & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, getBillState(), (Lcom/ejianc/business/tender/expert/bean/ExpertEntity;)Ljava/lang/Object;)(), new Object[]{1, 3});
                    expertLambda2.eq((Object)(SFunction & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, getState(), (Lcom/ejianc/business/tender/expert/bean/ExpertEntity;)Ljava/lang/Object;)(), (Object)0);
                    expertLambda2.eq((Object)(SFunction & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, getUnitName(), (Lcom/ejianc/business/tender/expert/bean/ExpertEntity;)Ljava/lang/Object;)(), (Object)orgVO.getShortName());
                    expertEntities = this.randomList(1, this.service.list((Wrapper)expertLambda2));
                    if (ListUtil.isNotEmpty(expertEntities)) {
                        randomExpertVO.setExpertNum(Integer.valueOf(randomExpertVO.getExpertNum() - 1));
                        res.addAll(BeanMapper.mapList(expertEntities, ExpertVO.class));
                        unitNameMap.computeIfAbsent(expertEntities.get(0).getUnitName(), (Function<String, List>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$randomExpertForSupplier$28(java.lang.String ), (Ljava/lang/String;)Ljava/util/List;)()).add(expertEntities.get(0).getExpertId() + "");
                    }
                }
lbl375:
                // 6 sources

                if (randomExpertVO.getExpertNum() > 0 && randomExpertVO.getSupplyContent().booleanValue() && ListUtil.isEmpty((List)((List)unitNameMap.get("\u673a\u68b0\u8bbe\u5907\u79df\u8d41\u516c\u53f8")))) {
                    expertLambda2 = Wrappers.lambdaQuery();
                    expertLambda2.in((Object)(SFunction & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, getBillState(), (Lcom/ejianc/business/tender/expert/bean/ExpertEntity;)Ljava/lang/Object;)(), new Object[]{1, 3});
                    expertLambda2.eq((Object)(SFunction & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, getState(), (Lcom/ejianc/business/tender/expert/bean/ExpertEntity;)Ljava/lang/Object;)(), (Object)0);
                    expertLambda2.eq((Object)(SFunction & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, getUnitName(), (Lcom/ejianc/business/tender/expert/bean/ExpertEntity;)Ljava/lang/Object;)(), (Object)"\u673a\u68b0\u8bbe\u5907\u79df\u8d41\u516c\u53f8");
                    expertEntities = this.randomList(1, this.service.list((Wrapper)expertLambda2));
                    if (ListUtil.isNotEmpty(expertEntities)) {
                        randomExpertVO.setExpertNum(Integer.valueOf(randomExpertVO.getExpertNum() - 1));
                        res.addAll(BeanMapper.mapList(expertEntities, ExpertVO.class));
                        unitNameMap.computeIfAbsent(expertEntities.get(0).getUnitName(), (Function<String, List>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$randomExpertForSupplier$29(java.lang.String ), (Ljava/lang/String;)Ljava/util/List;)()).add(expertEntities.get(0).getExpertId() + "");
                    }
                }
                if (randomExpertVO.getExpertNum() <= 0) break;
                expertLambda2 = Wrappers.lambdaQuery();
                expertLambda2.in((Object)(SFunction & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, getBillState(), (Lcom/ejianc/business/tender/expert/bean/ExpertEntity;)Ljava/lang/Object;)(), new Object[]{1, 3});
                expertLambda2.eq((Object)(SFunction & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, getState(), (Lcom/ejianc/business/tender/expert/bean/ExpertEntity;)Ljava/lang/Object;)(), (Object)0);
                ids = randomExpertVO.getExpertVOS() == null ? new ArrayList<E>() : randomExpertVO.getExpertVOS().stream().map((Function<ExpertVO, Long>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, getExpertId(), (Lcom/ejianc/business/tender/expert/vo/ExpertVO;)Ljava/lang/Long;)()).distinct().collect(Collectors.toList());
                ids.addAll(res.stream().map((Function<ExpertVO, Long>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, getExpertId(), (Lcom/ejianc/business/tender/expert/vo/ExpertVO;)Ljava/lang/Long;)()).distinct().collect(Collectors.toList()));
                if (ListUtil.isNotEmpty(ids)) {
                    expertLambda2.notIn((Object)(SFunction & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, getExpertId(), (Lcom/ejianc/business/tender/expert/bean/ExpertEntity;)Ljava/lang/Object;)(), (Collection)ids.stream().distinct().collect(Collectors.toList()));
                }
                expertEntities = this.randomList(randomExpertVO.getExpertNum(), this.service.list((Wrapper)expertLambda2));
                res.addAll(BeanMapper.mapList(expertEntities, ExpertVO.class));
                break;
            }
            case 6: {
                fieldNames = new String[]{"\u7269\u8d44\u7c7b", "\u65bd\u5de5\u6280\u672f\u53ca\u65bd\u5de5\u8d28\u91cf\u7ba1\u7406\u7c7b", "\u5de5\u7a0b\u7ecf\u6d4e\u7c7b"};
                map = new HashMap<K, V>();
                deptName = new ArrayList<E>();
                unitNameMap = new HashMap<K, V>();
                if (ListUtil.isNotEmpty((List)randomExpertVO.getExpertVOS())) {
                    for (ExpertVO expertVO : randomExpertVO.getExpertVOS()) {
                        for (String s : fieldNames) {
                            if (!expertVO.getFieldName().contains(s)) continue;
                            ex = map.computeIfAbsent(s, (Function<String, List>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$randomExpertForSupplier$30(java.lang.String ), (Ljava/lang/String;)Ljava/util/List;)());
                            ex.add(expertVO.getExpertId() + "");
                        }
                        if ("\u7edf\u8d2d\u4e2d\u5fc3".equals(expertVO.getDeptName())) {
                            deptName.add(expertVO.getExpertId() + "");
                        }
                        if (!StringUtils.isNotEmpty((CharSequence)expertVO.getUnitName())) continue;
                        unitNameMap.computeIfAbsent(expertVO.getUnitName(), (Function<String, List>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$randomExpertForSupplier$31(java.lang.String ), (Ljava/lang/String;)Ljava/util/List;)()).add(expertVO.getExpertId() + "");
                    }
                }
                for (String s : fieldNames) {
                    if (map.get(s) != null && ((List)map.get(s)).size() != 0 || res.size() > randomExpertVO.getExpertNum() - ("\u7269\u8d44\u7c7b".equals(s) != false ? 2 : 1)) continue;
                    v2 = select = "\u7269\u8d44\u7c7b".equals(s) != false ? this.randomSelect(2, s) : this.randomSelect(1, s);
                    if (!ListUtil.isNotEmpty(select)) continue;
                    res.addAll(select);
                    for (ExpertVO expertVO : select) {
                        randomExpertVO.setExpertNum(Integer.valueOf(randomExpertVO.getExpertNum() - 1));
                        if ("\u7edf\u8d2d\u4e2d\u5fc3".equals(expertVO.getDeptName())) {
                            deptName.add(expertVO.getExpertId() + "");
                        }
                        if (!StringUtils.isNotEmpty((CharSequence)expertVO.getUnitName())) continue;
                        unitNameMap.computeIfAbsent(expertVO.getUnitName(), (Function<String, List>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$randomExpertForSupplier$32(java.lang.String ), (Ljava/lang/String;)Ljava/util/List;)()).add(expertVO.getExpertId() + "");
                    }
                }
                if (randomExpertVO.getExpertNum() > 0 && ListUtil.isEmpty(deptName)) {
                    expertLambda2 = Wrappers.lambdaQuery();
                    expertLambda2.in((Object)(SFunction & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, getBillState(), (Lcom/ejianc/business/tender/expert/bean/ExpertEntity;)Ljava/lang/Object;)(), new Object[]{1, 3});
                    expertLambda2.eq((Object)(SFunction & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, getState(), (Lcom/ejianc/business/tender/expert/bean/ExpertEntity;)Ljava/lang/Object;)(), (Object)0);
                    expertLambda2.eq((Object)(SFunction & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, getDeptName(), (Lcom/ejianc/business/tender/expert/bean/ExpertEntity;)Ljava/lang/Object;)(), (Object)"\u7edf\u8d2d\u4e2d\u5fc3");
                    expertEntities = this.randomList(1, this.service.list((Wrapper)expertLambda2));
                    if (ListUtil.isNotEmpty(expertEntities)) {
                        randomExpertVO.setExpertNum(Integer.valueOf(randomExpertVO.getExpertNum() - 1));
                        res.addAll(BeanMapper.mapList(expertEntities, ExpertVO.class));
                        unitNameMap.computeIfAbsent(expertEntities.get(0).getUnitName(), (Function<String, List>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$randomExpertForSupplier$33(java.lang.String ), (Ljava/lang/String;)Ljava/util/List;)()).add(expertEntities.get(0).getExpertId() + "");
                    }
                }
                if (randomExpertVO.getExpertNum() <= 0) ** GOTO lbl490
                response = this.iOrgApi.getOneById(randomExpertVO.getApplyOrgId());
                orgVO = null;
                need = true;
                if (!response.isSuccess()) ** GOTO lbl475
                orgVO = (OrgVO)response.getData();
                if (orgVO.getOrgType() != 1 && orgVO.getOrgType() != 2) ** GOTO lbl467
                if (!ListUtil.isNotEmpty((List)((List)unitNameMap.get(orgVO.getShortName())))) ** GOTO lbl475
                need = false;
                ** GOTO lbl475
lbl467:
                // 1 sources

                innerCode = orgVO.getInnerCode();
                parentIds = innerCode.split("\\|");
                for (i = parentIds.length - 2; i >= 0; --i) {
                    response = this.iOrgApi.getOneById(Long.valueOf(parentIds[i]));
                    if (!response.isSuccess() || (orgVO = (OrgVO)response.getData()).getOrgType() != 1 && orgVO.getOrgType() != 2) continue;
                    if (!ListUtil.isNotEmpty((List)((List)unitNameMap.get(orgVO.getShortName())))) break;
                    need = false;
                    break;
                }
lbl475:
                // 6 sources

                if (need && orgVO != null) {
                    expertLambda2 = Wrappers.lambdaQuery();
                    expertLambda2.in((Object)(SFunction & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, getBillState(), (Lcom/ejianc/business/tender/expert/bean/ExpertEntity;)Ljava/lang/Object;)(), new Object[]{1, 3});
                    expertLambda2.eq((Object)(SFunction & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, getState(), (Lcom/ejianc/business/tender/expert/bean/ExpertEntity;)Ljava/lang/Object;)(), (Object)0);
                    expertLambda2.eq((Object)(SFunction & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, getUnitName(), (Lcom/ejianc/business/tender/expert/bean/ExpertEntity;)Ljava/lang/Object;)(), (Object)orgVO.getShortName());
                    expertEntities = this.randomList(1, this.service.list((Wrapper)expertLambda2));
                    if (ListUtil.isNotEmpty(expertEntities)) {
                        randomExpertVO.setExpertNum(Integer.valueOf(randomExpertVO.getExpertNum() - 1));
                        res.addAll(BeanMapper.mapList(expertEntities, ExpertVO.class));
                        unitNameMap.computeIfAbsent(expertEntities.get(0).getUnitName(), (Function<String, List>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$randomExpertForSupplier$34(java.lang.String ), (Ljava/lang/String;)Ljava/util/List;)()).add(expertEntities.get(0).getExpertId() + "");
                    }
                }
lbl490:
                // 6 sources

                if (randomExpertVO.getExpertNum() > 0 && ListUtil.isEmpty((List)((List)unitNameMap.get("\u8f85\u6599\u4e2d\u5fc3")))) {
                    expertLambda2 = Wrappers.lambdaQuery();
                    expertLambda2.in((Object)(SFunction & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, getBillState(), (Lcom/ejianc/business/tender/expert/bean/ExpertEntity;)Ljava/lang/Object;)(), new Object[]{1, 3});
                    expertLambda2.eq((Object)(SFunction & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, getState(), (Lcom/ejianc/business/tender/expert/bean/ExpertEntity;)Ljava/lang/Object;)(), (Object)0);
                    expertLambda2.eq((Object)(SFunction & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, getUnitName(), (Lcom/ejianc/business/tender/expert/bean/ExpertEntity;)Ljava/lang/Object;)(), (Object)"\u8f85\u6599\u4e2d\u5fc3");
                    expertEntities = this.randomList(1, this.service.list((Wrapper)expertLambda2));
                    if (ListUtil.isNotEmpty(expertEntities)) {
                        randomExpertVO.setExpertNum(Integer.valueOf(randomExpertVO.getExpertNum() - 1));
                        res.addAll(BeanMapper.mapList(expertEntities, ExpertVO.class));
                        unitNameMap.computeIfAbsent(expertEntities.get(0).getUnitName(), (Function<String, List>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$randomExpertForSupplier$35(java.lang.String ), (Ljava/lang/String;)Ljava/util/List;)()).add(expertEntities.get(0).getExpertId() + "");
                    }
                }
                if (randomExpertVO.getExpertNum() <= 0) break;
                expertLambda2 = Wrappers.lambdaQuery();
                expertLambda2.in((Object)(SFunction & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, getBillState(), (Lcom/ejianc/business/tender/expert/bean/ExpertEntity;)Ljava/lang/Object;)(), new Object[]{1, 3});
                expertLambda2.eq((Object)(SFunction & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, getState(), (Lcom/ejianc/business/tender/expert/bean/ExpertEntity;)Ljava/lang/Object;)(), (Object)0);
                ids = randomExpertVO.getExpertVOS() == null ? new ArrayList<E>() : randomExpertVO.getExpertVOS().stream().map((Function<ExpertVO, Long>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, getExpertId(), (Lcom/ejianc/business/tender/expert/vo/ExpertVO;)Ljava/lang/Long;)()).distinct().collect(Collectors.toList());
                ids.addAll(res.stream().map((Function<ExpertVO, Long>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, getExpertId(), (Lcom/ejianc/business/tender/expert/vo/ExpertVO;)Ljava/lang/Long;)()).distinct().collect(Collectors.toList()));
                if (ListUtil.isNotEmpty(ids)) {
                    expertLambda2.notIn((Object)(SFunction & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, getExpertId(), (Lcom/ejianc/business/tender/expert/bean/ExpertEntity;)Ljava/lang/Object;)(), (Collection)ids.stream().distinct().collect(Collectors.toList()));
                }
                expertEntities = this.randomList(randomExpertVO.getExpertNum(), this.service.list((Wrapper)expertLambda2));
                res.addAll(BeanMapper.mapList(expertEntities, ExpertVO.class));
                break;
            }
        }
        return res;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public List<String> checkForSupplier(RandomSupplierExpertVO randomExpertVO) {
        this.logger.info("\u6821\u9a8c\u4f9b\u5e94\u5546\u51c6\u5165\u8003\u5bdf\u4e13\u5bb6\uff0c\u53c2\u6570\uff1a{}", (Object)JSONObject.toJSONString((Object)randomExpertVO));
        res = new ArrayList<String>();
        fieldNames = null;
        fieldMap = null;
        deptName = null;
        unitNameMap = null;
        var7_7 = randomExpertVO.getSupplierType();
        var8_8 = -1;
        switch (var7_7.hashCode()) {
            case 102727728: {
                if (!var7_7.equals("labor")) break;
                var8_8 = 0;
                break;
            }
            case 103658937: {
                if (!var7_7.equals("major")) break;
                var8_8 = 1;
                break;
            }
            case 106069776: {
                if (!var7_7.equals("other")) break;
                var8_8 = 2;
                break;
            }
            case 951516140: {
                if (!var7_7.equals("consult")) break;
                var8_8 = 3;
                break;
            }
            case 299066663: {
                if (!var7_7.equals("material")) break;
                var8_8 = 4;
                break;
            }
            case 1076356494: {
                if (!var7_7.equals("equipment")) break;
                var8_8 = 5;
                break;
            }
            case 1169539581: {
                if (!var7_7.equals("revolvMaterial")) break;
                var8_8 = 6;
            }
        }
        block9 : switch (var8_8) {
            case 0: 
            case 1: {
                if (randomExpertVO.getExpertJSONArray().size() == 0) {
                    res.add("\u4e3b\u8425\u7c7b\u522b\u4e3a\u52b3\u52a1\u4e13\u4e1a\u65f6\uff0c\u4e13\u5bb6\u603b\u6570\u9700\u5927\u4e8e\u7b49\u4e8e6\u4eba\uff0c\u76ee\u524d0\u4eba");
                    res.add("\u4e3b\u8425\u7c7b\u522b\u4e3a\u52b3\u52a1\u4e13\u4e1a\u65f6\uff0c\u968f\u673a\u4e13\u5bb6\u603b\u6570\u9700\u5927\u4e8e\u7b49\u4e8e4\u4eba\uff0c\u76ee\u524d0\u4eba");
                    res.add("\u4e3b\u8425\u7c7b\u522b\u4e3a\u52b3\u52a1\u4e13\u4e1a\u65f6\uff0c\u751f\u4ea7\u7ba1\u7406\u7c7b\u4e13\u5bb6\u603b\u6570\u9700\u5927\u4e8e\u7b49\u4e8e1\u4eba\uff0c\u76ee\u524d0\u4eba");
                    res.add("\u4e3b\u8425\u7c7b\u522b\u4e3a\u52b3\u52a1\u4e13\u4e1a\u65f6\uff0c\u65bd\u5de5\u6280\u672f\u53ca\u65bd\u5de5\u8d28\u91cf\u7ba1\u7406\u7c7b\u4e13\u5bb6\u603b\u6570\u9700\u5927\u4e8e\u7b49\u4e8e1\u4eba\uff0c\u76ee\u524d0\u4eba");
                    res.add("\u4e3b\u8425\u7c7b\u522b\u4e3a\u52b3\u52a1\u4e13\u4e1a\u65f6\uff0c\u5b89\u5168\u53ca\u8bbe\u5907\u7ba1\u7406\u7c7b\u4e13\u5bb6\u603b\u6570\u9700\u5927\u4e8e\u7b49\u4e8e1\u4eba\uff0c\u76ee\u524d0\u4eba");
                    res.add("\u4e3b\u8425\u7c7b\u522b\u4e3a\u52b3\u52a1\u4e13\u4e1a\u65f6\uff0c\u5de5\u7a0b\u7ecf\u6d4e\u7c7b\u4e13\u5bb6\u603b\u6570\u9700\u5927\u4e8e\u7b49\u4e8e1\u4eba\uff0c\u76ee\u524d0\u4eba");
                    res.add("\u4e3b\u8425\u7c7b\u522b\u4e3a\u52b3\u52a1\u4e13\u4e1a\u65f6\uff0c\u6210\u672c\u5408\u7ea6\u90e8\u4e13\u5bb6\u603b\u6570\u9700\u5927\u4e8e\u7b49\u4e8e1\u4eba\uff0c\u76ee\u524d0\u4eba");
                    res.add("\u4e3b\u8425\u7c7b\u522b\u4e3a\u52b3\u52a1\u4e13\u4e1a\u65f6\uff0c\u7533\u8bf7\u5355\u4f4d\u672c\u4e0a\u7b2c\u4e00\u4e2a\u5206\u5b50\u516c\u53f8\u6216\u96c6\u56e2\u4e13\u5bb6\u603b\u6570\u9700\u5927\u4e8e\u7b49\u4e8e1\u4eba\uff0c\u76ee\u524d0\u4eba");
                    break;
                }
                if (randomExpertVO.getExpertJSONArray().size() < 6) {
                    res.add("\u4e3b\u8425\u7c7b\u522b\u4e3a\u52b3\u52a1\u4e13\u4e1a\u65f6\uff0c\u4e13\u5bb6\u603b\u6570\u9700\u5927\u4e8e\u7b49\u4e8e6\u4eba\uff0c\u76ee\u524d" + randomExpertVO.getExpertJSONArray().size() + "\u4eba");
                }
                fieldNames = new String[]{"\u751f\u4ea7\u7ba1\u7406\u7c7b", "\u65bd\u5de5\u6280\u672f\u53ca\u65bd\u5de5\u8d28\u91cf\u7ba1\u7406\u7c7b", "\u5b89\u5168\u53ca\u8bbe\u5907\u7ba1\u7406\u7c7b", "\u5de5\u7a0b\u7ecf\u6d4e\u7c7b"};
                fieldMap = new HashMap<K, V>();
                deptName = new HashMap<K, V>();
                unitNameMap = new HashMap<K, V>();
                randomWay = 0;
                for (i = 0; i < randomExpertVO.getExpertJSONArray().size(); ++i) {
                    expertVO = randomExpertVO.getExpertJSONArray().getJSONObject(i);
                    for (String s : fieldNames) {
                        fieldMap.computeIfAbsent(s, (Function<String, List>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$checkForSupplier$36(java.lang.String ), (Ljava/lang/String;)Ljava/util/List;)());
                        if (!expertVO.getString("fieldName").contains(s)) continue;
                        ex = (List)fieldMap.get(s);
                        ex.add(expertVO.getString("expertId"));
                    }
                    if (StringUtils.isNotEmpty((CharSequence)expertVO.getString("deptName"))) {
                        deptName.computeIfAbsent(expertVO.getString("deptName"), (Function<String, List>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$checkForSupplier$37(java.lang.String ), (Ljava/lang/String;)Ljava/util/List;)()).add(expertVO.getString("expertId"));
                    }
                    if (StringUtils.isNotEmpty((CharSequence)expertVO.getString("unitName"))) {
                        unitNameMap.computeIfAbsent(expertVO.getString("unitName"), (Function<String, List>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$checkForSupplier$38(java.lang.String ), (Ljava/lang/String;)Ljava/util/List;)()).add(expertVO.getString("expertId"));
                    }
                    if (!"1".equals(expertVO.getString("chooseWay"))) continue;
                    ++randomWay;
                }
                if (randomWay < 4) {
                    res.add("\u4e3b\u8425\u7c7b\u522b\u4e3a\u52b3\u52a1\u4e13\u4e1a\u65f6\uff0c\u968f\u673a\u4e13\u5bb6\u603b\u6570\u9700\u5927\u4e8e\u7b49\u4e8e4\u4eba\uff0c\u76ee\u524d" + randomWay + "\u4eba");
                }
                for (String s : fieldNames) {
                    if (((List)fieldMap.get(s)).size() >= 1) continue;
                    res.add("\u4e3b\u8425\u7c7b\u522b\u4e3a\u52b3\u52a1\u4e13\u4e1a\u65f6\uff0c" + s + "\u4e13\u5bb6\u603b\u6570\u9700\u5927\u4e8e\u7b49\u4e8e1\u4eba\uff0c\u76ee\u524d0\u4eba");
                }
                if (deptName.get("\u6210\u672c\u5408\u7ea6\u90e8") == null) {
                    res.add("\u4e3b\u8425\u7c7b\u522b\u4e3a\u52b3\u52a1\u4e13\u4e1a\u65f6\uff0c\u6210\u672c\u5408\u7ea6\u90e8\u4e13\u5bb6\u603b\u6570\u9700\u5927\u4e8e\u7b49\u4e8e1\u4eba\uff0c\u76ee\u524d0\u4eba");
                }
                response = this.iOrgApi.getOneById(randomExpertVO.getApplyOrgId());
                orgVO = null;
                if (!response.isSuccess()) break;
                orgVO = (OrgVO)response.getData();
                if (orgVO.getOrgType() == 1 || orgVO.getOrgType() == 2) {
                    if (!ListUtil.isEmpty((List)((List)unitNameMap.get(orgVO.getShortName()))) || !ListUtil.isEmpty((List)((List)unitNameMap.get(orgVO.getName())))) break;
                    res.add("\u4e3b\u8425\u7c7b\u522b\u4e3a\u52b3\u52a1\u4e13\u4e1a\u65f6\uff0c\u6240\u5c5e\u5355\u4f4d\u4e3a" + orgVO.getShortName() + "\u7684\u4e13\u5bb6\u603b\u6570\u9700\u5927\u4e8e\u7b49\u4e8e1\u4eba\uff0c\u76ee\u524d0\u4eba");
                    break;
                }
                innerCode = orgVO.getInnerCode();
                parentIds = innerCode.split("\\|");
                for (i = parentIds.length - 2; i >= 0; --i) {
                    response = this.iOrgApi.getOneById(Long.valueOf(parentIds[i]));
                    if (!response.isSuccess() || (orgVO = (OrgVO)response.getData()).getOrgType() != 1 && orgVO.getOrgType() != 2) continue;
                    if (!ListUtil.isEmpty((List)((List)unitNameMap.get(orgVO.getShortName()))) || !ListUtil.isEmpty((List)((List)unitNameMap.get(orgVO.getName())))) break block9;
                    res.add("\u4e3b\u8425\u7c7b\u522b\u4e3a\u52b3\u52a1\u4e13\u4e1a\u65f6\uff0c\u6240\u5c5e\u5355\u4f4d\u4e3a" + orgVO.getShortName() + "\u7684\u4e13\u5bb6\u603b\u6570\u9700\u5927\u4e8e\u7b49\u4e8e1\u4eba\uff0c\u76ee\u524d0\u4eba");
                    break block9;
                }
                break;
            }
            case 2: 
            case 3: {
                if (randomExpertVO.getExpertJSONArray().size() == 0) {
                    res.add("\u4e3b\u8425\u7c7b\u522b\u4e3a\u5176\u4ed6\u6216\u54a8\u8be2\u65f6\uff0c\u4e13\u5bb6\u603b\u6570\u9700\u5927\u4e8e\u7b49\u4e8e6\u4eba\uff0c\u76ee\u524d0\u4eba");
                    res.add("\u4e3b\u8425\u7c7b\u522b\u4e3a\u5176\u4ed6\u6216\u54a8\u8be2\u65f6\uff0c\u968f\u673a\u4e13\u5bb6\u603b\u6570\u9700\u5927\u4e8e\u7b49\u4e8e4\u4eba\uff0c\u76ee\u524d0\u4eba");
                    res.add("\u4e3b\u8425\u7c7b\u522b\u4e3a\u5176\u4ed6\u6216\u54a8\u8be2\u65f6\uff0c\u7533\u8bf7\u5355\u4f4d\u672c\u4e0a\u7b2c\u4e00\u4e2a\u5206\u5b50\u516c\u53f8\u6216\u96c6\u56e2\u4e13\u5bb6\u603b\u6570\u9700\u5927\u4e8e\u7b49\u4e8e1\u4eba\uff0c\u76ee\u524d0\u4eba");
                    break;
                }
                if (randomExpertVO.getExpertJSONArray().size() < 6) {
                    res.add("\u4e3b\u8425\u7c7b\u522b\u4e3a\u5176\u4ed6\u6216\u54a8\u8be2\u65f6\uff0c\u4e13\u5bb6\u603b\u6570\u9700\u5927\u4e8e\u7b49\u4e8e6\u4eba\uff0c\u76ee\u524d" + randomExpertVO.getExpertJSONArray().size() + "\u4eba");
                }
                unitNameMap = new HashMap<String, List>();
                randomWay = 0;
                for (i = 0; i < randomExpertVO.getExpertJSONArray().size(); ++i) {
                    expertVO = randomExpertVO.getExpertJSONArray().getJSONObject(i);
                    if (StringUtils.isNotEmpty((CharSequence)expertVO.getString("unitName"))) {
                        unitNameMap.computeIfAbsent(expertVO.getString("unitName"), (Function<String, List>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$checkForSupplier$39(java.lang.String ), (Ljava/lang/String;)Ljava/util/List;)()).add(expertVO.getString("expertId"));
                    }
                    if (!"1".equals(expertVO.getString("chooseWay"))) continue;
                    ++randomWay;
                }
                if (randomWay < 4) {
                    res.add("\u4e3b\u8425\u7c7b\u522b\u4e3a\u5176\u4ed6\u6216\u54a8\u8be2\u65f6\uff0c\u968f\u673a\u4e13\u5bb6\u603b\u6570\u9700\u5927\u4e8e\u7b49\u4e8e4\u4eba\uff0c\u76ee\u524d" + randomWay + "\u4eba");
                }
                response = this.iOrgApi.getOneById(randomExpertVO.getApplyOrgId());
                orgVO = null;
                if (!response.isSuccess()) break;
                orgVO = (OrgVO)response.getData();
                if (orgVO.getOrgType() == 1 || orgVO.getOrgType() == 2) {
                    if (!ListUtil.isEmpty((List)((List)unitNameMap.get(orgVO.getShortName()))) || !ListUtil.isEmpty((List)((List)unitNameMap.get(orgVO.getName())))) break;
                    res.add("\u4e3b\u8425\u7c7b\u522b\u4e3a\u5176\u4ed6\u6216\u54a8\u8be2\u65f6\uff0c\u6240\u5c5e\u5355\u4f4d\u4e3a" + orgVO.getShortName() + "\u7684\u4e13\u5bb6\u603b\u6570\u9700\u5927\u4e8e\u7b49\u4e8e1\u4eba\uff0c\u76ee\u524d0\u4eba");
                    break;
                }
                innerCode = orgVO.getInnerCode();
                parentIds = innerCode.split("\\|");
                for (i = parentIds.length - 2; i >= 0; --i) {
                    response = this.iOrgApi.getOneById(Long.valueOf(parentIds[i]));
                    if (!response.isSuccess() || (orgVO = (OrgVO)response.getData()).getOrgType() != 1 && orgVO.getOrgType() != 2) continue;
                    if (!ListUtil.isEmpty((List)((List)unitNameMap.get(orgVO.getShortName()))) || !ListUtil.isEmpty((List)((List)unitNameMap.get(orgVO.getName())))) break block9;
                    res.add("\u4e3b\u8425\u7c7b\u522b\u4e3a\u5176\u4ed6\u6216\u54a8\u8be2\u65f6\uff0c\u6240\u5c5e\u5355\u4f4d\u4e3a" + orgVO.getShortName() + "\u7684\u4e13\u5bb6\u603b\u6570\u9700\u5927\u4e8e\u7b49\u4e8e1\u4eba\uff0c\u76ee\u524d0\u4eba");
                    break block9;
                }
                break;
            }
            case 4: {
                if (randomExpertVO.getExpertJSONArray().size() == 0) {
                    res.add("\u4e3b\u8425\u7c7b\u522b\u4e3a\u7269\u8d44\u65f6\uff0c\u4e13\u5bb6\u603b\u6570\u9700\u5927\u4e8e\u7b49\u4e8e6\u4eba\uff0c\u76ee\u524d0\u4eba");
                    res.add("\u4e3b\u8425\u7c7b\u522b\u4e3a\u7269\u8d44\u65f6\uff0c\u968f\u673a\u4e13\u5bb6\u603b\u6570\u9700\u5927\u4e8e\u7b49\u4e8e4\u4eba\uff0c\u76ee\u524d0\u4eba");
                    res.add("\u4e3b\u8425\u7c7b\u522b\u4e3a\u7269\u8d44\u65f6\uff0c\u7269\u8d44\u7c7b\u4e13\u5bb6\u603b\u6570\u9700\u5927\u4e8e\u7b49\u4e8e2\u4eba\uff0c\u76ee\u524d0\u4eba");
                    res.add("\u4e3b\u8425\u7c7b\u522b\u4e3a\u7269\u8d44\u65f6\uff0c\u65bd\u5de5\u6280\u672f\u53ca\u65bd\u5de5\u8d28\u91cf\u7ba1\u7406\u7c7b\u4e13\u5bb6\u603b\u6570\u9700\u5927\u4e8e\u7b49\u4e8e1\u4eba\uff0c\u76ee\u524d0\u4eba");
                    res.add("\u4e3b\u8425\u7c7b\u522b\u4e3a\u7269\u8d44\u65f6\uff0c\u5de5\u7a0b\u7ecf\u6d4e\u7c7b\u4e13\u5bb6\u603b\u6570\u9700\u5927\u4e8e\u7b49\u4e8e1\u4eba\uff0c\u76ee\u524d0\u4eba");
                    res.add("\u4e3b\u8425\u7c7b\u522b\u4e3a\u7269\u8d44\u65f6\uff0c\u7edf\u8d2d\u4e2d\u5fc3\u4e13\u5bb6\u603b\u6570\u9700\u5927\u4e8e\u7b49\u4e8e1\u4eba\uff0c\u76ee\u524d0\u4eba");
                    res.add("\u4e3b\u8425\u7c7b\u522b\u4e3a\u7269\u8d44\u65f6\uff0c\u7533\u8bf7\u5355\u4f4d\u672c\u4e0a\u7b2c\u4e00\u4e2a\u5206\u5b50\u516c\u53f8\u6216\u96c6\u56e2\u4e13\u5bb6\u603b\u6570\u9700\u5927\u4e8e\u7b49\u4e8e1\u4eba\uff0c\u76ee\u524d0\u4eba");
                    break;
                }
                if (randomExpertVO.getExpertJSONArray().size() < 6) {
                    res.add("\u4e3b\u8425\u7c7b\u522b\u4e3a\u7269\u8d44\u65f6\uff0c\u4e13\u5bb6\u603b\u6570\u9700\u5927\u4e8e\u7b49\u4e8e6\u4eba\uff0c\u76ee\u524d" + randomExpertVO.getExpertJSONArray().size() + "\u4eba");
                }
                fieldNames = new String[]{"\u7269\u8d44\u7c7b", "\u65bd\u5de5\u6280\u672f\u53ca\u65bd\u5de5\u8d28\u91cf\u7ba1\u7406\u7c7b", "\u5de5\u7a0b\u7ecf\u6d4e\u7c7b"};
                fieldMap = new HashMap<String, List>();
                deptName = new HashMap<K, V>();
                unitNameMap = new HashMap<K, V>();
                randomWay = 0;
                for (i = 0; i < randomExpertVO.getExpertJSONArray().size(); ++i) {
                    expertVO = randomExpertVO.getExpertJSONArray().getJSONObject(i);
                    innerCode = fieldNames;
                    parentIds = innerCode.length;
                    for (i = 0; i < parentIds; ++i) {
                        s = innerCode[i];
                        fieldMap.computeIfAbsent(s, (Function<String, List>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$checkForSupplier$40(java.lang.String ), (Ljava/lang/String;)Ljava/util/List;)());
                        if (!expertVO.getString("fieldName").contains(s)) continue;
                        ex = (List)fieldMap.get(s);
                        ex.add(expertVO.getString("expertId"));
                    }
                    if (StringUtils.isNotEmpty((CharSequence)expertVO.getString("deptName"))) {
                        deptName.computeIfAbsent(expertVO.getString("deptName"), (Function<String, List>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$checkForSupplier$41(java.lang.String ), (Ljava/lang/String;)Ljava/util/List;)()).add(expertVO.getString("expertId"));
                    }
                    if (StringUtils.isNotEmpty((CharSequence)expertVO.getString("unitName"))) {
                        unitNameMap.computeIfAbsent(expertVO.getString("unitName"), (Function<String, List>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$checkForSupplier$42(java.lang.String ), (Ljava/lang/String;)Ljava/util/List;)()).add(expertVO.getString("expertId"));
                    }
                    if (!"1".equals(expertVO.getString("chooseWay"))) continue;
                    ++randomWay;
                }
                if (randomWay < 4) {
                    res.add("\u4e3b\u8425\u7c7b\u522b\u4e3a\u7269\u8d44\u65f6\uff0c\u968f\u673a\u4e13\u5bb6\u603b\u6570\u9700\u5927\u4e8e\u7b49\u4e8e4\u4eba\uff0c\u76ee\u524d" + randomWay + "\u4eba");
                }
                for (String s : fieldNames) {
                    if ("\u7269\u8d44\u7c7b".equals(s)) {
                        if (((List)fieldMap.get(s)).size() >= 2) continue;
                        res.add("\u4e3b\u8425\u7c7b\u522b\u4e3a\u7269\u8d44\u65f6\uff0c\u7269\u8d44\u7c7b\u4e13\u5bb6\u603b\u6570\u9700\u5927\u4e8e\u7b49\u4e8e2\u4eba\uff0c\u76ee\u524d" + ((List)fieldMap.get(s)).size() + "\u4eba");
                        continue;
                    }
                    if (((List)fieldMap.get(s)).size() >= 1) continue;
                    res.add("\u4e3b\u8425\u7c7b\u522b\u4e3a\u7269\u8d44\u65f6\uff0c" + s + "\u4e13\u5bb6\u603b\u6570\u9700\u5927\u4e8e\u7b49\u4e8e1\u4eba\uff0c\u76ee\u524d0\u4eba");
                }
                if (deptName.get("\u7edf\u8d2d\u4e2d\u5fc3") == null) {
                    res.add("\u4e3b\u8425\u7c7b\u522b\u4e3a\u7269\u8d44\u65f6\uff0c\u7edf\u8d2d\u4e2d\u5fc3\u4e13\u5bb6\u603b\u6570\u9700\u5927\u4e8e\u7b49\u4e8e1\u4eba\uff0c\u76ee\u524d0\u4eba");
                }
                response = this.iOrgApi.getOneById(randomExpertVO.getApplyOrgId());
                orgVO = null;
                if (!response.isSuccess()) break;
                orgVO = (OrgVO)response.getData();
                if (orgVO.getOrgType() == 1 || orgVO.getOrgType() == 2) {
                    if (!ListUtil.isEmpty((List)((List)unitNameMap.get(orgVO.getShortName()))) || !ListUtil.isEmpty((List)((List)unitNameMap.get(orgVO.getName())))) break;
                    res.add("\u4e3b\u8425\u7c7b\u522b\u4e3a\u7269\u8d44\u65f6\uff0c\u6240\u5c5e\u5355\u4f4d\u4e3a" + orgVO.getShortName() + "\u7684\u4e13\u5bb6\u603b\u6570\u9700\u5927\u4e8e\u7b49\u4e8e1\u4eba\uff0c\u76ee\u524d0\u4eba");
                    break;
                }
                innerCode = orgVO.getInnerCode();
                parentIds = innerCode.split("\\|");
                for (i = parentIds.length - 2; i >= 0; --i) {
                    response = this.iOrgApi.getOneById(Long.valueOf(parentIds[i]));
                    if (!response.isSuccess() || (orgVO = (OrgVO)response.getData()).getOrgType() != 1 && orgVO.getOrgType() != 2) continue;
                    if (!ListUtil.isEmpty((List)((List)unitNameMap.get(orgVO.getShortName()))) || !ListUtil.isEmpty((List)((List)unitNameMap.get(orgVO.getName())))) break block9;
                    res.add("\u4e3b\u8425\u7c7b\u522b\u4e3a\u7269\u8d44\u65f6\uff0c\u6240\u5c5e\u5355\u4f4d\u4e3a" + orgVO.getShortName() + "\u7684\u4e13\u5bb6\u603b\u6570\u9700\u5927\u4e8e\u7b49\u4e8e1\u4eba\uff0c\u76ee\u524d0\u4eba");
                    break block9;
                }
                break;
            }
            case 5: {
                if (randomExpertVO.getExpertJSONArray().size() == 0) {
                    res.add("\u4e3b\u8425\u7c7b\u522b\u4e3a\u8bbe\u5907\u65f6\uff0c\u4e13\u5bb6\u603b\u6570\u9700\u5927\u4e8e\u7b49\u4e8e5\u4eba\uff0c\u76ee\u524d0\u4eba");
                    res.add("\u4e3b\u8425\u7c7b\u522b\u4e3a\u8bbe\u5907\u65f6\uff0c\u968f\u673a\u4e13\u5bb6\u603b\u6570\u9700\u5927\u4e8e\u7b49\u4e8e3\u4eba\uff0c\u76ee\u524d0\u4eba");
                    res.add("\u4e3b\u8425\u7c7b\u522b\u4e3a\u8bbe\u5907\u65f6\uff0c\u5b89\u5168\u53ca\u8bbe\u5907\u7ba1\u7406\u7c7b\u4e13\u5bb6\u603b\u6570\u9700\u5927\u4e8e\u7b49\u4e8e2\u4eba\uff0c\u76ee\u524d0\u4eba");
                    res.add("\u4e3b\u8425\u7c7b\u522b\u4e3a\u8bbe\u5907\u65f6\uff0c\u65bd\u5de5\u6280\u672f\u53ca\u65bd\u5de5\u8d28\u91cf\u7ba1\u7406\u7c7b\u4e13\u5bb6\u603b\u6570\u9700\u5927\u4e8e\u7b49\u4e8e1\u4eba\uff0c\u76ee\u524d0\u4eba");
                    res.add("\u4e3b\u8425\u7c7b\u522b\u4e3a\u8bbe\u5907\u65f6\uff0c\u5de5\u7a0b\u7ecf\u6d4e\u7c7b\u4e13\u5bb6\u603b\u6570\u9700\u5927\u4e8e\u7b49\u4e8e1\u4eba\uff0c\u76ee\u524d0\u4eba");
                    res.add("\u4e3b\u8425\u7c7b\u522b\u4e3a\u8bbe\u5907\u65f6\uff0c\u5b89\u5168\u76d1\u7763\u7ba1\u7406\u90e8\u4e13\u5bb6\u603b\u6570\u9700\u5927\u4e8e\u7b49\u4e8e1\u4eba\uff0c\u76ee\u524d0\u4eba");
                    res.add("\u4e3b\u8425\u7c7b\u522b\u4e3a\u8bbe\u5907\u65f6\uff0c\u7533\u8bf7\u5355\u4f4d\u672c\u4e0a\u7b2c\u4e00\u4e2a\u5206\u5b50\u516c\u53f8\u6216\u96c6\u56e2\u4e13\u5bb6\u603b\u6570\u9700\u5927\u4e8e\u7b49\u4e8e1\u4eba\uff0c\u76ee\u524d0\u4eba");
                    break;
                }
                if (randomExpertVO.getExpertJSONArray().size() < 5) {
                    res.add("\u4e3b\u8425\u7c7b\u522b\u4e3a\u8bbe\u5907\u65f6\uff0c\u4e13\u5bb6\u603b\u6570\u9700\u5927\u4e8e\u7b49\u4e8e5\u4eba\uff0c\u76ee\u524d" + randomExpertVO.getExpertJSONArray().size() + "\u4eba");
                }
                fieldNames = new String[]{"\u5b89\u5168\u53ca\u8bbe\u5907\u7ba1\u7406\u7c7b", "\u65bd\u5de5\u6280\u672f\u53ca\u65bd\u5de5\u8d28\u91cf\u7ba1\u7406\u7c7b", "\u5de5\u7a0b\u7ecf\u6d4e\u7c7b"};
                fieldMap = new HashMap<K, V>();
                deptName = new HashMap<K, V>();
                unitNameMap = new HashMap<K, V>();
                randomWay = 0;
                for (i = 0; i < randomExpertVO.getExpertJSONArray().size(); ++i) {
                    expertVO = randomExpertVO.getExpertJSONArray().getJSONObject(i);
                    innerCode = fieldNames;
                    parentIds = innerCode.length;
                    for (i = 0; i < parentIds; ++i) {
                        s = innerCode[i];
                        fieldMap.computeIfAbsent(s, (Function<String, List>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$checkForSupplier$43(java.lang.String ), (Ljava/lang/String;)Ljava/util/List;)());
                        if (!expertVO.getString("fieldName").contains(s)) continue;
                        ex = (List)fieldMap.get(s);
                        ex.add(expertVO.getString("expertId"));
                    }
                    if (StringUtils.isNotEmpty((CharSequence)expertVO.getString("deptName"))) {
                        deptName.computeIfAbsent(expertVO.getString("deptName"), (Function<String, List>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$checkForSupplier$44(java.lang.String ), (Ljava/lang/String;)Ljava/util/List;)()).add(expertVO.getString("expertId"));
                    }
                    if (StringUtils.isNotEmpty((CharSequence)expertVO.getString("unitName"))) {
                        unitNameMap.computeIfAbsent(expertVO.getString("unitName"), (Function<String, List>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$checkForSupplier$45(java.lang.String ), (Ljava/lang/String;)Ljava/util/List;)()).add(expertVO.getString("expertId"));
                    }
                    if (!"1".equals(expertVO.getString("chooseWay"))) continue;
                    ++randomWay;
                }
                if (randomWay < 3) {
                    res.add("\u4e3b\u8425\u7c7b\u522b\u4e3a\u8bbe\u5907\u65f6\uff0c\u968f\u673a\u4e13\u5bb6\u603b\u6570\u9700\u5927\u4e8e\u7b49\u4e8e3\u4eba\uff0c\u76ee\u524d" + randomWay + "\u4eba");
                }
                for (String s : fieldNames) {
                    if ("\u5b89\u5168\u53ca\u8bbe\u5907\u7ba1\u7406\u7c7b".equals(s)) {
                        if (((List)fieldMap.get(s)).size() >= 2) continue;
                        res.add("\u4e3b\u8425\u7c7b\u522b\u4e3a\u8bbe\u5907\u65f6\uff0c\u5b89\u5168\u53ca\u8bbe\u5907\u7ba1\u7406\u7c7b\u4e13\u5bb6\u603b\u6570\u9700\u5927\u4e8e\u7b49\u4e8e2\u4eba\uff0c\u76ee\u524d" + ((List)fieldMap.get(s)).size() + "\u4eba");
                        continue;
                    }
                    if (((List)fieldMap.get(s)).size() >= 1) continue;
                    res.add("\u4e3b\u8425\u7c7b\u522b\u4e3a\u8bbe\u5907\u65f6\uff0c" + s + "\u4e13\u5bb6\u603b\u6570\u9700\u5927\u4e8e\u7b49\u4e8e1\u4eba\uff0c\u76ee\u524d0\u4eba");
                }
                if (deptName.get("\u5b89\u5168\u76d1\u7763\u7ba1\u7406\u90e8") == null) {
                    res.add("\u4e3b\u8425\u7c7b\u522b\u4e3a\u8bbe\u5907\u65f6\uff0c\u5b89\u5168\u76d1\u7763\u7ba1\u7406\u90e8\u4e13\u5bb6\u603b\u6570\u9700\u5927\u4e8e\u7b49\u4e8e1\u4eba\uff0c\u76ee\u524d0\u4eba");
                }
                response = this.iOrgApi.getOneById(randomExpertVO.getApplyOrgId());
                orgVO = null;
                if (!response.isSuccess()) ** GOTO lbl321
                orgVO = (OrgVO)response.getData();
                if (orgVO.getOrgType() != 1 && orgVO.getOrgType() != 2) ** GOTO lbl312
                if (!ListUtil.isEmpty((List)((List)unitNameMap.get(orgVO.getShortName()))) || !ListUtil.isEmpty((List)((List)unitNameMap.get(orgVO.getName())))) ** GOTO lbl321
                res.add("\u4e3b\u8425\u7c7b\u522b\u4e3a\u8bbe\u5907\u65f6\uff0c\u6240\u5c5e\u5355\u4f4d\u4e3a" + orgVO.getShortName() + "\u7684\u4e13\u5bb6\u603b\u6570\u9700\u5927\u4e8e\u7b49\u4e8e1\u4eba\uff0c\u76ee\u524d0\u4eba");
                ** GOTO lbl321
lbl312:
                // 1 sources

                innerCode = orgVO.getInnerCode();
                parentIds = innerCode.split("\\|");
                for (i = parentIds.length - 2; i >= 0; --i) {
                    response = this.iOrgApi.getOneById(Long.valueOf(parentIds[i]));
                    if (!response.isSuccess() || (orgVO = (OrgVO)response.getData()).getOrgType() != 1 && orgVO.getOrgType() != 2) continue;
                    if (!ListUtil.isEmpty((List)((List)unitNameMap.get(orgVO.getShortName()))) || !ListUtil.isEmpty((List)((List)unitNameMap.get(orgVO.getName())))) break;
                    res.add("\u4e3b\u8425\u7c7b\u522b\u4e3a\u8bbe\u5907\u65f6\uff0c\u6240\u5c5e\u5355\u4f4d\u4e3a" + orgVO.getShortName() + "\u7684\u4e13\u5bb6\u603b\u6570\u9700\u5927\u4e8e\u7b49\u4e8e1\u4eba\uff0c\u76ee\u524d0\u4eba");
                    break;
                }
lbl321:
                // 6 sources

                if (!randomExpertVO.getSupplyContent().booleanValue() || !ListUtil.isEmpty((List)((List)unitNameMap.get("\u673a\u68b0\u8bbe\u5907\u79df\u8d41\u516c\u53f8")))) break;
                res.add("\u4e3b\u8425\u7c7b\u522b\u4e3a\u8bbe\u5907\u65f6\uff0c\u6839\u636e\u6240\u9009\u4f9b\u8d27\u5185\u5bb9\uff0c\u6240\u5c5e\u5355\u4f4d\u4e3a\u673a\u68b0\u8bbe\u5907\u79df\u8d41\u516c\u53f8\u7684\u4e13\u5bb6\u603b\u6570\u9700\u5927\u4e8e\u7b49\u4e8e1\u4eba\uff0c\u76ee\u524d0\u4eba");
                break;
            }
            case 6: {
                if (randomExpertVO.getExpertJSONArray().size() == 0) {
                    res.add("\u4e3b\u8425\u7c7b\u522b\u4e3a\u5468\u8f6c\u6750\u65f6\uff0c\u4e13\u5bb6\u603b\u6570\u9700\u5927\u4e8e\u7b49\u4e8e6\u4eba\uff0c\u76ee\u524d0\u4eba");
                    res.add("\u4e3b\u8425\u7c7b\u522b\u4e3a\u5468\u8f6c\u6750\u65f6\uff0c\u968f\u673a\u4e13\u5bb6\u603b\u6570\u9700\u5927\u4e8e\u7b49\u4e8e4\u4eba\uff0c\u76ee\u524d0\u4eba");
                    res.add("\u4e3b\u8425\u7c7b\u522b\u4e3a\u5468\u8f6c\u6750\u65f6\uff0c\u7269\u8d44\u7c7b\u4e13\u5bb6\u603b\u6570\u9700\u5927\u4e8e\u7b49\u4e8e2\u4eba\uff0c\u76ee\u524d0\u4eba");
                    res.add("\u4e3b\u8425\u7c7b\u522b\u4e3a\u5468\u8f6c\u6750\u65f6\uff0c\u65bd\u5de5\u6280\u672f\u53ca\u65bd\u5de5\u8d28\u91cf\u7ba1\u7406\u7c7b\u4e13\u5bb6\u603b\u6570\u9700\u5927\u4e8e\u7b49\u4e8e1\u4eba\uff0c\u76ee\u524d0\u4eba");
                    res.add("\u4e3b\u8425\u7c7b\u522b\u4e3a\u5468\u8f6c\u6750\u65f6\uff0c\u5de5\u7a0b\u7ecf\u6d4e\u7c7b\u4e13\u5bb6\u603b\u6570\u9700\u5927\u4e8e\u7b49\u4e8e1\u4eba\uff0c\u76ee\u524d0\u4eba");
                    res.add("\u4e3b\u8425\u7c7b\u522b\u4e3a\u5468\u8f6c\u6750\u65f6\uff0c\u7edf\u8d2d\u4e2d\u5fc3\u4e13\u5bb6\u603b\u6570\u9700\u5927\u4e8e\u7b49\u4e8e1\u4eba\uff0c\u76ee\u524d0\u4eba");
                    res.add("\u4e3b\u8425\u7c7b\u522b\u4e3a\u5468\u8f6c\u6750\u65f6\uff0c\u7533\u8bf7\u5355\u4f4d\u672c\u4e0a\u7b2c\u4e00\u4e2a\u5206\u5b50\u516c\u53f8\u6216\u96c6\u56e2\u4e13\u5bb6\u603b\u6570\u9700\u5927\u4e8e\u7b49\u4e8e1\u4eba\uff0c\u76ee\u524d0\u4eba");
                    break;
                }
                if (randomExpertVO.getExpertJSONArray().size() < 6) {
                    res.add("\u4e3b\u8425\u7c7b\u522b\u4e3a\u5468\u8f6c\u6750\u65f6\uff0c\u4e13\u5bb6\u603b\u6570\u9700\u5927\u4e8e\u7b49\u4e8e6\u4eba\uff0c\u76ee\u524d" + randomExpertVO.getExpertJSONArray().size() + "\u4eba");
                }
                fieldNames = new String[]{"\u7269\u8d44\u7c7b", "\u65bd\u5de5\u6280\u672f\u53ca\u65bd\u5de5\u8d28\u91cf\u7ba1\u7406\u7c7b", "\u5de5\u7a0b\u7ecf\u6d4e\u7c7b"};
                deptName = new HashMap<String, List>();
                fieldMap = new HashMap<K, V>();
                unitNameMap = new HashMap<K, V>();
                randomWay = 0;
                for (i = 0; i < randomExpertVO.getExpertJSONArray().size(); ++i) {
                    expertVO = randomExpertVO.getExpertJSONArray().getJSONObject(i);
                    innerCode = fieldNames;
                    parentIds = innerCode.length;
                    for (i = 0; i < parentIds; ++i) {
                        s = innerCode[i];
                        fieldMap.computeIfAbsent(s, (Function<String, List>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$checkForSupplier$46(java.lang.String ), (Ljava/lang/String;)Ljava/util/List;)());
                        if (!expertVO.getString("fieldName").contains(s)) continue;
                        ex = (List)fieldMap.get(s);
                        ex.add(expertVO.getString("expertId"));
                    }
                    if (StringUtils.isNotEmpty((CharSequence)expertVO.getString("deptName"))) {
                        deptName.computeIfAbsent(expertVO.getString("deptName"), (Function<String, List>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$checkForSupplier$47(java.lang.String ), (Ljava/lang/String;)Ljava/util/List;)()).add(expertVO.getString("expertId"));
                    }
                    if (StringUtils.isNotEmpty((CharSequence)expertVO.getString("unitName"))) {
                        unitNameMap.computeIfAbsent(expertVO.getString("unitName"), (Function<String, List>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$checkForSupplier$48(java.lang.String ), (Ljava/lang/String;)Ljava/util/List;)()).add(expertVO.getString("expertId"));
                    }
                    if (!"1".equals(expertVO.getString("chooseWay"))) continue;
                    ++randomWay;
                }
                if (randomWay < 4) {
                    res.add("\u4e3b\u8425\u7c7b\u522b\u4e3a\u5468\u8f6c\u6750\u65f6\uff0c\u968f\u673a\u4e13\u5bb6\u603b\u6570\u9700\u5927\u4e8e\u7b49\u4e8e4\u4eba\uff0c\u76ee\u524d" + randomWay + "\u4eba");
                }
                for (String s : fieldNames) {
                    if ("\u7269\u8d44\u7c7b".equals(s)) {
                        if (((List)fieldMap.get(s)).size() >= 2) continue;
                        res.add("\u4e3b\u8425\u7c7b\u522b\u4e3a\u5468\u8f6c\u6750\u65f6\uff0c\u7269\u8d44\u7c7b\u4e13\u5bb6\u603b\u6570\u9700\u5927\u4e8e\u7b49\u4e8e2\u4eba\uff0c\u76ee\u524d" + ((List)fieldMap.get(s)).size() + "\u4eba");
                        continue;
                    }
                    if (((List)fieldMap.get(s)).size() >= 1) continue;
                    res.add("\u4e3b\u8425\u7c7b\u522b\u4e3a\u5468\u8f6c\u6750\u65f6\uff0c" + s + "\u4e13\u5bb6\u603b\u6570\u9700\u5927\u4e8e\u7b49\u4e8e1\u4eba\uff0c\u76ee\u524d0\u4eba");
                }
                if (deptName.get("\u7edf\u8d2d\u4e2d\u5fc3") == null) {
                    res.add("\u4e3b\u8425\u7c7b\u522b\u4e3a\u5468\u8f6c\u6750\u65f6\uff0c\u7edf\u8d2d\u4e2d\u5fc3\u4e13\u5bb6\u603b\u6570\u9700\u5927\u4e8e\u7b49\u4e8e1\u4eba\uff0c\u76ee\u524d0\u4eba");
                }
                if (!(response = this.iOrgApi.getOneById(randomExpertVO.getApplyOrgId())).isSuccess()) ** GOTO lbl404
                orgVO = (OrgVO)response.getData();
                if (orgVO.getOrgType() != 1 && orgVO.getOrgType() != 2) ** GOTO lbl395
                if (!ListUtil.isEmpty((List)((List)unitNameMap.get(orgVO.getShortName()))) || !ListUtil.isEmpty((List)((List)unitNameMap.get(orgVO.getName())))) ** GOTO lbl404
                res.add("\u4e3b\u8425\u7c7b\u522b\u4e3a\u5468\u8f6c\u6750\u65f6\uff0c\u6240\u5c5e\u5355\u4f4d\u4e3a" + orgVO.getShortName() + "\u7684\u4e13\u5bb6\u603b\u6570\u9700\u5927\u4e8e\u7b49\u4e8e1\u4eba\uff0c\u76ee\u524d0\u4eba");
                ** GOTO lbl404
lbl395:
                // 1 sources

                innerCode = orgVO.getInnerCode();
                parentIds = innerCode.split("\\|");
                for (i = parentIds.length - 2; i >= 0; --i) {
                    response = this.iOrgApi.getOneById(Long.valueOf(parentIds[i]));
                    if (!response.isSuccess() || (orgVO = (OrgVO)response.getData()).getOrgType() != 1 && orgVO.getOrgType() != 2) continue;
                    if (!ListUtil.isEmpty((List)((List)unitNameMap.get(orgVO.getShortName()))) || !ListUtil.isEmpty((List)((List)unitNameMap.get(orgVO.getName())))) break;
                    res.add("\u4e3b\u8425\u7c7b\u522b\u4e3a\u5468\u8f6c\u6750\u65f6\uff0c\u6240\u5c5e\u5355\u4f4d\u4e3a" + orgVO.getShortName() + "\u7684\u4e13\u5bb6\u603b\u6570\u9700\u5927\u4e8e\u7b49\u4e8e1\u4eba\uff0c\u76ee\u524d0\u4eba");
                    break;
                }
lbl404:
                // 6 sources

                if (!ListUtil.isEmpty((List)((List)unitNameMap.get("\u8f85\u6599\u4e2d\u5fc3")))) break;
                res.add("\u4e3b\u8425\u7c7b\u522b\u4e3a\u5468\u8f6c\u6750\u65f6\uff0c\u6240\u5c5e\u5355\u4f4d\u4e3a\u8f85\u6599\u4e2d\u5fc3\u7684\u4e13\u5bb6\u603b\u6570\u9700\u5927\u4e8e\u7b49\u4e8e1\u4eba\uff0c\u76ee\u524d0\u4eba");
                break;
            }
        }
        return res;
    }

    private static /* synthetic */ List lambda$checkForSupplier$48(String k) {
        return new ArrayList();
    }

    private static /* synthetic */ List lambda$checkForSupplier$47(String k) {
        return new ArrayList();
    }

    private static /* synthetic */ List lambda$checkForSupplier$46(String k) {
        return new ArrayList();
    }

    private static /* synthetic */ List lambda$checkForSupplier$45(String k) {
        return new ArrayList();
    }

    private static /* synthetic */ List lambda$checkForSupplier$44(String k) {
        return new ArrayList();
    }

    private static /* synthetic */ List lambda$checkForSupplier$43(String k) {
        return new ArrayList();
    }

    private static /* synthetic */ List lambda$checkForSupplier$42(String k) {
        return new ArrayList();
    }

    private static /* synthetic */ List lambda$checkForSupplier$41(String k) {
        return new ArrayList();
    }

    private static /* synthetic */ List lambda$checkForSupplier$40(String k) {
        return new ArrayList();
    }

    private static /* synthetic */ List lambda$checkForSupplier$39(String k) {
        return new ArrayList();
    }

    private static /* synthetic */ List lambda$checkForSupplier$38(String k) {
        return new ArrayList();
    }

    private static /* synthetic */ List lambda$checkForSupplier$37(String k) {
        return new ArrayList();
    }

    private static /* synthetic */ List lambda$checkForSupplier$36(String k) {
        return new ArrayList();
    }

    private static /* synthetic */ List lambda$randomExpertForSupplier$35(String k) {
        return new ArrayList();
    }

    private static /* synthetic */ List lambda$randomExpertForSupplier$34(String k) {
        return new ArrayList();
    }

    private static /* synthetic */ List lambda$randomExpertForSupplier$33(String k) {
        return new ArrayList();
    }

    private static /* synthetic */ List lambda$randomExpertForSupplier$32(String k) {
        return new ArrayList();
    }

    private static /* synthetic */ List lambda$randomExpertForSupplier$31(String k) {
        return new ArrayList();
    }

    private static /* synthetic */ List lambda$randomExpertForSupplier$30(String k) {
        return new ArrayList();
    }

    private static /* synthetic */ List lambda$randomExpertForSupplier$29(String k) {
        return new ArrayList();
    }

    private static /* synthetic */ List lambda$randomExpertForSupplier$28(String k) {
        return new ArrayList();
    }

    private static /* synthetic */ List lambda$randomExpertForSupplier$27(String k) {
        return new ArrayList();
    }

    private static /* synthetic */ List lambda$randomExpertForSupplier$26(String k) {
        return new ArrayList();
    }

    private static /* synthetic */ List lambda$randomExpertForSupplier$25(String k) {
        return new ArrayList();
    }

    private static /* synthetic */ List lambda$randomExpertForSupplier$24(String k) {
        return new ArrayList();
    }

    private static /* synthetic */ List lambda$randomExpertForSupplier$23(String k) {
        return new ArrayList();
    }

    private static /* synthetic */ List lambda$randomExpertForSupplier$22(String k) {
        return new ArrayList();
    }

    private static /* synthetic */ List lambda$randomExpertForSupplier$21(String k) {
        return new ArrayList();
    }

    private static /* synthetic */ List lambda$randomExpertForSupplier$20(String k) {
        return new ArrayList();
    }

    private static /* synthetic */ List lambda$randomExpertForSupplier$19(String k) {
        return new ArrayList();
    }

    private static /* synthetic */ List lambda$randomExpertForSupplier$18(String k) {
        return new ArrayList();
    }

    private static /* synthetic */ List lambda$randomExpertForSupplier$17(String k) {
        return new ArrayList();
    }

    private static /* synthetic */ List lambda$randomExpertForSupplier$16(String k) {
        return new ArrayList();
    }

    private static /* synthetic */ List lambda$randomExpertForSupplier$15(String k) {
        return new ArrayList();
    }

    private static /* synthetic */ List lambda$randomExpertForSupplier$14(String k) {
        return new ArrayList();
    }

    private static /* synthetic */ List lambda$randomExpertForSupplier$13(String k) {
        return new ArrayList();
    }

    private static /* synthetic */ List lambda$randomExpertForSupplier$12(String k) {
        return new ArrayList();
    }
}

