/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.tender.other.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.tender.enums.DraftTypeEnum;
import com.ejianc.business.tender.other.bean.OtherInviteDetailEntity;
import com.ejianc.business.tender.other.bean.OtherInviteDetailRecordEntity;
import com.ejianc.business.tender.other.bean.OtherInviteEntity;
import com.ejianc.business.tender.other.bean.OtherPicketageRefsupplierEntity;
import com.ejianc.business.tender.other.service.IOtherInviteDetailService;
import com.ejianc.business.tender.other.service.IOtherInviteService;
import com.ejianc.business.tender.other.service.IOtherPicketageRefsupplierService;
import com.ejianc.business.tender.other.vo.OtherInviteDetailBidderVO;
import com.ejianc.business.tender.other.vo.TenderStageEnum;
import com.ejianc.foundation.message.api.IPushMessageApi;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="otherInvite")
public class OtherInviteBpmServiceImpl
implements ICommonBusinessService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IPushMessageApi pushMessageApi;
    @Autowired
    private IOtherInviteService service;
    @Autowired
    private IOtherInviteDetailService detailService;
    @Autowired
    private IOtherPicketageRefsupplierService picketageRefsupplierService;

    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        OtherInviteEntity otherInviteEntity = (OtherInviteEntity)((Object)this.service.selectById(billId));
        if (0 == otherInviteEntity.getEstablishType() && DraftTypeEnum.\u7ebf\u4e0a\u8d77\u8349.getCode().toString().equals(otherInviteEntity.getDraftType().toString())) {
            if (null == otherInviteEntity.getContractFileId()) {
                return CommonResponse.error((String)"\u8bf7\u7f16\u8f91\u62db\u6807\u6587\u4ef6\u5e76\u4fdd\u5b58\u540e\u518d\u6267\u884c\u6b64\u64cd\u4f5c\uff01");
            }
            if (!otherInviteEntity.getContractFileSyncFlag().booleanValue()) {
                return CommonResponse.error((String)"\u8bf7\u91cd\u65b0\u8fdb\u884c\u62db\u6807\u6587\u4ef6\u7f16\u8f91\uff0c\u540c\u6b65\u5355\u636e\u4fe1\u606f\u5230\u62db\u6807\u6587\u4ef6\uff01");
            }
        }
        return CommonResponse.success();
    }

    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        OtherInviteEntity otherInviteEntity = (OtherInviteEntity)((Object)this.service.selectById(billId));
        if (0 == otherInviteEntity.getEstablishType() && DraftTypeEnum.\u7ebf\u4e0a\u8d77\u8349.getCode().toString().equals(otherInviteEntity.getDraftType().toString())) {
            if (null == otherInviteEntity.getContractFileId()) {
                return CommonResponse.error((String)"\u8bf7\u7f16\u8f91\u62db\u6807\u6587\u4ef6\u5e76\u4fdd\u5b58\u540e\u518d\u6267\u884c\u6b64\u64cd\u4f5c\uff01");
            }
            if (!otherInviteEntity.getContractFileSyncFlag().booleanValue()) {
                return CommonResponse.error((String)"\u8bf7\u91cd\u65b0\u8fdb\u884c\u62db\u6807\u6587\u4ef6\u7f16\u8f91\uff0c\u540c\u6b65\u5355\u636e\u4fe1\u606f\u5230\u62db\u6807\u6587\u4ef6\uff01");
            }
        }
        return CommonResponse.success();
    }

    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        if (BillStateEnum.COMMITED_STATE.getBillStateCode() == state || BillStateEnum.PASSED_STATE.getBillStateCode() == state) {
            OtherInviteEntity inviteEntity = (OtherInviteEntity)((Object)this.service.selectById(billId));
            List<OtherInviteDetailRecordEntity> otherDetailRecord = inviteEntity.getOtherDetailRecord();
            for (OtherInviteDetailRecordEntity detailRecordEntity : otherDetailRecord) {
                this.detailService.saveOrUpdate(BeanMapper.map((Object)((Object)detailRecordEntity), OtherInviteDetailEntity.class));
            }
            List<OtherInviteDetailBidderVO> detailBidderList = this.service.selectDetailBidder(billId);
            String tenderUnitNum = "";
            for (OtherInviteDetailBidderVO detailBidderVO : detailBidderList) {
                OtherPicketageRefsupplierEntity otherPicketageRefsupplierEntity = new OtherPicketageRefsupplierEntity();
                otherPicketageRefsupplierEntity.setPicketageId(billId);
                otherPicketageRefsupplierEntity.setPicketageName(inviteEntity.getTenderName() + "\u5b9a\u6807");
                otherPicketageRefsupplierEntity.setPicketageDate(new Date());
                otherPicketageRefsupplierEntity.setMoney(detailBidderVO.getSumMoney());
                otherPicketageRefsupplierEntity.setMoneyTax(detailBidderVO.getSumTaxMoney());
                otherPicketageRefsupplierEntity.setSupplierId(detailBidderVO.getSupplierId());
                otherPicketageRefsupplierEntity.setSupplierName(detailBidderVO.getSupplierName());
                otherPicketageRefsupplierEntity.setProjectId(inviteEntity.getProjectId());
                otherPicketageRefsupplierEntity.setProjectName(inviteEntity.getProjectName());
                otherPicketageRefsupplierEntity.setProjectCode(inviteEntity.getProjectCode());
                otherPicketageRefsupplierEntity.setOrgId(inviteEntity.getOrgId());
                otherPicketageRefsupplierEntity.setOrgName(inviteEntity.getOrgName());
                otherPicketageRefsupplierEntity.setParentOrgId(inviteEntity.getParentOrgId());
                otherPicketageRefsupplierEntity.setParentOrgName(inviteEntity.getParentOrgName());
                otherPicketageRefsupplierEntity.setOccupyFlag(0);
                otherPicketageRefsupplierEntity.setPicketageFlag(1);
                otherPicketageRefsupplierEntity.setSignStatus(0);
                otherPicketageRefsupplierEntity.setPurchaseType(inviteEntity.getPurchaseType());
                this.picketageRefsupplierService.saveOrUpdate((Object)otherPicketageRefsupplierEntity);
                BigDecimal sumNum = detailBidderVO.getSumNum().setScale(4, 4);
                tenderUnitNum = tenderUnitNum + detailBidderVO.getSupplierName() + "(" + sumNum + "),";
            }
            if (tenderUnitNum.length() > 1) {
                tenderUnitNum = tenderUnitNum.substring(0, tenderUnitNum.length() - 1);
            }
            inviteEntity.setTenderUnitNum(tenderUnitNum);
            this.service.saveOrUpdate((Object)inviteEntity);
        }
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        OtherInviteEntity inviteEntity = (OtherInviteEntity)((Object)this.service.selectById(billId));
        if (inviteEntity.getOccupyState() != null && inviteEntity.getOccupyState() == 1) {
            return CommonResponse.error((String)"\u62db\u6807\u5df2\u88ab\u5360\u7528,\u4e0d\u80fd\u64a4\u56de!");
        }
        if (inviteEntity.getTenderStage() > 1) {
            return CommonResponse.error((String)("\u62db\u6807\u5904\u4e8e" + TenderStageEnum.getEnumByStateCode((Integer)inviteEntity.getTenderStage()).getDescription() + ",\u4e0d\u80fd\u64a4\u56de!"));
        }
        if (inviteEntity.getEstablishType() == 1) {
            QueryWrapper refWrapper = new QueryWrapper();
            refWrapper.eq((Object)"picketage_id", (Object)inviteEntity.getId());
            List refsupplierEntityList = this.picketageRefsupplierService.list((Wrapper)refWrapper);
            for (OtherPicketageRefsupplierEntity refsupplierEntity : refsupplierEntityList) {
                if (refsupplierEntity.getSignStatus() == 0) continue;
                return CommonResponse.error((String)"\u5b58\u5728\u5df2\u7b7e\u8ba2\u5408\u540c,\u4e0d\u80fd\u64a4\u56de!");
            }
            this.picketageRefsupplierService.remove((Wrapper)refWrapper);
        }
        this.detailService.delByInviteId(inviteEntity.getId());
        return CommonResponse.success();
    }

    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }
}

