package com.ejianc.business.tender.expert.service;

import com.ejianc.business.tender.expert.bean.ExpertRecordEntity;
import com.ejianc.business.tender.expert.bean.ExpertRecordScoreEntity;
import com.ejianc.business.tender.expert.bean.ExpertEvaluatingEntity;
import com.ejianc.business.tender.expert.vo.ExpertRecordScoreVO;
import com.ejianc.business.tender.other.bean.OtherDocumentSchemeEntity;
import com.ejianc.business.tender.other.bean.OtherDocumentSupplierEntity;
import com.ejianc.business.tender.expert.vo.ExpertRecordVO;
import com.ejianc.business.tender.expert.bean.TemplateDetailEntity;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.IBaseService;

import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.Map;

/**
 * 评标记录表
 * 
 * @author generator
 * 
 */
public interface IExpertRecordService extends IBaseService<ExpertRecordEntity> {


    List<TemplateDetailEntity> selectTemplateList(Long templateId);

    Integer selectExist(Long employeeId,Long documentId);

    List<ExpertRecordVO> selectDetail();

    List<ExpertRecordScoreEntity> selectScore(Long id);

    ExpertEvaluatingEntity selectEvaluation(Long id);

    List<ExpertRecordVO> selectBySupplier(Long employeeId, Long documentId);

    List<List<ExpertRecordVO>> saveOrUpdateList(List<List<Map>> supplierDetail);

    Map<String, Object> querySupplierList(Long documentId, Long templateId, Long id) throws InvocationTargetException, IllegalAccessException;

    List<TemplateDetailEntity> selectTemplateDetail(Long parentId);

    List<ExpertRecordScoreVO> selectByParentId(Long scoringTemplateDetailParentId,Long recordId);

    List<List<ExpertRecordVO>> queryDetail(Long evaluationId, Long expertId);

    List<OtherDocumentSchemeEntity> selectOtherSchemeList(Long id,Long supplierId);

    List<OtherDocumentSupplierEntity> selectOtherSupplierList(Long documentId, Integer talkNum);
}
