package com.ejianc.business.tender.other.controller;

import com.ejianc.business.tender.other.bean.OtherAdviceEntity;
import com.ejianc.business.tender.other.bean.OtherPicketageEntity;
import com.ejianc.business.tender.other.service.IOtherAdviceService;
import com.ejianc.business.tender.other.service.IOtherPicketageService;
import com.ejianc.business.tender.other.vo.OtherAdviceVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import java.io.Serializable;
import java.util.List;

/**
 * 其它-中标通知书
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("otherAdvice")
public class OtherAdviceController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "other-advice-code";//此处需要根据实际修改

    @Autowired
    private IOtherAdviceService service;
    @Autowired
    private IOtherPicketageService otherPicketageService;
    @Autowired
    private SessionManager sessionManager;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<OtherAdviceVO> saveOrUpdate(@RequestBody OtherAdviceVO saveOrUpdateVO) {
        OtherAdviceEntity entity = BeanMapper.map(saveOrUpdateVO, OtherAdviceEntity.class);
        if(entity.getBillCode() == null){
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE,InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        entity.setScFlag(0);
        service.saveOrUpdate(entity, false);
        OtherAdviceVO vo = BeanMapper.map(entity, OtherAdviceVO.class);
        return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<OtherAdviceVO> queryDetail(Long id) {
        OtherAdviceEntity entity = service.selectById(id);
        OtherPicketageEntity otherPicketageEntity = otherPicketageService.selectById(entity.getPicketageId());
        OtherAdviceVO vo = BeanMapper.map(entity, OtherAdviceVO.class);
        vo.setTrusteesId(otherPicketageEntity.getTrusteesId());
        vo.setTrusteesName(otherPicketageEntity.getTrusteesName());
        vo.setTrusteesPhone(otherPicketageEntity.getTrusteesPhone());
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    @RequestMapping(value = "/queryAdviceList", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<OtherAdviceVO>> queryAdviceList(@RequestParam Long id) {
        List<OtherAdviceVO> list = service.queryAdviceList(id);
        return CommonResponse.success("查询详情数据成功！",list);
    }
    /**
     * @Description 发布接口
     * @param id
     */
    @RequestMapping(value = "/sendAdvice", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<String> sendAdvice(Long id) {
        String s = service.sendAdvice(id);
        return CommonResponse.success("发送成功！",s);
    }
}
