package com.ejianc.business.tender.other.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.supbid.other.api.ISupNoticeApi;
import com.ejianc.business.supbid.win.vo.BidVO;
import com.ejianc.business.tender.other.bean.OtherAdviceEntity;
import com.ejianc.business.tender.other.bean.OtherBidEntity;
import com.ejianc.business.tender.other.bean.OtherInviteEntity;
import com.ejianc.business.tender.other.mapper.OtherAdviceMapper;
import com.ejianc.business.tender.other.service.IOtherAdviceService;
import com.ejianc.business.tender.other.service.IOtherBidService;
import com.ejianc.business.tender.other.service.IOtherInviteService;
import com.ejianc.business.tender.other.vo.OtherAdviceSupplierPushVO;
import com.ejianc.business.tender.other.vo.OtherAdviceVO;
import com.ejianc.business.tender.util.CommonUtils;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.framework.cache.utils.RedisTool;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.dataPush.ISystemDataPushService;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 其它-中标通知书
 * 
 * @author generator
 * 
 */
@Service("otherAdviceService")
public class OtherAdviceServiceImpl extends BaseServiceImpl<OtherAdviceMapper, OtherAdviceEntity> implements IOtherAdviceService{
    @Autowired
    private IOtherInviteService otherInviteService;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private JedisPool jedisPool;
    @Autowired
    private ISystemDataPushService systemDataPushService;
    //    @Autowired
//    private IStuffAdviceService stuffAdviceService;
private final String OPERATE = "STUFF_ADVICE_SYNC";

    private final String PUSH_ADVICE_SERVER_URL = "/ejc-supbid-web/openapi/bid/saveBid";
//    @Autowired
//    private IProSupplierApi proSupplierApi;
    private static final String BILL_TYPE = "BT220317000000004";//此处需要根据实际修改
    @Autowired
    private IOtherBidService otherBidService;
    @Autowired
    private IAttachmentApi attachmentApi;
    @Autowired
    private ISupNoticeApi supNoticeApi;

//    @Autowired
//    private ISignatureCommonApi signatureCommonApi;

//    @Override
//    public CommonResponse<String> changeStatus(Long billId, int status, String refCode) {
//        //status   发起:3,  甲方-4  已签章
//        //签章状态 未签章 -0,待签章-1,已签章-2
//        OtherAdviceEntity otherAdviceEntity = super.selectById(billId);
//        if(status == 5 || status == 6 || status == 7 || status == 8){
//            otherAdviceEntity.setSignFlag(0);
//        }
//        if(status == 2 || status == 3){
//            otherAdviceEntity.setSignFlag(1);
//        }
//        if(status == 4){
//            otherAdviceEntity.setSignFlag(2);
//            // 先同步签章附件
//            ContractVO cv = new ContractVO();
//            cv.setContractId(otherAdviceEntity.getId());
//            cv.setContractName(otherAdviceEntity.getTitleName());
//            cv.setBillType(BILL_TYPE);
//            cv.setSourceType("tenderAdvice");
//            ArrayList<ContractVO> cvs = new ArrayList<>();
//            cvs.add(cv);
//
//            CommonResponse<List<SignMgrPreviewVO>> signResp = signatureCommonApi.fetchSignedContract(cvs);
//            if(!signResp.isSuccess()){
//                throw new BusinessException("同步签章附件失败!");
//            }
//        }
//        super.updateById(otherAdviceEntity);
//
//        return CommonResponse.success("更新成功!");
//    }

    @Override
    @Transactional
    public String sendAdvice(Long id) {
        OtherAdviceEntity otherAdviceEntity = super.selectById(id);
        otherAdviceEntity.setSendFlag(0);
        super.updateById(otherAdviceEntity);
        OtherInviteEntity otherInviteEntity = otherInviteService.selectById(otherAdviceEntity.getInviteId());
        BidVO otherAdviceSupplierPushVO = BeanMapper.map(otherAdviceEntity, BidVO.class);

        //设置单据当前系统信息
//        CommonResponse<String> ejcCloudSystemCode = proSupplierApi.getEjcCloudSystemCode();
//        if (!ejcCloudSystemCode.isSuccess()) {
//            throw new BusinessException("获取当前系统编码失败" + ejcCloudSystemCode.getMsg());
//        }
        //设置当前系统ID
//        otherAdviceSupplierPushVO.setSystemId(ejcCloudSystemCode.getData());
        otherAdviceSupplierPushVO.setSourceType("云南建投材料中标通知书");
        otherAdviceSupplierPushVO.setSourceId(otherAdviceEntity.getId().toString());
        otherAdviceSupplierPushVO.setBidTitle(otherAdviceEntity.getTitleName());
        otherAdviceSupplierPushVO.setSourceProjectId(otherAdviceEntity.getProjectId() != null ? otherAdviceEntity.getProjectId().toString() : null);
        otherAdviceSupplierPushVO.setSourceOrgId(otherAdviceEntity.getOrgId().toString());
        otherAdviceSupplierPushVO.setSourceUnitId(otherAdviceEntity.getUnitId().toString());
//        otherAdviceSupplierPushVO.setType("TYPE_MATERIAL");
        otherAdviceSupplierPushVO.setType(CommonUtils.getGysType(CommonUtils.TYPE_OTHER));
        otherAdviceSupplierPushVO.setTenderType(otherInviteEntity.getTenderType());
        otherAdviceSupplierPushVO.setBidDate(otherAdviceEntity.getNoticeDate());
        otherAdviceSupplierPushVO.setMoney(otherAdviceEntity.getMoney());
        otherAdviceSupplierPushVO.setMoneyTax(otherAdviceEntity.getMoneyTax());

        String dataInfo = JSONObject.toJSONString(otherAdviceSupplierPushVO);

        CommonResponse<Boolean> booleanCommonResponse = supNoticeApi.saveBid(otherAdviceSupplierPushVO);
        if (!booleanCommonResponse.isSuccess()){
            throw new BusinessException("推送供方失败!");
        }
//        boolean b = pushBillToSupCenter(dataInfo, otherAdviceEntity.getSupplierId(), otherAdviceEntity.getId(),
//                BILL_TYPE, PUSH_ADVICE_SERVER_URL, otherAdviceEntity.getTitleName());
//        if (!b){
//            throw new BusinessException("推送供方失败!");
//        }
        return null;
    }
    private boolean pushBillToSupCenter(String datInfo, Long supplierId, Long sourceId, String billTypeCode, String url,String sourceName) {
        boolean locked = false, syncFlag = false;
        Jedis jedis = jedisPool.getResource();
        String key = billTypeCode + "::" + sourceId.toString();

        try {
            //对单据进行加锁
            locked = RedisTool.tryLock(jedis, key, OPERATE, 600);

            if(!locked) {
                logger.error("单据推送失败，单据锁获取失败！");
                releaseLock(jedis, false, key, OPERATE);
                return false;
            }
//            // 先同步最新合同
//            StuffAdviceEntity stuffAdviceEntity = super.selectById(sourceId);
//            Assert.notNull(entity, "查询不到合同详情");
//            ContractVO cv = new ContractVO();
//            cv.setContractId(sourceId);
//            cv.setContractName(sourceName);
////            cv.setBillType("BT220316000000001");
//            cv.setBillType(billTypeCode);
//            cv.setSourceType("tenderAdvice");
//            ArrayList<ContractVO> cvs = new ArrayList<>();
//            cvs.add(cv);
//
//            CommonResponse<List<SignMgrPreviewVO>> signResp = signatureCommonApi.fetchSignedContract(cvs);


            Map<String, String> paramMap = new HashMap<>();
            paramMap.put("transData", datInfo);

            //查询单据附件信息并下载
            CommonResponse<List<AttachmentVO>> fileResp = attachmentApi.queryListBySourceId(sourceId, null, "tenderAdvice", null);
            if (fileResp.isSuccess()) {
                Map<String, Map<String, InputStream>> files = new HashMap<>();
                List<AttachmentVO> fileList = fileResp.getData();
                Map<String, String> fileSourceTypeMap = new HashMap<>();
                List<Long> fileIds = new ArrayList<>();

                //从附件信息列表获取到： 1、附件名对应附件业务类型Map,2、获取到附件Id列表
                for (AttachmentVO attach : fileList) {
                    fileSourceTypeMap.put(attach.getFileName(), attach.getSourceType());
                    fileIds.add(attach.getId());
                }

                paramMap.put("nameSourceTypeMapping", JSONObject.toJSONString(fileSourceTypeMap));

                //当前单据携带有附件信息
//                if (org.apache.commons.collections.CollectionUtils.isNotEmpty(fileList)) {
//                    Map<String, InputStream> fileMap = FileUtil.getInstance().batchDownFileFlow(fileIds, true);
//                    fileMap.keySet().stream().forEach(fileKey -> {
//                        Map<String, InputStream> file = new HashMap<>(1);
//                        file.put(fileKey, fileMap.get(fileKey));
//                        files.put("file", file);
//                    });
//                }
                logger.info("向供应商-{}推送计量单据参数-{}", supplierId, JSONObject.toJSONString(paramMap));

                //推送单据到指定的供方
                CommonResponse<String> syncReqResp = systemDataPushService.exchangeDataAndFilesWithEachLinkSystem(url,
                        paramMap,
                        supplierId.toString(),
                        files);

                if (syncReqResp.isSuccess()) {
                    CommonResponse<String> billPushResp = JSONObject.parseObject(syncReqResp.getData(), CommonResponse.class);
                    if (billPushResp.isSuccess()) {
                        syncFlag = true;
                    } else {
                        logger.error("供方id-{}处理推送验收单据id-{}失败, {}", supplierId, sourceId, billPushResp.getMsg());
                    }
                } else {
                    logger.error("发送请求推送验收单据id-{}给供方id-{}失败, {}", sourceId, supplierId, syncReqResp.getMsg());
                }
            } else {
                logger.error("获取验收单据id-{}对应附件信息失败, {}", sourceId, fileResp.getMsg());
            }

        } catch (Exception e) {
            logger.error("推送验收单据id-{}给供方id-{} 异常，", sourceId, supplierId, e);
        } finally {
            //释放单据锁
            releaseLock(jedis, locked, key, OPERATE);
        }

        return syncFlag;
    }
    public void releaseLock(Jedis jedis, boolean locked, String key, String OPERATE) {
        try {
            if(locked) {
                RedisTool.releaseLock(jedis, key, OPERATE);
            }
        } finally {
            if(null != jedis) {
                jedis.close();
            }
        }
    }
    @Override
    public List<OtherAdviceVO> queryAdviceList(Long id) {
        OtherBidEntity otherBidEntity = otherBidService.selectById(id);
        LambdaQueryWrapper<OtherAdviceEntity> lambdaAdvice = Wrappers.<OtherAdviceEntity>lambdaQuery();
        lambdaAdvice.eq(OtherAdviceEntity::getInviteId, otherBidEntity.getInviteId());
        List<OtherAdviceEntity> list = super.list(lambdaAdvice);
        List<OtherAdviceVO> otherAdviceVOS = BeanMapper.mapList(list, OtherAdviceVO.class);
        //处理签章附件信息
        if (CollectionUtils.isNotEmpty(otherAdviceVOS)) {
            List<Long> attachIds = otherAdviceVOS.stream().map(OtherAdviceVO::getId).collect(Collectors.toList());
            Map<String, List<Long>> map = new HashMap<>();
            map.put("sourceIds", attachIds);
            JSONObject itemJSONObj = JSONObject.parseObject(JSON.toJSONString(map));
            CommonResponse<List<AttachmentVO>> listCommonResponse = attachmentApi.queryAllBySourceIdList(itemJSONObj);
            if (listCommonResponse.isSuccess()) {
                List<AttachmentVO> data = listCommonResponse.getData();
                if (CollectionUtils.isNotEmpty(data)) {
                    Map<Long, AttachmentVO> attacMap = data.stream().filter(s -> s.getSourceType().equals("tenderAdvice")).collect(Collectors.toMap(AttachmentVO::getSourceId, Function.identity()));
                    for (OtherAdviceVO otherAdviceVO : otherAdviceVOS) {
                        AttachmentVO attachmentVO = attacMap.get(otherAdviceVO.getId());
                        if (attachmentVO != null) {
                            otherAdviceVO.setAttachId(attachmentVO.getId());
                            otherAdviceVO.setFileName(attachmentVO.getFileName());
                            otherAdviceVO.setFilePath(attachmentVO.getFilePath());
                        }
                    }
                }
            }
        }
        return otherAdviceVOS;
    }
}
