/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.tender.other.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.tender.other.bean.OtherDocumentEntity;
import com.ejianc.business.tender.other.bean.OtherInviteEntity;
import com.ejianc.business.tender.other.bean.OtherPicketageEntity;
import com.ejianc.business.tender.other.bean.OtherPicketageSupplierEntity;
import com.ejianc.business.tender.other.bean.OtherWinnoticeEntity;
import com.ejianc.business.tender.other.mapper.OtherWinnoticeMapper;
import com.ejianc.business.tender.other.service.IOtherBidDetailService;
import com.ejianc.business.tender.other.service.IOtherBidSupplierService;
import com.ejianc.business.tender.other.service.IOtherDocumentSellService;
import com.ejianc.business.tender.other.service.IOtherDocumentService;
import com.ejianc.business.tender.other.service.IOtherDocumentSupplierService;
import com.ejianc.business.tender.other.service.IOtherInviteService;
import com.ejianc.business.tender.other.service.IOtherNoticeService;
import com.ejianc.business.tender.other.service.IOtherPicketageService;
import com.ejianc.business.tender.other.service.IOtherPicketageSupplierService;
import com.ejianc.business.tender.other.service.IOtherWinnoticeService;
import com.ejianc.business.tender.other.vo.OtherPicketageSupplierVO;
import com.ejianc.business.tender.other.vo.OtherWinDetailVO;
import com.ejianc.business.tender.other.vo.OtherWinVO;
import com.ejianc.business.tender.other.vo.OtherWinnoticeVO;
import com.ejianc.business.tender.other.vo.TenderStageEnum;
import com.ejianc.business.tender.process.bean.ProcessEntity;
import com.ejianc.business.tender.process.service.IProcessService;
import com.ejianc.business.tender.util.CommonUtils;
import com.ejianc.business.tender.util.TenderTypeEnum;
import com.ejianc.foundation.share.vo.SupplierVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.ISupplierApi;
import com.ejianc.foundation.tenant.api.IidmWebEnterpriseApi;
import com.ejianc.foundation.tenant.vo.EnterpriseVO;
import com.ejianc.framework.cache.redis.CacheManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.dataPush.IEjcCloudDataPushService;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.RequestMethod;

@Service(value="otherWinnoticeService")
public class OtherWinnoticeServiceImpl
extends BaseServiceImpl<OtherWinnoticeMapper, OtherWinnoticeEntity>
implements IOtherWinnoticeService {
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOtherPicketageService otherPicketageService;
    @Autowired
    private IOtherNoticeService otherNoticeService;
    @Autowired
    private IOtherDocumentService otherDocumentService;
    @Autowired
    private IOtherInviteService otherInviteService;
    @Autowired
    private IOtherBidDetailService otherBidDetailService;
    @Autowired
    private IOtherDocumentSellService otherDocumentSellService;
    @Autowired
    private IOtherBidSupplierService otherBidSupplierService;
    @Autowired
    private IOtherDocumentSupplierService otherDocumentSupplierService;
    @Autowired
    private IProcessService processService;
    @Autowired
    private CacheManager cacheManager;
    @Value(value="${gysUrl.winSaveOrUpdateUrl}")
    private String winSaveOrUpdateUrl;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IEjcCloudDataPushService systemDataPushService;
    @Autowired
    private IidmWebEnterpriseApi idmWebEnterpriseApi;
    @Value(value="${gysUrl.appId}")
    private String appId;
    @Value(value="${gysUrl.appSecret}")
    private String appSecret;
    @Value(value="${gysUrl.appHost}")
    private String appHost;
    @Autowired
    private ISupplierApi supplierApi;
    @Autowired
    private IOtherPicketageSupplierService OtherPicketageSupplierService;

    @Override
    @Transactional
    public OtherWinnoticeVO saveWinnotice(Long picketageId) {
        OtherWinnoticeEntity entity = new OtherWinnoticeEntity();
        entity.setPicketageId(picketageId);
        OtherPicketageEntity otherPicketageEntity = (OtherPicketageEntity)((Object)this.otherPicketageService.selectById(picketageId));
        OtherInviteEntity inviteEntity = (OtherInviteEntity)((Object)this.otherInviteService.selectById(otherPicketageEntity.getInviteId()));
        entity.setInviteId(otherPicketageEntity.getInviteId());
        entity.setTitleName(inviteEntity.getTenderName() + "\u4e2d\u6807\u516c\u544a");
        entity.setInviteName(inviteEntity.getTenderName());
        entity.setUnitId(inviteEntity.getUnitId());
        entity.setUnitName(inviteEntity.getUnitName());
        if (inviteEntity.getPurchaseType().equals(0)) {
            entity.setOrgId(inviteEntity.getOrgId());
            entity.setOrgName(inviteEntity.getOrgName());
            entity.setProjectId(inviteEntity.getProjectId());
            entity.setProjectName(inviteEntity.getProjectName());
            entity.setProjectCode(inviteEntity.getProjectCode());
            entity.setParentOrgId(inviteEntity.getParentOrgId());
            entity.setParentOrgName(inviteEntity.getParentOrgName());
        }
        if (inviteEntity.getPurchaseType().equals(1)) {
            entity.setOrgId(inviteEntity.getOrgId());
            entity.setOrgName(inviteEntity.getOrgName());
        }
        OtherDocumentEntity otherDocumentEntity = (OtherDocumentEntity)((Object)this.otherDocumentService.selectById(otherPicketageEntity.getDocumentId()));
        entity.setEmployeeId(otherDocumentEntity.getEmployeeId());
        entity.setEmployeeName(otherDocumentEntity.getEmployeeName());
        entity.setEmployeeMobile(otherDocumentEntity.getEmployeeMobile());
        entity.setPurchaseType(inviteEntity.getPurchaseType());
        entity.setPublishFlag(1);
        entity.setNextFlag(1);
        entity.setLineTypeName(CommonUtils.getTypeName(5));
        entity.setTenderTypeName(TenderTypeEnum.getEnumByStateCode((Integer)inviteEntity.getTenderType()).getDescription());
        super.saveOrUpdate((Object)entity, false);
        otherPicketageEntity.setWinnoticeStatus(1);
        otherPicketageEntity.setWinnoticeId(entity.getId());
        this.otherPicketageService.updateById((Object)otherPicketageEntity);
        inviteEntity.setTenderStage(TenderStageEnum.BID_ANNOUNCEMENT_STATE.getTenderTypeCode());
        this.otherInviteService.updateById((Object)inviteEntity);
        List<OtherPicketageSupplierEntity> picketageSupplierList = otherPicketageEntity.getPicketageSupplierList();
        for (OtherPicketageSupplierEntity otherPicketageSupplierEntity : picketageSupplierList) {
            otherPicketageSupplierEntity.setWinnoticeId(entity.getId());
        }
        this.OtherPicketageSupplierService.updateBatchById(picketageSupplierList);
        ProcessEntity processEntity = new ProcessEntity();
        processEntity.setBillId(entity.getId());
        processEntity.setBillName(TenderStageEnum.BID_ANNOUNCEMENT_STATE.getDescription());
        processEntity.setTenderId(entity.getInviteId());
        processEntity.setType(3);
        processEntity.setFrontendUrl("other/winnotice");
        this.processService.saveOrUpdate((Object)processEntity);
        OtherWinnoticeVO otherWinnoticeVO = (OtherWinnoticeVO)BeanMapper.map((Object)((Object)entity), OtherWinnoticeVO.class);
        return otherWinnoticeVO;
    }

    @Override
    public OtherWinnoticeVO queryDetail(Long id) {
        OtherWinnoticeEntity otherWinnoticeEntity = (OtherWinnoticeEntity)((Object)super.selectById((Serializable)id));
        OtherWinnoticeVO otherWinnoticeVO = (OtherWinnoticeVO)BeanMapper.map((Object)((Object)otherWinnoticeEntity), OtherWinnoticeVO.class);
        OtherPicketageEntity otherPicketageEntity = (OtherPicketageEntity)((Object)this.otherPicketageService.selectById(otherWinnoticeEntity.getPicketageId()));
        List<OtherPicketageSupplierEntity> picketageSupplierList = otherPicketageEntity.getPicketageSupplierList();
        List otherPicketageSupplierList = BeanMapper.mapList(picketageSupplierList, OtherPicketageSupplierVO.class);
        otherWinnoticeVO.setPicketageSupplierList(otherPicketageSupplierList);
        return otherWinnoticeVO;
    }

    @Override
    public OtherWinnoticeVO publishWinnotice(Long id) {
        OtherWinnoticeEntity otherWinnoticeEntity = (OtherWinnoticeEntity)((Object)super.selectById((Serializable)id));
        otherWinnoticeEntity.setPublishFlag(0);
        super.updateById((Object)otherWinnoticeEntity);
        OtherPicketageEntity otherPicketageEntity = (OtherPicketageEntity)((Object)this.otherPicketageService.selectById(otherWinnoticeEntity.getPicketageId()));
        otherPicketageEntity.setWinnoticeStatus(2);
        this.otherPicketageService.updateById((Object)otherPicketageEntity);
        OtherInviteEntity otherInviteEntity = (OtherInviteEntity)((Object)this.otherInviteService.selectById(otherPicketageEntity.getInviteId()));
        OtherWinVO winVO = new OtherWinVO();
        winVO.setSourceType("\u4e91\u5357\u5efa\u6295\u4e2d\u6807\u516c\u544a");
        winVO.setSourceId(Long.toString(otherWinnoticeEntity.getInviteId()));
        winVO.setBillCode(otherInviteEntity.getBillCode());
        if (otherInviteEntity.getPurchaseType() == 0) {
            winVO.setSourceProjectId(Long.toString(otherInviteEntity.getProjectId()));
            winVO.setProjectName(otherInviteEntity.getProjectName());
            winVO.setProjectCode(otherInviteEntity.getProjectCode());
        }
        if (otherInviteEntity.getPurchaseType() == 1) {
            winVO.setOrgName(otherInviteEntity.getOrgName());
            winVO.setSourceOrgId(Long.toString(otherInviteEntity.getOrgId()));
        }
        winVO.setSourceUnitId(Long.toString(otherInviteEntity.getUnitId()));
        winVO.setUnitName(otherInviteEntity.getUnitName());
        winVO.setType("OTHER");
        winVO.setTenderName(otherInviteEntity.getTenderName());
        winVO.setTenderType(otherInviteEntity.getTenderType());
        winVO.setSourceEmployeeId(Long.toString(otherWinnoticeEntity.getEmployeeId()));
        winVO.setEmployeeName(otherWinnoticeEntity.getEmployeeName());
        winVO.setEmployeeMobile(otherWinnoticeEntity.getEmployeeMobile());
        winVO.setPurchaseType(otherInviteEntity.getPurchaseType());
        winVO.setWinDate(otherWinnoticeEntity.getWinDate());
        winVO.setStopDate(otherWinnoticeEntity.getStopDate());
        winVO.setWinTitle(otherWinnoticeEntity.getTitleName());
        winVO.setMemo(otherWinnoticeEntity.getMemo());
        winVO.setSystemId(((EnterpriseVO)this.idmWebEnterpriseApi.getEnterpriseByTenantId(InvocationInfoProxy.getTenantid()).getData()).getId().toString());
        List<OtherPicketageSupplierEntity> picketageSupplierList = otherPicketageEntity.getPicketageSupplierList();
        ArrayList<OtherWinDetailVO> winDetailVOS = new ArrayList<OtherWinDetailVO>();
        for (OtherPicketageSupplierEntity otherPicketageSupplierEntity : picketageSupplierList) {
            OtherWinDetailVO winDetailVO = new OtherWinDetailVO();
            winDetailVO.setWinId(otherWinnoticeEntity.getId());
            winDetailVO.setSupplierName(otherPicketageSupplierEntity.getSupplierName());
            winDetailVO.setTenderFlag(otherPicketageSupplierEntity.getTenderFlag());
            SupplierVO supplierVO = (SupplierVO)this.supplierApi.queryById(otherPicketageSupplierEntity.getSupplierId()).getData();
            winDetailVO.setTenantId(supplierVO.getTenant());
            winDetailVO.setMoney(otherPicketageSupplierEntity.getMoneyTax());
            winDetailVOS.add(winDetailVO);
        }
        winVO.setWinDetailList(winDetailVOS);
        String stringFb = JSONObject.toJSONString((Object)winVO);
        this.logger.info("\u4e2d\u6807\u516c\u544a\u53d1\u5e03" + stringFb);
        CommonResponse stringCommonResponse = this.systemDataPushService.exchangeDataWithUniversal(this.winSaveOrUpdateUrl, RequestMethod.POST, stringFb, this.appId, this.appSecret, this.appHost);
        if (!stringCommonResponse.isSuccess()) {
            throw new BusinessException("\u4e2d\u6807\u516c\u544a\u540c\u6b65\u4f9b\u65b9\u63a5\u53e3\u62a5\u9519" + stringCommonResponse.getMsg());
        }
        return this.queryDetail(id);
    }

    @Override
    public OtherWinnoticeVO saveOrUpdates(OtherWinnoticeEntity entity) {
        super.saveOrUpdate((Object)entity, false);
        return this.queryDetail(entity.getId());
    }
}

