/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.tender.equipment.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.signaturemanage.api.ISignatureCommonApi;
import com.ejianc.business.signaturemanage.vo.ContractVO;
import com.ejianc.business.tender.equipment.bean.EquipmentAdviceEntity;
import com.ejianc.business.tender.equipment.bean.EquipmentBidEntity;
import com.ejianc.business.tender.equipment.bean.EquipmentInviteEntity;
import com.ejianc.business.tender.equipment.mapper.EquipmentAdviceMapper;
import com.ejianc.business.tender.equipment.service.IEquipmentAdviceService;
import com.ejianc.business.tender.equipment.service.IEquipmentBidService;
import com.ejianc.business.tender.equipment.service.IEquipmentInviteService;
import com.ejianc.business.tender.equipment.vo.EquipmentAdviceSupplierPushVO;
import com.ejianc.business.tender.equipment.vo.EquipmentAdviceVO;
import com.ejianc.business.tender.stuff.service.IStuffAdviceService;
import com.ejianc.business.tender.util.CommonUtils;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.foundation.share.api.IProSupplierApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="equipmentAdviceService")
public class EquipmentAdviceServiceImpl
extends BaseServiceImpl<EquipmentAdviceMapper, EquipmentAdviceEntity>
implements IEquipmentAdviceService {
    @Autowired
    private IEquipmentInviteService equipmentInviteService;
    @Autowired
    private IEquipmentBidService equipmentBidService;
    @Autowired
    private IStuffAdviceService stuffAdviceService;
    private final String PUSH_ADVICE_SERVER_URL = "/ejc-supbid-web/openapi/bid/saveBid";
    @Autowired
    private IProSupplierApi proSupplierApi;
    private static final String BILL_TYPE = "BT220317000000002";
    @Autowired
    private IAttachmentApi attachmentApi;
    @Autowired
    private ISignatureCommonApi signatureCommonApi;

    @Override
    public CommonResponse<String> changeStatus(Long billId, int status, String refCode) {
        EquipmentAdviceEntity equipmentAdviceEntity = (EquipmentAdviceEntity)((Object)super.selectById((Serializable)billId));
        if (status == 5 || status == 6 || status == 7 || status == 8) {
            equipmentAdviceEntity.setSignFlag(0);
        }
        if (status == 2 || status == 3) {
            equipmentAdviceEntity.setSignFlag(1);
        }
        if (status == 4) {
            equipmentAdviceEntity.setSignFlag(2);
            ContractVO cv = new ContractVO();
            cv.setContractId(equipmentAdviceEntity.getId());
            cv.setContractName(equipmentAdviceEntity.getTitleName());
            cv.setBillType(BILL_TYPE);
            cv.setSourceType("tenderAdvice");
            ArrayList<ContractVO> cvs = new ArrayList<ContractVO>();
            cvs.add(cv);
            CommonResponse signResp = this.signatureCommonApi.fetchSignedContract(cvs);
            if (!signResp.isSuccess()) {
                throw new BusinessException("\u540c\u6b65\u7b7e\u7ae0\u9644\u4ef6\u5931\u8d25!");
            }
        }
        super.updateById((Object)equipmentAdviceEntity);
        return CommonResponse.success((String)"\u66f4\u65b0\u6210\u529f!");
    }

    @Override
    @Transactional
    public String sendAdvice(Long id) {
        EquipmentAdviceEntity equipmentAdviceEntity = (EquipmentAdviceEntity)((Object)super.selectById((Serializable)id));
        equipmentAdviceEntity.setSendFlag(0);
        super.updateById((Object)equipmentAdviceEntity);
        EquipmentInviteEntity equipmentInviteEntity = (EquipmentInviteEntity)((Object)this.equipmentInviteService.selectById(equipmentAdviceEntity.getInviteId()));
        EquipmentAdviceSupplierPushVO equipmentAdviceSupplierPushVO = (EquipmentAdviceSupplierPushVO)BeanMapper.map((Object)((Object)equipmentAdviceEntity), EquipmentAdviceSupplierPushVO.class);
        CommonResponse ejcCloudSystemCode = this.proSupplierApi.getEjcCloudSystemCode();
        if (!ejcCloudSystemCode.isSuccess()) {
            throw new BusinessException("\u83b7\u53d6\u5f53\u524d\u7cfb\u7edf\u7f16\u7801\u5931\u8d25" + ejcCloudSystemCode.getMsg());
        }
        equipmentAdviceSupplierPushVO.setSystemId((String)ejcCloudSystemCode.getData());
        equipmentAdviceSupplierPushVO.setSourceType("\u90d1\u5dde\u4e00\u5efa\u6750\u6599\u4e2d\u6807\u901a\u77e5\u4e66");
        equipmentAdviceSupplierPushVO.setSourceId(equipmentAdviceEntity.getId().toString());
        equipmentAdviceSupplierPushVO.setBidTitle(equipmentAdviceEntity.getTitleName());
        equipmentAdviceSupplierPushVO.setSourceProjectId(equipmentAdviceEntity.getProjectId() != null ? equipmentAdviceEntity.getProjectId().toString() : null);
        equipmentAdviceSupplierPushVO.setSourceOrgId(equipmentAdviceEntity.getOrgId().toString());
        equipmentAdviceSupplierPushVO.setSourceUnitId(equipmentAdviceEntity.getUnitId().toString());
        equipmentAdviceSupplierPushVO.setType(CommonUtils.getGysType(2));
        equipmentAdviceSupplierPushVO.setTenderType(equipmentInviteEntity.getTenderType());
        equipmentAdviceSupplierPushVO.setBidDate(equipmentAdviceEntity.getNoticeDate());
        equipmentAdviceSupplierPushVO.setMoney(equipmentAdviceEntity.getMoney());
        equipmentAdviceSupplierPushVO.setMoneyTax(equipmentAdviceEntity.getMoneyTax());
        String dataInfo = JSONObject.toJSONString((Object)equipmentAdviceSupplierPushVO);
        boolean b = this.stuffAdviceService.pushBillToSupCenter(dataInfo, equipmentAdviceEntity.getSupplierId(), equipmentAdviceEntity.getId(), BILL_TYPE, "/ejc-supbid-web/openapi/bid/saveBid", equipmentAdviceEntity.getTitleName());
        if (!b) {
            throw new BusinessException("\u63a8\u9001\u4f9b\u65b9\u5931\u8d25!");
        }
        return null;
    }

    @Override
    public List<EquipmentAdviceVO> queryAdviceList(Long id) {
        EquipmentBidEntity equipmentBidEntity = (EquipmentBidEntity)((Object)this.equipmentBidService.selectById(id));
        LambdaQueryWrapper lambdaAdvice = Wrappers.lambdaQuery();
        lambdaAdvice.eq(EquipmentAdviceEntity::getInviteId, (Object)equipmentBidEntity.getInviteId());
        List list = super.list((Wrapper)lambdaAdvice);
        List equipmentAdviceVOS = BeanMapper.mapList((Iterable)list, EquipmentAdviceVO.class);
        if (CollectionUtils.isNotEmpty((Collection)equipmentAdviceVOS)) {
            List data;
            List attachIds = equipmentAdviceVOS.stream().map(BaseVO::getId).collect(Collectors.toList());
            HashMap map = new HashMap();
            map.put("sourceIds", attachIds);
            JSONObject itemJSONObj = JSONObject.parseObject((String)JSON.toJSONString(map));
            CommonResponse listCommonResponse = this.attachmentApi.queryAllBySourceIdList(itemJSONObj);
            if (listCommonResponse.isSuccess() && CollectionUtils.isNotEmpty((Collection)(data = (List)listCommonResponse.getData()))) {
                Map attacMap = data.stream().filter(s -> s.getSourceType().equals("tenderAdvice")).collect(Collectors.toMap(AttachmentVO::getSourceId, Function.identity()));
                for (EquipmentAdviceVO equipmentAdviceVO : equipmentAdviceVOS) {
                    AttachmentVO attachmentVO = (AttachmentVO)attacMap.get(equipmentAdviceVO.getId());
                    if (attachmentVO == null) continue;
                    equipmentAdviceVO.setAttachId(attachmentVO.getId());
                    equipmentAdviceVO.setFileName(attachmentVO.getFileName());
                    equipmentAdviceVO.setFilePath(attachmentVO.getFilePath());
                }
            }
        }
        return equipmentAdviceVOS;
    }
}

