/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.tender.rent.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.signaturemanage.api.ISignatureCommonApi;
import com.ejianc.business.signaturemanage.vo.ContractVO;
import com.ejianc.business.tender.rent.bean.RentAdviceEntity;
import com.ejianc.business.tender.rent.bean.RentBidEntity;
import com.ejianc.business.tender.rent.bean.RentInviteEntity;
import com.ejianc.business.tender.rent.mapper.RentAdviceMapper;
import com.ejianc.business.tender.rent.service.IRentAdviceService;
import com.ejianc.business.tender.rent.service.IRentBidService;
import com.ejianc.business.tender.rent.service.IRentInviteService;
import com.ejianc.business.tender.rent.vo.RentAdviceSupplierPushVO;
import com.ejianc.business.tender.rent.vo.RentAdviceVO;
import com.ejianc.business.tender.stuff.service.IStuffAdviceService;
import com.ejianc.business.tender.util.CommonUtils;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.foundation.share.api.IProSupplierApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="rentAdviceService")
public class RentAdviceServiceImpl
extends BaseServiceImpl<RentAdviceMapper, RentAdviceEntity>
implements IRentAdviceService {
    @Autowired
    private IRentInviteService rentInviteService;
    @Autowired
    private IStuffAdviceService stuffAdviceService;
    private final String PUSH_ADVICE_SERVER_URL = "/ejc-supbid-web/openapi/bid/saveBid";
    @Autowired
    private IRentBidService rentBidService;
    @Autowired
    private IProSupplierApi proSupplierApi;
    private static final String BILL_TYPE = "BT220317000000003";
    @Autowired
    private IAttachmentApi attachmentApi;
    @Autowired
    private ISignatureCommonApi signatureCommonApi;

    @Override
    public CommonResponse<String> changeStatus(Long billId, int status, String refCode) {
        RentAdviceEntity rentAdviceEntity = (RentAdviceEntity)((Object)super.selectById((Serializable)billId));
        if (status == 5 || status == 6 || status == 7 || status == 8) {
            rentAdviceEntity.setSignFlag(0);
        }
        if (status == 2 || status == 3) {
            rentAdviceEntity.setSignFlag(1);
        }
        if (status == 4) {
            rentAdviceEntity.setSignFlag(2);
            ContractVO cv = new ContractVO();
            cv.setContractId(rentAdviceEntity.getId());
            cv.setContractName(rentAdviceEntity.getTitleName());
            cv.setBillType(BILL_TYPE);
            cv.setSourceType("tenderAdvice");
            ArrayList<ContractVO> cvs = new ArrayList<ContractVO>();
            cvs.add(cv);
            CommonResponse signResp = this.signatureCommonApi.fetchSignedContract(cvs);
            if (!signResp.isSuccess()) {
                throw new BusinessException("\u540c\u6b65\u7b7e\u7ae0\u9644\u4ef6\u5931\u8d25!");
            }
        }
        super.updateById((Object)rentAdviceEntity);
        return CommonResponse.success((String)"\u66f4\u65b0\u6210\u529f!");
    }

    @Override
    @Transactional
    public String sendAdvice(Long id) {
        RentAdviceEntity rentAdviceEntity = (RentAdviceEntity)((Object)super.selectById((Serializable)id));
        rentAdviceEntity.setSendFlag(0);
        super.updateById((Object)rentAdviceEntity);
        RentInviteEntity rentInviteEntity = (RentInviteEntity)((Object)this.rentInviteService.selectById(rentAdviceEntity.getInviteId()));
        RentAdviceSupplierPushVO rentAdviceSupplierPushVO = (RentAdviceSupplierPushVO)BeanMapper.map((Object)((Object)rentAdviceEntity), RentAdviceSupplierPushVO.class);
        CommonResponse ejcCloudSystemCode = this.proSupplierApi.getEjcCloudSystemCode();
        if (!ejcCloudSystemCode.isSuccess()) {
            throw new BusinessException("\u83b7\u53d6\u5f53\u524d\u7cfb\u7edf\u7f16\u7801\u5931\u8d25" + ejcCloudSystemCode.getMsg());
        }
        rentAdviceSupplierPushVO.setSystemId((String)ejcCloudSystemCode.getData());
        rentAdviceSupplierPushVO.setSourceType("\u90d1\u5dde\u4e00\u5efa\u6750\u6599\u4e2d\u6807\u901a\u77e5\u4e66");
        rentAdviceSupplierPushVO.setSourceId(rentAdviceEntity.getId().toString());
        rentAdviceSupplierPushVO.setBidTitle(rentAdviceEntity.getTitleName());
        rentAdviceSupplierPushVO.setSourceProjectId(rentAdviceEntity.getProjectId() != null ? rentAdviceEntity.getProjectId().toString() : null);
        rentAdviceSupplierPushVO.setSourceOrgId(rentAdviceEntity.getOrgId().toString());
        rentAdviceSupplierPushVO.setSourceUnitId(rentAdviceEntity.getUnitId().toString());
        rentAdviceSupplierPushVO.setType(CommonUtils.getGysType(3));
        rentAdviceSupplierPushVO.setTenderType(rentInviteEntity.getTenderType());
        rentAdviceSupplierPushVO.setBidDate(rentAdviceEntity.getNoticeDate());
        rentAdviceSupplierPushVO.setMoney(rentAdviceEntity.getMoney());
        rentAdviceSupplierPushVO.setMoneyTax(rentAdviceEntity.getMoneyTax());
        String dataInfo = JSONObject.toJSONString((Object)rentAdviceSupplierPushVO);
        boolean b = this.stuffAdviceService.pushBillToSupCenter(dataInfo, rentAdviceEntity.getSupplierId(), rentAdviceEntity.getId(), BILL_TYPE, "/ejc-supbid-web/openapi/bid/saveBid", rentAdviceEntity.getTitleName());
        if (!b) {
            throw new BusinessException("\u63a8\u9001\u4f9b\u65b9\u5931\u8d25!");
        }
        return null;
    }

    @Override
    public List<RentAdviceVO> queryAdviceList(Long id) {
        RentBidEntity rentBidEntity = (RentBidEntity)((Object)this.rentBidService.selectById(id));
        LambdaQueryWrapper lambdaAdvice = Wrappers.lambdaQuery();
        lambdaAdvice.eq(RentAdviceEntity::getInviteId, (Object)rentBidEntity.getInviteId());
        List list = super.list((Wrapper)lambdaAdvice);
        List rentAdviceVOS = BeanMapper.mapList((Iterable)list, RentAdviceVO.class);
        if (CollectionUtils.isNotEmpty((Collection)rentAdviceVOS)) {
            List data;
            List attachIds = rentAdviceVOS.stream().map(BaseVO::getId).collect(Collectors.toList());
            HashMap map = new HashMap();
            map.put("sourceIds", attachIds);
            JSONObject itemJSONObj = JSONObject.parseObject((String)JSON.toJSONString(map));
            CommonResponse listCommonResponse = this.attachmentApi.queryAllBySourceIdList(itemJSONObj);
            if (listCommonResponse.isSuccess() && CollectionUtils.isNotEmpty((Collection)(data = (List)listCommonResponse.getData()))) {
                Map attacMap = data.stream().filter(s -> s.getSourceType().equals("tenderAdvice")).collect(Collectors.toMap(AttachmentVO::getSourceId, Function.identity()));
                for (RentAdviceVO rentAdviceVO : rentAdviceVOS) {
                    AttachmentVO attachmentVO = (AttachmentVO)attacMap.get(rentAdviceVO.getId());
                    if (attachmentVO == null) continue;
                    rentAdviceVO.setAttachId(attachmentVO.getId());
                    rentAdviceVO.setFileName(attachmentVO.getFileName());
                    rentAdviceVO.setFilePath(attachmentVO.getFilePath());
                }
            }
        }
        return rentAdviceVOS;
    }
}

