package com.ejianc.business.tender.buildmaterial.service.impl;


import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.tender.buildmaterial.service.ISystemRequestService;
import com.ejianc.business.tender.buildmaterial.vo.PublishTenderVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

import javax.xml.bind.DatatypeConverter;
import java.io.*;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.URL;
import java.security.MessageDigest;

/**
 * 筑材信息
 *
 * @author generator
 *
 */
@Service("systemRequestService")
public class SystemRequestService  implements ISystemRequestService {

    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Override
    public String sendGetRequest(String queryUrl) {
        String responseObiect="";
        try {
            String merchant = "ZZYJ" ; // 筑材网提供的商户代码
            Long timestamp = System.currentTimeMillis();
            StringBuilder sb = new StringBuilder();
            sb.append(merchant).append(timestamp);
            String param = sb.toString();
            String str = "10840e1aeebc84523cc2f8904dd1d9f9" + param;  // key为筑材网提供
            String sign = "";
            try {
                MessageDigest sha1 = MessageDigest.getInstance("SHA-1");
                byte[] dst = sha1.digest(str.getBytes("utf-8"));
                sign = DatatypeConverter.printHexBinary(dst);
            } catch (Exception e) {
                logger.error("异常:", e);
                throw new BusinessException("参数加密异常:", e);
            }

            URL url = new URL("http://yanshi.zhucai.com/zc_api/v2/"+queryUrl);
            HttpURLConnection connection = (HttpURLConnection) url.openConnection();
            connection.setRequestMethod("GET");
            connection.setRequestProperty("Content-Type", "application/json");
            // 在Header中添加参数
            connection.setRequestProperty("merchant", merchant);
            connection.setRequestProperty("timestamp", timestamp.toString());
            connection.setRequestProperty("sign", sign);
            connection.setDoOutput(true);

            // 发送请求并获取响应
            int responseCode = connection.getResponseCode();

            // 检查响应是否成功
            if (responseCode == HttpURLConnection.HTTP_OK) {
                // 读取响应数据
                InputStream inputStream = connection.getInputStream();
                BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));
                String line;
                StringBuilder response = new StringBuilder();
                while ((line = reader.readLine()) != null) {
                    response.append(line);
                }
                reader.close();
                inputStream.close();
                // 处理响应数据
                String responseBody = response.toString();
                responseObiect = responseBody;
            } else {
                throw new BusinessException("Request failed. Response Code: " + responseCode);
            }
            // 关闭连接
            connection.disconnect();
        } catch (MalformedURLException e) {
            e.printStackTrace();
        } catch (ProtocolException e) {
            e.printStackTrace();
        } catch (IOException e) {
            e.printStackTrace();
        }

        return responseObiect;
    }

    @Override
    public String sendPostRequest(String queryUrl, JSONObject queryParam) {
        String responseObiect="";
        try {
            String merchant = "ZZYJ" ; // 筑材网提供的商户代码
            Long timestamp = System.currentTimeMillis();
            StringBuilder sb = new StringBuilder();
            sb.append(merchant).append(timestamp).append(queryParam);
            String param = sb.toString();
            String str = "10840e1aeebc84523cc2f8904dd1d9f9" + param;  // key为筑材网提供
            String sign = "";
            try {
                MessageDigest sha1 = MessageDigest.getInstance("SHA-1");
                byte[] dst = sha1.digest(str.getBytes("utf-8"));
                sign = DatatypeConverter.printHexBinary(dst);
            } catch (Exception e) {
                logger.error("异常:", e);
                throw new BusinessException("参数加密异常:", e);
            }

            URL url = new URL("http://yanshi.zhucai.com/zc_api/v2/"+queryUrl);
            HttpURLConnection connection = (HttpURLConnection) url.openConnection();
            connection.setRequestMethod("POST");
            connection.setRequestProperty("Content-Type", "application/json");
            // 在Header中添加参数
            connection.setRequestProperty("merchant", merchant);
            connection.setRequestProperty("timestamp", timestamp.toString());
            connection.setRequestProperty("sign", sign);
            connection.setDoOutput(true);
            // 将JSON字符串作为请求体发送
            OutputStream outputStream = connection.getOutputStream();
            outputStream.write(queryParam.toString().getBytes());
            outputStream.flush();
            // 发送请求并获取响应
            int responseCode = connection.getResponseCode();

            // 检查响应是否成功
            if (responseCode == HttpURLConnection.HTTP_OK) {
                // 读取响应数据
                InputStream inputStream = connection.getInputStream();
                BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));
                String line;
                StringBuilder response = new StringBuilder();
                while ((line = reader.readLine()) != null) {
                    response.append(line);
                }
                reader.close();
                inputStream.close();
                // 处理响应数据
                String responseBody = response.toString();
                responseObiect = responseBody;
            } else {
                responseObiect = "{code:"+responseCode+",message:接口请求失败"+responseCode+"}";
                //throw new BusinessException("Request failed. Response Code: " + responseCode);
            }
            // 关闭连接
            connection.disconnect();
        } catch (MalformedURLException e) {
            e.printStackTrace();
        } catch (ProtocolException e) {
            e.printStackTrace();
        } catch (IOException e) {
            e.printStackTrace();
        }

        return responseObiect;
    }

    @Override
    public String sendPutRequest(String queryUrl, JSONObject queryParam) {
        String responseObiect="";
        try {
            String merchant = "ZZYJ" ; // 筑材网提供的商户代码
            Long timestamp = System.currentTimeMillis();
            StringBuilder sb = new StringBuilder();
            sb.append(merchant).append(timestamp).append(queryParam);
            String param = sb.toString();
            String str = "10840e1aeebc84523cc2f8904dd1d9f9" + param;  // key为筑材网提供
            String sign = "";
            try {
                MessageDigest sha1 = MessageDigest.getInstance("SHA-1");
                byte[] dst = sha1.digest(str.getBytes("utf-8"));
                sign = DatatypeConverter.printHexBinary(dst);
            } catch (Exception e) {
                logger.error("异常:", e);
                throw new BusinessException("参数加密异常:", e);
            }

            URL url = new URL("http://yanshi.zhucai.com/zc_api/v2/"+queryUrl);
            HttpURLConnection connection = (HttpURLConnection) url.openConnection();
            connection.setRequestMethod("PUT");
            connection.setRequestProperty("Content-Type", "application/json");
            // 在Header中添加参数
            connection.setRequestProperty("merchant", merchant);
            connection.setRequestProperty("timestamp", timestamp.toString());
            connection.setRequestProperty("sign", sign);
            connection.setDoOutput(true);
            // 将JSON字符串作为请求体发送
            OutputStream outputStream = connection.getOutputStream();
            outputStream.write(queryParam.toString().getBytes());
            outputStream.flush();
            // 发送请求并获取响应
            int responseCode = connection.getResponseCode();

            // 检查响应是否成功
            if (responseCode == HttpURLConnection.HTTP_OK) {
                // 读取响应数据
                InputStream inputStream = connection.getInputStream();
                BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));
                String line;
                StringBuilder response = new StringBuilder();
                while ((line = reader.readLine()) != null) {
                    response.append(line);
                }
                reader.close();
                inputStream.close();
                // 处理响应数据
                String responseBody = response.toString();
                responseObiect = responseBody;
            } else {
                throw new BusinessException("Request failed. Response Code: " + responseCode);
            }
            // 关闭连接
            connection.disconnect();
        } catch (MalformedURLException e) {
            e.printStackTrace();
        } catch (ProtocolException e) {
            e.printStackTrace();
        } catch (IOException e) {
            e.printStackTrace();
        }

        return responseObiect;
    }

    @Override
    public String sendDeleteRequest(String queryUrl) {
        String responseObiect="";
        try {
            String merchant = "ZZYJ" ; // 筑材网提供的商户代码
            Long timestamp = System.currentTimeMillis();
            StringBuilder sb = new StringBuilder();
            sb.append(merchant).append(timestamp);
            String param = sb.toString();
            String str = "10840e1aeebc84523cc2f8904dd1d9f9" + param;  // key为筑材网提供
            String sign = "";
            try {
                MessageDigest sha1 = MessageDigest.getInstance("SHA-1");
                byte[] dst = sha1.digest(str.getBytes("utf-8"));
                sign = DatatypeConverter.printHexBinary(dst);
            } catch (Exception e) {
                logger.error("异常:", e);
                throw new BusinessException("参数加密异常:", e);
            }

            URL url = new URL("http://yanshi.zhucai.com/zc_api/v2/"+queryUrl);
            HttpURLConnection connection = (HttpURLConnection) url.openConnection();
            connection.setRequestMethod("DELETE");
            connection.setRequestProperty("Content-Type", "application/json");
            // 在Header中添加参数
            connection.setRequestProperty("merchant", merchant);
            connection.setRequestProperty("timestamp", timestamp.toString());
            connection.setRequestProperty("sign", sign);
            connection.setDoOutput(true);

            // 发送请求并获取响应
            int responseCode = connection.getResponseCode();

            // 检查响应是否成功
            if (responseCode == HttpURLConnection.HTTP_OK) {
                // 读取响应数据
                InputStream inputStream = connection.getInputStream();
                BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));
                String line;
                StringBuilder response = new StringBuilder();
                while ((line = reader.readLine()) != null) {
                    response.append(line);
                }
                reader.close();
                inputStream.close();
                // 处理响应数据
                String responseBody = response.toString();
                responseObiect = responseBody;
            } else {
                throw new BusinessException("Request failed. Response Code: " + responseCode);
            }
            // 关闭连接
            connection.disconnect();
        } catch (MalformedURLException e) {
            e.printStackTrace();
        } catch (ProtocolException e) {
            e.printStackTrace();
        } catch (IOException e) {
            e.printStackTrace();
        }

        return responseObiect;
    }

    @Override
    public String publishNotice(PublishTenderVO publishTenderVO) {
        String s = JSONObject.toJSONString(publishTenderVO);
        logger.info("--------------:{}",s);
        JSONObject param = JSONObject.parseObject(JSONObject.toJSONString(publishTenderVO));
        String responseBody = this.sendPostRequest("bid/releaseBid", param);
        return responseBody;
    }

    @Override
    public String publishNoticeUpdate(PublishTenderVO publishTenderVO) {
        String s = JSONObject.toJSONString(publishTenderVO);
        logger.info("--------------:{}",s);
        JSONObject param = JSONObject.parseObject(JSONObject.toJSONString(publishTenderVO));
        String responseBody = this.sendPostRequest("bid/adjustBid", param);
        return responseBody;
    }
}
