package com.ejianc.business.tender.expert.service.impl;

import com.ejianc.business.tender.expert.bean.ExpertEvaluatingDetailEntity;
import com.ejianc.business.tender.expert.bean.ExpertEvaluatingEntity;
import com.ejianc.business.tender.expert.service.IExpertEvaluatingService;
import com.ejianc.business.tender.stuff.service.IStuffDocumentExpertService;
import com.ejianc.business.tender.util.SendMsgUtils;
import com.ejianc.foundation.message.api.IPushMessageApi;
import com.ejianc.framework.core.response.BillStateEnum;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;

@Service("expertEvaluating")
public class ExpertEvaluatingBpmServiceImpl implements ICommonBusinessService {

	private Logger logger = LoggerFactory.getLogger(this.getClass());

	@Autowired
	private IPushMessageApi pushMessageApi;

	@Autowired
	private IExpertEvaluatingService service;

	@Autowired
	private IStuffDocumentExpertService expertService;


	@Value("${common.env.base-host}")
	private String baseHost;


	
	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		if(BillStateEnum.COMMITED_STATE.getBillStateCode() == state ||BillStateEnum.PASSED_STATE.getBillStateCode() == state) {
			ExpertEvaluatingEntity expertEvaluating = service.selectById(billId);
			if(CollectionUtils.isNotEmpty(expertEvaluating.getStuffEvaluationDetailEntities())){
				for (ExpertEvaluatingDetailEntity entity : expertEvaluating.getStuffEvaluationDetailEntities()) {
					//审批通过给专家发内部消息
					List<String> messageType = new ArrayList<>();
					//系统消息
					messageType.add("sys");
					messageType.add("dingding");
					//微信消息
					//messageType.add("weChat");
					List<String> sender = new ArrayList<>();
					sender.add(entity.getExpertId()+ "");
					String formUrl = baseHost+"ejc-tender-frontend/#/bidRecordList";
					SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
					String name = expertEvaluating.getPurchaseType()==0?expertEvaluating.getProjectName():expertEvaluating.getOrgName();
					logger.info("发送信息给专家:>----------" + sender);
//					String subject = entity.getExpertName() + "专家您好，" +name+ "已于"+sdf.format(expertEvaluating.getStartTime())+"开始评标,请尽快评标!";
//					String content = entity.getExpertName() + "专家您好，" +name+ "已于"+sdf.format(expertEvaluating.getStartTime())+"开始评标!"+"<a href=" + '"' + formUrl + '"' + ">请尽快评标</a>";
					String subject = entity.getExpertName() + "专家您好，" +name+ "已于"+sdf.format(expertEvaluating.getStartTime())+"进入评标阶段，请在72小时内完成评标任务。";
					String content = entity.getExpertName() + "专家您好，" +name+ "已于"+sdf.format(expertEvaluating.getStartTime())+"进入评标阶段，请在72小时内完成评标任务。"
							+"<a href=" + '"' + formUrl + '"' + ">请尽快评标</a>";
					// 组长发送组长消息
					if(entity.getLeader() == 0){
						subject = entity.getExpertName() + "专家您好，" +name+ "已于"+sdf.format(expertEvaluating.getStartTime())+"进入评标阶段，并且您被选为评标组长，请在72小时内完成评标任务并根据专家评标信息进行汇总。";
						content = entity.getExpertName() + "专家您好，" +name+ "已于"+sdf.format(expertEvaluating.getStartTime())+"进入评标阶段，并且您被选为评标组长，请在72小时内完成评标任务并根据专家评标信息进行汇总。"
								+"<a href=" + '"' + formUrl + '"' + ">请尽快评标</a>";

					}
					logger.info("发送信息的内容:>----------"+content);
//					new SendMsgUtils().sendSysMsg(sender,subject,content,pushMessageApi);
					new SendMsgUtils().sendMsgByMsgType(messageType,sender,subject,content,pushMessageApi);
				}
			}
		}
		return CommonResponse.success();
	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.error("该功能不支持！");
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

}
