package com.ejianc.business.tender.other.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.promaterial.plan.vo.BatPlanEnum;
import com.ejianc.business.tender.other.bean.OtherInviteDetailRecordEntity;
import com.ejianc.business.tender.other.bean.OtherPicketageRefsupplierEntity;
import com.ejianc.business.tender.other.service.IOtherBatPlanService;
import com.ejianc.business.tender.other.service.IOtherPicketageRefsupplierService;
import com.ejianc.business.tender.other.vo.OtherInviteDetailBidderVO;
import com.ejianc.business.tender.other.bean.OtherInviteDetailEntity;
import com.ejianc.business.tender.other.bean.OtherInviteEntity;
import com.ejianc.business.tender.other.service.IOtherInviteDetailService;
import com.ejianc.business.tender.other.service.IOtherInviteService;
import com.ejianc.business.tender.prosub.bean.ProsubInviteDetailRecordEntity;
import com.ejianc.business.tender.prosub.service.IProSubBatPlanService;
import com.ejianc.business.tender.stuff.vo.TenderStageEnum;
import com.ejianc.foundation.message.api.IPushMessageApi;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;

@Service("otherInvite")
public class OtherInviteBpmServiceImpl implements ICommonBusinessService {

	private Logger logger = LoggerFactory.getLogger(this.getClass());

	@Autowired
	private IPushMessageApi pushMessageApi;

	@Autowired
	private IOtherInviteService service;

	@Autowired
	private IOtherInviteDetailService detailService;

	@Autowired
	private IOtherPicketageRefsupplierService picketageRefsupplierService;
	

	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}
	@Autowired
	private IOtherBatPlanService otherBatPlanService;
	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		if(BillStateEnum.COMMITED_STATE.getBillStateCode() == state ||BillStateEnum.PASSED_STATE.getBillStateCode() == state) {
			OtherInviteEntity inviteEntity = service.selectById(billId);

			//采购计划修改
			if (inviteEntity.getEstablishType() == 1) {
				// 获取采购计划ID
				if (org.apache.commons.collections.CollectionUtils.isNotEmpty(inviteEntity.getOtherDetailRecord())) {
					List<String> planIdList = inviteEntity.getOtherDetailRecord().stream()
							.map(OtherInviteDetailRecordEntity::getPlanId).map(String::valueOf).distinct()
							.collect(Collectors.toList());
					// 释放采购计划
					otherBatPlanService.updateBatPlanByQuoteType(planIdList, BatPlanEnum.PLAN_STATE_OVER.getPlanState(),1);
				}
			}
//			List<OtherInviteDetailVO> detailVOList = new ArrayList<>();
//			if (inviteEntity.getPurchaseType()==0){
//				 detailVOList = service.selectSumDetail(billId);
//			}else {
//				 detailVOList  =  service.selectOrgSumDetail(billId);
//			}
//			for (OtherInviteDetailVO otherInviteDetailVO : detailVOList) {
//				otherInviteDetailVO.setNum(otherInviteDetailVO.getSumNum());
//				otherInviteDetailVO.setMoney(otherInviteDetailVO.getSumMoney());
//				otherInviteDetailVO.setMoneyTax(otherInviteDetailVO.getSumMoneyTax());
//				detailService.saveOrUpdate(BeanMapper.map(otherInviteDetailVO, OtherInviteDetailEntity.class));
//			}
			List<OtherInviteDetailRecordEntity> otherDetailRecord = inviteEntity.getOtherDetailRecord();
			for (OtherInviteDetailRecordEntity detailRecordEntity : otherDetailRecord) {
				detailService.saveOrUpdate(BeanMapper.map(detailRecordEntity, OtherInviteDetailEntity.class));
			}
			List<OtherInviteDetailBidderVO> detailBidderList =  service.selectDetailBidder(billId);
			String tenderUnitNum = "";
			for (OtherInviteDetailBidderVO detailBidderVO : detailBidderList) {
				OtherPicketageRefsupplierEntity otherPicketageRefsupplierEntity = new OtherPicketageRefsupplierEntity();
				otherPicketageRefsupplierEntity.setPicketageId(billId);
				otherPicketageRefsupplierEntity.setPicketageName(inviteEntity.getTenderName()+"定标");
				otherPicketageRefsupplierEntity.setPicketageDate(new Date());
				otherPicketageRefsupplierEntity.setMoney(detailBidderVO.getSumMoney());
				otherPicketageRefsupplierEntity.setMoneyTax(detailBidderVO.getSumTaxMoney());
				otherPicketageRefsupplierEntity.setSupplierId(detailBidderVO.getSupplierId());
				otherPicketageRefsupplierEntity.setSupplierName(detailBidderVO.getSupplierName());
//				otherPicketageRefsupplierEntity.setProjectId(detailBidderVO.getProjectId());
//				otherPicketageRefsupplierEntity.setProjectName(detailBidderVO.getProjectName());
//				otherPicketageRefsupplierEntity.setOrgId(detailBidderVO.getOrgId());
//				otherPicketageRefsupplierEntity.setOrgName(detailBidderVO.getOrgName());
				//暂时使用主表
				otherPicketageRefsupplierEntity.setProjectId(inviteEntity.getProjectId());
				otherPicketageRefsupplierEntity.setProjectName(inviteEntity.getProjectName());
				otherPicketageRefsupplierEntity.setProjectCode(inviteEntity.getProjectCode());
				otherPicketageRefsupplierEntity.setOrgId(inviteEntity.getOrgId());
				otherPicketageRefsupplierEntity.setOrgName(inviteEntity.getOrgName());
				otherPicketageRefsupplierEntity.setParentOrgId(inviteEntity.getParentOrgId());
				otherPicketageRefsupplierEntity.setParentOrgName(inviteEntity.getParentOrgName());
				otherPicketageRefsupplierEntity.setOccupyFlag(0);
				otherPicketageRefsupplierEntity.setPicketageFlag(1);
				otherPicketageRefsupplierEntity.setSignStatus(0);
				otherPicketageRefsupplierEntity.setPurchaseType(inviteEntity.getPurchaseType());
				picketageRefsupplierService.saveOrUpdate(otherPicketageRefsupplierEntity);
				BigDecimal sumNum = detailBidderVO.getSumNum().setScale(4,BigDecimal.ROUND_HALF_UP);
				tenderUnitNum+=detailBidderVO.getSupplierName()+"("+sumNum+"),";
			}
			if (tenderUnitNum.length() > 1) {
				tenderUnitNum = tenderUnitNum.substring(0,tenderUnitNum.length() -1);
			}
			inviteEntity.setTenderUnitNum(tenderUnitNum);
			service.saveOrUpdate(inviteEntity);
		}
		return CommonResponse.success();
	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		OtherInviteEntity inviteEntity = service.selectById(billId);
		if (inviteEntity.getOccupyState()!= null && inviteEntity.getOccupyState()==1){
			return CommonResponse.error("招标已被占用,不能撤回!");
		}
		if (inviteEntity.getTenderStage()>1){
			return CommonResponse.error("招标处于"+ TenderStageEnum.getEnumByStateCode(inviteEntity.getTenderStage()).getDescription()+",不能撤回!");
		}
		if (inviteEntity.getEstablishType()==1){
			QueryWrapper<OtherPicketageRefsupplierEntity> refWrapper = new QueryWrapper<>();
			refWrapper.eq("picketage_id",inviteEntity.getId());
			List<OtherPicketageRefsupplierEntity> refsupplierEntityList = picketageRefsupplierService.list(refWrapper);
			for (OtherPicketageRefsupplierEntity refsupplierEntity : refsupplierEntityList) {
				if (refsupplierEntity.getSignStatus()!=0){
					return CommonResponse.error("存在已签订合同,不能撤回!");
				}
			}
			picketageRefsupplierService.remove(refWrapper);
		}
		detailService.delByInviteId(inviteEntity.getId());
//		QueryWrapper<OtherInviteDetailEntity> detailWrapper = new QueryWrapper<>();
//		detailWrapper.eq("invite_id",inviteEntity.getId());
//		detailService.remove(detailWrapper);
		return CommonResponse.success();
//        return CommonResponse.error("该功能不支持！");
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		OtherInviteEntity inviteEntity = service.selectById(billId);

		//采购计划修改
		if (inviteEntity.getEstablishType() == 1) {
			// 获取采购计划ID
			if (org.apache.commons.collections.CollectionUtils.isNotEmpty(inviteEntity.getOtherDetailRecord())) {
				List<String> planIdList = inviteEntity.getOtherDetailRecord().stream()
						.map(OtherInviteDetailRecordEntity::getPlanId).map(String::valueOf).distinct()
						.collect(Collectors.toList());
				// 释放采购计划
				otherBatPlanService.updateBatPlanByQuoteType(planIdList, BatPlanEnum.PLAN_STATE_OVER.getPlanState(),1);
			}
		}
		return CommonResponse.success();
	}

}
