/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.tender.rent.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.tender.process.bean.ProcessEntity;
import com.ejianc.business.tender.process.service.IProcessService;
import com.ejianc.business.tender.rent.bean.RentBidDetailEntity;
import com.ejianc.business.tender.rent.bean.RentBidEntity;
import com.ejianc.business.tender.rent.bean.RentBidSupplierEntity;
import com.ejianc.business.tender.rent.bean.RentDocumentEntity;
import com.ejianc.business.tender.rent.bean.RentDocumentSellEntity;
import com.ejianc.business.tender.rent.bean.RentDocumentSupplierEntity;
import com.ejianc.business.tender.rent.bean.RentInviteEntity;
import com.ejianc.business.tender.rent.bean.RentNoticeEntity;
import com.ejianc.business.tender.rent.bean.RentPicketageEntity;
import com.ejianc.business.tender.rent.bean.RentPicketageSupplierEntity;
import com.ejianc.business.tender.rent.bean.RentWinnoticeEntity;
import com.ejianc.business.tender.rent.mapper.RentBidMapper;
import com.ejianc.business.tender.rent.service.IRentBidDetailService;
import com.ejianc.business.tender.rent.service.IRentBidService;
import com.ejianc.business.tender.rent.service.IRentBidSupplierService;
import com.ejianc.business.tender.rent.service.IRentDocumentSellService;
import com.ejianc.business.tender.rent.service.IRentDocumentService;
import com.ejianc.business.tender.rent.service.IRentDocumentSupplierService;
import com.ejianc.business.tender.rent.service.IRentInviteService;
import com.ejianc.business.tender.rent.service.IRentNoticeService;
import com.ejianc.business.tender.rent.service.IRentPicketageService;
import com.ejianc.business.tender.rent.service.IRentPicketageSupplierService;
import com.ejianc.business.tender.rent.service.IRentWinnoticeService;
import com.ejianc.business.tender.rent.vo.RentBidDetailVO;
import com.ejianc.business.tender.rent.vo.RentBidSupplierVO;
import com.ejianc.business.tender.rent.vo.RentBidVO;
import com.ejianc.business.tender.rent.vo.RentDocumentSellVO;
import com.ejianc.business.tender.rent.vo.RentPicketageSupplierVO;
import com.ejianc.business.tender.rent.vo.RentPicketageVO;
import com.ejianc.business.tender.rent.vo.RentWinbidDetailVO;
import com.ejianc.business.tender.rent.vo.RentWinbidVO;
import com.ejianc.business.tender.rent.vo.TenderStageEnum;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.share.api.IProSupplierApi;
import com.ejianc.foundation.share.vo.dto.SupplierDTO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IShareSupplierApi;
import com.ejianc.framework.cache.redis.CacheManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.dataPush.ISystemDataPushService;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.RequestMethod;

@Service(value="rentBidService")
public class RentBidServiceImpl
extends BaseServiceImpl<RentBidMapper, RentBidEntity>
implements IRentBidService {
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IRentPicketageService rentPicketageService;
    @Autowired
    private IRentNoticeService rentNoticeService;
    @Autowired
    private IRentWinnoticeService rentWinnoticeService;
    @Autowired
    private IRentDocumentService rentDocumentService;
    @Autowired
    private IRentInviteService rentInviteService;
    @Autowired
    private IRentBidDetailService rentBidDetailService;
    @Autowired
    private IRentDocumentSellService rentDocumentSellService;
    @Autowired
    private IRentBidSupplierService rentBidSupplierService;
    @Autowired
    private IRentDocumentSupplierService rentDocumentSupplierService;
    @Autowired
    private IProcessService processService;
    @Autowired
    private IRentPicketageSupplierService rentPicketageSupplierService;
    @Autowired
    private IOrgApi iOrgApi;
    @Value(value="${gysUrl.updateTimeUrl}")
    private String updateTimeUrl;
    @Value(value="${gysUrl.winbidSavesUrl}")
    private String winbidSavesUrl;
    @Value(value="${gysUrl.appId}")
    private String appId;
    @Value(value="${gysUrl.appSecret}")
    private String appSecret;
    @Value(value="${gysUrl.appHost}")
    private String appHost;
    @Autowired
    private ISystemDataPushService systemDataPushService;
    @Autowired
    private IProSupplierApi proSupplierApi;
    @Autowired
    private IShareSupplierApi shareSupplierApi;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private CacheManager cacheManager;
    private static final String BILL_CODE = "invite-bid-code";

    @Override
    public RentBidVO saveBid(Long picketageId) {
        RentBidEntity entity = new RentBidEntity();
        entity.setPicketageId(picketageId);
        if (entity.getId() == null || entity.getId() == 0L) {
            CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        RentPicketageEntity rentPicketageEntity = (RentPicketageEntity)((Object)this.rentPicketageService.selectById(picketageId));
        RentInviteEntity inviteEntity = (RentInviteEntity)((Object)this.rentInviteService.selectById(rentPicketageEntity.getInviteId()));
        entity.setInviteId(rentPicketageEntity.getInviteId());
        entity.setBidName(inviteEntity.getTenderName());
        entity.setPurchaseType(inviteEntity.getPurchaseType());
        super.saveOrUpdate((Object)entity, false);
        RentBidVO vo = (RentBidVO)BeanMapper.map((Object)((Object)entity), RentBidVO.class);
        rentPicketageEntity.setBidId(entity.getId());
        this.rentPicketageService.updateById((Object)rentPicketageEntity);
        LambdaQueryWrapper lambdaSell = Wrappers.lambdaQuery();
        lambdaSell.eq(RentDocumentSellEntity::getDocumentId, (Object)rentPicketageEntity.getDocumentId());
        lambdaSell.eq(RentDocumentSellEntity::getTenderFlag, (Object)1);
        List sellList = this.rentDocumentSellService.list((Wrapper)lambdaSell);
        List rentDocumentSellVOS = BeanMapper.mapList((Iterable)sellList, RentDocumentSellVO.class);
        Map<Long, List<RentDocumentSellVO>> sellMap = rentDocumentSellVOS.stream().collect(Collectors.groupingBy(RentDocumentSellVO::getSupplierId));
        LambdaQueryWrapper lambdaSupplier = Wrappers.lambdaQuery();
        lambdaSupplier.eq(RentDocumentSupplierEntity::getDocumentId, (Object)rentPicketageEntity.getDocumentId());
        lambdaSupplier.eq(RentDocumentSupplierEntity::getTalkNum, (Object)0);
        List supplierList = this.rentDocumentSupplierService.list((Wrapper)lambdaSupplier);
        Map supplierEntityMap = supplierList.stream().collect(Collectors.toMap(RentDocumentSupplierEntity::getSupplierId, Function.identity()));
        ArrayList supplierVOList = new ArrayList();
        ArrayList rentBidDetailEntityList = new ArrayList();
        sellMap.forEach((key, value) -> {
            RentBidSupplierVO rentBidSupplierVO = new RentBidSupplierVO();
            rentBidSupplierVO.setSupplierId(key);
            rentBidSupplierVO.setSupplierName(((RentDocumentSellVO)value.stream().findFirst().get()).getSupplierName());
            RentDocumentSupplierEntity rentDocumentSupplierEntity = (RentDocumentSupplierEntity)((Object)((Object)supplierEntityMap.get(key)));
            rentBidSupplierVO.setLinkName(rentDocumentSupplierEntity.getLinkName());
            rentBidSupplierVO.setSupplierMobile(rentDocumentSupplierEntity.getLinkMobile());
            rentBidSupplierVO.setId(Long.valueOf(IdWorker.getId()));
            BigDecimal tenderMoneyTax = BigDecimal.ZERO;
            BigDecimal tenderMoney = BigDecimal.ZERO;
            for (RentDocumentSellVO rentDocumentSellVO : value) {
                tenderMoneyTax = tenderMoneyTax.add(rentDocumentSellVO.getTenderMoneyTax() == null ? BigDecimal.ZERO : rentDocumentSellVO.getTenderMoneyTax());
                tenderMoney = tenderMoney.add(rentDocumentSellVO.getTenderMoney() == null ? BigDecimal.ZERO : rentDocumentSellVO.getTenderMoney());
                RentBidDetailEntity rentBidDetailEntity = (RentBidDetailEntity)((Object)((Object)BeanMapper.map((Object)rentDocumentSellVO, RentBidDetailEntity.class)));
                rentBidDetailEntity.setMoney(rentDocumentSellVO.getTenderMoney());
                rentBidDetailEntity.setMoneyTax(rentDocumentSellVO.getTenderMoneyTax());
                rentBidDetailEntity.setId(null);
                rentBidDetailEntity.setBidSupplierId(rentBidSupplierVO.getId());
                rentBidDetailEntity.setBidId(entity.getId());
                rentBidDetailEntityList.add(rentBidDetailEntity);
            }
            rentBidSupplierVO.setMoneyTax(tenderMoneyTax);
            rentBidSupplierVO.setMoney(tenderMoney);
            rentBidSupplierVO.setBidId(entity.getId());
            supplierVOList.add(rentBidSupplierVO);
        });
        List rentBidSupplierEntities = BeanMapper.mapList(supplierVOList, RentBidSupplierEntity.class);
        this.rentBidSupplierService.saveBatch(rentBidSupplierEntities);
        this.rentBidDetailService.saveBatch(rentBidDetailEntityList);
        String tenderUnitNum = new String();
        List<RentBidDetailEntity> bidDetailEntityList = ((RentBidMapper)this.baseMapper).selectBidSupplier(entity.getId());
        for (RentBidDetailEntity rentBidDetailEntity : bidDetailEntityList) {
            RentBidSupplierEntity supplierEntity = (RentBidSupplierEntity)((Object)this.rentBidSupplierService.selectById(rentBidDetailEntity.getBidSupplierId()));
            BigDecimal sumNum = rentBidDetailEntity.getTenderNum().setScale(4, 4);
            String name = supplierEntity.getSupplierName() + "(" + sumNum + "),";
            tenderUnitNum = tenderUnitNum + name;
        }
        if (tenderUnitNum.length() > 1) {
            tenderUnitNum = tenderUnitNum.substring(0, tenderUnitNum.length() - 1);
        }
        inviteEntity.setTenderUnitNum(tenderUnitNum);
        this.rentInviteService.saveOrUpdate((Object)inviteEntity);
        RentBidVO rentBidVO = (RentBidVO)BeanMapper.map((Object)((Object)entity), RentBidVO.class);
        return rentBidVO;
    }

    @Override
    public RentBidVO queryDetail(Long bidId) {
        RentBidEntity rentBidEntity = (RentBidEntity)((Object)super.selectById((Serializable)bidId));
        RentBidVO rentBidVO = (RentBidVO)BeanMapper.map((Object)((Object)rentBidEntity), RentBidVO.class);
        List rentBidDetailList = rentBidVO.getRentBidDetailList();
        Map<Long, List<RentBidDetailVO>> detailMap = rentBidDetailList.stream().collect(Collectors.groupingBy(RentBidDetailVO::getBidSupplierId));
        List rentBidSupplierList = rentBidVO.getRentBidSupplierList();
        for (RentBidSupplierVO rentBidSupplierVO : rentBidSupplierList) {
            rentBidSupplierVO.setRentBidDetailList(detailMap.get(rentBidSupplierVO.getId()));
        }
        rentBidVO.setRentBidSupplierList(rentBidSupplierList);
        return rentBidVO;
    }

    @Override
    @Transactional
    public RentBidVO publishBid(RentBidVO saveorUpdateVO) {
        RentBidEntity entity = (RentBidEntity)((Object)super.selectById((Serializable)saveorUpdateVO.getId()));
        entity.setBidContent(saveorUpdateVO.getBidContent());
        entity.setBidName(saveorUpdateVO.getBidName());
        entity.setPublishFlag(0);
        entity.setBillState(1);
        RentBidVO vo = (RentBidVO)BeanMapper.map((Object)((Object)entity), RentBidVO.class);
        RentInviteEntity rentInviteEntity = (RentInviteEntity)((Object)this.rentInviteService.selectById(entity.getInviteId()));
        RentWinbidVO winbidVO = new RentWinbidVO();
        winbidVO.setSourceId(Long.toString(entity.getInviteId()));
        winbidVO.setBillCode(rentInviteEntity.getBillCode());
        if (winbidVO.getPurchaseType() == null || winbidVO.getPurchaseType() == 1) {
            winbidVO.setSourceProjectId(null);
        } else {
            winbidVO.setSourceProjectId(Long.toString(rentInviteEntity.getProjectId()));
        }
        winbidVO.setProjectName(rentInviteEntity.getProjectName());
        winbidVO.setProjectCode(rentInviteEntity.getProjectCode());
        winbidVO.setSourceOrgId(Long.toString(rentInviteEntity.getOrgId()));
        winbidVO.setOrgName(rentInviteEntity.getOrgName());
        winbidVO.setUnitName(rentInviteEntity.getUnitName());
        winbidVO.setSourceUnitId(Long.toString(rentInviteEntity.getUnitId()));
        winbidVO.setType("RENT");
        winbidVO.setTenderName(rentInviteEntity.getTenderName());
        winbidVO.setTenderType(rentInviteEntity.getTenderType());
        winbidVO.setSystemId((String)this.proSupplierApi.getEjcCloudSystemCode().getData());
        LambdaQueryWrapper lambdaDoc = Wrappers.lambdaQuery();
        lambdaDoc.eq(RentDocumentEntity::getInviteId, (Object)entity.getInviteId());
        RentDocumentEntity rentDocumentEntity = (RentDocumentEntity)((Object)this.rentDocumentService.getOne((Wrapper)lambdaDoc));
        winbidVO.setNoticeBidTime(rentDocumentEntity.getBidTime());
        winbidVO.setNoticeWinbidTime(new Date());
        if (rentInviteEntity.getTenderType() == 2 || rentInviteEntity.getTenderType() == 3 || rentInviteEntity.getTenderType() == 4 || rentInviteEntity.getTenderType() == 5) {
            winbidVO.setSourceEmployeeId(Long.toString(rentDocumentEntity.getEmployeeId()));
            winbidVO.setEmployeeName(rentDocumentEntity.getEmployeeName());
            winbidVO.setEmployeeMobile(rentDocumentEntity.getEmployeeMobile());
            winbidVO.setPurchaseType(rentDocumentEntity.getPurchaseType());
        } else {
            LambdaQueryWrapper lambdaNotice = Wrappers.lambdaQuery();
            lambdaNotice.eq(RentNoticeEntity::getInviteId, (Object)entity.getInviteId());
            RentNoticeEntity noticeEntity = (RentNoticeEntity)((Object)this.rentNoticeService.getOne((Wrapper)lambdaNotice));
            winbidVO.setSourceEmployeeId(Long.toString(noticeEntity.getEmployeeId()));
            winbidVO.setEmployeeName(noticeEntity.getEmployeeName());
            winbidVO.setEmployeeMobile(noticeEntity.getEmployeeMobile());
            winbidVO.setPurchaseType(noticeEntity.getPurchaseType());
        }
        RentBidVO rentBidVO = this.queryDetail(entity.getId());
        List rentBidSupplierList = rentBidVO.getRentBidSupplierList();
        ArrayList<RentWinbidVO> winbidVOList = new ArrayList<RentWinbidVO>();
        for (RentBidSupplierVO rentBidSupplierVO : rentBidSupplierList) {
            RentWinbidVO winbidVONew = (RentWinbidVO)BeanMapper.map((Object)winbidVO, RentWinbidVO.class);
            SupplierDTO supplierVO = (SupplierDTO)this.shareSupplierApi.queryById(rentBidSupplierVO.getSupplierId()).getData();
            winbidVONew.setTenantId(supplierVO.getTenant());
            winbidVONew.setWinbidMoneyTax(rentBidSupplierVO.getMoneyTax());
            winbidVONew.setWinbidMoney(rentBidSupplierVO.getMoney());
            winbidVONew.setContent(rentBidVO.getBidContent());
            winbidVONew.setWinbidType(Integer.valueOf(0));
            List rentBidDetailList = rentBidSupplierVO.getRentBidDetailList();
            HashMap<String, List> map = new HashMap<String, List>();
            for (RentBidDetailVO rentBidDetailVO : rentBidDetailList) {
                String s = null;
                if (rentBidDetailVO.getMaterialId() == null) {
                    s = rentBidDetailVO.getMaterialTypeId().toString() + rentBidDetailVO.getRate() + rentBidDetailVO.getSchemeId() + rentBidDetailVO.getPlanEnterDate() + rentBidDetailVO.getPlanLeaveDate();
                }
                if (rentBidDetailVO.getMaterialId() != null) {
                    s = rentBidDetailVO.getMaterialId().toString() + rentBidDetailVO.getMaterialTypeId().toString() + rentBidDetailVO.getRate() + rentBidDetailVO.getSchemeId() + rentBidDetailVO.getPlanEnterDate() + rentBidDetailVO.getPlanLeaveDate();
                }
                if (map.containsKey(s)) {
                    List rentBidDetailVOS = (List)map.get(s);
                    rentBidDetailVOS.add(rentBidDetailVO);
                    map.put(s, rentBidDetailVOS);
                    continue;
                }
                ArrayList<RentBidDetailVO> rentBidDetailVOList = new ArrayList<RentBidDetailVO>();
                rentBidDetailVOList.add(rentBidDetailVO);
                map.put(s, rentBidDetailVOList);
            }
            ArrayList winbidDetailVOList = new ArrayList();
            map.forEach((key, value) -> {
                BigDecimal tenderNum = BigDecimal.ZERO;
                BigDecimal money = BigDecimal.ZERO;
                BigDecimal moneyTax = BigDecimal.ZERO;
                BigDecimal tax = BigDecimal.ZERO;
                for (RentBidDetailVO rentBidDetailVOLast : value) {
                    tenderNum = tenderNum.add(rentBidDetailVOLast.getTenderNum() == null ? BigDecimal.ZERO : rentBidDetailVOLast.getTenderNum());
                    money = money.add(rentBidDetailVOLast.getMoney() == null ? BigDecimal.ZERO : rentBidDetailVOLast.getMoney());
                    moneyTax = moneyTax.add(rentBidDetailVOLast.getMoneyTax() == null ? BigDecimal.ZERO : rentBidDetailVOLast.getMoneyTax());
                    tax = tax.add(rentBidDetailVOLast.getSellTax() == null ? BigDecimal.ZERO : rentBidDetailVOLast.getSellTax());
                }
                RentBidDetailVO first = (RentBidDetailVO)value.stream().findFirst().get();
                RentWinbidDetailVO winbidDetailVO = new RentWinbidDetailVO();
                winbidDetailVO.setSourceId(Long.toString(entity.getInviteId()));
                winbidDetailVO.setSourceMaterialId(Long.toString(first.getMaterialId()));
                winbidDetailVO.setMaterialName(first.getMaterialName());
                winbidDetailVO.setMaterialCode(first.getMaterialCode());
                winbidDetailVO.setSourceMaterialTypeId(Long.toString(first.getMaterialTypeId()));
                winbidDetailVO.setMaterialTypeName(first.getMaterialTypeName());
                winbidDetailVO.setUnit(first.getUnit());
                winbidDetailVO.setSpec(first.getSpec());
                winbidDetailVO.setBrand(first.getMaterialBrand());
                winbidDetailVO.setSupplierBrand(first.getBrand());
                winbidDetailVO.setPrice(first.getPrice());
                winbidDetailVO.setPriceTax(first.getPriceTax());
                winbidDetailVO.setMoney(money);
                winbidDetailVO.setMoneyTax(moneyTax);
                winbidDetailVO.setTax(tax);
                winbidDetailVO.setCalculateType(first.getCalculateType());
                winbidDetailVO.setMemo(first.getMaterialMemo());
                winbidDetailVO.setSupplierMemo(first.getMemo());
                winbidDetailVO.setMoney(money);
                winbidDetailVO.setRate(first.getRate());
                winbidDetailVO.setTenderNum(tenderNum);
                winbidDetailVO.setNum(first.getNum());
                winbidDetailVOList.add(winbidDetailVO);
            });
            winbidVONew.setRentWinbidDetailList(winbidDetailVOList);
            winbidVOList.add(winbidVONew);
        }
        String stringFb = JSONObject.toJSONString(winbidVOList);
        this.logger.info("\u63a8\u9001\u4f9b\u65b9\u4e2d\u6807\u4fe1\u606f:" + stringFb);
        Object response = null;
        CommonResponse stringCommonResponse = this.systemDataPushService.exchangeDataWithUniversal(this.winbidSavesUrl, RequestMethod.POST, stringFb, this.appId, this.appSecret, this.appHost);
        if (!stringCommonResponse.isSuccess()) {
            throw new BusinessException("\u4e2d\u6807\u540c\u6b65\u63a5\u53e3\u62a5\u9519" + stringCommonResponse.getMsg());
        }
        return this.queryDetail(vo.getId());
    }

    @Override
    public RentBidVO queryDbDetail(Long picketage) {
        return null;
    }

    @Override
    public RentBidVO nextPaper(Long winnoticeId) {
        RentBidEntity entity = new RentBidEntity();
        RentWinnoticeEntity rentWinnoticeEntity = (RentWinnoticeEntity)((Object)this.rentWinnoticeService.selectById(winnoticeId));
        RentInviteEntity rentInviteEntity = (RentInviteEntity)((Object)this.rentInviteService.selectById(rentWinnoticeEntity.getInviteId()));
        entity.setInviteId(rentWinnoticeEntity.getInviteId());
        entity.setBidName(rentInviteEntity.getTenderName());
        entity.setPurchaseType(rentInviteEntity.getPurchaseType());
        entity.setWinnoticeId(winnoticeId);
        super.saveOrUpdate((Object)entity, false);
        rentWinnoticeEntity.setNextFlag(1);
        this.rentWinnoticeService.updateById((Object)rentWinnoticeEntity);
        rentInviteEntity.setTenderStage(TenderStageEnum.BID_NOTICE_STATE.getTenderTypeCode());
        this.rentInviteService.updateById((Object)rentInviteEntity);
        ProcessEntity processEntity = new ProcessEntity();
        processEntity.setBillId(entity.getId());
        processEntity.setBillName(TenderStageEnum.BID_ANNOUNCEMENT_STATE.getDescription());
        processEntity.setTenderId(entity.getInviteId());
        processEntity.setType(3);
        processEntity.setFrontendUrl("rent/winLetter");
        this.processService.saveOrUpdate((Object)processEntity);
        RentBidVO rentBidVO = (RentBidVO)BeanMapper.map((Object)((Object)entity), RentBidVO.class);
        return rentBidVO;
    }

    @Override
    public List<RentPicketageSupplierVO> querySupplierList(Long picketageId) {
        RentBidEntity rentBidEntity = (RentBidEntity)((Object)super.selectById((Serializable)picketageId));
        RentWinnoticeEntity rentWinnoticeEntity = (RentWinnoticeEntity)((Object)this.rentWinnoticeService.selectById(rentBidEntity.getWinnoticeId()));
        LambdaQueryWrapper lambdaSupplierList = Wrappers.lambdaQuery();
        lambdaSupplierList.eq(RentPicketageSupplierEntity::getPicketageId, (Object)rentWinnoticeEntity.getPicketageId());
        List listSupplier = this.rentPicketageSupplierService.list((Wrapper)lambdaSupplierList);
        List rentPicketageSupplierVOS = BeanMapper.mapList((Iterable)listSupplier, RentPicketageSupplierVO.class);
        return rentPicketageSupplierVOS;
    }

    @Override
    @Transactional
    public RentPicketageVO insertProcess(Long picketageId) {
        RentPicketageEntity rentPicketageEntity = (RentPicketageEntity)((Object)this.rentPicketageService.selectById(picketageId));
        RentInviteEntity rentInviteEntity = (RentInviteEntity)((Object)this.rentInviteService.selectById(rentPicketageEntity.getInviteId()));
        rentInviteEntity.setTenderStage(TenderStageEnum.BID_NOTICE_STATE.getTenderTypeCode());
        this.rentInviteService.updateById((Object)rentInviteEntity);
        rentPicketageEntity.setBidStatus(1);
        this.rentPicketageService.updateById((Object)rentPicketageEntity);
        ProcessEntity processEntity = new ProcessEntity();
        processEntity.setBillId(rentPicketageEntity.getBidId());
        processEntity.setBillName(TenderStageEnum.BID_NOTICE_STATE.getDescription());
        processEntity.setTenderId(rentInviteEntity.getId());
        processEntity.setType(3);
        processEntity.setFrontendUrl("rent/winLetter");
        this.processService.saveOrUpdate((Object)processEntity);
        RentPicketageVO rentPicketageVO = (RentPicketageVO)BeanMapper.map((Object)((Object)rentPicketageEntity), RentPicketageVO.class);
        return rentPicketageVO;
    }

    @Override
    public List<RentPicketageSupplierVO> querySupplierDetail(Long id) {
        RentBidEntity rentBidEntity = (RentBidEntity)((Object)super.selectById((Serializable)id));
        return this.rentPicketageService.querySupplierList(rentBidEntity.getPicketageId());
    }
}

